/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.common.context.CommonContext;
import kd.mpscmm.common.util.BigDecimalUtil;
import kd.mpscmm.msplan.mrp.business.helper.BillQuantityHelper;
import kd.mpscmm.msplan.mrp.business.helper.MaterialHelper;

public class BillUnitConvertPlugin
extends AbstractConvertPlugIn {
    private static final int CUR_PRICEPRECISION = 10;
    private static final String SPLIT_DONT = "\\.";
    private static final Log log = LogFactory.getLog(BillUnitConvertPlugin.class);
    public static Map<String, String> materialInfoMap = new HashMap<String, String>();
    public static Map<String, String> mainBillToEntryFieldMapping = new HashMap<String, String>();
    public static Map<String, String> mainBillToBillFieldMapping = new HashMap<String, String>();

    protected boolean isMuConvFromCache() {
        return true;
    }

    protected void afterUnitConvert(DynamicObject afterConvertEntryInfo, int[] muBaseConv, int[] muConv, DynamicObject beforeUnit, DynamicObject convertUnit, DynamicObject mainBillEntryInfo) {
    }

    protected CommonContext getCommonContext() {
        CommonContext commonContext = CommonContext.get();
        Map ProperytMapping = commonContext.getProperytMapping();
        if (ProperytMapping.get(UnitConvertPluginConstant.MATERIALKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.MATERIALKEY, this.getMaterial());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.QTYKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.QTYKEY, this.getQty());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.UNITKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.UNITKEY, this.getUnit());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.BASEQTYKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.BASEQTYKEY, this.getBaseQty());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.BASEUNITKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.BASEUNITKEY, this.getBaseUnit());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.PRICEKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.PRICEKEY, this.getPrice());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.TAXPRICEKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.TAXPRICEKEY, this.getTaxPrice());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.CURRENCYKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.CURRENCYKEY, this.getCurrency());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.ISTAXKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.ISTAXKEY, this.getIsTax());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.TAXRATEIDKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.TAXRATEIDKEY, this.getTaxRateID());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.TAXRATEKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.TAXRATEKEY, this.getTaxRate());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.DISCOUNTTYPEKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.DISCOUNTTYPEKEY, this.getDiscountType());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.DISCOUNTRATEKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.DISCOUNTRATEKEY, this.getDiscountRate());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.MAINBILLENTITYKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.MAINBILLENTITYKEY, this.getMainBillEntity());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.MAINBILLIDKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.MAINBILLIDKEY, this.getMainBillID());
        }
        if (ProperytMapping.get(UnitConvertPluginConstant.MAINBILLENTRYIDKEY) == null) {
            ProperytMapping.put(UnitConvertPluginConstant.MAINBILLENTRYIDKEY, this.getMainBillEntryID());
        }
        return commonContext;
    }

    protected CommonContext getMainBillContext(String mainBillEntity) {
        CommonContext commonContext = CommonContext.get();
        Map ProperytMapping = commonContext.getProperytMapping();
        if (ProperytMapping.get(UnitConvertPluginMainBillConstant.MAINBILL_UNITKEY) == null) {
            ProperytMapping.put(UnitConvertPluginMainBillConstant.MAINBILL_UNITKEY, this.getMainBillUnitField(mainBillEntity));
        }
        if (ProperytMapping.get(UnitConvertPluginMainBillConstant.MAINBILL_PRICEKEY) == null) {
            ProperytMapping.put(UnitConvertPluginMainBillConstant.MAINBILL_PRICEKEY, this.getMainBillPriceField(mainBillEntity));
        }
        if (ProperytMapping.get(UnitConvertPluginMainBillConstant.MAINBILL_TAXPRICEKEY) == null) {
            ProperytMapping.put(UnitConvertPluginMainBillConstant.MAINBILL_TAXPRICEKEY, this.getMainBillTaxPriceField(mainBillEntity));
        }
        if (ProperytMapping.get(UnitConvertPluginMainBillConstant.MAINBILL_DISCOUNTTYPEKEY) == null) {
            ProperytMapping.put(UnitConvertPluginMainBillConstant.MAINBILL_DISCOUNTTYPEKEY, this.getMainBillDiscountTypeField(mainBillEntity));
        }
        if (ProperytMapping.get(UnitConvertPluginMainBillConstant.MAINBILL_DISCOUNTRATEKEY) == null) {
            ProperytMapping.put(UnitConvertPluginMainBillConstant.MAINBILL_DISCOUNTRATEKEY, this.getMainBillDiscountRateField(mainBillEntity));
        }
        if (ProperytMapping.get(UnitConvertPluginMainBillConstant.MAINBILL_TAXRATEID) == null) {
            ProperytMapping.put(UnitConvertPluginMainBillConstant.MAINBILL_TAXRATEID, this.getMainBillTaxRateIDField(mainBillEntity));
        }
        if (ProperytMapping.get(UnitConvertPluginMainBillConstant.MAINBILL_TAXRATE) == null) {
            ProperytMapping.put(UnitConvertPluginMainBillConstant.MAINBILL_TAXRATE, this.getMainBillTaxRateField(mainBillEntity));
        }
        if (ProperytMapping.get(UnitConvertPluginMainBillConstant.MAINBILL_ISTAXKEY) == null) {
            ProperytMapping.put(UnitConvertPluginMainBillConstant.MAINBILL_ISTAXKEY, this.getMainBillIsTaxField(mainBillEntity));
        }
        return commonContext;
    }

    private String getUnitSource() {
        return "unitsrctype";
    }

    private String getMaterial() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("material")) {
            return "material";
        }
        if (tgtMainType.getAllFields().containsKey("e_material")) {
            return "e_material";
        }
        if (tgtMainType.getAllFields().containsKey("materialid")) {
            return "materialid";
        }
        if (tgtMainType.getAllFields().containsKey("materialmasterid")) {
            return "materialmasterid";
        }
        return "material";
    }

    private String getCurrency() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("settlecurrency")) {
            return "settlecurrency";
        }
        if (tgtMainType.getAllFields().containsKey("currency")) {
            return "currency";
        }
        if (tgtMainType.getAllFields().containsKey("settlecurrencyid")) {
            return "settlecurrencyid";
        }
        if (tgtMainType.getAllFields().containsKey("curr")) {
            return "curr";
        }
        if (tgtMainType.getAllFields().containsKey("settlescurrency")) {
            return "settlescurrency";
        }
        return "";
    }

    private String getIsTax() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("istax")) {
            return "istax";
        }
        if (tgtMainType.getAllFields().containsKey("isincludetax")) {
            return "isincludetax";
        }
        return "";
    }

    private String getMainBillEntity() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("mainbillentity")) {
            return "mainbillentity";
        }
        if (tgtMainType.getAllFields().containsKey("e_corebilltype")) {
            return "e_corebilltype";
        }
        if (tgtMainType.getAllFields().containsKey("corebilltype")) {
            return "corebilltype";
        }
        return "mainbillentity";
    }

    private String getMainBillID() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("mainbillid")) {
            return "mainbillid";
        }
        if (tgtMainType.getAllFields().containsKey("corebillid")) {
            return "corebillid";
        }
        if (tgtMainType.getAllFields().containsKey("e_corebillid")) {
            return "e_corebillid";
        }
        return "mainbillid";
    }

    private String getMainBillEntryID() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("mainbillentryid")) {
            return "mainbillentryid";
        }
        if (tgtMainType.getAllFields().containsKey("corebillentryid")) {
            return "corebillentryid";
        }
        if (tgtMainType.getAllFields().containsKey("e_corebillentryid")) {
            return "e_corebillentryid";
        }
        return "mainbillid";
    }

    private String getQty() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("qty")) {
            return "qty";
        }
        if (tgtMainType.getAllFields().containsKey("e_quantity")) {
            return "e_quantity";
        }
        if (tgtMainType.getAllFields().containsKey("reqqty")) {
            return "reqqty";
        }
        if (tgtMainType.getAllFields().containsKey("quantity")) {
            return "quantity";
        }
        return "qty";
    }

    private String getBaseQty() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("baseqty")) {
            return "baseqty";
        }
        if (tgtMainType.getAllFields().containsKey("e_baseunitqty")) {
            return "e_baseunitqty";
        }
        if (tgtMainType.getAllFields().containsKey("reqbaseqty")) {
            return "reqbaseqty";
        }
        if (tgtMainType.getAllFields().containsKey("basicqty")) {
            return "basicqty";
        }
        return "";
    }

    private String getPrice() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("price")) {
            return "price";
        }
        if (tgtMainType.getAllFields().containsKey("e_unitprice")) {
            return "e_unitprice";
        }
        return "";
    }

    private String getTaxRateID() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("taxrateid")) {
            return "taxrateid";
        }
        return "";
    }

    private String getTaxRate() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("taxrate")) {
            return "taxrate";
        }
        return "";
    }

    private String getTaxPrice() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("priceandtax")) {
            return "priceandtax";
        }
        if (tgtMainType.getAllFields().containsKey("taxprice")) {
            return "taxprice";
        }
        if (tgtMainType.getAllFields().containsKey("e_taxunitprice")) {
            return "e_taxunitprice";
        }
        if (tgtMainType.getAllFields().containsKey("pricetax")) {
            return "pricetax";
        }
        return "";
    }

    private String getDiscountType() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("discounttype")) {
            return "discounttype";
        }
        if (tgtMainType.getAllFields().containsKey("e_discountmode")) {
            return "e_discountmode";
        }
        if (tgtMainType.getAllFields().containsKey("discountmode")) {
            return "discountmode";
        }
        return "";
    }

    private String getDiscountRate() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("discountrate")) {
            return "discountrate";
        }
        if (tgtMainType.getAllFields().containsKey("e_discountrate")) {
            return "e_discountrate";
        }
        return "";
    }

    private String getUnit() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("unit")) {
            return "unit";
        }
        if (tgtMainType.getAllFields().containsKey("e_measureunit")) {
            return "e_measureunit";
        }
        if (tgtMainType.getAllFields().containsKey("measureunit")) {
            return "measureunit";
        }
        return "unit";
    }

    private String getBaseUnit() {
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey("baseunit")) {
            return "baseunit";
        }
        if (tgtMainType.getAllFields().containsKey("e_baseunit")) {
            return "e_baseunit";
        }
        if (tgtMainType.getAllFields().containsKey("basicunit")) {
            return "basicunit";
        }
        BasedataProp materialProp = (BasedataProp)tgtMainType.getAllFields().get(this.getMaterial());
        String materialInfoEntity = materialProp.getBaseEntityId();
        if ("bd_material".equals(materialInfoEntity)) {
            return this.getMaterial() + ".baseunit";
        }
        return "";
    }

    private String getBillEntry() {
        String materialField = (String)this.getCommonContext().getProperytMapping().get(UnitConvertPluginConstant.MATERIALKEY);
        BillEntityType tgtMainType = this.getTgtMainType();
        if (tgtMainType.getAllFields().containsKey(materialField)) {
            return ((IDataEntityProperty)tgtMainType.getAllFields().get(materialField)).getParent().getName();
        }
        return null;
    }

    private String getMainBillUnitField(String mainBillEntity) {
        MainEntityType mainBillType = EntityMetadataCache.getDataEntityType((String)mainBillEntity);
        if (!mainBillType.getAllFields().containsKey("unit")) {
            String mainBillUnitExistsMsg = String.format(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e%1$s\uff1a\u6807\u8bc6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"BillUnitConvertPlugin_0", (String)"mpscmm-msbd-common", (Object[])new Object[0]), mainBillType.getName(), "unit");
            throw new KDBizException(mainBillUnitExistsMsg);
        }
        return "unit";
    }

    private String getMainBillPriceField(String mainBillEntity) {
        MainEntityType mainBillType = EntityMetadataCache.getDataEntityType((String)mainBillEntity);
        if (mainBillType.getAllFields().containsKey("price")) {
            return "price";
        }
        return "";
    }

    private String getMainBillTaxPriceField(String mainBillEntity) {
        MainEntityType mainBillType = EntityMetadataCache.getDataEntityType((String)mainBillEntity);
        if (mainBillType.getAllFields().containsKey("priceandtax")) {
            return "priceandtax";
        }
        return "";
    }

    private String getMainBillDiscountTypeField(String mainBillEntity) {
        MainEntityType mainBillType = EntityMetadataCache.getDataEntityType((String)mainBillEntity);
        if (mainBillType.getAllFields().containsKey("discounttype")) {
            return "discounttype";
        }
        return "";
    }

    private String getMainBillDiscountRateField(String mainBillEntity) {
        MainEntityType mainBillType = EntityMetadataCache.getDataEntityType((String)mainBillEntity);
        if (mainBillType.getAllFields().containsKey("discountrate")) {
            return "discountrate";
        }
        return "";
    }

    private String getMainBillTaxRateIDField(String mainBillEntity) {
        MainEntityType mainBillType = EntityMetadataCache.getDataEntityType((String)mainBillEntity);
        if (mainBillType.getAllFields().containsKey("taxrateid")) {
            return "taxrateid";
        }
        return "";
    }

    private String getMainBillTaxRateField(String mainBillEntity) {
        MainEntityType mainBillType = EntityMetadataCache.getDataEntityType((String)mainBillEntity);
        if (mainBillType.getAllFields().containsKey("taxrate")) {
            return "taxrate";
        }
        return "";
    }

    private String getMainBillIsTaxField(String mainBillEntity) {
        MainEntityType mainBillType = EntityMetadataCache.getDataEntityType((String)mainBillEntity);
        if (mainBillType.getAllFields().containsKey("istax")) {
            return "istax";
        }
        return "";
    }

    private String getMainBillEntry(String mainBillEntity) {
        String mainUnitlField = (String)this.getMainBillContext(mainBillEntity).getProperytMapping().get(UnitConvertPluginMainBillConstant.MAINBILL_UNITKEY);
        MainEntityType mainBillType = EntityMetadataCache.getDataEntityType((String)mainBillEntity);
        if (mainBillType.getAllFields().containsKey(mainUnitlField)) {
            return ((IDataEntityProperty)mainBillType.getAllFields().get(mainUnitlField)).getParent().getName();
        }
        return null;
    }

    public void afterConvert(AfterConvertEventArgs e) {
        DynamicObject entryInfo;
        Object mainbillentryUnitSelect;
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        BillEntityType tgtMainType = this.getTgtMainType();
        String tgtTypeName = tgtMainType.getName();
        log.info(this.getLogMsg("\u5207\u6362\u5355\u4f4d\u5f00\u59cb"));
        ArrayList<DynamicObject> convertEntryInfos = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> convertUnitInfos = new ArrayList<DynamicObject>();
        ArrayList mainBillInfos = new ArrayList();
        ArrayList<DynamicObject> fromMainBillRecs = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> fromCurAppRecs = new ArrayList<DynamicObject>();
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            String unitSource = bill.getString(this.getUnitSource());
            if (StringUtils.isEmpty((String)unitSource) || "NULL".equals(unitSource)) continue;
            if ("MAINBILLUNIT".equals(unitSource)) {
                fromMainBillRecs.add(bill);
                continue;
            }
            if (!"BIZUNIT".equals(unitSource)) continue;
            fromCurAppRecs.add(bill);
        }
        if (fromMainBillRecs.size() == 0 && fromCurAppRecs.size() == 0) {
            return;
        }
        Map properytMapping = this.getCommonContext().getProperytMapping();
        String materialField = (String)properytMapping.get(UnitConvertPluginConstant.MATERIALKEY);
        if (!tgtMainType.getAllFields().containsKey(this.getUnitSource())) {
            String unitSourceExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u8ba1\u91cf\u5355\u4f4d\u6765\u6e90\u201d\u6807\u8bc6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"BillUnitConvertPlugin_1", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName, this.getUnitSource());
            throw new KDBizException(unitSourceExistsMsg);
        }
        if (!tgtMainType.getAllFields().containsKey(materialField)) {
            String materialExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u7269\u6599\u201d\u6807\u8bc6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"BillUnitConvertPlugin_2", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName, materialField);
            throw new KDBizException(materialExistsMsg);
        }
        if (!tgtMainType.getAllFields().containsKey(properytMapping.get(UnitConvertPluginConstant.UNITKEY))) {
            String unitExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u6807\u8bc6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"BillUnitConvertPlugin_3", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName, properytMapping.get(UnitConvertPluginConstant.UNITKEY));
            throw new KDBizException(unitExistsMsg);
        }
        if (!tgtMainType.getAllFields().containsKey(properytMapping.get(UnitConvertPluginConstant.QTYKEY))) {
            String qtyExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u6570\u91cf\u201d\u6807\u8bc6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"BillUnitConvertPlugin_4", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName, properytMapping.get(UnitConvertPluginConstant.QTYKEY));
            throw new KDBizException(qtyExistsMsg);
        }
        if (StringUtils.isNotEmpty((String)((String)properytMapping.get(UnitConvertPluginConstant.PRICEKEY)))) {
            if (!tgtMainType.getAllFields().containsKey(properytMapping.get(UnitConvertPluginConstant.PRICEKEY))) {
                String priceExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u5355\u4ef7\u201d\u6807\u8bc6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"BillUnitConvertPlugin_5", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName, properytMapping.get(UnitConvertPluginConstant.PRICEKEY));
                throw new KDBizException(priceExistsMsg);
            }
            if (StringUtils.isEmpty((String)((String)properytMapping.get(UnitConvertPluginConstant.CURRENCYKEY)))) {
                String taxPriceExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u5e01\u79cd\u201d\u6807\u8bc6\u672a\u88ab\u8bbe\u7f6e\u3002", (String)"BillUnitConvertPlugin_6", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName);
                throw new KDBizException(taxPriceExistsMsg);
            }
        }
        if (StringUtils.isNotEmpty((String)((String)properytMapping.get(UnitConvertPluginConstant.TAXPRICEKEY)))) {
            if (!tgtMainType.getAllFields().containsKey(properytMapping.get(UnitConvertPluginConstant.TAXPRICEKEY))) {
                String taxPriceExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u6807\u8bc6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"BillUnitConvertPlugin_7", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName, properytMapping.get(UnitConvertPluginConstant.TAXPRICEKEY));
                throw new KDBizException(taxPriceExistsMsg);
            }
            if (StringUtils.isEmpty((String)((String)properytMapping.get(UnitConvertPluginConstant.CURRENCYKEY)))) {
                String taxPriceExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u5e01\u79cd\u201d\u6807\u8bc6\u672a\u88ab\u8bbe\u7f6e\u3002", (String)"BillUnitConvertPlugin_6", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName);
                throw new KDBizException(taxPriceExistsMsg);
            }
        }
        if (StringUtils.isNotEmpty((String)((String)properytMapping.get(UnitConvertPluginConstant.CURRENCYKEY))) && !tgtMainType.getAllFields().containsKey(properytMapping.get(UnitConvertPluginConstant.CURRENCYKEY))) {
            String currencyExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u5e01\u79cd\u201d\u6807\u8bc6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"BillUnitConvertPlugin_8", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName, properytMapping.get(UnitConvertPluginConstant.CURRENCYKEY));
            throw new KDBizException(currencyExistsMsg);
        }
        if (StringUtils.isNotEmpty((String)((String)properytMapping.get(UnitConvertPluginConstant.DISCOUNTTYPEKEY))) && !tgtMainType.getAllFields().containsKey(properytMapping.get(UnitConvertPluginConstant.DISCOUNTTYPEKEY))) {
            String discountTypeExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u6298\u6263\u65b9\u5f0f\u201d\u6807\u8bc6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"BillUnitConvertPlugin_9", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName, properytMapping.get(UnitConvertPluginConstant.DISCOUNTTYPEKEY));
            throw new KDBizException(discountTypeExistsMsg);
        }
        if (StringUtils.isNotEmpty((String)((String)properytMapping.get(UnitConvertPluginConstant.DISCOUNTRATEKEY))) && !tgtMainType.getAllFields().containsKey(properytMapping.get(UnitConvertPluginConstant.DISCOUNTRATEKEY))) {
            String discountRateExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u5355\u4f4d\u6298\u6263\u201d\u6807\u8bc6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"BillUnitConvertPlugin_10", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName, properytMapping.get(UnitConvertPluginConstant.DISCOUNTRATEKEY));
            throw new KDBizException(discountRateExistsMsg);
        }
        log.info(this.getLogMsg("\u6765\u6e90\u4e3a\u6838\u5fc3\u5355\u636e\u8bb0\u5f55\u6761\u6570\u4e3a") + fromMainBillRecs.size());
        log.info(this.getLogMsg("\u6765\u6e90\u4e3a\u6838\u5fc3\u5355\u636e\u8bb0\u5f55\u83b7\u53d6\u5355\u4f4d\u5f00\u59cb"));
        HashSet<Object> mainBillSet = new HashSet<Object>(16);
        if (fromMainBillRecs.size() > 0) {
            if (!tgtMainType.getAllFields().containsKey(properytMapping.get(UnitConvertPluginConstant.MAINBILLENTITYKEY))) {
                String mainbillEntityExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u6838\u5fc3\u5355\u636e\u5b9e\u4f53\u201d\u6807\u8bc6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"BillUnitConvertPlugin_11", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName, properytMapping.get(UnitConvertPluginConstant.MAINBILLENTITYKEY));
                throw new KDBizException(mainbillEntityExistsMsg);
            }
            if (!tgtMainType.getAllFields().containsKey(properytMapping.get(UnitConvertPluginConstant.MAINBILLIDKEY))) {
                String mainbillIDExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u6838\u5fc3\u5355\u636e\u5b9e\u4f53\u201d\u6807\u8bc6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"BillUnitConvertPlugin_11", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName, properytMapping.get(UnitConvertPluginConstant.MAINBILLIDKEY));
                throw new KDBizException(mainbillIDExistsMsg);
            }
            if (!tgtMainType.getAllFields().containsKey(properytMapping.get(UnitConvertPluginConstant.MAINBILLENTRYIDKEY))) {
                String mainbillEntryIDExistsMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u6838\u5fc3\u5355\u636e\u5b9e\u4f53\u201d\u6807\u8bc6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u7684\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"BillUnitConvertPlugin_11", (String)"mpscmm-msbd-common", (Object[])new Object[0]), tgtTypeName, properytMapping.get(UnitConvertPluginConstant.MAINBILLENTRYIDKEY));
                throw new KDBizException(mainbillEntryIDExistsMsg);
            }
        }
        String mainBillEntity = "";
        for (DynamicObject bill : fromMainBillRecs) {
            DynamicObjectCollection entryColl = bill.getDynamicObjectCollection(this.getBillEntry());
            if (entryColl == null) continue;
            for (DynamicObject entryInfo2 : entryColl) {
                Object mainbillID = entryInfo2.get((String)properytMapping.get(UnitConvertPluginConstant.MAINBILLIDKEY));
                mainBillEntity = entryInfo2.getString((String)properytMapping.get(UnitConvertPluginConstant.MAINBILLENTITYKEY));
                if (!StringUtils.isNotEmpty((String)mainBillEntity) || mainbillID == null || Long.valueOf(0L).equals(mainbillID)) continue;
                mainBillSet.add(mainbillID);
            }
        }
        HashMap mainBillUnitMap = new HashMap();
        HashMap<String, DynamicObject> mainBillInfoMap = new HashMap<String, DynamicObject>();
        if (mainBillSet.size() > 0) {
            HashSet selector = new HashSet(16);
            Map mainbillPropertyMapping = this.getMainBillContext(mainBillEntity).getProperytMapping();
            String mainbillentryIDSelect = this.getMainBillSelectField(mainBillEntity, "id");
            selector.add(mainbillentryIDSelect);
            mainbillentryUnitSelect = this.getMainBillSelectField(mainBillEntity, (String)mainbillPropertyMapping.get(UnitConvertPluginMainBillConstant.MAINBILL_UNITKEY));
            selector.add(mainbillentryUnitSelect);
            selector.add("id");
            if (this.isPriceInfoFromMainBill()) {
                Set<Map.Entry<String, String>> entryFields = mainBillToEntryFieldMapping.entrySet();
                Iterator<Map.Entry<String, String>> entryFieldsIt = entryFields.iterator();
                while (entryFieldsIt.hasNext()) {
                    selector.add(this.getMainBillSelectField(mainBillEntity, (String)mainbillPropertyMapping.get(entryFieldsIt.next().getValue())));
                }
                Set<Map.Entry<String, String>> billFields = mainBillToBillFieldMapping.entrySet();
                Iterator billFieldsIt = billFields.iterator();
                while (billFieldsIt.hasNext()) {
                    selector.add(mainbillPropertyMapping.get(billFieldsIt.next().getValue()));
                }
            }
            String selecties = String.join((CharSequence)",", selector);
            DynamicObjectCollection mainBillColl = QueryServiceHelper.query((String)mainBillEntity, (String)selecties, (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillSet)});
            HashSet<Long> mainUnitIDS = new HashSet<Long>(16);
            for (Object mainBill : mainBillColl) {
                mainUnitIDS.add(mainBill.getLong((String)mainbillentryUnitSelect));
            }
            Map unitsCache = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"id,precision", (QFilter[])new QFilter[]{new QFilter("id", "in", mainUnitIDS)});
            for (DynamicObject mainBill : mainBillColl) {
                Object mainEntryID = mainBill.get(mainbillentryIDSelect);
                mainBillUnitMap.put(this.generateMainUnitKey(mainBillEntity, mainEntryID), unitsCache.get(mainBill.getLong((String)mainbillentryUnitSelect)));
                mainBillInfoMap.put(this.generateMainUnitKey(mainBillEntity, mainEntryID), mainBill);
            }
        }
        log.info(this.getLogMsg("\u6765\u6e90\u4e3a\u6838\u5fc3\u5355\u636e\u8bb0\u5f55\u83b7\u53d6\u5355\u4f4d\u7ed3\u675f"));
        log.info(this.getLogMsg("\u6765\u6e90\u4e3a\u6838\u5fc3\u5355\u636e\u8bb0\u5f55\u8bbe\u7f6e\u5355\u4f4d\u5f00\u59cb"));
        for (DynamicObject bill : fromMainBillRecs) {
            DynamicObjectCollection entryColl = bill.getDynamicObjectCollection(this.getBillEntry());
            if (entryColl == null) continue;
            mainbillentryUnitSelect = entryColl.iterator();
            while (mainbillentryUnitSelect.hasNext()) {
                DynamicObject convertUnit;
                DynamicObject entryInfo3 = (DynamicObject)mainbillentryUnitSelect.next();
                Object mainbillEntryID = entryInfo3.get((String)properytMapping.get(UnitConvertPluginConstant.MAINBILLENTRYIDKEY));
                if (!StringUtils.isNotEmpty((String)mainBillEntity) || mainbillEntryID == null || Long.valueOf(0L).equals(mainbillEntryID) || (convertUnit = (DynamicObject)mainBillUnitMap.get(this.generateMainUnitKey(mainBillEntity, mainbillEntryID))) == null) continue;
                convertEntryInfos.add(entryInfo3);
                convertUnitInfos.add(convertUnit);
                mainBillInfos.add(mainBillInfoMap.get(this.generateMainUnitKey(mainBillEntity, mainbillEntryID)));
            }
        }
        log.info(this.getLogMsg("\u6765\u6e90\u4e3a\u6838\u5fc3\u5355\u636e\u8bb0\u5f55\u8bbe\u7f6e\u5355\u4f4d\u7ed3\u675f"));
        log.info(this.getLogMsg("\u6765\u6e90\u4e3a\u5f53\u524d\u5e94\u7528\u5355\u636e\u8bb0\u5f55\u4e3a") + fromCurAppRecs.size());
        log.info(this.getLogMsg("\u6765\u6e90\u4e3a\u5f53\u524d\u5e94\u7528\u8bbe\u7f6e\u5355\u4f4d\u5f00\u59cb"));
        BasedataProp materialProp = (BasedataProp)tgtMainType.getAllFields().get(materialField);
        String materialInfoEntity = materialProp.getBaseEntityId();
        if (materialInfoMap.get(materialInfoEntity) != null) {
            for (DynamicObject bill : fromCurAppRecs) {
                DynamicObjectCollection entryColl = bill.getDynamicObjectCollection(this.getBillEntry());
                if (entryColl == null) continue;
                for (DynamicObject entryInfo4 : entryColl) {
                    DynamicObject convertUnit;
                    DynamicObject materialInfo = entryInfo4.getDynamicObject(materialField);
                    if (materialInfo == null || (convertUnit = materialInfo.getDynamicObject(materialInfoMap.get(materialInfoEntity))) == null) continue;
                    convertEntryInfos.add(entryInfo4);
                    convertUnitInfos.add(convertUnit);
                    mainBillInfos.add(null);
                }
            }
        }
        log.info(this.getLogMsg("\u6765\u6e90\u4e3a\u5f53\u524d\u5e94\u7528\u8bbe\u7f6e\u5355\u4f4d\u7ed3\u675f"));
        if ("bd_material".equals(materialInfoEntity)) {
            for (int i = 0; i < convertEntryInfos.size(); ++i) {
                entryInfo = (DynamicObject)convertEntryInfos.get(i);
                DynamicObject materialMaster = entryInfo.getDynamicObject(materialField);
                this.convertQtyAndPriceInfo(entryInfo, materialMaster, (DynamicObject)convertUnitInfos.get(i), (DynamicObject)mainBillInfos.get(i));
            }
        } else {
            for (int i = 0; i < convertEntryInfos.size(); ++i) {
                entryInfo = (DynamicObject)convertEntryInfos.get(i);
                DynamicObject material = entryInfo.getDynamicObject(materialField);
                DynamicObject materialMaster = material.getDynamicObject("masterid");
                this.convertQtyAndPriceInfo(entryInfo, materialMaster, (DynamicObject)convertUnitInfos.get(i), (DynamicObject)mainBillInfos.get(i));
            }
        }
    }

    private void convertQtyAndPriceInfo(DynamicObject entryInfo, DynamicObject materialMaster, DynamicObject convertUnit, DynamicObject mainBillEntryInfo) {
        int denominator;
        int numberator;
        BigDecimal baseQty;
        Map propertyMapping = this.getCommonContext().getProperytMapping();
        DynamicObject beforeUnit = entryInfo.getDynamicObject((String)propertyMapping.get(UnitConvertPluginConstant.UNITKEY));
        BigDecimal beforeQty = entryInfo.getBigDecimal((String)propertyMapping.get(UnitConvertPluginConstant.QTYKEY));
        DynamicObject baseUnit = this.getBaseUnitValue(entryInfo, (String)propertyMapping.get(UnitConvertPluginConstant.BASEUNITKEY));
        int[] muBaseConv = null;
        DynamicObject actualBeforeUnit = null;
        BigDecimal actualBeforeQty = BigDecimal.ZERO;
        boolean fromBaseQtyCovert = false;
        if (beforeUnit != null && !beforeUnit.getPkValue().equals(convertUnit.getPkValue()) && baseUnit != null && StringUtils.isNotEmpty((String)((String)propertyMapping.get(UnitConvertPluginConstant.BASEQTYKEY))) && BigDecimal.ZERO.compareTo(baseQty = entryInfo.getBigDecimal((String)propertyMapping.get(UnitConvertPluginConstant.BASEQTYKEY))) != 0) {
            fromBaseQtyCovert = true;
        }
        if (fromBaseQtyCovert) {
            baseQty = entryInfo.getBigDecimal((String)propertyMapping.get(UnitConvertPluginConstant.BASEQTYKEY));
            actualBeforeUnit = baseUnit;
            actualBeforeQty = baseQty;
        } else if (beforeUnit != null) {
            actualBeforeUnit = beforeUnit;
            actualBeforeQty = beforeQty;
        }
        if (actualBeforeUnit != null) {
            int[] muQtyConv = MaterialHelper.getMUConvFraction((Long)((Long)materialMaster.getPkValue()), (Long)((Long)actualBeforeUnit.getPkValue()), (Long)((Long)convertUnit.getPkValue()), (boolean)this.isMuConvFromCache());
            if (baseUnit != null) {
                muBaseConv = muQtyConv;
            }
            if (muQtyConv != null) {
                numberator = muQtyConv[0];
                denominator = muQtyConv[1];
                if (denominator != 0) {
                    entryInfo.set((String)propertyMapping.get(UnitConvertPluginConstant.UNITKEY), (Object)convertUnit);
                    BigDecimal qty = actualBeforeQty.multiply(new BigDecimal(numberator)).divide(new BigDecimal(denominator), BillQuantityHelper.getPrecision((DynamicObject)convertUnit), BillQuantityHelper.getPrecisionType((DynamicObject)convertUnit));
                    entryInfo.set((String)propertyMapping.get(UnitConvertPluginConstant.QTYKEY), (Object)qty);
                } else {
                    log.info(this.getLogMsg("\u7269\u6599:" + materialMaster.getString("number") + "\u57fa\u672c\u5355\u4f4d\u8f6c\u6362\u7387\u4e0d\u5b58\u5728\u3002"));
                }
            }
        }
        int[] muConv = null;
        if (beforeUnit != null) {
            muConv = MaterialHelper.getMUConvFraction((Long)((Long)materialMaster.getPkValue()), (Long)((Long)beforeUnit.getPkValue()), (Long)((Long)convertUnit.getPkValue()), (boolean)this.isMuConvFromCache());
            if (muConv != null) {
                numberator = muConv[0];
                denominator = muConv[1];
                if (mainBillEntryInfo != null && this.isPriceInfoFromMainBill()) {
                    mainBillToEntryFieldMapping.forEach((k, v) -> {
                        String pField = (String)propertyMapping.get(k);
                        String vField = (String)propertyMapping.get(v);
                        if (StringUtils.isNotEmpty((String)pField) && StringUtils.isNotEmpty((String)vField)) {
                            if (UnitConvertPluginConstant.DISCOUNTTYPEKEY.equals(k)) {
                                Object discounttype = mainBillEntryInfo.get(this.getMainBillSelectField(entryInfo.getString((String)propertyMapping.get(UnitConvertPluginConstant.MAINBILLENTITYKEY)), vField));
                                discounttype = this.trasnferDiscountTypeValue(discounttype);
                                entryInfo.set(pField, discounttype);
                            } else {
                                entryInfo.set(pField, mainBillEntryInfo.get(this.getMainBillSelectField(entryInfo.getString((String)propertyMapping.get(UnitConvertPluginConstant.MAINBILLENTITYKEY)), vField)));
                            }
                        }
                    });
                    mainBillToBillFieldMapping.forEach((k, v) -> {
                        String pField = (String)propertyMapping.get(k);
                        String vField = (String)propertyMapping.get(v);
                        if (StringUtils.isNotEmpty((String)pField) && StringUtils.isNotEmpty((String)vField)) {
                            ((DynamicObject)entryInfo.getParent()).set(pField, mainBillEntryInfo.get(vField));
                        }
                    });
                } else {
                    String discountType;
                    String priceField = (String)propertyMapping.get(UnitConvertPluginConstant.PRICEKEY);
                    String taxPriceField = (String)propertyMapping.get(UnitConvertPluginConstant.TAXPRICEKEY);
                    String discountTypeField = (String)propertyMapping.get(UnitConvertPluginConstant.DISCOUNTTYPEKEY);
                    String discountRateField = (String)propertyMapping.get(UnitConvertPluginConstant.DISCOUNTRATEKEY);
                    if (StringUtils.isNotEmpty((String)priceField)) {
                        BigDecimal beforePrice = entryInfo.getBigDecimal(priceField) == null ? BigDecimal.ZERO : entryInfo.getBigDecimal(priceField);
                        BigDecimal afterPrice = beforePrice.multiply(new BigDecimal(denominator)).divide(new BigDecimal(numberator), 10, RoundingMode.HALF_UP);
                        entryInfo.set(priceField, (Object)afterPrice);
                    }
                    if (StringUtils.isNotEmpty((String)taxPriceField)) {
                        BigDecimal beforeTaxPrice = entryInfo.getBigDecimal(taxPriceField) == null ? BigDecimal.ZERO : entryInfo.getBigDecimal(taxPriceField);
                        BigDecimal afterTaxPrice = beforeTaxPrice.multiply(new BigDecimal(denominator)).divide(new BigDecimal(numberator), 10, RoundingMode.HALF_UP);
                        entryInfo.set(taxPriceField, (Object)afterTaxPrice);
                    }
                    if (StringUtils.isNotEmpty((String)discountTypeField) && ("B".equals(discountType = entryInfo.getString(discountTypeField)) || "PERUNIT".equals(discountType)) && StringUtils.isNotEmpty((String)discountRateField)) {
                        BigDecimal beforeDiscountRate = entryInfo.getBigDecimal(discountRateField) == null ? BigDecimal.ZERO : entryInfo.getBigDecimal(discountRateField);
                        BigDecimal afterDiscountRate = beforeDiscountRate.multiply(new BigDecimal(denominator)).divide(new BigDecimal(numberator), 10, RoundingMode.HALF_UP);
                        entryInfo.set(discountRateField, (Object)afterDiscountRate);
                    }
                    String isTaxField = (String)propertyMapping.get(UnitConvertPluginConstant.ISTAXKEY);
                    String taxRateField = (String)propertyMapping.get(UnitConvertPluginConstant.TAXRATEKEY);
                    if (StringUtils.isNotEmpty((String)priceField) && StringUtils.isNotEmpty((String)taxPriceField) && StringUtils.isNotEmpty((String)taxRateField) && StringUtils.isNotEmpty((String)isTaxField)) {
                        BigDecimal taxRate;
                        boolean isTax = ((DynamicObject)entryInfo.getParent()).getBoolean(isTaxField);
                        BigDecimal afterPrice = entryInfo.getBigDecimal(priceField);
                        BigDecimal afterTaxPrice = entryInfo.getBigDecimal(taxPriceField);
                        BigDecimal bigDecimal = taxRate = entryInfo.getBigDecimal(taxRateField) == null ? BigDecimal.ZERO : entryInfo.getBigDecimal(taxRateField);
                        if (isTax) {
                            afterPrice = afterTaxPrice.divide(BigDecimalUtil.ONE.add(BigDecimalUtil.div100((BigDecimal)taxRate)), 10, RoundingMode.HALF_UP);
                            entryInfo.set(priceField, (Object)afterPrice);
                        } else {
                            afterTaxPrice = afterPrice.multiply(BigDecimalUtil.ONE.add(BigDecimalUtil.div100((BigDecimal)taxRate))).setScale(10, RoundingMode.HALF_UP);
                            entryInfo.set(taxPriceField, (Object)afterTaxPrice);
                        }
                    }
                }
            } else {
                log.info(this.getLogMsg("\u7269\u6599:" + materialMaster.getString("number") + "\u8f6c\u6362\u7387\u4e0d\u5b58\u5728\u3002"));
            }
        }
        this.afterUnitConvert(entryInfo, muBaseConv, muConv, beforeUnit, convertUnit, mainBillEntryInfo);
    }

    private Object trasnferDiscountTypeValue(Object discounttype) {
        BillEntityType tgtMainType = this.getTgtMainType();
        String tgtMainName = tgtMainType.getName();
        if ("ap_finapbill".equals(tgtMainName) || "ar_finarbill".equals(tgtMainName) || "ar_busbill".equals(tgtMainName) || "ap_busbill".equals(tgtMainName) || "ar_revcfmbill".equals(tgtMainName)) {
            if ("A".equals(discounttype)) {
                discounttype = "PERCENT";
            } else if ("B".equals(discounttype)) {
                discounttype = "PERUNIT";
            }
        }
        return discounttype;
    }

    private boolean isPriceInfoFromMainBill() {
        return false;
    }

    private String getLogMsg(String msg) {
        return "convertUnit=" + msg;
    }

    private String generateMainUnitKey(String k, Object billentryID) {
        return k + billentryID;
    }

    private String getMainBillSelectField(String mainBillEntity, String field) {
        return this.getMainBillEntry(mainBillEntity) + "." + field;
    }

    private DynamicObject getBaseUnitValue(DynamicObject entryInfo, String baseUnitField) {
        if (StringUtils.isNotEmpty((String)baseUnitField)) {
            String[] fields = baseUnitField.split(SPLIT_DONT);
            if (fields.length == 1) {
                return entryInfo.getDynamicObject(baseUnitField);
            }
            if (fields.length == 2) {
                return entryInfo.getDynamicObject(fields[0]).getDynamicObject(fields[1]);
            }
        }
        return null;
    }

    static {
        materialInfoMap.put("bd_materialinventoryinfo", "inventoryunit");
        materialInfoMap.put("bd_materialmftinfo", "mftunit");
        materialInfoMap.put("bd_materialpurchaseinfo", "purchaseunit");
        materialInfoMap.put("bd_materialsalinfo", "salesunit");
        mainBillToEntryFieldMapping.put(UnitConvertPluginConstant.PRICEKEY, UnitConvertPluginMainBillConstant.MAINBILL_PRICEKEY);
        mainBillToEntryFieldMapping.put(UnitConvertPluginConstant.TAXPRICEKEY, UnitConvertPluginMainBillConstant.MAINBILL_TAXPRICEKEY);
        mainBillToEntryFieldMapping.put(UnitConvertPluginConstant.DISCOUNTTYPEKEY, UnitConvertPluginMainBillConstant.MAINBILL_DISCOUNTTYPEKEY);
        mainBillToEntryFieldMapping.put(UnitConvertPluginConstant.DISCOUNTRATEKEY, UnitConvertPluginMainBillConstant.MAINBILL_DISCOUNTRATEKEY);
        mainBillToEntryFieldMapping.put(UnitConvertPluginConstant.TAXRATEIDKEY, UnitConvertPluginMainBillConstant.MAINBILL_TAXRATEID);
        mainBillToEntryFieldMapping.put(UnitConvertPluginConstant.TAXRATEKEY, UnitConvertPluginMainBillConstant.MAINBILL_TAXRATE);
        mainBillToBillFieldMapping.put(UnitConvertPluginConstant.ISTAXKEY, UnitConvertPluginMainBillConstant.MAINBILL_ISTAXKEY);
    }

    static class UnitConvertPluginMainBillConstant {
        public static String MAINBILL_UNITKEY = "MAINBILL_UNITKEY";
        public static String MAINBILL_PRICEKEY = "MAINBILL_PRICEKEY";
        public static String MAINBILL_TAXPRICEKEY = "MAINBILL_TAXPRICEKEY";
        public static String MAINBILL_ISTAXKEY = "MAINBILL_ISTAXKEY";
        public static String MAINBILL_TAXRATEID = "MAINBILL_TAXRATEID";
        public static String MAINBILL_TAXRATE = "MAINBILL_TAXRATE";
        public static String MAINBILL_DISCOUNTTYPEKEY = "MAINBILL_DISCOUNTTYPEKEY";
        public static String MAINBILL_DISCOUNTRATEKEY = "MAINBILL_DISCOUNTRATEKEY";

        UnitConvertPluginMainBillConstant() {
        }
    }

    static class UnitConvertPluginConstant {
        public static String MATERIALKEY = "MATERIAL";
        public static String QTYKEY = "QTY";
        public static String UNITKEY = "UNIT";
        public static String BASEQTYKEY = "BASEQTY";
        public static String BASEUNITKEY = "BASEUNIT";
        public static String MAINBILLENTITYKEY = "MAINBILLENTITY";
        public static String MAINBILLIDKEY = "MAINBILLID";
        public static String MAINBILLENTRYIDKEY = "MAINBILLENTRYID";
        public static String PRICEKEY = "PRICE";
        public static String TAXPRICEKEY = "TAXPRICE";
        public static String CURRENCYKEY = "CURRENCY";
        public static String ISTAXKEY = "ISTAX";
        public static String TAXRATEIDKEY = "TAXRATEID";
        public static String TAXRATEKEY = "TAXRATE";
        public static String DISCOUNTTYPEKEY = "DISCOUNTTYPE";
        public static String DISCOUNTRATEKEY = "DISCOUNTRATE";

        UnitConvertPluginConstant() {
        }
    }
}

