/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin.botp;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mrp.opplugin.botp.PlanOrderToTargetOrderOp;

public class PlanOrderToOmOrderOp
extends PlanOrderToTargetOrderOp {
    private static final Log logger = LogFactory.getLog(PlanOrderToTargetOrderOp.class);
    private static final String OM_MFTORDER = "om_mftorder";
    private static final String _SPLIT_ = "&&";

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        Map dicMap = e.getFldProperties();
        List dataList = e.getSourceRows();
        HashMap orgMaterialsMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject data : dataList) {
            Long materialId = (Long)((DynamicProperty)dicMap.get("material")).getValue((Object)data);
            Long deptId = (Long)((DynamicProperty)dicMap.get("proorpurorg")).getValue((Object)data);
            Set materialsSet = orgMaterialsMap.computeIfAbsent(deptId, k -> new HashSet());
            materialsSet.add(materialId);
        }
        ArrayList<Long> planOrderIds = new ArrayList<Long>(100);
        Map materialmftInfosMap = PlanOrderHelper.getMaterialmftInfos((Map)orgMaterialsMap);
        for (DynamicObject data : dataList) {
            Long materId = (Long)((DynamicProperty)dicMap.get("material")).getValue((Object)data);
            Long org = (Long)((DynamicProperty)dicMap.get("proorpurorg")).getValue((Object)data);
            Long materialmftInfoId = (Long)materialmftInfosMap.get(materId + _SPLIT_ + org);
            Object planOrderId = ((DynamicProperty)dicMap.get("id")).getValue((Object)data);
            if (materialmftInfoId == null) {
                planOrderIds.add(Long.valueOf(planOrderId.toString()));
            }
            ((DynamicProperty)dicMap.get("material")).setValue((Object)data, (Object)materialmftInfoId);
            ((DynamicProperty)dicMap.get("materiallmft")).setValue((Object)data, (Object)materialmftInfoId);
            logger.info("\u8ba1\u5212\u8ba2\u5355id" + planOrderId + "\u4e0b\u63a8\u67e5\u8be2\u751f\u4ea7\u4fe1\u606fid" + materialmftInfoId);
        }
        if (planOrderIds != null && planOrderIds.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355%s\u65e0\u53ef\u7528\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"PlanOrderToOmOrderOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), planOrderIds));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] arg3 = entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        int arg4 = entitys.length;
        Map<Object, DynamicObject> materialsMap = this.getMaterials(entitys, "treeentryentity");
        for (int arg5 = 0; arg5 < arg4; ++arg5) {
            ExtendedDataEntity entity = arg3[arg5];
            DynamicObject bill = entity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObjectCollection treeentryentity = bill.getDynamicObjectCollection("treeentryentity");
            String name = bill.getDataEntityType().getName();
            if (org == null || treeentryentity == null || treeentryentity.size() == 0) continue;
            for (DynamicObject treeentry : treeentryentity) {
                this.setEntryMaterial(treeentry);
                this.coverMultiUnit(name, treeentry, materialsMap, this.cacheMap);
            }
            boolean exist = CodeRuleServiceHelper.isExist((String)OM_MFTORDER, (DynamicObject)bill, (String)org.getPkValue().toString());
            if (exist || !StringUtils.isBlank((CharSequence)bill.getString("billno"))) continue;
            bill.set("billno", (Object)UUID.randomUUID().toString().substring(0, 30));
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().getName();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        HashMap<String, Set> orgmasterIdMap = new HashMap<String, Set>(100);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject order = entity.getDataEntity();
            long orgid = order.getLong("org.id");
            if (orgid == 0L) continue;
            DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                Long materialId = orderEntry.getLong("material.masterid.id");
                if (materialId == 0L || orderEntry.get("warehouse") != null) continue;
                long bailedorgId = this.getBailedorgId(orderEntry.getString("supplyrule"), order);
                Set masterIdSet = orgmasterIdMap.computeIfAbsent(orgid + _SPLIT_ + bailedorgId, k -> new HashSet());
                masterIdSet.add(materialId);
            }
        }
        HashMap<String, Map<Long, Map<String, Object>>> mtfMessageMap = new HashMap<String, Map<Long, Map<String, Object>>>(100);
        for (Map.Entry orgmasterIdEntry : orgmasterIdMap.entrySet()) {
            String key = (String)orgmasterIdEntry.getKey();
            String[] orgIds = key.split(_SPLIT_);
            Long orgid = Long.valueOf(orgIds[0]);
            Long bailedorgId = Long.valueOf(orgIds[1]);
            Set masterIdSet = (Set)orgmasterIdEntry.getValue();
            Map<Long, Map<String, Object>> mtfMessage = this.getMtfMessage(orgid, masterIdSet, bailedorgId);
            mtfMessageMap.put(key, mtfMessage);
        }
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject order = entity.getDataEntity();
            long orgid = order.getLong("org.id");
            if (orgid == 0L) continue;
            DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                Map map;
                Long materialId = orderEntry.getLong("material.masterid.id");
                if (materialId == 0L || orderEntry.get("warehouse") != null) continue;
                long bailedorgId = this.getBailedorgId(orderEntry.getString("supplyrule"), order);
                Map mtfMessage = (Map)mtfMessageMap.get(orgid + _SPLIT_ + bailedorgId);
                if (mtfMessage == null || (map = (Map)mtfMessage.get(materialId)) == null) continue;
                orderEntry.set("inwardept_id", map.get("inwarorg"));
                orderEntry.set("warehouse_id", map.get("inwarehouse"));
                orderEntry.set("location_id", map.get("inwarelocation"));
                orderEntry.set("planscope_id", map.get("planscope"));
            }
        }
    }

    private long getBailedorgId(String supplyrule, DynamicObject order) {
        long bailedorgId = 0L;
        if (StringUtils.isNotBlank((CharSequence)supplyrule) && "C".equals(supplyrule)) {
            bailedorgId = order.getLong("entrustdept.id");
        }
        return bailedorgId;
    }

    private Map<Long, Map<String, Object>> getMtfMessage(Long orgid, Set<Long> masterIdSet, Long bailedorg) {
        Map mtfMessage = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IPlanScopeHelperService", (String)"getMaterialInwareInfo", (Object[])new Object[]{orgid, bailedorg, masterIdSet});
        return mtfMessage;
    }

    protected void setEntryMaterial(DynamicObject treeentry) {
        DynamicObject material;
        DynamicObject materialinv = treeentry.getDynamicObject("material");
        if (materialinv != null && (material = materialinv.getDynamicObject("masterid")) != null) {
            treeentry.set("materielmasterid", (Object)material);
        }
    }
}

