/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin.botp;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mrp.opplugin.botp.BillUnitConvertPlugin;

public class PlanOrderToPurApplyOp
extends BillUnitConvertPlugin {
    private static final String PM_PURAPPLYBILL = "pm_purapplybill";

    @Override
    protected void afterUnitConvert(DynamicObject afterConvertEntryInfo, int[] muBaseConv, int[] muConv, DynamicObject beforeUnit, DynamicObject convertUnit, DynamicObject mainBillEntryInfo) {
        BigDecimal qty = afterConvertEntryInfo.getBigDecimal("qty");
        afterConvertEntryInfo.set("applyqty", (Object)qty);
    }

    @Override
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] arg3 = entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        int arg4 = entitys.length;
        ConvertRuleElement rule = this.getRule();
        String sourceLoadField = PlanOrderHelper.getSourceLoadField((ConvertRuleElement)rule);
        for (int arg5 = 0; arg5 < arg4; ++arg5) {
            ExtendedDataEntity entity = arg3[arg5];
            DynamicObject bill = entity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) {
                return;
            }
            Long orgId = (Long)org.getPkValue();
            boolean exist = CodeRuleServiceHelper.isExist((String)PM_PURAPPLYBILL, (DynamicObject)bill, (String)orgId.toString());
            if (!exist && StringUtils.isBlank((CharSequence)bill.getString("billno"))) {
                bill.set("billno", (Object)UUID.randomUUID().toString().substring(0, 30));
            }
            List sourceBillIds = PlanOrderHelper.getAllSourceBillIds((DynamicObject)bill);
            DynamicObject currency = bill.getDynamicObject("currency");
            if (currency == null) {
                Map<String, Long> map;
                DynamicObject currencyInfo = null;
                if (orgId != 0L && (map = PlanOrderToPurApplyOp.getCurrencyAndExRateTable(orgId)) != null) {
                    currencyInfo = BusinessDataServiceHelper.loadSingle((Object)map.get("baseCurrencyID"), (String)"bd_currency");
                }
                if (currencyInfo != null) {
                    bill.set("currency", currencyInfo);
                } else {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5e01\u79cd\u4e3a\u7a7a\u3002", (String)"PlanOrderToPurApplyOp_0", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), sourceBillIds));
                }
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                DynamicObject material;
                DynamicObject materialinv = entry.getDynamicObject("material");
                if (materialinv == null || (material = materialinv.getDynamicObject("masterid")) == null) continue;
                entry.set("materialmasterid", (Object)material);
            }
        }
        super.afterConvert(e);
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map map;
        Map mapOrg;
        if (orgId != null && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            return map;
        }
        return null;
    }
}

