/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin.botp;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.common.enums.PrecisionAccountEnum;
import kd.mpscmm.msplan.mrp.business.helper.BillUnitAndQtytHelper;

public class PlanOrderToTargetOrderOp
extends AbstractConvertPlugIn {
    protected Map<String, String> cacheMap = new HashMap<String, String>();
    protected static final String UNITCONVERTDIR_A = "A";
    protected static final String UNITCONVERTDIR_C = "C";

    protected void coverMultiUnit(String entityNumber, DynamicObject entityEntry, Map<Object, DynamicObject> materialsMap, Map<String, String> cacheMap) {
        DynamicObject materialInfo = entityEntry.getDynamicObject("material");
        if (materialInfo == null) {
            return;
        }
        DynamicObject material = materialInfo.getDynamicObject("masterid");
        DynamicObject materialUnit = materialInfo.getDynamicObject(this.getMaterialUnitType());
        if (materialUnit == null) {
            return;
        }
        entityEntry.set(this.getMaterialUnit(), (Object)materialUnit);
        DynamicObject baseunit = entityEntry.getDynamicObject(this.getBaseunit());
        BigDecimal baseqty = entityEntry.getBigDecimal(this.getBaseqty());
        if (baseunit == null || BigDecimal.ZERO.compareTo(baseqty) == 0) {
            return;
        }
        Object materialId = material.getPkValue();
        BigDecimal unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv((Long)((Long)(material = materialsMap.get(materialId)).getPkValue()), (Long)((Long)materialUnit.getPkValue()), (Long)((Long)baseunit.getPkValue()), cacheMap);
        if (unit2ndRate == null || BigDecimal.ZERO.compareTo(unit2ndRate) == 0) {
            return;
        }
        BigDecimal qtyUnit2nd = BigDecimal.ZERO;
        if (baseqty != null && baseqty.compareTo(BigDecimal.ZERO) != 0) {
            qtyUnit2nd = baseqty.divide(unit2ndRate, materialUnit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)materialUnit.getInt("precisionaccount")));
        }
        entityEntry.set(this.getMaterialQty(), (Object)qtyUnit2nd);
        if ("pm_purapplybill".equals(entityNumber)) {
            entityEntry.set("qty", (Object)qtyUnit2nd);
        } else if ("pom_mftorder".equals(entityNumber) || "om_mftorder".equals(entityNumber)) {
            entityEntry.set("planqty", (Object)qtyUnit2nd);
        }
        DynamicObject auxptyunit = entityEntry.getDynamicObject(this.getAuxptyUnitType());
        String unitconvertdir = material.getString("unitconvertdir");
        if (auxptyunit != null && (UNITCONVERTDIR_A.equals(unitconvertdir) || UNITCONVERTDIR_C.equals(unitconvertdir))) {
            BigDecimal auxptyRate = BillUnitAndQtytHelper.getUnitRateConv((Long)((Long)material.getPkValue()), (Long)((Long)auxptyunit.getPkValue()), (Long)((Long)baseunit.getPkValue()), cacheMap);
            BigDecimal auxptyqty = BigDecimal.ZERO;
            if (baseqty != null && baseqty.compareTo(BigDecimal.ZERO) != 0 && auxptyRate.compareTo(BigDecimal.ZERO) != 0) {
                auxptyqty = baseqty.divide(auxptyRate, auxptyunit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)auxptyunit.getInt("precisionaccount")));
            }
            entityEntry.set(this.getAuxptyQty(), (Object)auxptyqty);
        }
    }

    protected Map<Object, DynamicObject> getMaterials(ExtendedDataEntity[] entitys, String entryName) {
        HashSet materialIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryName);
            for (DynamicObject entry : entrys) {
                DynamicObject material;
                DynamicObject materialInfo = entry.getDynamicObject("material");
                if (materialInfo == null || (material = materialInfo.getDynamicObject("masterid")) == null) continue;
                materialIdSet.add(Long.valueOf(material.getPkValue().toString()));
            }
        }
        Map materialsMap = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,auxptyunit,unitconvertdir", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)materialIdSet)});
        return materialsMap;
    }

    protected String getBaseunit() {
        return "baseunit";
    }

    protected String getBaseqty() {
        return "baseqty";
    }

    protected String getMaterialUnit() {
        return "unit";
    }

    protected String getMaterialQty() {
        return "qty";
    }

    protected String getMaterialUnitType() {
        return "mftunit";
    }

    protected String getAuxptyUnitType() {
        return "auxptyunit";
    }

    protected String getAuxptyQty() {
        return "auxptyqty";
    }
}

