/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin.planexecute;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DropConfigureSaveAndSubmitValidator
extends AbstractValidator {
    private static final String MORE = "more";
    private static final String NONE = "none";

    public void validate() {
        this.checkDataMustInput();
        this.checkDataRepeat();
        this.checkCtrlPolicy();
    }

    private void checkDataRepeat() {
        ArrayList<Long> createOrgIds = new ArrayList<Long>(this.dataEntities.length);
        ArrayList<Long> ids = new ArrayList<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            DynamicObject createOrg = obj.getDynamicObject("createorg");
            if (createOrg == null) continue;
            createOrgIds.add(createOrg.getLong("id"));
            ids.add(obj.getLong("id"));
        }
        QFilter qfilter = new QFilter("createorg", "in", createOrgIds);
        qfilter.and(new QFilter("id", "not in", ids));
        String selectField = "id, createorg.id createorg";
        Map<Long, String> allData = this.getData(qfilter, selectField, "createorg");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            DynamicObject createOrg = obj.getDynamicObject("createorg");
            if (createOrg == null) continue;
            String createOrgStr = createOrg.getString("id");
            if (!allData.values().contains(createOrgStr)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u5df2\u5b58\u5728\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u914d\u7f6e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u3002", (String)"DropConfigureSaveAndSubmitValidator_7", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkDataMustInput() {
        MainEntityType planordertpl = EntityMetadataCache.getDataEntityType((String)"mrp_planordertpl");
        ComboProp planordertplOrdertype = (ComboProp)planordertpl.getProperty("ordertype");
        List comboItems = planordertplOrdertype.getComboItems();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entryentity");
            DynamicObjectType dropConf = entrys.getDynamicObjectType();
            ComboProp dropConfOrdertype = (ComboProp)dropConf.getProperty("ordertype");
            List comboItems2 = dropConfOrdertype.getComboItems();
            if (comboItems2 != null && comboItems2.size() > 0) {
                comboItems.addAll(comboItems2);
            }
            HashMap orderTypeIsDefMap = Maps.newHashMapWithExpectedSize((int)comboItems.size());
            HashMap orderTypeNameMap = Maps.newHashMapWithExpectedSize((int)comboItems.size());
            for (ValueMapItem comboItem : comboItems) {
                if (!comboItem.isItemVisible()) continue;
                orderTypeIsDefMap.put(comboItem.getValue(), 0);
                orderTypeNameMap.put(comboItem.getValue(), comboItem.getName());
            }
            for (DynamicObject entry : entrys) {
                String orderType = entry.getString("ordertype");
                DynamicObject targetBill = entry.getDynamicObject("targetbill");
                boolean isDefault = entry.getBoolean("isdefault");
                if (StringUtils.isBlank((CharSequence)orderType) || targetBill == null) continue;
                Integer oldIsDefault = (Integer)orderTypeIsDefMap.get(orderType);
                if (!isDefault) continue;
                Integer n = oldIsDefault;
                Integer n2 = oldIsDefault = Integer.valueOf(oldIsDefault + 1);
                orderTypeIsDefMap.put(orderType, oldIsDefault);
            }
            this.checkData(MORE, orderTypeIsDefMap, orderTypeNameMap, dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e00\u4e2a\u9ed8\u8ba4\u6295\u653e\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u591a\u4e2a\u3002", (String)"DropConfigureSaveAndSubmitValidator_5", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
            this.checkData(NONE, orderTypeIsDefMap, orderTypeNameMap, dataEntity, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e00\u4e2a\u9ed8\u8ba4\u6295\u653e\u5355\u636e\u3002", (String)"DropConfigureSaveAndSubmitValidator_6", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkData(String flag, Map<String, Integer> orderTypeIsDefMap, Map<String, LocaleString> orderTypeNameMap, ExtendedDataEntity dataEntity, String errorMsg) {
        StringBuilder errorMessage = new StringBuilder(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u914d\u7f6e\uff1a\u8ba2\u5355\u7c7b\u578b\u4e3a", (String)"DropConfigureSaveAndSubmitValidator_4", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
        StringBuilder errorOrderType = new StringBuilder();
        for (Map.Entry<String, Integer> data : orderTypeIsDefMap.entrySet()) {
            String orderTypeValue = data.getKey();
            Integer isDef = data.getValue();
            if (MORE.equals(flag) && isDef > 1) {
                errorOrderType.append('[').append(orderTypeNameMap.get(orderTypeValue).getLocaleValue()).append(']');
            }
            if (!NONE.equals(flag) || isDef != 0) continue;
            errorOrderType.append('[').append(orderTypeNameMap.get(orderTypeValue).getLocaleValue()).append(']');
        }
        if (StringUtils.isBlank((CharSequence)errorOrderType)) {
            return;
        }
        errorMessage.append((CharSequence)errorOrderType).append(errorMsg);
        this.addErrorMessage(dataEntity, errorMessage.toString());
    }

    private void checkCtrlPolicy() {
        QFilter ctrlFilter = new QFilter("ctrlstrategy", "=", (Object)Character.valueOf('5'));
        String selectField = "id, createorg.name createorg";
        Map<Long, String> allSharedData = this.getData(ctrlFilter, selectField, "createorg");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Set<Long> ids;
            DynamicObject obj = dataEntity.getDataEntity();
            String ctrlstrategy = obj.getString("ctrlstrategy");
            long id = 0L;
            if (obj.get("id") != null) {
                id = obj.getLong("id");
            }
            if ((ids = allSharedData.keySet()).contains(id) || !"5".equals(ctrlstrategy) || allSharedData == null || allSharedData.size() <= 0 || id != 0L) continue;
            StringBuilder errorMessage = new StringBuilder(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u914d\u7f6e\uff1a", (String)"DropConfigureSaveAndSubmitValidator_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
            errorMessage.append(ResManager.loadKDString((String)"\u5728\u7ec4\u7ec7", (String)"DropConfigureSaveAndSubmitValidator_2", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
            for (String orgName : allSharedData.values()) {
                errorMessage.append('[').append(orgName).append(']');
            }
            errorMessage.append(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5168\u5c40\u5171\u4eab\u7684\u8ba1\u5212\u5efa\u8bae\u6295\u653e\u914d\u7f6e\u3002", (String)"DropConfigureSaveAndSubmitValidator_3", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
            this.addErrorMessage(dataEntity, errorMessage.toString());
        }
    }

    private Map<Long, String> getData(QFilter ctrlFilter, String selectField, String prop) {
        HashMap<Long, String> allSharedData = new HashMap<Long, String>(this.dataEntities.length);
        String createOrg = "";
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"msplan_dropconfigure", (String)"msplan_dropconfigure", (String)selectField, (QFilter[])new QFilter[]{ctrlFilter}, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long id = row.getLong("id");
                if (row.getString(prop) != null) {
                    createOrg = row.getString(prop);
                }
                allSharedData.put(id, createOrg);
            }
        }
        return allSharedData;
    }
}

