/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin.planexecute;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mrp.opplugin.planexecute.PlanOrderValidator;

public class PlanOrderSaveOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PlanOrderSaveOp.class);
    private static Set<String> prop = new HashSet<String>();
    private Map<Object, List<DynamicObject>> updateLogMap = new HashMap<Object, List<DynamicObject>>();
    private String opName;
    private String isLog;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("ordertype");
        e.getFieldKeys().add("entrymaterial");
        e.getFieldKeys().add("entryversion");
        e.getFieldKeys().add("entrymode");
        e.getFieldKeys().add("seq");
        e.getFieldKeys().add("entryentity.seq");
        e.getFieldKeys().add("copentry.seq");
        e.getFieldKeys().add("bom");
        e.getFieldKeys().add("unfoldbomdate");
        e.getFieldKeys().add("proorpurorg");
        e.getFieldKeys().add("orderqty");
        e.getFieldKeys().add("yield");
        e.getFieldKeys().add("endproqty");
        e.getFieldKeys().add("startdate");
        e.getFieldKeys().add("enddate");
        e.getFieldKeys().add("availabledate");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("unit");
        e.getFieldKeys().add("entryrequiredate");
        e.getFieldKeys().add("materialplanid");
        e.getFieldKeys().add("materiallock");
        e.getFieldKeys().add("materialspread");
        e.getFieldKeys().add("orderdate");
        e.getFieldKeys().add("entryunit");
        e.getFieldKeys().add("copentryunit");
        e.getFieldKeys().add("entryreplaceplan");
        e.getFieldKeys().add("entryrequireqty");
        e.getFieldKeys().add("entrystandqty");
        e.getFieldKeys().add("entryscraprate");
        e.getFieldKeys().add("configuredcode");
        e.getFieldKeys().add("entryconfiguredcode");
        e.getFieldKeys().add("entrymaterialplanid");
        e.getFieldKeys().add("auxproperty");
        e.getFieldKeys().add("entryauxproperty");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("inwarehouse");
        e.getFieldKeys().add("planscope");
        e.getFieldKeys().add("supplyrule");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String name = this.billEntityType.getName();
        if ("mrp_xplanorder".equals(name)) {
            return;
        }
        e.addValidator((AbstractValidator)new PlanOrderValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] oldPlanorders;
        boolean containsIslog;
        String name = this.billEntityType.getName();
        if ("mrp_xplanorder".equals(name)) {
            return;
        }
        boolean containsBatchUpdate = this.operateOption.containsVariable("batchUpdate");
        if (containsBatchUpdate) {
            this.opName = this.operateOption.getVariableValue("batchUpdate");
        }
        this.isLog = (containsIslog = this.operateOption.containsVariable("islog")) ? this.operateOption.getVariableValue("islog") : null;
        if (StringUtils.isBlank((CharSequence)this.isLog)) {
            return;
        }
        this.opName = "batchUpdate".equals(this.opName) ? ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539", (String)"PlanOrderSaveOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fee\u6539", (String)"PlanOrderSaveOp_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
        DynamicObject[] dataEntities = e.getDataEntities();
        BillEntityType dataEntityType = (BillEntityType)dataEntities[0].getDataEntityType();
        ArrayList<Object> orderIds = new ArrayList<Object>(dataEntities.length);
        HashMap<Object, DynamicObject> orderMap = new HashMap<Object, DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DataEntityState dataEntityState = dataEntity.getDataEntityState();
            Boolean isFromDB = dataEntityState.getFromDatabase();
            if (!isFromDB.booleanValue() && !Objects.equals(dataEntity.getPkValue(), 0L)) continue;
            orderIds.add(dataEntity.getPkValue());
            orderMap.put(dataEntity.getPkValue(), dataEntity);
        }
        if (orderIds.isEmpty()) {
            return;
        }
        Map fieldDatas = BusinessDataServiceHelper.loadFromCache((String)"msplan_batch_edit", (String)"id,field", (QFilter[])new QFilter[]{new QFilter("source", "=", (Object)name)});
        for (DynamicObject fieldData : fieldDatas.values()) {
            prop.add(fieldData.getString("field"));
        }
        for (DynamicObject oldPlanorder : oldPlanorders = BusinessDataServiceHelper.load((Object[])orderIds.toArray(new Object[0]), (DynamicObjectType)dataEntityType)) {
            Object pkValue = oldPlanorder.getPkValue();
            DynamicObject newPlanorder = (DynamicObject)orderMap.get(pkValue);
            this.compare(newPlanorder, oldPlanorder, (MainEntityType)dataEntityType);
        }
    }

    private void compare(DynamicObject newPlanorder, DynamicObject oldPlanorder, MainEntityType dataEntityType) {
        long starttime = System.currentTimeMillis();
        for (String pro : prop) {
            String[] props = pro.split("\\.");
            int level = 0;
            if (props.length > 2) continue;
            this.dealUpdateLog(props, level, dataEntityType, newPlanorder, oldPlanorder);
        }
        logger.info("PlanOrderSaveOp.compare\u6bd4\u8f83\u65f6\u957f\uff1a" + (System.currentTimeMillis() - starttime) / 1000L + "s");
    }

    private void dealUpdateLog(String[] props, int level, MainEntityType dataEntityType, DynamicObject newPlanorder, DynamicObject oldPlanorder) {
        IDataEntityProperty property = dataEntityType.findProperty(props[level]);
        if (property == null) {
            return;
        }
        Long planorderentryid = 0L;
        String planorderentry = "";
        String planorderentryno = "";
        String planorderbillno = newPlanorder.getString("billno");
        Long planorderId = newPlanorder.getLong("id");
        DynamicObject baseunit = newPlanorder.getDynamicObject("unit");
        if (property instanceof DynamicCollectionProperty) {
            DynamicObjectCollection newEntrys = newPlanorder.getDynamicObjectCollection(props[level]);
            DynamicObjectCollection oldEntrys = oldPlanorder.getDynamicObjectCollection(props[level]);
            String entryProp = props[level + 1];
            String unitKey = this.getEntryUnitKey(props[level]);
            IDataEntityProperty entryProperty = dataEntityType.findProperty(entryProp);
            if (entryProperty == null) {
                return;
            }
            Map<Object, DynamicObject> newEntryMap = this.getEntryMap(newEntrys);
            Map<Object, DynamicObject> oldEntryMap = this.getEntryMap(oldEntrys);
            for (Map.Entry<Object, DynamicObject> entry : newEntryMap.entrySet()) {
                Object key = entry.getKey();
                DynamicObject newEntry = entry.getValue();
                DynamicObject oldEntry = oldEntryMap.get(key);
                if (oldEntry == null) continue;
                planorderentryid = Long.valueOf(key.toString());
                planorderentry = props[level];
                planorderentryno = newEntry.getString("seq");
                DynamicObject entryUnit = newEntry.getDynamicObject(unitKey);
                this.recordLogInfo(oldEntry, newEntry, entryProp, entryProperty, planorderentryid, planorderentry, planorderentryno, planorderId, planorderbillno, entryUnit);
            }
            return;
        }
        this.recordLogInfo(oldPlanorder, newPlanorder, props[level], property, planorderentryid, planorderentry, planorderentryno, planorderId, planorderbillno, baseunit);
    }

    private String getEntryUnitKey(String entryProp) {
        String unitKey = null;
        if ("entryentity".equals(entryProp)) {
            unitKey = "entryunit";
        } else if ("copentry".equals(entryProp)) {
            unitKey = "copentryunit";
        }
        return unitKey;
    }

    private void recordLogInfo(DynamicObject oldEntry, DynamicObject newData, String prop, IDataEntityProperty property, Long planorderentryid, String planorderentry, String planorderentryno, Long planorderid, String planorderbillno, DynamicObject unit) {
        String oldValue = this.getValue(oldEntry, prop, property, unit);
        String newValue = this.getValue(newData, prop, property, unit);
        logger.info("\u8ba1\u5212\u8ba2\u5355" + planorderbillno + "\u8bb0\u5f55\u6bd4\u8f83\u6570\u636e\uff1a\u4fee\u6539\u5b57\u6bb5" + prop + "\u4fee\u6539\u524d" + oldValue + "\u4fee\u6539\u540e" + newValue);
        if (!Objects.equals(oldValue, newValue)) {
            DynamicObject updateLog = BusinessDataServiceHelper.newDynamicObject((String)"msplan_planupdatelog");
            updateLog.set("prevalue", (Object)oldValue);
            updateLog.set("nextvalue", (Object)newValue);
            updateLog.set("propname", (Object)property.getDisplayName().getLocaleValue());
            updateLog.set("opname", (Object)this.opName);
            updateLog.set("planorderbillno", (Object)planorderbillno);
            updateLog.set("planorderid", (Object)planorderid);
            updateLog.set("planorderentry", (Object)planorderentry);
            updateLog.set("planorderentryid", (Object)planorderentryid);
            updateLog.set("planorderentryno", (Object)planorderentryno);
            this.updateLogMap.computeIfAbsent(planorderid, k -> new ArrayList()).add(updateLog);
        }
    }

    private Map<Object, DynamicObject> getEntryMap(DynamicObjectCollection entrys) {
        HashMap<Object, DynamicObject> entryMap = new HashMap<Object, DynamicObject>(entrys.size());
        for (DynamicObject entry : entrys) {
            entryMap.put(entry.getPkValue(), entry);
        }
        return entryMap;
    }

    public String getValue(DynamicObject data, String prop, IDataEntityProperty property, DynamicObject unit) {
        if (data == null) {
            return "";
        }
        if (property instanceof BasedataProp) {
            BasedataProp baseDataProp = (BasedataProp)property;
            String displayProp = baseDataProp.getDisplayProp();
            DynamicObject dobj = data.getDynamicObject(prop);
            if (dobj == null) {
                return "";
            }
            return data.getDynamicObject(prop).getString(displayProp);
        }
        if (property instanceof TextProp) {
            return data.getString(prop);
        }
        if (property instanceof DateProp || property instanceof DateTimeProp) {
            Date date = data.getDate(prop);
            if (date == null) {
                return "";
            }
            return PlanOrderHelper.formatDateTime((Date)date);
        }
        if (property instanceof QtyProp) {
            BigDecimal value = data.getBigDecimal(prop).setScale(unit.getInt("precision"), 4);
            if (value == null || value.compareTo(BigDecimal.ZERO) == 0) {
                return "";
            }
            return value.toString();
        }
        if (property instanceof DecimalProp) {
            BigDecimal value = data.getBigDecimal(prop);
            if (value == null || value.compareTo(BigDecimal.ZERO) == 0) {
                return "";
            }
            return value.toString();
        }
        if (property instanceof BooleanProp) {
            Boolean value = data.getBoolean(prop);
            return value.toString();
        }
        if (property instanceof ComboProp) {
            String value = data.getString(prop);
            List comboItems = ((ComboProp)property).getComboItems();
            String name = "";
            for (ValueMapItem comboItem : comboItems) {
                if (!comboItem.getValue().equals(value)) continue;
                name = comboItem.getName().getLocaleValue();
                break;
            }
            return name;
        }
        return "";
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> updateLogs = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            Object pkValue = data.getPkValue();
            List<DynamicObject> logs = this.updateLogMap.get(pkValue);
            if (logs == null) continue;
            Date opdate = data.getDate("modifytime");
            String userName = RequestContext.get().getUserName();
            for (DynamicObject updateLog : logs) {
                updateLog.set("opdate", (Object)opdate);
                updateLog.set("username", (Object)userName);
            }
            updateLogs.addAll(logs);
        }
        SaveServiceHelper.save((DynamicObject[])updateLogs.toArray(new DynamicObject[0]));
    }

    static {
        prop.add("endproqty");
        prop.add("bom");
        prop.add("unfoldbomdate");
        prop.add("availabledate");
        prop.add("copentry.copentryallqty");
        prop.add("entryentity.entrystandqty");
        prop.add("entryentity.entryrequireqty");
        prop.add("entryentity.entryrequiredate");
    }
}

