/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin.planexecute;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.mpscmm.common.enums.MaterialAttrEnum;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mrp.opplugin.planexecute.PlanOrderSplitValidator;

public class PlanOrderSplitOp
extends AbstractOperationServicePlugIn {
    private static final String ENTRY_ENTITY = "entryentity";
    private static Log logger = LogFactory.getLog(PlanOrderSplitOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PlanOrderSplitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        for (DynamicObject obj : e.getDataEntities()) {
            try {
                this.doBizOp(obj);
                successObjs.add(obj);
            }
            catch (KDBizException exp) {
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(obj, exp));
            }
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }

    private void doBizOp(DynamicObject obj) {
        String entityNumber = this.getEntityNumber();
        String oldbillid = obj.getString("oldbillid");
        if (StringUtils.isBlank((CharSequence)oldbillid)) {
            throw new KDBizException(new ErrorCode(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u62c6\u5206", (String)"PlanOrderSplitOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u539f\u8ba1\u5212\u8ba2\u5355\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"PlanOrderSplitOp_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0])), new Object[0]);
        }
        DynamicObject planOrder = BusinessDataServiceHelper.loadSingle((Object)oldbillid, (String)entityNumber);
        if (planOrder == null) {
            throw new KDBizException(new ErrorCode(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u62c6\u5206", (String)"PlanOrderSplitOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u539f\u8ba1\u5212\u8ba2\u5355\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"PlanOrderSplitOp_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0])), new Object[0]);
        }
        DynamicObjectCollection entrys = obj.getDynamicObjectCollection(ENTRY_ENTITY);
        if (entrys == null || entrys.isEmpty()) {
            throw new KDBizException(new ErrorCode(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u62c6\u5206", (String)"PlanOrderSplitOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u62c6\u5206\u5206\u5f55\u3002", (String)"PlanOrderSplitOp_2", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0])), new Object[0]);
        }
        DynamicObject material = planOrder.getDynamicObject("material");
        DynamicObject supplyOrg = planOrder.getDynamicObject("proorpurorg");
        DynamicObject entryMaterialPlan = PlanOrderHelper.getMaterialInfo((Long)material.getLong("id"), (Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")), (String)"mpdm_materialplan", (String)"id,createorg,leadtimetype,materialattr,fixedleadtime,changeleadtime,changebatch,preprocessingtime,postprocessingtime", (IPageCache)null);
        if (entryMaterialPlan == null) {
            throw new KDBizException(new ErrorCode(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u62c6\u5206", (String)"PlanOrderSplitOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u7269\u6599%s\u4e0d\u5b58\u5728\u5df2\u5ba1\u6838\u3001\u53ef\u7528\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"PlanOrderSplitOp_3", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), material.getString("number"))), new Object[0]);
        }
        String materialattr = entryMaterialPlan.getString("materialattr");
        BigDecimal oldOrderQty = obj.getBigDecimal("oldorderqty");
        ArrayList<Long> orderIds = new ArrayList<Long>();
        long[] ids = DB.genLongIds((String)planOrder.getDataEntityType().getAlias(), (int)entrys.size());
        ArrayList<Object> newOrders = new ArrayList<Object>(entrys.size());
        HashMap newOrderIdMap = Maps.newHashMapWithExpectedSize((int)entrys.size());
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject newOrder = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
            this.copy(planOrder, newOrder);
            if (StringUtils.isNotBlank((Object)entry.get("id"))) {
                newOrder.set("id", entry.get("id"));
                orderIds.add(Long.valueOf(entry.getString("id")));
            } else {
                newOrder.set("id", (Object)ids[i]);
                orderIds.add(ids[i]);
            }
            BigDecimal newOrderQty = entry.getBigDecimal("orderqty");
            String orderType = entry.getString("ordertype");
            newOrder.set("billno", entry.get("billno"));
            newOrder.set("ordertype", (Object)orderType);
            newOrder.set("orderqty", (Object)newOrderQty);
            newOrder.set("enddate", entry.get("enddate"));
            newOrder.set("startdate", entry.get("startdate"));
            BigDecimal yield = newOrder.getBigDecimal("yield");
            BigDecimal endproqty = entry.getBigDecimal("orderqty").multiply(yield);
            newOrder.set("endproqty", (Object)endproqty);
            newOrder.set("billstatus", (Object)"A");
            if (!MaterialAttrEnum.PURCHASEDPART.getValue().equals(orderType)) {
                this.recalCulation(newOrder, materialattr, planOrder, supplyOrg, newOrderQty, oldOrderQty);
            }
            newOrders.add(newOrder);
            newOrderIdMap.put(entry.get("id"), i);
        }
        OperationResult result = SaveServiceHelper.saveOperate((String)entityNumber, (DynamicObject[])newOrders.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            StringBuilder error = new StringBuilder();
            for (IOperateInfo info : result.getAllErrorOrValidateInfo()) {
                Object pkValue = info.getPkValue();
                if (pkValue == null) continue;
                Integer i = (Integer)newOrderIdMap.get(pkValue.toString());
                error.append(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u62c6\u5206\u7b2c%1$s\u6761\u6570\u636e\uff0c%2$s", (String)"PlanOrderSplitOp_4", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), i + 1, info.getMessage()));
            }
            if (error.length() == 0) {
                error.append(result.getMessage());
            }
            throw new KDBizException(new ErrorCode(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u62c6\u5206", (String)"PlanOrderSplitOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), error.toString()), new Object[0]);
        }
        BigDecimal sumQty = obj.getBigDecimal("sumqty");
        BigDecimal newOrderQty = oldOrderQty.subtract(sumQty);
        if (sumQty.compareTo(oldOrderQty) == 0) {
            planOrder.set("billstatus", (Object)"D");
            newOrderQty = BigDecimal.ZERO;
        }
        planOrder.set("orderqty", (Object)newOrderQty);
        BigDecimal yield = planOrder.getBigDecimal("yield");
        BigDecimal endproqty = planOrder.getBigDecimal("orderqty").multiply(yield);
        planOrder.set("endproqty", (Object)endproqty);
        this.recalCulation(planOrder, materialattr, planOrder, supplyOrg, newOrderQty, oldOrderQty);
        SaveServiceHelper.update((DynamicObject)planOrder);
        this.addSplitRel(oldbillid, orderIds, planOrder);
        ThreadPools.executeOnce((String)"PlanOrderSplitOp_Operate", () -> {
            try {
                DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"INetChangeSynService", (String)"synSplitPlanOrderRecords", (Object[])new Object[]{planOrder, newOrders});
            }
            catch (Exception ex) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            }
        });
    }

    private void recalCulation(DynamicObject newOrder, String materialattr, DynamicObject planOrder, DynamicObject supplyOrg, BigDecimal newOrderQty, BigDecimal oldOrderQty) {
        DynamicObjectCollection planOrderEntrys = newOrder.getDynamicObjectCollection(ENTRY_ENTITY);
        if (planOrderEntrys != null && !planOrderEntrys.isEmpty()) {
            for (int j = 0; j < planOrderEntrys.size(); ++j) {
                DynamicObject planOrderEntry = (DynamicObject)planOrderEntrys.get(j);
                this.recalCulationDate(planOrderEntry, newOrder, materialattr, supplyOrg);
                DynamicObject entryreplaceplan = planOrderEntry.getDynamicObject("entryreplaceplan");
                BigDecimal entryrequireqty = planOrderEntry.getBigDecimal("entryrequireqty");
                if (entryreplaceplan != null && BigDecimal.ZERO.compareTo(entryrequireqty) == 0) continue;
                PlanOrderHelper.recalCulationQty((DynamicObject)planOrderEntry, (DynamicObject)planOrder, (DynamicObject)planOrderEntry, (int)j, (BigDecimal)newOrderQty, (BigDecimal)oldOrderQty);
            }
        }
        DynamicObjectCollection copEntrys = newOrder.getDynamicObjectCollection("copentry");
        PlanOrderHelper.recalCulationCopentrysQty((DynamicObjectCollection)copEntrys, (BigDecimal)newOrderQty);
    }

    private void recalCulationDate(DynamicObject planOrderEntry, DynamicObject planOrder, String materialattr, DynamicObject supplyOrg) {
        Date date = null;
        if (!MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            date = this.getRecentWorkDate(planOrder.getDate("startdate"), supplyOrg);
        }
        if (date == null) {
            date = planOrder.getDate("startdate");
        }
        Integer leadtime = planOrderEntry.getInt("entryleadtime");
        Date reqDate = PlanOrderHelper.getReqDate((Date)date, (Integer)leadtime, (Long)supplyOrg.getLong("id"), (String)materialattr);
        planOrderEntry.set("entryrequiredate", (Object)reqDate);
    }

    private Date getRecentWorkDate(Date date, DynamicObject supplyOrg) {
        if (date == null) {
            return date;
        }
        Set calendarIds = PlanOrderHelper.getCalendarIds((Long)supplyOrg.getLong("id"));
        if (calendarIds == null || calendarIds.isEmpty()) {
            return date;
        }
        Date workDate = PlanOrderHelper.getRecentWorkDate((Date)date, (Long)supplyOrg.getLong("id"));
        return workDate;
    }

    private void addSplitRel(String oldbillid, List<Long> orderIds, DynamicObject planOrder) {
        Long billid = Long.valueOf(oldbillid);
        long[] ids = DB.genLongIds((String)"t_mrp_planordersplitrel", (int)orderIds.size());
        String insertSql = " insert into  t_mrp_planordersplitrel (fid, FSOUCEID, FRESULTID) values (?,?,?) ";
        ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(orderIds.size());
        Object[] params = null;
        for (int i = 0; i < orderIds.size(); ++i) {
            params = new Object[]{ids[i], billid, orderIds.get(i)};
            insertParamsList.add(params);
        }
        String dbRouteKey = planOrder.getDataEntityType().getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        DB.executeBatch((DBRoute)dbRoute, (String)insertSql, insertParamsList);
    }

    private ValidationErrorInfo buildErrMessage(DynamicObject obj, KDBizException exp) {
        Object pkId = obj.getPkValue();
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = exp.getMessage();
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, ((Object)((Object)this)).getClass().getName(), ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u62c6\u5206", (String)"PlanOrderSplitOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), msg, errorLevel);
        return info;
    }

    private void copy(DynamicObject fromObj, DynamicObject toObj) {
        this.copy(fromObj, toObj, null, null);
    }

    private void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        DataEntityPropertyCollection toPros;
        DataEntityPropertyCollection fromPros;
        if (fromObj != null && toObj != null && (fromPros = fromObj.getDataEntityType().getProperties()) != null && !fromPros.isEmpty() && (toPros = toObj.getDataEntityType().getProperties()) != null && !toPros.isEmpty()) {
            HashSet<String> fromPsSet = new HashSet<String>(fromPros.size());
            for (IDataEntityProperty primaryKeyObj : fromPros) {
                fromPsSet.add(String.valueOf(primaryKeyObj.getName()).toLowerCase());
            }
            HashSet<String> toPsSet1 = new HashSet<String>(fromPros.size());
            for (IDataEntityProperty primaryKey : toPros) {
                toPsSet1.add(String.valueOf(primaryKey.getName()).toLowerCase());
            }
            ISimpleProperty primaryKeyObj2 = toObj.getDataEntityType().getPrimaryKey();
            String primaryKey1 = "";
            if (primaryKeyObj2 != null) {
                primaryKey1 = primaryKeyObj2.getName();
            }
            Iterator arg9 = toPros.iterator();
            while (true) {
                String proname;
                String toProName;
                if (!arg9.hasNext()) {
                    return;
                }
                IDataEntityProperty pro = (IDataEntityProperty)arg9.next();
                String fromProName = toProName = pro.getName();
                if (transKeyMap != null && (proname = transKeyMap.get("toProName")) != null) {
                    toProName = proname;
                } else if (ignoreKeys != null && ignoreKeys.contains(toProName)) continue;
                if (!fromPsSet.contains(toProName) || !toPsSet1.contains(toProName)) continue;
                if (toProName.equals(primaryKey1)) {
                    toObj.set(toProName, null);
                    continue;
                }
                Object value = fromObj.get(fromProName);
                if (value instanceof DynamicObjectCollection) {
                    DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
                    DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toProName);
                    if (toEntity != null) {
                        toEntity.clear();
                        DynamicObjectType entityType = toEntity.getDynamicObjectType();
                        for (DynamicObject baseEntry : formEntity) {
                            DynamicObject newEntry = new DynamicObject(entityType);
                            this.copy(baseEntry, newEntry, ignoreKeys, transKeyMap);
                            toEntity.add((Object)newEntry);
                        }
                    }
                    toObj.set(toProName, (Object)toEntity);
                    continue;
                }
                toObj.set(toProName, value);
            }
        }
    }

    private String getEntityNumber() {
        String entitynumber = this.getOption().getVariableValue("entitynumber");
        if (StringUtils.isBlank((CharSequence)entitynumber)) {
            entitynumber = "mrp_planorder";
        }
        return entitynumber;
    }
}

