/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin.planexecute;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class PlanOrderSplitValidator
extends AbstractValidator {
    private static final String ENTRY_ENTITY = "entryentity";

    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject bill = rowDataEntity.getDataEntity();
            this.splitSure(bill, rowDataEntity);
        }
    }

    private void splitSure(DynamicObject bill, ExtendedDataEntity rowDataEntity) {
        DynamicObjectCollection entrys;
        BigDecimal oldOrderQty;
        BigDecimal sumQty = bill.getBigDecimal("sumqty");
        if (sumQty.compareTo(oldOrderQty = bill.getBigDecimal("oldorderqty")) > 0) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8ba2\u5355\u6570\u91cf\u5df2\u62c6\u5206\uff0c\u6570\u91cf\u6c47\u603b\u5927\u4e8e\u539f\u8ba2\u5355\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PlanOrderSplitValidator_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
        }
        if ((entrys = bill.getDynamicObjectCollection(ENTRY_ENTITY)) == null || entrys.isEmpty()) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u62c6\u5206\u5206\u5f55\u3002", (String)"PlanOrderSplitValidator_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            SimpleDateFormat sdf;
            DynamicObject entry = (DynamicObject)entrys.get(i);
            BigDecimal orderqty = entry.getBigDecimal("orderqty");
            if (orderqty.compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u62c6\u5206\u5206\u5f55\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"PlanOrderSplitValidator_2", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
            }
            Date orderdate = bill.getDate("orderdate");
            Date startDate = entry.getDate("startdate");
            Date enddate = entry.getDate("enddate");
            Date availabledate = bill.getDate("availabledate");
            if (startDate == null) {
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u9884\u89c8\u7b2c%s\u884c\uff0c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanOrderSplitValidator_3", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            if (enddate == null) {
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u9884\u89c8\u7b2c%s\u884c\uff0c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanOrderSplitValidator_4", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            if (enddate.compareTo(startDate) < 0) {
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u9884\u89c8\u7b2c%s\u884c\uff0c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f > \u8ba1\u5212\u5b8c\u6210\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanOrderSplitValidator_5", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), i + 1));
            }
            if (orderdate != null) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                try {
                    orderdate = sdf.parse(sdf.format(orderdate));
                    startDate = sdf.parse(sdf.format(startDate));
                    if (startDate.compareTo(orderdate) < 0) {
                        this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u9884\u89c8\u7b2c%s\u884c\uff0c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f < \u8ba1\u5212\u51c6\u5907\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanOrderSplitValidator_6", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), i + 1));
                    }
                }
                catch (ParseException e) {
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u9884\u89c8\u7b2c%s\u884c\uff0c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u586b\u5199\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanOrderSplitValidator_7", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), i + 1));
                }
            }
            if (availabledate == null) continue;
            sdf = new SimpleDateFormat("yyyyMMdd");
            try {
                availabledate = sdf.parse(sdf.format(availabledate));
                enddate = sdf.parse(sdf.format(enddate));
                if (enddate.compareTo(availabledate) <= 0) continue;
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u9884\u89c8\u7b2c%s\u884c\uff0c\u8ba1\u5212\u5b8c\u6210\u65e5\u671f > \u8ba1\u5212\u53ef\u7528\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanOrderSplitValidator_8", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            catch (ParseException e) {
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u62c6\u5206\u9884\u89c8\u7b2c%s\u884c\uff0c\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u586b\u5199\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanOrderSplitValidator_9", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), i + 1));
            }
        }
    }
}

