/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin.planexecute;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mrp.opplugin.planexecute.PlanOrderUpdateDateValidator;

public class PlanOrderUpateDateOp
extends AbstractOperationServicePlugIn {
    private static final String ENTRY_ENTITY = "entryentity";
    private static Log logger = LogFactory.getLog(PlanOrderUpateDateOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PlanOrderUpdateDateValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        for (DynamicObject obj : e.getDataEntities()) {
            try {
                this.doBizOp(obj);
                successObjs.add(obj);
            }
            catch (KDBizException exp) {
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(obj, exp));
            }
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }

    private void doBizOp(DynamicObject obj) {
        DynamicObject[] planorders;
        DynamicObjectCollection entrys = obj.getDynamicObjectCollection(ENTRY_ENTITY);
        HashSet<Long> ids = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> idDataMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject planOrder : entrys) {
            Long id = planOrder.getLong("id");
            ids.add(id);
            idDataMap.put(id, planOrder);
        }
        for (DynamicObject planorder : planorders = BusinessDataServiceHelper.load((String)"mrp_planorder", (String)"id,billno,billstatus,startdate,enddate,availabledate,materialattr,proorpurorg,entryentity,entryentity.entryrequiredate,entryentity.entryleadtime", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
            Long id = planorder.getLong("id");
            DynamicObject data = (DynamicObject)idDataMap.get(id);
            if (data == null) continue;
            String billstatus = planorder.getString("billstatus");
            String billno = planorder.getString("billno");
            if ("D".equals(billstatus)) {
                throw new KDBizException(new ErrorCode(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u66f4\u65b0\u65e5\u671f", (String)"PlanOrderUpateDateOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u7f16\u53f7%s\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u65e5\u671f\u3002", (String)"PlanOrderUpateDateOp_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), billno)), new Object[0]);
            }
            Date startDate = data.getDate("startdate");
            String materialattr = planorder.getString("materialattr");
            DynamicObject proorpurorg = planorder.getDynamicObject("proorpurorg");
            planorder.set("startdate", (Object)startDate);
            planorder.set("enddate", data.get("enddate"));
            planorder.set("availabledate", data.get("availabledate"));
            DynamicObjectCollection entityEntrys = planorder.getDynamicObjectCollection(ENTRY_ENTITY);
            for (DynamicObject entry : entityEntrys) {
                Integer leadtime = entry.getInt("entryleadtime");
                Date reqDate = PlanOrderHelper.getReqDate((Date)startDate, (Integer)leadtime, (Long)(proorpurorg == null ? 0L : proorpurorg.getLong("id")), (String)materialattr);
                entry.set("entryrequiredate", (Object)reqDate);
            }
        }
        SaveServiceHelper.save((DynamicObject[])planorders);
    }

    private ValidationErrorInfo buildErrMessage(DynamicObject obj, KDBizException exp) {
        Object pkId = obj.getPkValue();
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = exp.getMessage();
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, ((Object)((Object)this)).getClass().getName(), ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u66f4\u65b0\u65e5\u671f", (String)"PlanOrderUpateDateOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), msg, errorLevel);
        return info;
    }
}

