/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin.planexecute;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class PlanOrderUpdateDateValidator
extends AbstractValidator {
    private static final String ENTRY_ENTITY = "entryentity";

    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject bill = rowDataEntity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(ENTRY_ENTITY);
            for (DynamicObject planOrder : entrys) {
                Date enddate;
                String billno = planOrder.getString("billno");
                Date orderdate = planOrder.getDate("orderdate");
                Date startdate = planOrder.getDate("startdate");
                if (startdate == null) {
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355%s\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanOrderUpdateDateValidator_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), billno));
                }
                if (orderdate != null && startdate != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    try {
                        orderdate = sdf.parse(sdf.format(orderdate));
                        startdate = sdf.parse(sdf.format(startdate));
                        if (startdate.compareTo(orderdate) < 0) {
                            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355%s\u8ba1\u5212\u51c6\u5907\u65e5\u671f > \u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanOrderUpdateDateValidator_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), billno));
                        }
                    }
                    catch (ParseException e) {
                        this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355%s\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u586b\u5199\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanOrderUpdateDateValidator_2", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), billno));
                    }
                }
                if ((enddate = planOrder.getDate("enddate")) == null) {
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355%s\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanOrderUpdateDateValidator_3", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), billno));
                }
                if (startdate == null || enddate == null) continue;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                try {
                    startdate = sdf.parse(sdf.format(startdate));
                    if ((enddate = sdf.parse(sdf.format(enddate))).compareTo(startdate) >= 0) continue;
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355%s\u8ba1\u5212\u5f00\u59cb\u65e5\u671f > \u8ba1\u5212\u5b8c\u6210\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanOrderUpdateDateValidator_4", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), billno));
                }
                catch (ParseException e) {
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355%s\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u586b\u5199\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanOrderUpdateDateValidator_5", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), billno));
                }
            }
        }
    }
}

