/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin.pls;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PLSStopCaculateOp
extends AbstractOperationServicePlugIn {
    private static String ID = "id";
    private static String MRP_CACULATE_LOG = "mrp_caculate_log";
    private static String STARTDATE = "startdate";
    private static String ENDDATE = "enddate";
    private static String SUMMIN = "summin";
    private static String PLANGRAM = "plangram";
    private static String LOG_QUERY = "id,calculatestatus";
    private static String CALCULATESTATUS = "calculatestatus";
    private static String CALCULATEPRO = "calculatepro";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(CALCULATESTATUS);
        e.getFieldKeys().add(CALCULATEPRO);
        e.getFieldKeys().add(PLANGRAM);
        e.getFieldKeys().add(STARTDATE);
        e.getFieldKeys().add(ENDDATE);
        e.getFieldKeys().add(SUMMIN);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        for (DynamicObject obj : e.getDataEntities()) {
            QFilter qFilter = new QFilter(ID, "=", obj.getPkValue());
            DynamicObject log = QueryServiceHelper.queryOne((String)MRP_CACULATE_LOG, (String)LOG_QUERY, (QFilter[])new QFilter[]{qFilter});
            String calculatestatus = log.getString(CALCULATESTATUS);
            if (!"D".equals(calculatestatus)) {
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(obj, new KDBizException(new ErrorCode(ResManager.loadKDString((String)"\u7ec8\u6b62\u8fd0\u7b97", (String)"PLSStopCaculateOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u7b97\u72b6\u6001\u975e\u8fd0\u884c\u4e2d\uff0c\u65e0\u6cd5\u624b\u52a8\u7ec8\u6b62\u3002", (String)"PLSStopCaculateOp_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0])), new Object[0])));
                continue;
            }
            obj.set(CALCULATESTATUS, (Object)"C");
            BigDecimal calculatepro = obj.getBigDecimal(CALCULATEPRO);
            if (calculatepro == null || calculatepro.compareTo(BigDecimal.ZERO) <= 0) {
                obj.set(CALCULATEPRO, (Object)50.0);
            }
            Date startDate = obj.getDate(STARTDATE);
            Date endDate = obj.getDate(ENDDATE);
            startDate = startDate == null ? new Date() : startDate;
            endDate = endDate == null ? new Date() : endDate;
            long milli = endDate.getTime() - startDate.getTime();
            BigDecimal sumMin = new BigDecimal("" + milli).divide(new BigDecimal("60000"), 2, RoundingMode.UP);
            obj.set(STARTDATE, (Object)startDate);
            obj.set(ENDDATE, (Object)endDate);
            obj.set(SUMMIN, (Object)sumMin);
            long planId = obj.getLong(PLANGRAM);
            this.clearMutexByPlanId(planId);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{obj});
            successObjs.add(obj);
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }

    private void clearMutexByPlanId(long planId) {
        if (planId > 0L) {
            DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"IPLSStopCalcService", (String)"stopCalc", (Object[])new Object[]{String.valueOf(planId)});
        }
    }

    private ValidationErrorInfo buildErrMessage(DynamicObject obj, KDBizException exp) {
        Object pkId = obj.getPkValue();
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = exp.getMessage();
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, ((Object)((Object)this)).getClass().getName(), ResManager.loadKDString((String)"\u7ec8\u6b62\u8fd0\u7b97", (String)"PLSStopCaculateOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), msg, errorLevel);
        return info;
    }
}

