/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.opplugin.flexmetric;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class FlexMetricDefineValidator
extends AbstractValidator {
    private static final String Save = "save";
    private static final String Submit = "submit";
    private static final String EntryEntity = "entryentity";
    private static final String ReplaceEntryEntity = "subentryentity";
    private static final String SOURCE_BD = "source_bd";
    private static final String TARGETENTITY = "targetentity";

    private void checkMulSourceLines(Map<Long, Set<Integer>> sourceMap, DynamicObject entryObj, int sourceSeq) {
        Long sourcebd = entryObj.getLong("id");
        Set<Object> seqSet = null;
        if (sourceMap.get(sourcebd) == null) {
            seqSet = new HashSet(16);
            seqSet.add(sourceSeq);
            sourceMap.put(sourcebd, seqSet);
        } else {
            seqSet = sourceMap.get(sourcebd);
            seqSet.add(sourceSeq);
            sourceMap.put(sourcebd, seqSet);
        }
    }

    private void checkMutlReplacePriorityEntry(Map<Integer, Set<Integer>> sourceMap, int priority, int replaceEntrySeq) {
        Set<Object> seqSet = null;
        if (sourceMap.get(priority) == null) {
            seqSet = new HashSet<Integer>(16);
            seqSet.add(replaceEntrySeq);
            sourceMap.put(priority, seqSet);
        } else {
            seqSet = sourceMap.get(priority);
            seqSet.add(replaceEntrySeq);
            sourceMap.put(priority, seqSet);
        }
    }

    private void checkMulReplaceLines(Map<Integer, Map<Long, Set<Integer>>> replaceMap, DynamicObject replaceEntryObj, int sourceSeq, int replaceEntrySeq) {
        Long replaceEntryId = replaceEntryObj.getLong("id");
        if (replaceMap.get(sourceSeq) == null) {
            HashSet<Integer> seqSet = new HashSet<Integer>(16);
            seqSet.add(replaceEntrySeq);
            HashMap<Long, HashSet<Integer>> replaceEntryMap = new HashMap<Long, HashSet<Integer>>(16);
            replaceEntryMap.put(replaceEntryId, seqSet);
            replaceMap.put(sourceSeq, replaceEntryMap);
        } else {
            Map<Long, Set<Integer>> replaceEntryMap = replaceMap.get(sourceSeq);
            this.checkMulSourceLines(replaceEntryMap, replaceEntryObj, replaceEntrySeq);
            replaceMap.put(sourceSeq, replaceEntryMap);
        }
    }

    private void checkMulReplacePriorityLines(Map<Integer, Map<Integer, Set<Integer>>> replaceMap, DynamicObject replace, int sourceSeq, int replaceEntrySeq) {
        int priority = replace.getInt("priority");
        if (replaceMap.get(sourceSeq) == null) {
            HashSet<Integer> seqSet = new HashSet<Integer>(16);
            seqSet.add(replaceEntrySeq);
            HashMap<Integer, HashSet<Integer>> replaceEntryMap = new HashMap<Integer, HashSet<Integer>>(16);
            replaceEntryMap.put(priority, seqSet);
            replaceMap.put(sourceSeq, replaceEntryMap);
        } else {
            Map<Integer, Set<Integer>> replaceEntryMap = replaceMap.get(sourceSeq);
            this.checkMutlReplacePriorityEntry(replaceEntryMap, priority, replaceEntrySeq);
            replaceMap.put(sourceSeq, replaceEntryMap);
        }
    }

    public void validate() {
        String operate = this.getOperateKey();
        if (Save.equals(operate) || Submit.equals(operate)) {
            ExtendedDataEntity[] extendedDataEntities;
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = this.getDataEntities()) {
                String message;
                Set seqSet;
                Map map;
                HashMap<Long, Set<Integer>> sourceMap = new HashMap<Long, Set<Integer>>(16);
                HashMap<Integer, Map<Long, Set<Integer>>> replaceMap = new HashMap<Integer, Map<Long, Set<Integer>>>(16);
                HashMap<Integer, Map<Integer, Set<Integer>>> priorityMap = new HashMap<Integer, Map<Integer, Set<Integer>>>(16);
                DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(EntryEntity);
                for (DynamicObject sourcrObj : dynamicObjectCollection) {
                    DynamicObject entryObj = sourcrObj.getDynamicObject(SOURCE_BD);
                    if (entryObj == null) continue;
                    int sourceSeq = sourcrObj.getInt("seq");
                    this.checkMulSourceLines(sourceMap, entryObj, sourceSeq);
                    DynamicObjectCollection replaceEntrys = sourcrObj.getDynamicObjectCollection(ReplaceEntryEntity);
                    if (replaceEntrys == null || replaceEntrys.isEmpty()) continue;
                    for (DynamicObject replace : replaceEntrys) {
                        DynamicObject replaceEntryObj = replace.getDynamicObject("target_bd");
                        if (replaceEntryObj == null) continue;
                        int replaceEntrySeq = replace.getInt("seq");
                        this.checkMulReplaceLines(replaceMap, replaceEntryObj, sourceSeq, replaceEntrySeq);
                        this.checkMulReplacePriorityLines(priorityMap, replace, sourceSeq, replaceEntrySeq);
                    }
                }
                if (!sourceMap.isEmpty()) {
                    for (Map.Entry entry : sourceMap.entrySet()) {
                        Set seqSet2 = (Set)entry.getValue();
                        if (seqSet2.size() < 2) continue;
                        String message2 = String.format(ResManager.loadKDString((String)"\u6e90\u8bbe\u7f6e\u5206\u5f55\u4e2d%1$s\u884c\u7684\u6e90\u57fa\u7840\u8d44\u6599\u5b58\u5728\u91cd\u590d\u503c\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"FlexMetricDefineValidator_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), seqSet2);
                        this.addErrorMessage(extendedDataEntity, message2);
                    }
                }
                if (!replaceMap.isEmpty()) {
                    for (Map.Entry entry : replaceMap.entrySet()) {
                        map = (Map)entry.getValue();
                        String row = String.valueOf(entry.getKey());
                        for (Map.Entry replaceEntry : map.entrySet()) {
                            seqSet = (Set)replaceEntry.getValue();
                            if (seqSet.size() < 2) continue;
                            message = String.format(ResManager.loadKDString((String)"\u6e90\u8bbe\u7f6e\u5206\u5f55\u4e2d%1$s\u884c\u5bf9\u5e94\u7684\u66ff\u4ee3\u8bbe\u7f6e\u4e2d\u7684%2$s\u66ff\u4ee3\u57fa\u7840\u8d44\u6599\u5b58\u5728\u91cd\u590d\u503c\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"FlexMetricDefineValidator_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), row, seqSet);
                            this.addErrorMessage(extendedDataEntity, message);
                        }
                    }
                }
                if (priorityMap.isEmpty()) continue;
                for (Map.Entry entry : priorityMap.entrySet()) {
                    map = (Map)entry.getValue();
                    String row = String.valueOf(entry.getKey());
                    for (Map.Entry replaceEntry : map.entrySet()) {
                        seqSet = (Set)replaceEntry.getValue();
                        if (seqSet.size() < 2) continue;
                        message = String.format(ResManager.loadKDString((String)"\u6e90\u8bbe\u7f6e\u5206\u5f55\u4e2d%1$s\u884c\u5bf9\u5e94\u7684\u66ff\u4ee3\u8bbe\u7f6e\u4e2d\u7684%2$s\u4f18\u5148\u7ea7\u5b58\u5728\u91cd\u590d\u503c\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"FlexMetricDefineValidator_2", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), row, seqSet);
                        this.addErrorMessage(extendedDataEntity, message);
                    }
                }
            }
        }
    }
}

