/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.opplugin.inventory;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msplan.mrp.opplugin.InventoryLevelAuditValidator;

public class InventoryBaseOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("audittime");
        e.getFieldKeys().add("disabler");
        e.getFieldKeys().add("disabledate");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String opetateKey;
        DynamicObject[] dynamicObjects = e.getDataEntities();
        switch (opetateKey = e.getOperationKey()) {
            case "audit": {
                this.doOpeate(dynamicObjects, "auditor", "audittime");
                break;
            }
            case "unaudit": {
                this.doUnOpeate(dynamicObjects, "auditor", "audittime");
                break;
            }
            case "disable": {
                this.doOpeate(dynamicObjects, "disabler", "disabledate");
                break;
            }
            case "enable": {
                this.doUnOpeate(dynamicObjects, "disabler", "disabledate");
                break;
            }
        }
    }

    public void doOpeate(DynamicObject[] dynamicObjects, String userField, String timeField) {
        long userId = 0L;
        if (RequestContext.get() != null) {
            userId = RequestContext.get().getCurrUserId();
        }
        Date date = new Date();
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set(userField, (Object)userId);
            dynamicObject.set(timeField, (Object)date);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
    }

    public void doUnOpeate(DynamicObject[] dynamicObjects, String userField, String timeField) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set(userField, null);
            dynamicObject.set(timeField, null);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InventoryLevelAuditValidator());
    }
}

