/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.opplugin.planscpoe;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PlanScopWarHouDefSaveValidator
extends AbstractValidator {
    public static final String SAVE = "save";
    private static final String EFFECTUATE_TYPE = "effectuate_type";
    private static final String CREATEORG = "createorg";
    private static final String INV_SUPPLY_STRATEGY = "inv_supply_strategy";
    private static final String PLANSCOPE = "planscope";
    private static final String WAREHOUSE = "warehouse";
    private static final String IS_ININV_WHS = "is_ininv_whs";

    public void validate() {
        String operate = this.getOperateKey();
        if (SAVE.equals(operate)) {
            ExtendedDataEntity[] objs = this.getDataEntities();
            ArrayList<Long> useOrgList = new ArrayList<Long>(objs.length);
            for (ExtendedDataEntity obj : objs) {
                DynamicObject useorgValue = obj.getDataEntity().getDynamicObject(CREATEORG);
                useOrgList.add(useorgValue.getLong("id"));
            }
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"msplan_planscope_whs", (String)"inv_supply_strategy,createorg,effectuate_type,planscope,warehouse,is_ininv_whs,id", (QFilter[])new QFilter[]{new QFilter(CREATEORG, "in", useOrgList)});
            for (ExtendedDataEntity obj : objs) {
                this.checkWareHouse(obj);
                this.checkout(dynamicObjectCollection, obj);
            }
        }
    }

    private void checkWareHouse(ExtendedDataEntity obj) {
        DynamicObject entity = obj.getDataEntity();
        DynamicObject warehouse = entity.getDynamicObject(WAREHOUSE);
        DynamicObject invorg = entity.getDynamicObject("invorg");
        DynamicObject inv_supply_strategy = entity.getDynamicObject(INV_SUPPLY_STRATEGY);
        if (warehouse != null && inv_supply_strategy != null && invorg != null) {
            String s;
            QFilter qFilter1 = new QFilter(WAREHOUSE, "=", warehouse.getPkValue());
            QFilter qFilter2 = new QFilter("initstatus", "=", (Object)"B");
            QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
            QFilter qFilter4 = new QFilter("startstatus", "=", (Object)"B");
            HashSet<Long> orgs = new HashSet<Long>(2);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"im_warehousesetup", (String)"org", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4}, null);){
                for (Row row : dataSet) {
                    orgs.add(row.getLong(0));
                }
            }
            if (orgs.isEmpty()) {
                s = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%s\u201d\u672a\u542f\u7528\u6216\u672a\u521d\u59cb\u5316\u3002", (String)"PlanScopWarHouDefSaveValidator_6", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), warehouse.getString("name"));
                this.addErrorMessage(obj, s);
                return;
            }
            if (!orgs.contains(invorg.getLong("id"))) {
                s = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u5e93\u5b58\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"PlanScopWarHouDefSaveValidator_8", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), warehouse.getString("name"), invorg.getString("name"));
                this.addErrorMessage(obj, s);
            } else {
                boolean flag = false;
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"mrp_stocksupply_policy", (String)"entryentity.storageorg storageorg", (QFilter[])new QFilter[]{new QFilter("id", "=", inv_supply_strategy.getPkValue())}, null);
                Object object = null;
                try {
                    for (Row row : dataSet) {
                        Long org = row.getLong(0);
                        if (!Objects.equals(invorg.getLong("id"), org)) continue;
                        flag = true;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (dataSet != null) {
                        if (object != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
                if (!flag) {
                    String s2 = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%1$s\u201d\u548c\u5e93\u5b58\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u5728\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7ec4\u7ec7\u8303\u56f4\u5185\u3002", (String)"PlanScopWarHouDefSaveValidator_9", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), warehouse.getString("name"), invorg.getString("name"));
                    this.addErrorMessage(obj, s2);
                }
            }
        }
    }

    private void checkout(DynamicObjectCollection dynamicObjectCollection, ExtendedDataEntity obj) {
        String s;
        DynamicObject createOrgValue = (DynamicObject)obj.getDataEntity().get(CREATEORG);
        Long importCreateorg = createOrgValue.getLong("id");
        DynamicObject invValue = (DynamicObject)obj.getDataEntity().get(INV_SUPPLY_STRATEGY);
        Long importInvSupplyStrategy = invValue.getLong("id");
        DynamicObject planScopeValue = (DynamicObject)obj.getDataEntity().get(PLANSCOPE);
        Long importPlanScope = planScopeValue.getLong("id");
        String importEffectuateType = obj.getDataEntity().getString(EFFECTUATE_TYPE);
        Boolean importIsIninvWhs = (Boolean)obj.getDataEntity().get(IS_ININV_WHS);
        DynamicObject wareHouseValue = (DynamicObject)obj.getDataEntity().get(WAREHOUSE);
        long importId = (Long)obj.getDataEntity().get("id");
        if (importPlanScope != 0L) {
            QFilter qFilter1 = new QFilter(CREATEORG, "=", (Object)importCreateorg);
            Iterator qFilter2 = new QFilter("enable", "=", (Object)"1");
            QFilter qFilter3 = new QFilter("status", "=", (Object)"C");
            DynamicObjectCollection planscopeId = QueryServiceHelper.query((String)"msplan_planscope", (String)"id", (QFilter[])new QFilter[]{qFilter1.and((QFilter)qFilter2).and(qFilter3)});
            ArrayList<Long> id = new ArrayList<Long>();
            for (DynamicObject dynamicObject : planscopeId) {
                id.add(dynamicObject.getLong("id"));
            }
            if (!id.contains(importPlanScope)) {
                String s2 = ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u8303\u56f4\u201d\u5e94\u9009\u62e9\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u4e0b\u5df2\u5ba1\u6838\u3001\u53ef\u7528\u7684\u8ba1\u5212\u8303\u56f4\u3002", (String)"PlanScopWarHouDefSaveValidator_5", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(obj, s2);
            }
        }
        if (wareHouseValue != null) {
            DynamicObject invorg;
            Long importWareHouse = wareHouseValue.getLong("id");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                long originalId = dynamicObject.getLong("id");
                Long originalCreateorg = dynamicObject.getLong(CREATEORG);
                String originalEffectuateType = dynamicObject.getString(EFFECTUATE_TYPE);
                Long originalInvSupplyStrategy = dynamicObject.getLong(INV_SUPPLY_STRATEGY);
                Long originalPlanScope = dynamicObject.getLong(PLANSCOPE);
                Long originalWareHouse = dynamicObject.getLong(WAREHOUSE);
                if (originalId == importId && importId != 0L || !Objects.equals(importCreateorg, originalCreateorg) || !Objects.equals(importEffectuateType, originalEffectuateType) || !Objects.equals(importInvSupplyStrategy, originalInvSupplyStrategy) || !Objects.equals(importWareHouse, originalWareHouse) || Objects.equals(importPlanScope, originalPlanScope)) continue;
                s = ResManager.loadKDString((String)"\u201c\u521b\u5efa\u7ec4\u7ec7\u201d+\u201c\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u201d+\u201c\u8ba1\u5212\u8303\u56f4\u201d+\u201c\u4ed3\u5e93\u201d+\u201c\u751f\u6548\u7c7b\u578b\u201d\u76f8\u540c\u65f6\uff0c\u4e00\u4e2a\u201c\u4ed3\u5e93\u201d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u201c\u8ba1\u5212\u8303\u56f4\u201d\u3002", (String)"PlanScopWarHouDefSaveValidator_3", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(obj, s);
                break;
            }
            if ((invorg = obj.getDataEntity().getDynamicObject("invorg")) == null) {
                QFilter qFilter = new QFilter(WAREHOUSE, "=", (Object)importWareHouse);
                QFilter qFilter1 = new QFilter("startstatus", "=", (Object)"B");
                QFilter qFilter2 = new QFilter("initstatus", "=", (Object)"B");
                QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
                DynamicObjectCollection orgValue = QueryServiceHelper.query((String)"im_warehousesetup", (String)"org", (QFilter[])new QFilter[]{qFilter.and(qFilter1).and(qFilter2).and(qFilter3)});
                ArrayList<Long> orgList = new ArrayList<Long>();
                if (orgValue != null && !orgValue.isEmpty()) {
                    for (Object dynamicObject : orgValue) {
                        orgList.add(dynamicObject.getLong("org"));
                    }
                    DynamicObjectCollection storageorg = QueryServiceHelper.query((String)"mrp_stocksupply_policy", (String)"entryentity.storageorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)importInvSupplyStrategy)});
                    if (storageorg != null) {
                        for (DynamicObject dynamicObject : storageorg) {
                            long aLong = dynamicObject.getLong("entryentity.storageorg");
                            if (!orgList.contains(aLong)) continue;
                            invorg = BusinessDataServiceHelper.loadSingleFromCache((Object)aLong, (String)"bos_org");
                            obj.setValue("invorg", (Object)invorg);
                            obj.setValue("invorg_id", (Object)aLong);
                            break;
                        }
                    }
                    if (invorg == null) {
                        invorg = BusinessDataServiceHelper.loadSingleFromCache(orgList.get(0), (String)"bos_org");
                        String s3 = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%1$s\u201d\u548c\u5e93\u5b58\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u5728\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7ec4\u7ec7\u8303\u56f4\u5185\u3002", (String)"PlanScopWarHouDefSaveValidator_9", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), wareHouseValue.getString("name"), invorg.getString("name"));
                        this.addErrorMessage(obj, s3);
                    }
                } else {
                    String s4 = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%s\u201d\u672a\u542f\u7528\u6216\u672a\u521d\u59cb\u5316\u3002", (String)"PlanScopWarHouDefSaveValidator_6", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), wareHouseValue.getString("name"));
                    this.addErrorMessage(obj, s4);
                }
            }
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            long originalId = dynamicObject.getLong("id");
            Long originalCreateorg = dynamicObject.getLong(CREATEORG);
            Long originalInvSupplyStrategy = dynamicObject.getLong(INV_SUPPLY_STRATEGY);
            Long originalPlanScope = dynamicObject.getLong(PLANSCOPE);
            String originalEffectuateType = dynamicObject.getString(EFFECTUATE_TYPE);
            Long originalWareHouse = dynamicObject.getLong(WAREHOUSE);
            Boolean oringinalIsIninvWhs = dynamicObject.getBoolean(IS_ININV_WHS);
            if (originalId == importId && importId != 0L) continue;
            if (Objects.equals(importCreateorg, originalCreateorg) && Objects.equals(importEffectuateType, originalEffectuateType) && Objects.equals(importPlanScope, originalPlanScope) && Objects.equals(importInvSupplyStrategy, originalInvSupplyStrategy) && importIsIninvWhs.booleanValue() && oringinalIsIninvWhs.booleanValue()) {
                s = ResManager.loadKDString((String)"\u201c\u521b\u5efa\u7ec4\u7ec7\u201d+\u201c\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u201d+\u201c\u8ba1\u5212\u8303\u56f4\u201d+\u201c\u751f\u6548\u7c7b\u578b\u201d\u76f8\u540c\u65f6\uff0c\u591a\u6761\u6570\u636e\u4e2d\u53ea\u80fd\u52fe\u9009\u4e00\u4e2a\u201c\u662f\u5426\u5165\u5e93\u4ed3\u5e93\u201d\u3002", (String)"PlanScopWarHouDefSaveValidator_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(obj, s);
                break;
            }
            if (!Objects.equals(importCreateorg, originalCreateorg) || !Objects.equals(importEffectuateType, originalEffectuateType) || Objects.equals(importInvSupplyStrategy, originalInvSupplyStrategy)) continue;
            s = ResManager.loadKDString((String)"\u201c\u521b\u5efa\u7ec4\u7ec7\u201d+\u201c\u751f\u6548\u7c7b\u578b\u201d\u76f8\u540c\u65f6\uff0c\u8fd9\u4e00\u7ec4\u6570\u636e\u5e94\u4f7f\u7528\u540c\u4e00\u4e2a\u201c\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u201d\u3002", (String)"PlanScopWarHouDefSaveValidator_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(obj, s);
            break;
        }
    }
}

