/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.opplugin.resourcecheck.validator;

import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.service.resourcecheck.ResourceCheckDataValidService;

public class ResourceCheckValidatorPlugin
extends AbstractValidator {
    private static final String APPPARAM = "mpscmm-msplan-opplugin";

    public void validate() {
        String operate = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        for (int i = 0; i < dataEntities.length; ++i) {
            String existsBillnos;
            String checkRange;
            DynamicObject data = dataEntities[i].getDataEntity();
            if ("submit".equals(operate) || "audit".equals(operate)) {
                ResourceCheckDataValidService services = new ResourceCheckDataValidService();
                Map resultMap = services.checkData(data, operate, "submit".equals(operate));
                boolean isValid = (Boolean)resultMap.get("result");
                if (isValid) continue;
                this.addErrorMessage(dataEntities[i], resultMap.get("msg").toString());
                continue;
            }
            if (!"unaudit".equals(operate) || !"A".equals(checkRange = data.getString("checkrange")) || StringUtils.isEmpty((String)(existsBillnos = this.checkExistsGroupData(data.getLong("id"))))) continue;
            this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u5b58\u5728\u4e8e\u7ec4\u5408\u68c0\u67e5\u201c%2$s\u201d\u7684\u5b50\u9879\u5206\u5f55\u4e2d\uff0c\u8bf7\u5148\u53cd\u5ba1\u6838\u7ec4\u5408\u68c0\u67e5\u9879\u70b9\u540e\u518d\u5bf9\u672c\u8d44\u6e90\u68c0\u67e5\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"ResourceCheckValidatorPlugin_01", (String)APPPARAM, (Object[])new Object[0]), data.getString("number"), existsBillnos));
        }
    }

    public String checkExistsGroupData(Long id) {
        QFilter qfilter = new QFilter("groupcheckentry.resourcecheckitem", "=", (Object)id);
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("checkrange", "=", (Object)"B"));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"msplan_resourcecheck", (String)"number", (QFilter[])qfilter.toArray());
        if (dys == null || dys.isEmpty()) {
            return "";
        }
        return dys.stream().map(p -> p.getString("number")).collect(Collectors.toSet()).toString();
    }
}

