/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.common.cache;

import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;

public class PlanOrderCacheMrg {
    private static final String PLAN_ORDER_REGION = "PLAN_ORDER";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("PLAN_ORDER");
    private static final String PLAN_ORDER = "PLAN_ORDER_";
    public static final String DATA_PLAN_ORDER_DROPSTATUS = "PLAN_ORDER_DROPSTATUS";
    public static final String DATA_PLAN_ORDER_BATCHUPDATASTATUS = "PLAN_ORDER_BATCHUPDATASTATUS";
    public static final String DATA_PLAN_ORDER_SPLITSTATUS = "PLAN_ORDER_SPLITSTATUS";
    public static final String DATA_LOADED = "DATA_LOADED";
    private static int timeout = 600;

    private PlanOrderCacheMrg() {
    }

    private static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId == null || acctId.length() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237\u4e3a\u7a7a\u3002", (String)"PlanOrderCacheMrg_0", (String)"mpscmm-msplan-common", (Object[])new Object[0]));
        }
        return acctId;
    }

    public static LocalMemoryCache getLocalCtrlCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(600);
        info.setMaxMemSize(10000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(PlanOrderCacheMrg.getAcctId(), PLAN_ORDER_REGION, info);
    }

    public static void clearCache(String type) {
        cache.removeType(type);
    }

    public static void clearCaches(String type, String[] keys) {
        cache.remove(type, keys);
    }

    public static void clearCache(String type, String key) {
        cache.remove(type, key);
    }

    public static void clearCacheWithPrefix(String type, String keyPrefix) {
        List keyList = cache.getKeysWithPrefix(type, keyPrefix);
        for (String key : keyList) {
            cache.remove(type, key);
        }
    }

    public static String getCache(String type, String key) {
        return (String)cache.get(type, key);
    }

    public static void putCache(String type, String key, String value) {
        cache.put(type, key, value, PlanOrderCacheMrg.getTimeout());
    }

    public static void putCache(String type, Map<String, String> values) {
        cache.put(type, values, PlanOrderCacheMrg.getTimeout());
    }

    public static Map<String, String> getCache(String type) {
        return cache.getAll(type);
    }

    public static void loaded(String type, String key) {
        cache.put(type, key, DATA_LOADED, PlanOrderCacheMrg.getTimeout());
    }

    public static boolean isData(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return !DATA_LOADED.equals(value);
    }

    public static boolean isLoaded(String value) {
        return value != null && value.length() != 0;
    }

    public static String getType4PlanOrderDropStatus() {
        return "PLAN_ORDER_DROPSTATUS_" + PlanOrderCacheMrg.getAcctId();
    }

    public static String getType4PlanOrderBatchUpdataStatus() {
        return "PLAN_ORDER_BATCHUPDATASTATUS_" + PlanOrderCacheMrg.getAcctId();
    }

    public static String getType4PlanOrderSplitStatus() {
        return "PLAN_ORDER_SPLITSTATUS_" + PlanOrderCacheMrg.getAcctId();
    }

    public static int getTimeout() {
        return timeout;
    }

    public static void setTimeout(int timeout) {
        PlanOrderCacheMrg.timeout = timeout;
    }
}

