/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.id.ID;
import kd.bos.servicehelper.mulilang.GLDataServiceHelper;

public class LanguageUtil {
    private static final String ALGO_KEY = LanguageUtil.class.getName();
    private static final DBRoute DB_ROUTE = DBRoute.of((String)"scm");
    private static final int BATCH_NUM = 1000;
    private static final int DEFAULT_BATCHSIZE = 5000;

    public static void updateAllFieldMapping() {
        String queryDropLog = "SELECT FENTRYID, FDESTFIELDNAME, FSOURCEFIELDNAME FROM T_MRP_BILLTRANFERENTRY";
        DataSet dropLogDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE, (String)queryDropLog);
        String[] pkids = DB.genStringIds((String)"T_MRP_BILLTRANFERENTRY_L", (int)dropLogDataSet.copy().count("FENTRYID", false));
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(1000);
        int i = 0;
        for (Row row : dropLogDataSet) {
            Long mappingEntryId = row.getLong("FENTRYID");
            String destfieldname = row.getString("FDESTFIELDNAME");
            String sourcefieldname = row.getString("FSOURCEFIELDNAME");
            Object[] param = new Object[]{pkids[i], mappingEntryId, "zh_CN", destfieldname, sourcefieldname};
            updateParamList.add(param);
            ++i;
        }
        String insertSQL = "INSERT INTO T_MRP_BILLTRANFERENTRY_L(FPKID, FENTRYID, FLOCALEID, FDESTFIELDNAME, FSOURCEFIELDNAME) VALUES (?,?,?,?,?)";
        if (updateParamList.size() != 0) {
            LanguageUtil.batchSave(DB_ROUTE, insertSQL, updateParamList);
        }
    }

    public static void batchSave(DBRoute dbRoute, String sql, List<Object[]> values) {
        int totalCount = values.size();
        if (totalCount > 5000) {
            int times = totalCount / 5000;
            times = totalCount % 5000 != 0 ? times + 1 : times;
            for (int i = 0; i < times; ++i) {
                int startIndex = i * 5000;
                int endIndex = Math.min(startIndex + 5000, totalCount);
                DB.executeBatch((DBRoute)dbRoute, (String)sql, values.subList(startIndex, endIndex));
            }
        } else {
            DB.executeBatch((DBRoute)dbRoute, (String)sql, values);
        }
    }

    public static void synHistoryData() {
        try {
            ArrayList<String> billfieldtransferFields = new ArrayList<String>(1);
            billfieldtransferFields.add("name");
            GLDataServiceHelper.repairData((String)"mrp_billfieldtransfer", billfieldtransferFields);
            ArrayList<String> caculatelogFields = new ArrayList<String>(2);
            caculatelogFields.add("name");
            GLDataServiceHelper.repairData((String)"mrp_caculatelog", caculatelogFields);
            ArrayList<String> definitionexceptionFields = new ArrayList<String>(2);
            definitionexceptionFields.add("name");
            GLDataServiceHelper.repairData((String)"mrp_definitionexception", definitionexceptionFields);
            ArrayList<String> demandpriority_groupFields = new ArrayList<String>(2);
            demandpriority_groupFields.add("name");
            GLDataServiceHelper.repairData((String)"mrp_demandpriority_group", demandpriority_groupFields);
            ArrayList<String> plancalendarFields = new ArrayList<String>(2);
            plancalendarFields.add("name");
            GLDataServiceHelper.repairData((String)"mrp_plancalendar", plancalendarFields);
            ArrayList<String> resource_dataconfigFields = new ArrayList<String>(2);
            resource_dataconfigFields.add("name");
            GLDataServiceHelper.repairData((String)"mrp_resource_dataconfig", resource_dataconfigFields);
            ArrayList<String> wasteratioFields = new ArrayList<String>(2);
            wasteratioFields.add("name");
            GLDataServiceHelper.repairData((String)"mrp_wasteratio", wasteratioFields);
            ArrayList<String> dataconfigFields = new ArrayList<String>(2);
            dataconfigFields.add("fieldname");
            dataconfigFields.add("name");
            GLDataServiceHelper.repairData((String)"msplan_dataconfig", dataconfigFields);
            ArrayList<String> ds_settingsFields = new ArrayList<String>(2);
            ds_settingsFields.add("name");
            GLDataServiceHelper.repairData((String)"msplan_ds_settings", ds_settingsFields);
            ArrayList<String> ds_versionFields = new ArrayList<String>(2);
            ds_versionFields.add("name");
            GLDataServiceHelper.repairData((String)"msplan_ds_version", ds_versionFields);
            ArrayList<String> linerulesFields = new ArrayList<String>(2);
            linerulesFields.add("name");
            GLDataServiceHelper.repairData((String)"msplan_linerules", linerulesFields);
            ArrayList<String> planprogramFields = new ArrayList<String>(2);
            planprogramFields.add("name");
            GLDataServiceHelper.repairData((String)"mrp_planprogram", planprogramFields);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateNewMulLangTable(DBRoute dbRoute, String srcTableName, String srcPkField, List<String> srcTableFieldList, String targetTableName, String pkField) {
        HashSet<String> srcFields = new HashSet<String>(srcTableFieldList.size());
        srcFields.add(srcPkField);
        srcFields.addAll(srcTableFieldList);
        String srcSelectFields = String.join((CharSequence)",", srcFields);
        String querySrcDataSql = String.format("select %1$s from %2$s;", srcSelectFields, srcTableName);
        DataSet srcDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)dbRoute, (String)querySrcDataSql);
        int batchNum = 1000;
        String defaultLocaleId = GLDataServiceHelper.getDefaultLocaleId();
        ArrayList<Object> srcPkList = new ArrayList<Object>(batchNum);
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(batchNum);
        int mulLangTableFieldCnt = 3 + srcTableFieldList.size();
        String insertFieldStr = String.join((CharSequence)",", srcTableFieldList);
        StringBuilder placeHolderStr = new StringBuilder();
        for (int i = 0; i < srcTableFieldList.size(); ++i) {
            if (placeHolderStr.length() > 0) {
                placeHolderStr.append(",");
            }
            placeHolderStr.append("?");
        }
        String insertMulLangSql = String.format("INSERT INTO %1$s (%2$s, %3$s, flocaleid, %4$s) VALUES(?, ?, ?, %5$s);", targetTableName, pkField, srcPkField, insertFieldStr, placeHolderStr.toString());
        for (Row row : srcDataSet) {
            Object srcPk = row.get(srcPkField);
            srcPkList.add(srcPk);
            Object[] insertParam = new Object[mulLangTableFieldCnt];
            insertParam[1] = srcPk;
            insertParam[2] = defaultLocaleId;
            int paramIdx = 3;
            for (String srcField : srcTableFieldList) {
                insertParam[paramIdx++] = row.get(srcField);
            }
            insertParamList.add(insertParam);
            if (insertParamList.size() < batchNum) continue;
            SqlBuilder deleteMulLangSql = new SqlBuilder();
            deleteMulLangSql.append(String.format("delete from %s where ", targetTableName), new Object[0]);
            deleteMulLangSql.appendIn(String.format(" %s ", srcPkField), srcPkList);
            DB.execute((DBRoute)dbRoute, (SqlBuilder)deleteMulLangSql);
            String[] mulLangPks = ID.genStringIds((int)insertParamList.size());
            for (int pkIdx = 0; pkIdx < insertParamList.size(); ++pkIdx) {
                Object[] param = (Object[])insertParamList.get(pkIdx);
                param[0] = mulLangPks[pkIdx];
            }
            DB.executeBatch((DBRoute)dbRoute, (String)insertMulLangSql, insertParamList);
            srcPkList.clear();
            insertParamList.clear();
        }
        if (!insertParamList.isEmpty()) {
            SqlBuilder deleteMulLangSql = new SqlBuilder();
            deleteMulLangSql.append(String.format("delete from %s where ", targetTableName), new Object[0]);
            deleteMulLangSql.appendIn(String.format(" %s ", srcPkField), srcPkList);
            DB.execute((DBRoute)dbRoute, (SqlBuilder)deleteMulLangSql);
            String[] mulLangPks = ID.genStringIds((int)insertParamList.size());
            for (int pkIdx = 0; pkIdx < insertParamList.size(); ++pkIdx) {
                Object[] param = (Object[])insertParamList.get(pkIdx);
                param[0] = mulLangPks[pkIdx];
            }
            DB.executeBatch((DBRoute)dbRoute, (String)insertMulLangSql, insertParamList);
        }
    }
}

