/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BaseUnitqtyProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.RefProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;

public class ReportExtUtils {
    public static EntityMetadata getEntityMetadata(String reportEntity) {
        return (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)reportEntity, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
    }

    public static Map<String, EntityItem<?>> getBaseDataPropFieldItemMap(EntityMetadata entityMetadata) {
        List items = entityMetadata.getItems();
        LinkedHashMap itemMap = new LinkedHashMap(16);
        for (EntityItem item : items) {
            if (!(item instanceof BasedataPropField)) continue;
            itemMap.put(item.getKey(), item);
        }
        return itemMap;
    }

    public static String getSimpleText(String fullText) {
        if (fullText != null && fullText.length() > 240) {
            return fullText.substring(0, 240);
        }
        return fullText;
    }

    public static String getBasePropFieldName(EntityItem<?> fieldEntityItem) {
        return ((BasedataPropField)fieldEntityItem).getName().getLocaleValue();
    }

    public static String buildJsonByProp(String entityNumber, String fieldNumber, String fieldName) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map propMap = mainType.getAllFields();
        IDataEntityProperty prop = (IDataEntityProperty)propMap.get(fieldNumber);
        if (prop == null) {
            return null;
        }
        JSONObject dataJsonObject = new JSONObject(16);
        dataJsonObject.put("fieldnumer", (Object)fieldNumber);
        dataJsonObject.put("fieldname", (Object)fieldName);
        if (prop instanceof BasedataProp) {
            dataJsonObject.put("fieldtype", (Object)"G");
            dataJsonObject.put("entityobject", (Object)((BasedataProp)prop).getBaseEntityId());
            dataJsonObject.put("displayprop", (Object)((BasedataProp)prop).getDisplayProp());
            dataJsonObject.put("refprop", (Object)ReportExtUtils.getRefFields((BasedataProp)prop));
        } else if (prop instanceof ComboProp) {
            dataJsonObject.put("fieldtype", (Object)"F");
            List itemList = ((ComboProp)prop).getComboItems();
            HashSet<String> valueSet = new HashSet<String>(16);
            JSONArray itemJs = new JSONArray(16);
            for (ValueMapItem vi : itemList) {
                if (vi == null || !valueSet.add(vi.getValue())) continue;
                JSONObject itemObject = new JSONObject();
                itemObject.put("combstatusvalue", (Object)vi.getValue());
                itemObject.put("combstatusname", (Object)vi.getName().getLocaleValue());
                itemJs.add((Object)itemObject);
            }
            dataJsonObject.put("statusentryentity", (Object)itemJs);
        } else if (prop instanceof QtyProp || prop instanceof DecimalProp) {
            dataJsonObject.put("fieldtype", (Object)"B");
            dataJsonObject.put("zeroshow", (Object)((QtyProp)prop).isZeroShow());
            dataJsonObject.put("bigdecimalscale", (Object)((QtyProp)prop).getScale());
            if (prop instanceof BaseUnitqtyProp) {
                dataJsonObject.put("measureunitfield", (Object)((BaseUnitqtyProp)prop).getRelatedMaterielKey());
            }
        } else if (prop instanceof DateTimeProp) {
            dataJsonObject.put("fieldtype", (Object)"E");
            dataJsonObject.put("dateformatmask", (Object)"A");
        } else if (prop instanceof DateProp) {
            dataJsonObject.put("fieldtype", (Object)"E");
            dataJsonObject.put("dateformatmask", (Object)"B");
        } else if (prop instanceof BooleanProp) {
            dataJsonObject.put("fieldtype", (Object)"C");
        } else if (prop instanceof LongProp || prop instanceof BigIntProp || prop instanceof IntegerProp) {
            dataJsonObject.put("fieldtype", (Object)"D");
        } else if (prop instanceof TextProp) {
            dataJsonObject.put("fieldtype", (Object)"A");
        }
        return dataJsonObject.toJSONString();
    }

    public static String getRefFields(BasedataProp prop) {
        RefEntityType refEntityType = (RefEntityType)prop.getDynamicComplexPropertyType();
        StringBuilder sb = new StringBuilder();
        if (refEntityType != null && refEntityType.getExtendName() != null) {
            String[] fields;
            String extendNames = refEntityType.getExtendName();
            int indexS = extendNames.indexOf("[");
            int indexE = extendNames.indexOf("]");
            extendNames = extendNames.substring(indexS + 1, indexE);
            for (String field : fields = extendNames.split(",")) {
                if (kd.bos.util.StringUtils.isEmpty((String)field) || field.equals("id")) continue;
                sb.append(field).append(",");
            }
        }
        return sb.length() > 1 ? sb.substring(0, sb.length() - 1) : sb.toString();
    }

    public static String buildJsonByMetaField(EntityMetadata entityMetadata, EntityItem<?> fieldEntityItem) {
        JSONObject dataJsonObject = new JSONObject(16);
        if (fieldEntityItem instanceof BasedataPropField) {
            dataJsonObject.put("fieldtype", (Object)"H");
            dataJsonObject.put("fieldnumer", (Object)fieldEntityItem.getKey());
            dataJsonObject.put("displayprop", (Object)((BasedataPropField)fieldEntityItem).getRefDisplayProp());
            String refBaseId = ((BasedataPropField)fieldEntityItem).getRefBaseFieldId();
            BasedataField refEntityItem = (BasedataField)entityMetadata.getItemById(refBaseId);
            dataJsonObject.put("refbasedataprop", (Object)refEntityItem.getKey());
            dataJsonObject.put("entityobject", (Object)MetadataDao.getEntityNumberById((String)refEntityItem.getBaseEntityId()));
            dataJsonObject.put("refprop", (Object)ReportExtUtils.getDisplayProp(refEntityItem));
            return dataJsonObject.toJSONString();
        }
        return "";
    }

    public static TreeNode buildRefColTree(String entity) {
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.setIncludePKField(true);
        ops.setIncludeChildEntity(false);
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entity);
        return FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)ops);
    }

    public static final List<String> splitCombColToList(String combColVal) {
        ArrayList<String> tempSet = new ArrayList<String>();
        if (combColVal != null) {
            String[] keys;
            for (String key : keys = combColVal.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                tempSet.add(key);
            }
        }
        return tempSet;
    }

    public static String getDisplayProp(BasedataField refEntityItem) {
        StringBuilder sb = new StringBuilder();
        List list = refEntityItem.getRefProps();
        if (list != null) {
            for (RefProp ref : list) {
                sb.append(ref.getName()).append(",");
            }
        }
        return sb.length() > 1 ? sb.substring(0, sb.length() - 1) : sb.toString();
    }
}

