/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;

public class ControlUtil {
    private ControlUtil() {
    }

    public static void setOldValue(IFormView fv, IDataModel dm, DynamicObject propertyValueCDDE, String propertyName, Object oldObject) {
        dm.beginInit();
        if (propertyValueCDDE != null) {
            propertyValueCDDE.beginInit();
            propertyValueCDDE.set(propertyName, oldObject);
            propertyValueCDDE.endInit();
        }
        dm.endInit();
        fv.updateView(propertyName);
    }

    public static void setOldValue(IFormView fv, IDataModel dm, DynamicObject propertyValueCDDE, String propertyName, Object oldObject, int row) {
        dm.beginInit();
        if (propertyValueCDDE != null) {
            propertyValueCDDE.beginInit();
            propertyValueCDDE.set(propertyName, oldObject);
            propertyValueCDDE.endInit();
        }
        dm.endInit();
        fv.updateView(propertyName, row);
    }

    public static void showEntityFieldForm(TreeNode entityNode, String formId, String customParmsName, String callbackKey, IFormView fv, IFormPlugin plugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        String nodesJson = SerializationUtils.toJsonString((Object)entityNode);
        showParameter.getCustomParams().put(customParmsName, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, callbackKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        fv.showForm(showParameter);
    }

    public static MainEntityType getMainEntityType(DynamicObject entity) {
        if (entity != null) {
            Object billentityPkValue = entity.getPkValue();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billentityPkValue.toString());
            return dataEntityType;
        }
        return null;
    }

    public static void setCellColor(IFormView fv, String entryKey, String fieldKey, Object fieldData, String foreColor, String backColor, String defeatForceColor, String defeatBackColor) {
        if (fv == null || StringUtils.isBlank((CharSequence)entryKey) || StringUtils.isBlank((CharSequence)fieldKey)) {
            return;
        }
        IDataModel dm = fv.getModel();
        EntryGrid entryGrid = (EntryGrid)fv.getControl(entryKey);
        if (entryGrid == null) {
            return;
        }
        int rows = dm.getEntryRowCount(entryKey);
        ArrayList<CellStyle> cells = new ArrayList<CellStyle>();
        for (int i = 0; i < rows; ++i) {
            CellStyle cell;
            Object data = dm.getValue(fieldKey, i);
            if (fieldData != null && data != null && StringUtils.equalsIgnoreCase((CharSequence)data.toString(), (CharSequence)fieldData.toString())) {
                cell = new CellStyle();
                cell.setFieldKey(fieldKey);
                cell.setRow(i);
                cell.setBackColor(backColor);
                cell.setForeColor(foreColor);
                cells.add(cell);
                continue;
            }
            cell = new CellStyle();
            cell.setFieldKey(fieldKey);
            cell.setRow(i);
            cell.setBackColor(defeatBackColor);
            cell.setForeColor(defeatForceColor);
            cells.add(cell);
        }
        if (!cells.isEmpty()) {
            entryGrid.setCellStyle(cells);
            fv.updateView(entryKey);
        }
    }

    public static void setControlMustInput(IFormView fv, String controlName, String tip, boolean isMustInput) {
        BasedataProp basedataProp;
        FieldEdit fieldEdit = (FieldEdit)fv.getControl(controlName);
        DynamicProperty dp = fv.getModel().getDataEntityType().getProperty(controlName);
        FieldProp fieldProp = dp instanceof FieldProp ? (FieldProp)dp : null;
        BasedataProp basedataProp2 = basedataProp = dp instanceof BasedataProp ? (BasedataProp)dp : null;
        if (fieldEdit == null) {
            return;
        }
        HashMap<String, String> itemMap = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> ctlMap = new HashMap<String, HashMap<String, String>>();
        fieldEdit.setMustInput(isMustInput);
        itemMap.put("emptytip", tip);
        ctlMap.put("item", itemMap);
        fv.updateControlMetadata(controlName, ctlMap);
    }

    public static void setEntryFieldBizChanged(DynamicObject dataEntity, String entryKey, List<String> entryProperties) {
        if (dataEntity == null || StringUtils.isEmpty((CharSequence)entryKey) || entryProperties == null) {
            return;
        }
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection(entryKey);
        if (entryEntity != null && !entryEntity.isEmpty()) {
            for (DynamicObject dy : entryEntity) {
                IDataEntityType dt = dy.getDataEntityType();
                DataEntityPropertyCollection properties = dt.getProperties();
                for (String name : entryProperties) {
                    IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)name);
                    if (property == null) continue;
                    int ordinal = property.getOrdinal();
                    dy.getDataEntityState().setBizChanged(ordinal, false);
                    if (!(property instanceof BasedataProp)) continue;
                    property = (IDataEntityProperty)properties.get((Object)(name + "_id"));
                    Optional.ofNullable(property).ifPresent(p -> dy.getDataEntityState().setBizChanged(p.getOrdinal(), false));
                }
            }
        }
    }
}

