/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.common.util;

import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

public class DemandPriorityTableUtils {
    private static final String ID = "id";
    private static final String ENTRY = "entryentity";
    private static final String TYPE = "elementtype";

    public static void createTables(DynamicObject obj, String routekey) {
        long id = obj.getLong(ID);
        DynamicObjectCollection coll = obj.getDynamicObjectCollection(ENTRY);
        StringBuilder sql = new StringBuilder();
        sql.append("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_mrp_").append(id).append("') ");
        sql.append("create table t_mrp_").append(id).append("(\n");
        sql.append((CharSequence)DemandPriorityTableUtils.getFieldSql(coll)).append(')');
        DB.execute((DBRoute)new DBRoute(routekey), (String)sql.toString());
    }

    public static void dropTables(DynamicObject obj, String routekey) {
        long id = obj.getLong(ID);
        DemandPriorityTableUtils.executeDelete(routekey, id);
    }

    public static boolean checkTableHasData(DynamicObject obj, String routekey) {
        block30: {
            long id = obj.getLong(ID);
            StringBuilder sql = new StringBuilder();
            StringBuilder checkSql = new StringBuilder();
            checkSql.append("SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_mrp_").append(id).append("' ");
            sql.append("select top 1 fid from t_mrp_").append(id);
            try (DataSet checkset = DB.queryDataSet((String)DemandPriorityTableUtils.class.getName(), (DBRoute)new DBRoute(routekey), (String)checkSql.toString());){
                if (!checkset.hasNext()) break block30;
                try (DataSet set = DB.queryDataSet((String)DemandPriorityTableUtils.class.getName(), (DBRoute)new DBRoute(routekey), (String)sql.toString());){
                    if (set.hasNext()) {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    private static void executeDelete(String routekey, long id) {
        StringBuilder sql = new StringBuilder();
        sql.append("IF EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_mrp_").append(id).append("') ");
        sql.append("drop table t_mrp_").append(id);
        DB.execute((DBRoute)new DBRoute(routekey), (String)sql.toString());
    }

    private static StringBuilder getFieldSql(DynamicObjectCollection coll) {
        Iterator its = coll.iterator();
        StringBuilder std = new StringBuilder();
        std.append("fid BIGINT primary key");
        std.append(",fweight").append(" DECIMAL(23,10)");
        std.append(",fgroupid").append(" nvarchar(50)");
        int i = 0;
        while (its.hasNext()) {
            DynamicObject dyn = (DynamicObject)its.next();
            String type = dyn.getString(TYPE);
            if ("0".equals(type)) {
                std.append(",fmaterial").append(i).append(" BIGINT");
                std.append(",fstartnumber").append(i).append(" DECIMAL(23,10)");
                std.append(",fendnumber").append(i).append(" DECIMAL(23,10)");
            } else if ("1".equals(type)) {
                std.append(",fcombounit").append(i).append(" NVARCHAR(30)");
                std.append(",fstartdate").append(i).append(" DECIMAL(23,10)");
                std.append(",fenddate").append(i).append(" DECIMAL(23,10)");
            } else if ("2".equals(type)) {
                std.append(",fpriority").append(i).append(" BIGINT");
            }
            ++i;
        }
        return std;
    }
}

