/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.resourcecheck.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.util.StringUtils;

public class CheckLogicUtils {
    public static final String AFTERCHAR = "B";
    public static final String SPACECHAR = " ";

    public static boolean isNull(String condition) {
        return "G".equals(condition);
    }

    public static boolean isNotNull(String condition) {
        return "H".equals(condition);
    }

    public static String genFieldNumber(String oldFieldNumber, String entityType) {
        return "A".equals(entityType) ? oldFieldNumber : oldFieldNumber + AFTERCHAR;
    }

    public static String genConditionStr(String conditionCombType, String LeftFieldNumber, String rightFieldNumber, Field fieldType) {
        StringBuilder sb = new StringBuilder();
        String nullValue = CheckLogicUtils.getNullValueByFieldType(fieldType);
        sb.append(" ( ");
        sb.append(LeftFieldNumber);
        switch (conditionCombType) {
            case "A": {
                sb.append(" = ");
                break;
            }
            case "B": {
                sb.append(" <> ");
                break;
            }
            case "C": {
                sb.append(" > ");
                break;
            }
            case "D": {
                sb.append(" >= ");
                break;
            }
            case "E": {
                sb.append(" < ");
                break;
            }
            case "F": {
                sb.append(" <= ");
                break;
            }
            case "G": {
                sb.append(" = null ");
                if (nullValue == null) break;
                sb.append(" or ").append(LeftFieldNumber).append(" = ").append(nullValue);
                break;
            }
            case "H": {
                sb.append(" <> null ");
                if (nullValue == null) break;
                sb.append(" and ").append(LeftFieldNumber).append(" <> ").append(nullValue);
                break;
            }
        }
        if (!StringUtils.isEmpty((String)rightFieldNumber)) {
            sb.append(rightFieldNumber);
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getNullValueByFieldType(Field fieldType) {
        if (DataType.BooleanType.equals((Object)fieldType.getDataType()) || DataType.DateType.equals((Object)fieldType.getDataType()) || DataType.TimestampType.equals((Object)fieldType.getDataType())) {
            return null;
        }
        if (DataType.IntegerType.equals((Object)fieldType.getDataType()) || DataType.LongType.equals((Object)fieldType.getDataType()) || DataType.BigDecimalType.equals((Object)fieldType.getDataType()) || DataType.DoubleType.equals((Object)fieldType.getDataType())) {
            return "0";
        }
        return "''";
    }

    public static String genChar(String charCombType, boolean isLeft) {
        if (isLeft) {
            return "C".equalsIgnoreCase(charCombType) ? "((" : (AFTERCHAR.equalsIgnoreCase(charCombType) ? "(" : "");
        }
        return "C".equalsIgnoreCase(charCombType) ? "))" : (AFTERCHAR.equalsIgnoreCase(charCombType) ? ")" : "");
    }

    public static String genOrAnd(String orandCombType) {
        return "A".equalsIgnoreCase(orandCombType) ? "and" : "or";
    }

    public static String buildFilter(DynamicObject resourceCheckObj, DataSet ds) {
        DynamicObjectCollection checkLogicEntryColl = resourceCheckObj.getDynamicObjectCollection("checklogicentry");
        int size = checkLogicEntryColl.size();
        StringBuilder filterSb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            DynamicObject checkLogicEntry = (DynamicObject)checkLogicEntryColl.get(i);
            String filterType = checkLogicEntry.getString("entryfiltertype");
            String leftChar = checkLogicEntry.getString("leftchar");
            String entryLeftEntityType = checkLogicEntry.getString("entryleftentitytype");
            String entryLeftEntityNumber = (String)checkLogicEntry.getDynamicObject("entryleftentity").getPkValue();
            String entryLeftFieldNumber = checkLogicEntry.getString("entryleftfieldnumber");
            String condition = checkLogicEntry.getString("condition");
            String entryRightEntityType = checkLogicEntry.getString("entryrightentitytype");
            String entryRightFieldNumber = checkLogicEntry.getString("entryrightfieldnumber");
            String filterValue = checkLogicEntry.getString("entryfiltervalue_tag");
            String rightChar = checkLogicEntry.getString("rightchar");
            String orAnd = checkLogicEntry.getString("orand");
            filterSb.append(CheckLogicUtils.genChar(leftChar, true));
            filterSb.append(SPACECHAR);
            if ("A".equals(filterType)) {
                String leftFieldNumber = CheckLogicUtils.genFieldNumber(entryLeftFieldNumber, entryLeftEntityType);
                String rightFieldNumber = CheckLogicUtils.genFieldNumber(entryRightFieldNumber, entryRightEntityType);
                if (CheckLogicUtils.isNull(condition) || CheckLogicUtils.isNotNull(condition)) {
                    rightFieldNumber = null;
                }
                filterSb.append(CheckLogicUtils.genConditionStr(condition, leftFieldNumber, rightFieldNumber, ds.getRowMeta().getField(leftFieldNumber)));
            } else {
                QFilter qfilter = CheckLogicUtils.getQFilter(filterValue, entryLeftEntityNumber);
                filterSb.append(CheckLogicUtils.buildQFilterToStr(qfilter, "A".equals(entryLeftEntityType)));
            }
            filterSb.append(SPACECHAR);
            filterSb.append(CheckLogicUtils.genChar(rightChar, false));
            if (i >= size - 1) continue;
            filterSb.append(CheckLogicUtils.genOrAnd(orAnd));
        }
        String expression = filterSb.toString();
        String validResult = CheckLogicUtils.isValid(expression);
        if (!StringUtils.isEmpty((String)validResult)) {
            throw new KDBizException(new ErrorCode("isValid", String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u903b\u8f91\u7684\u5b57\u7b26\u4e32\u6821\u9a8c\u5931\u8d25\uff1a%1$s\uff0c\u8868\u8fbe\u5f0f\u4e3a\uff1a%2$s", (String)"CheckLogicUtils_01", (String)"mpscmm-msplan-common", (Object[])new Object[0]), validResult, expression)), new Object[0]);
        }
        return expression;
    }

    public static String buildQFilterToStr(QFilter qfilter, boolean isMainEntity) {
        String filterExpress = "";
        if (isMainEntity) {
            filterExpress = qfilter.tryConvertToAlgoExpression();
        } else {
            QFilter[] qs;
            for (QFilter qf : qs = qfilter.toArray()) {
                String fieldNumber = qf.getProperty();
                if (!"1".equals(fieldNumber)) {
                    qf.__setProperty(qf.getProperty() + AFTERCHAR);
                }
                List allFilters = qf.getNests(true);
                for (QFilter.QFilterNest sub : allFilters) {
                    QFilter qfSub = sub.getFilter();
                    String subfieldNumber = qfSub.getProperty();
                    if ("1".equals(subfieldNumber)) continue;
                    qfSub.__setProperty(subfieldNumber + AFTERCHAR);
                }
            }
            filterExpress = qfilter.tryConvertToAlgoExpression();
        }
        if (filterExpress != null) {
            filterExpress = filterExpress.replace("\\", "");
        }
        return filterExpress;
    }

    public static String isValid(String expression) {
        Stack<Character> stack = new Stack<Character>();
        int size = expression.length();
        for (int i = 0; i < size; ++i) {
            char c = expression.charAt(i);
            if (c == '(') {
                stack.push(Character.valueOf(c));
                continue;
            }
            if (c != ')') continue;
            if (stack.isEmpty()) {
                return String.format(ResManager.loadKDString((String)"\u5728\u4f4d\u7f6e  %1$s \u5904\u7f3a\u5c11\u5de6\u62ec\u53f7\u3002", (String)"CheckLogicUtils_02", (String)"mpscmm-msplan-common", (Object[])new Object[0]), i);
            }
            stack.pop();
        }
        if (!stack.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u5728\u4f4d\u7f6e  %1$s \u5904\u7f3a\u5c11\u53f3\u62ec\u53f7\u3002", (String)"CheckLogicUtils_03", (String)"mpscmm-msplan-common", (Object[])new Object[0]), expression.length() - stack.size());
        }
        return "";
    }

    public static Set<String> getQFilterFields(QFilter qfilter) {
        QFilter[] qs = qfilter.toArray();
        HashSet<String> sets = new HashSet<String>(16);
        for (QFilter qf : qs) {
            String fieldNumber = qf.getProperty();
            if (!"1".equals(fieldNumber)) {
                sets.add(fieldNumber);
            }
            List allFilters = qf.getNests(true);
            for (QFilter.QFilterNest sub : allFilters) {
                QFilter qfSub = sub.getFilter();
                String subfieldNumber = qfSub.getProperty();
                if ("1".equals(subfieldNumber)) continue;
                sets.add(subfieldNumber);
            }
        }
        return sets;
    }

    public static QFilter getQFilter(String filterContent, String entityName) {
        FilterBuilder fb = CheckLogicUtils.getFilterBuilder(filterContent, entityName);
        return fb.getQFilter();
    }

    public static FilterBuilder getFilterBuilder(String filterContent, String entityName) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterContent, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(entityType, filterCondition);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        return fb;
    }
}

