/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.resourcecheck.utils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.mpscmm.msplan.resourcecheck.utils.SqlParamUtils;

public class ResourceCheckUtils {
    private static final String APPPARAM = "mpscmm-msplan-common";

    public static String translateJsonString(String filters, String number) {
        if (kd.bos.util.StringUtils.isBlank((String)filters) || kd.bos.util.StringUtils.isBlank((String)number)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filters, FilterCondition.class);
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)number);
        String filterStr = ResourceCheckUtils.convertFilterCondition(filterCondition, mainType);
        FilterBuilder fb = new FilterBuilder(mainType, filterCondition, false);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        return filterStr;
    }

    private static String convertFilterCondition(FilterCondition filterCondition, MainEntityType mainType) {
        List simpleFilterRows = filterCondition.getFilterRow();
        Iterator simpleFilterRowIterator = simpleFilterRows.iterator();
        StringBuilder filterStr = new StringBuilder();
        ArrayList<SimpleFilterRow> filterRow = new ArrayList<SimpleFilterRow>(16);
        FilterCondition fc = new FilterCondition();
        int row = 1;
        int size = simpleFilterRows.size();
        while (simpleFilterRowIterator.hasNext()) {
            SimpleFilterRow simpleFilterRow = (SimpleFilterRow)simpleFilterRowIterator.next();
            String leftBracket = simpleFilterRow.getLeftBracket();
            String rightBracket = simpleFilterRow.getRightBracket();
            simpleFilterRow.setLeftBracket("");
            simpleFilterRow.setRightBracket("");
            String logicDesc = "";
            String logic = simpleFilterRow.getLogic();
            logicDesc = "1".equals(logic) ? ResManager.loadKDString((String)"\u6216\u8005", (String)"ResourceCheckUtils_01", (String)APPPARAM, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e76\u4e14", (String)"ResourceCheckUtils_02", (String)APPPARAM, (Object[])new Object[0]);
            String fieldName = simpleFilterRow.getFieldName();
            List filterValues = simpleFilterRow.getValue();
            UserService userService = new UserService();
            if (fieldName.endsWith("_mmc_formula") && filterValues != null && !filterValues.isEmpty()) {
                String value = ((FilterValue)filterValues.get(0)).getValue() == null ? "" : (String)((FilterValue)filterValues.get(0)).getValue();
                fieldName = fieldName.replaceAll("_mmc_formula", "");
                if (value.contains("@this")) {
                    value = value.replaceAll("\"@this\"", fieldName);
                }
                value = value.replaceAll("\\s+", " ");
                value = fieldName.concat(" ").concat(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f", (String)"ResourceCheckUtils_03", (String)APPPARAM, (Object[])new Object[0])).concat(" ").concat(value);
                filterStr.append(leftBracket);
                if (value.length() > 0) {
                    String[] strlen;
                    for (String str : strlen = value.split(" ")) {
                        DynamicProperty dynamicProperty = mainType.getProperty(str);
                        if (dynamicProperty != null && dynamicProperty.getDisplayName() != null) {
                            String displayName = dynamicProperty.getDisplayName().toString();
                            filterStr.append(displayName).append(' ');
                            continue;
                        }
                        filterStr.append(str).append(' ');
                    }
                }
                if (size == row) {
                    filterStr.append(rightBracket).append(' ');
                } else {
                    filterStr.append(rightBracket).append(logicDesc).append(' ');
                }
                simpleFilterRow.setCompareType("37");
                simpleFilterRow.setFieldName(fieldName);
                simpleFilterRow.setValue(new ArrayList(0));
            } else {
                filterRow.add(simpleFilterRow);
                fc.setFilterRow(filterRow);
                FilterBuilder fb = new FilterBuilder(mainType, fc, false);
                fb.setUserService((IUserService)userService);
                fb.buildFilter(false);
                filterRow.clear();
                if (size == row) {
                    filterStr.append(leftBracket).append(fb.getFilterString().trim()).append(rightBracket).append(' ');
                } else {
                    filterStr.append(leftBracket).append(fb.getFilterString().trim()).append(rightBracket).append(logicDesc).append(' ');
                }
            }
            simpleFilterRow.setLeftBracket(leftBracket);
            simpleFilterRow.setRightBracket(rightBracket);
            ++row;
        }
        return filterStr.toString();
    }

    public static Map<String, IDataEntityProperty> getEntityEntryFields(String entityNumber, String entryTag) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map entityFields = mainType.getAllFields();
        HashMap<String, IDataEntityProperty> allFields = new HashMap<String, IDataEntityProperty>(64);
        for (Map.Entry fieldEntrys : entityFields.entrySet()) {
            String fieldNumber = (String)fieldEntrys.getKey();
            IDataEntityProperty fieldValue = (IDataEntityProperty)fieldEntrys.getValue();
            if (fieldValue == null || !(fieldValue.getParent() instanceof EntryType) || !entryTag.equals(((EntryType)fieldValue.getParent()).getName())) continue;
            allFields.put(fieldNumber, fieldValue);
        }
        return allFields;
    }

    public static String getFieldName(String entityName, String fieldNumber) {
        if (kd.bos.util.StringUtils.isEmpty((String)entityName) || kd.bos.util.StringUtils.isEmpty((String)fieldNumber)) {
            return null;
        }
        ArrayList<String> captions = new ArrayList<String>();
        MainEntityType mainType = ResourceCheckUtils.getMainEntityType(entityName);
        Map<String, IDataEntityProperty> props = ResourceCheckUtils.findPropertys((EntityType)mainType, fieldNumber);
        IDataEntityProperty firstProp = props.entrySet().iterator().next().getValue();
        if (firstProp != null) {
            IDataEntityType parentType = null;
            parentType = firstProp instanceof EntryProp ? ((EntryProp)firstProp).getItemType() : firstProp.getParent();
            if (parentType instanceof MainEntityType) {
                captions.add(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ResourceCheckUtils_04", (String)APPPARAM, (Object[])new Object[0]));
            }
        }
        for (Map.Entry<String, IDataEntityProperty> item : props.entrySet()) {
            if (item.getValue() == null) {
                captions.add(item.getKey());
                continue;
            }
            IDataEntityProperty property = item.getValue();
            if (property instanceof DynamicProperty) {
                LocaleString displayCaption = ((DynamicProperty)property).getDisplayName();
                captions.add(displayCaption == null ? item.getKey() : displayCaption.toString());
                continue;
            }
            captions.add(item.getKey());
        }
        return StringUtils.join((Object[])captions.toArray(), (String)".");
    }

    public static Map<String, IDataEntityProperty> findPropertys(EntityType mainType, String fullPropName) {
        LinkedHashMap<String, IDataEntityProperty> props = new LinkedHashMap<String, IDataEntityProperty>();
        if (mainType.getName().equalsIgnoreCase(fullPropName) || "billhead".equalsIgnoreCase(fullPropName)) {
            props.put(fullPropName, (IDataEntityProperty)mainType.getPrimaryKey());
            return props;
        }
        Object prop = null;
        String[] keys = fullPropName.split("\\.");
        ArrayList<String> unknowKeys = new ArrayList<String>(16);
        String key1 = null;
        int index = 0;
        boolean flag = false;
        for (int i = 0; i < keys.length; ++i) {
            unknowKeys.add(keys[i]);
            if (flag || keys[i].equals(mainType.getExtendName())) continue;
            key1 = keys[i];
            index = i;
            flag = true;
        }
        int nextKeyIndex = index + 1;
        if (keys.length == 1) {
            prop = mainType.findProperty(key1);
            if (prop != null) {
                props.put(key1, (IDataEntityProperty)prop);
            } else {
                props.put(key1, null);
            }
            unknowKeys.clear();
        } else if (keys.length > 1) {
            prop = mainType.findProperty(key1);
            if (prop == null) {
                props.put(fullPropName, null);
                unknowKeys.clear();
            } else {
                props.put(key1, (IDataEntityProperty)prop);
                unknowKeys.remove(0);
                String key2 = keys[nextKeyIndex];
                if (prop instanceof EntryProp) {
                    prop = mainType.findProperty(key2);
                    if (prop == null) {
                        prop = mainType.findProperty(key1 + "." + key2);
                    }
                    ++nextKeyIndex;
                    if (prop != null) {
                        props.put(key2, (IDataEntityProperty)prop);
                        unknowKeys.remove(0);
                    }
                }
                if (prop instanceof BasedataProp && keys.length > nextKeyIndex) {
                    key2 = keys[nextKeyIndex];
                    ++nextKeyIndex;
                    BasedataProp bdProp1 = (BasedataProp)prop;
                    MainEntityType baseEntityType1 = (MainEntityType)bdProp1.getComplexType();
                    if ((prop = baseEntityType1.getPrimaryKey().getName().equals(key2) ? baseEntityType1.getPrimaryKey() : baseEntityType1.findProperty(key2)) != null) {
                        props.put(key2, (IDataEntityProperty)prop);
                        unknowKeys.remove(0);
                    }
                    if (prop instanceof BasedataProp && keys.length > nextKeyIndex) {
                        String key3 = keys[nextKeyIndex];
                        ++nextKeyIndex;
                        BasedataProp bdProp2 = (BasedataProp)prop;
                        MainEntityType baseEntityType2 = (MainEntityType)bdProp2.getComplexType();
                        if ((prop = baseEntityType2.getPrimaryKey().getName().equals(key3) ? baseEntityType2.getPrimaryKey() : baseEntityType2.findProperty(key3)) != null) {
                            props.put(key3, (IDataEntityProperty)prop);
                            unknowKeys.remove(0);
                        }
                    }
                }
            }
        }
        if (unknowKeys.size() > 0) {
            // empty if block
        }
        return props;
    }

    public static IDataEntityProperty getFieldDataEntityProperty(String entityName, String fieldNumber) {
        MainEntityType mainType = ResourceCheckUtils.getMainEntityType(entityName);
        Map allFields = mainType.getAllFields();
        return (IDataEntityProperty)allFields.get(fieldNumber);
    }

    public static MainEntityType getMainEntityType(String entityName) {
        return EntityMetadataCache.getDataEntityType((String)entityName);
    }

    public static String getResultEntityNumber(String oldEntityNumber) {
        return kd.bos.util.StringUtils.isEmpty((String)oldEntityNumber) ? "msplan_checkresult" : oldEntityNumber;
    }

    public static void addToStringMap(String keyString, Long value, Map<String, Set<Long>> map) {
        Set<Long> idSet = map.get(keyString);
        if (idSet == null) {
            idSet = new HashSet<Long>(16);
        }
        idSet.add(value);
        map.put(keyString, idSet);
    }

    public static void addToLongMap(Long keyString, Long value, Map<Long, Set<Long>> map) {
        Set<Long> idSet = map.get(keyString);
        if (idSet == null) {
            idSet = new HashSet<Long>(16);
        }
        idSet.add(value);
        map.put(keyString, idSet);
    }

    public static DynamicObjectCollection queryResourceCheckByFilter(QFilter qfilter) {
        String selectFields = "id,checkrange,groupcheckentry.resourcecheckitem subid, resultentitynumber,mainentity";
        return QueryServiceHelper.query((String)"msplan_resourcecheck", (String)selectFields, (QFilter[])new QFilter[]{qfilter});
    }

    public static Map<Long, String> queryResourceCheckResultEntityNumber(Set<Long> subIdset) {
        QFilter qfilter = new QFilter("id", "in", subIdset);
        DynamicObjectCollection coll = ResourceCheckUtils.queryResourceCheckByFilter(qfilter);
        HashMap<Long, String> dataMap = new HashMap<Long, String>(16);
        for (DynamicObject entry : coll) {
            Long itemId = entry.getLong("id");
            String resultentitynumber = ResourceCheckUtils.getResultEntityNumber(entry.getString("resultentitynumber"));
            dataMap.put(itemId, resultentitynumber);
        }
        return dataMap;
    }

    public static void setDefaultValue(Object[] resourceCheckIds, boolean isTrue) {
        DynamicObject[] dys;
        HashSet<Object> ids = new HashSet<Object>(Arrays.asList(resourceCheckIds));
        QFilter qfilter = new QFilter("id", "in", (Object)resourceCheckIds);
        DynamicObjectCollection coll = ResourceCheckUtils.queryResourceCheckByFilter(qfilter);
        Set mainEntityNumberSet = coll.stream().map(p -> p.getString("mainentity")).collect(Collectors.toSet());
        qfilter = new QFilter("mainentity", "in", mainEntityNumberSet);
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)"msplan_resourcecheck", (String)"id,isdefault", (QFilter[])new QFilter[]{qfilter})) {
            if (ids.contains(dy.getPkValue())) {
                dy.set("isdefault", (Object)isTrue);
                continue;
            }
            if (!isTrue) continue;
            dy.set("isdefault", (Object)false);
        }
        SaveServiceHelper.save((DynamicObject[])dys);
    }

    public static Long buildResultData(Object[] resourceCheckIds, Set<Long> resourceCheckIdSet, Map<Long, Set<Long>> srcMap) {
        QFilter qfilter = new QFilter("id", "in", (Object)resourceCheckIds);
        return ResourceCheckUtils.createResultData(qfilter, resourceCheckIdSet, "", srcMap);
    }

    public static Long createResultData(QFilter qfilter, Set<Long> resourceCheckIdSet, String bizIds, Map<Long, Set<Long>> srcMap) {
        Long tagId = ORM.create().genLongId("msplan_checkresult");
        Date currentDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String yp = sdf.format(currentDate);
        int seq = 0;
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>(16);
        DynamicObjectCollection coll = ResourceCheckUtils.queryResourceCheckByFilter(qfilter);
        Set<Long> subIdset = coll.stream().map(p -> p.getLong("subid")).collect(Collectors.toSet());
        Map<Object, Object> childItemResultMap = new HashMap(16);
        if (!subIdset.isEmpty()) {
            childItemResultMap = ResourceCheckUtils.queryResourceCheckResultEntityNumber(subIdset);
        }
        for (DynamicObject entry : coll) {
            Long itemId = entry.getLong("id");
            String resultentitynumber = ResourceCheckUtils.getResultEntityNumber(entry.getString("resultentitynumber"));
            ResourceCheckUtils.addToStringMap(resultentitynumber, itemId, resultMap);
            ResourceCheckUtils.addToLongMap(itemId, itemId, srcMap);
            resourceCheckIdSet.add(itemId);
            if (!"B".equals(entry.getString("checkrange"))) continue;
            Long subItemId = entry.getLong("subid");
            String subResultEntityNumber = (String)childItemResultMap.get(subItemId);
            ResourceCheckUtils.addToStringMap(subResultEntityNumber, subItemId, resultMap);
            resourceCheckIdSet.add(subItemId);
            ResourceCheckUtils.addToLongMap(subItemId, itemId, srcMap);
        }
        for (Map.Entry entrys : resultMap.entrySet()) {
            String resultEntityNumber = (String)entrys.getKey();
            Set idSet = (Set)entrys.getValue();
            if (idSet == null || idSet.isEmpty()) continue;
            ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(16);
            for (Long id : idSet) {
                DynamicObject result = ResourceCheckUtils.genResultHead(id, resultEntityNumber, tagId, bizIds);
                result.set("billno", (Object)("A_" + yp + "_" + ++seq));
                resultList.add(result);
            }
            SaveServiceHelper.save((DynamicObject[])resultList.toArray(new DynamicObject[resultList.size()]), (OperateOption)OperateOption.create());
        }
        return tagId;
    }

    public static Long buildResultData(Set<Long> bizIds, Set<Long> resourceCheckIds, Set<Long> resourceCheckIdSet, Map<Long, Set<Long>> srcMap) {
        QFilter qfilter = new QFilter("id", "in", resourceCheckIds);
        return ResourceCheckUtils.createResultData(qfilter, resourceCheckIdSet, bizIds.toString(), srcMap);
    }

    public static DynamicObject genResultHead(Long resourceCheckId, String resultEntityNumber, Long tagId, String bizids) {
        DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)resultEntityNumber);
        result.set("createtime", (Object)new Date());
        result.set("creator", (Object)RequestContext.get().getCurrUserId());
        result.set("billstatus", (Object)"A");
        result.set("checkstatus", (Object)"A");
        result.set("cost", (Object)BigDecimal.ZERO);
        result.set("resourcecheck", (Object)resourceCheckId);
        result.set("tagid", (Object)tagId);
        result.set("execdatas", (Object)SqlParamUtils.getSimpleSql(bizids));
        result.set("execdatas_tag", (Object)bizids);
        return result;
    }

    public static Set<String> getAllFieldsByEntity(String entityNumber) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return mainType.getFields().keySet();
    }

    public static String getErrorMsg(OperationResult operationResult) {
        StringBuilder errMsg = new StringBuilder();
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateResult : validateErrors) {
            List allErrorInfo = validateResult.getAllErrorInfo();
            String validatorKey = validateResult.getValidatorKey();
            allErrorInfo.forEach(operateErrorInfo -> {
                String message = operateErrorInfo.getMessage();
                errMsg.append(validatorKey).append(message);
            });
        }
        if (errMsg.length() < 1 && !operationResult.getAllErrorInfo().isEmpty()) {
            errMsg.append(operationResult.getAllErrorInfo());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess() && operationResult.getMessage() != null) {
            errMsg.append(operationResult.getMessage());
        }
        if (errMsg.length() < 1 && operationResult.getInteractionContext() != null && operationResult.getInteractionContext().getSimpleMessage() != null) {
            errMsg.append(operationResult.getInteractionContext().getSimpleMessage());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess()) {
            errMsg.append(operationResult.toString());
        }
        return errMsg.toString();
    }

    public static String getAllFields(String entityNumber) {
        return ResourceCheckUtils.getAllFields(ResourceCheckUtils.getAllFieldsByEntity(entityNumber));
    }

    public static String getAllFields(Set<String> fieldSet) {
        StringBuilder msg = new StringBuilder();
        int seq = 0;
        for (String field : fieldSet) {
            if (seq > 0) {
                msg.append(",");
            }
            msg.append(field);
            ++seq;
        }
        return msg.toString();
    }

    public static Set<Long> getDataRangeIdSet(String ids, String idSetTag, String entityNumber) {
        Set<Long> idSet = new HashSet<Long>(64);
        if (ids != null) {
            ids = ids.trim();
            idSet = SqlParamUtils.ParseStringToLongSet(ids);
        }
        if (!idSet.isEmpty() && !"id".equalsIgnoreCase(idSetTag)) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)entityNumber, (String)idSetTag, (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
            return coll.stream().map(p -> p.getLong(idSetTag)).collect(Collectors.toSet());
        }
        return idSet;
    }

    public static Long getLongId(DynamicObject dy, String field) {
        Object value = dy.get(field);
        if (value != null) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Integer) {
                return Long.parseLong(value + "");
            }
            if (value instanceof DynamicObject) {
                return (Long)dy.getDynamicObject(field).getPkValue();
            }
        }
        return 0L;
    }

    public static String getLastStr(String str, String chars) {
        int firstDotIndex = str.indexOf(chars);
        if (firstDotIndex != -1) {
            str = str.substring(firstDotIndex + 1);
        }
        return str;
    }
}

