/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mspur.utils;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;

public class CommonUtils {
    public static boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof StringBuffer && ((StringBuffer)o).length() == 0) {
            return true;
        }
        if (o instanceof List && ((List)o).isEmpty()) {
            return true;
        }
        if (o instanceof Collection && ((Collection)o).isEmpty()) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Map && ((Map)o).size() == 0;
    }

    public static boolean isRealChanged(ChangeData changeSet) {
        if (changeSet == null) {
            return false;
        }
        Object oldObject = changeSet.getOldValue();
        Object newObject = changeSet.getNewValue();
        return CommonUtils.isRealChanged(oldObject, newObject);
    }

    public static boolean isRealChanged(Object oldObject, Object newObject) {
        if (oldObject == null && newObject == null) {
            return false;
        }
        if (oldObject == null) {
            return true;
        }
        if (newObject == null) {
            return true;
        }
        if (oldObject instanceof BigDecimal) {
            if (newObject instanceof BigDecimal && ((BigDecimal)oldObject).compareTo((BigDecimal)newObject) != 0) {
                return true;
            }
            if (newObject instanceof String && ((BigDecimal)oldObject).compareTo(new BigDecimal(newObject.toString())) != 0) {
                return true;
            }
        } else if (oldObject.getClass().isAssignableFrom(newObject.getClass())) {
            if (newObject instanceof DynamicObject) {
                if (!((DynamicObject)newObject).getPkValue().equals(((DynamicObject)oldObject).getPkValue())) {
                    return true;
                }
            } else if (newObject instanceof OrmLocaleValue) {
                if (!((OrmLocaleValue)oldObject).getLocaleValue().equals(((OrmLocaleValue)newObject).getLocaleValue())) {
                    return true;
                }
            } else {
                return !oldObject.equals(newObject);
            }
        }
        return false;
    }

    public static int getProcessByVersionId(Long versionid) {
        int ip;
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"queryDataSyncActionStatus", (Object[])new Object[]{versionid});
        if (Boolean.TRUE.equals((Boolean)result.get("ok"))) {
            Map statistics = (Map)result.get("desc");
            String status = (String)statistics.get("status");
            if ("A".equals(status)) {
                ip = (Integer)statistics.get("progress");
            } else if ("S".equals(status)) {
                ip = 100;
            } else if ("F".equals(status)) {
                ip = 100;
            } else if ("C".equals(status)) {
                ip = 100;
            } else if ("N".equals(status)) {
                ip = 100;
            } else {
                throw new KDBizException("UNKNOWN SYNC STATUS, status: " + status);
            }
            if (ip == 100 && "A".equals(status)) {
                ip /= 2;
            }
        } else {
            throw new KDBizException("UNKNOWN SYNC STATUS, ec: " + result.get("ec") + ", em: " + result.get("em"));
        }
        return ip;
    }
}

