/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.business.event;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AuditGanttSrcSynchWkBenchConfigServicePlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(AuditGanttSrcSynchWkBenchConfigServicePlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        EntityEvent entityEvent = (EntityEvent)evt;
        Set pkIds = entityEvent.getBusinesskeys().stream().map(Long::parseLong).collect(Collectors.toSet());
        logger.info("Received EntityEvent with pkIds: " + pkIds);
        Map<String, Set<Long>> geMappingsAndGanttDataSrcs = AuditGanttSrcSynchWkBenchConfigServicePlugin.getGeMappingsAndGanttDataSrcs();
        Set ganttDataSrcs = geMappingsAndGanttDataSrcs.getOrDefault("ganttDataSrcs", new HashSet(2));
        if (AuditGanttSrcSynchWkBenchConfigServicePlugin.hasIntersection(ganttDataSrcs, pkIds)) {
            AuditGanttSrcSynchWkBenchConfigServicePlugin.doUpdate(ganttDataSrcs);
        }
        return evt.toString();
    }

    public static Map<String, Set<Long>> getGeMappingsAndGanttDataSrcs() {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and("modelentity.number", "in", Arrays.asList("pmts_task_gantt", "pmts_task_release_version"));
        DynamicObjectCollection mapColl = QueryServiceHelper.query((String)"msplan_gemapping", (String)"id,datasource", (QFilter[])new QFilter[]{qFilter});
        HashSet geMappings = new HashSet(2);
        HashSet ganttDataSrcs = new HashSet(2);
        mapColl.forEach(t -> {
            geMappings.add(t.getLong("id"));
            ganttDataSrcs.add(t.getLong("datasource"));
        });
        logger.info("Retrieved geMappings: " + geMappings);
        logger.info("Retrieved ganttDataSrcs: " + ganttDataSrcs);
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>();
        result.put("geMappings", geMappings);
        result.put("ganttDataSrcs", ganttDataSrcs);
        return result;
    }

    public static void doUpdate(Set<Long> ganttDataSrcs) {
        DynamicObject[] workBenchObjs = BusinessDataServiceHelper.load((String)"pmts_wkbenchconfigplan", (String)"id,ganttdatasrcs,configentry,configentry.fromgantt,configentry.confentity", null);
        if (workBenchObjs.length > 0) {
            Set<String> allEntities = AuditGanttSrcSynchWkBenchConfigServicePlugin.getGanttToEntitiesMap(ganttDataSrcs);
            logger.info("Found " + workBenchObjs.length + " workbench configurations.");
            for (DynamicObject workBenchObj : workBenchObjs) {
                HashSet<String> entities = new HashSet<String>(allEntities);
                long workBenchId = workBenchObj.getLong("id");
                DynamicObjectCollection configentry = workBenchObj.getDynamicObjectCollection("configentry");
                DynamicObjectType dynamicObjectType = configentry.getDynamicObjectType();
                Iterator iterator = configentry.iterator();
                while (iterator.hasNext()) {
                    DynamicObject rowObj = (DynamicObject)iterator.next();
                    DynamicObject confentity = rowObj.getDynamicObject("confentity");
                    boolean fromgantt = rowObj.getBoolean("fromgantt");
                    String entityId = (String)confentity.getPkValue();
                    if (!fromgantt || !StringUtils.isNotBlank((CharSequence)entityId)) continue;
                    if (!entities.contains(entityId)) {
                        iterator.remove();
                        logger.info("Removed entityId: " + entityId + " from workbench ID: " + workBenchId);
                        continue;
                    }
                    entities.remove(entityId);
                }
                if (entities.isEmpty()) continue;
                for (String entity : entities) {
                    DynamicObject newRowObj = new DynamicObject(dynamicObjectType);
                    newRowObj.set("confentity", (Object)entity);
                    newRowObj.set("fromgantt", (Object)Boolean.TRUE);
                    configentry.add((Object)newRowObj);
                }
            }
            SaveServiceHelper.save((DynamicObject[])workBenchObjs);
        } else {
            logger.info("No workbench configurations found for the provided pkIds.");
        }
    }

    public static boolean hasIntersection(Set<?> set1, Set<?> set2) {
        logger.info("Checking intersection between sets: " + set1 + " and " + set2);
        if (set1 == null || set2 == null || set1.isEmpty() || set2.isEmpty()) {
            logger.info("One or both sets are null or empty. Returning false.");
            return false;
        }
        Set<?> smallerSet = set1.size() < set2.size() ? set1 : set2;
        Set<?> largerSet = set1.size() < set2.size() ? set2 : set1;
        for (Object element : smallerSet) {
            if (!largerSet.contains(element)) continue;
            logger.info("Sets have intersection: found common element " + element);
            return true;
        }
        logger.info("No intersection found between sets.");
        return false;
    }

    private static Set<String> getGanttToEntitiesMap(Set<Long> pkIds) {
        HashSet<String> result = new HashSet<String>(2);
        logger.info("Querying Gantt entities for pkIds: " + pkIds);
        DynamicObjectCollection ganttEntities = QueryServiceHelper.query((String)"msplan_gantt_source", (String)"id,entityselect,entityselect.gantttype as gantttype,entityselect.groupentity as groupentity,entityselect.upgroupentity as upgroupentity,entityselect.upupgroupentity as upupgroupentity,entityselect.entity as entity", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
        for (DynamicObject ganttEntity : ganttEntities) {
            String gantttype = ganttEntity.getString("gantttype");
            if (!"B".equals(gantttype)) continue;
            AuditGanttSrcSynchWkBenchConfigServicePlugin.addEntityIfNotBlank(ganttEntity, "entity", result);
            AuditGanttSrcSynchWkBenchConfigServicePlugin.addEntityIfNotBlank(ganttEntity, "groupentity", result);
            AuditGanttSrcSynchWkBenchConfigServicePlugin.addEntityIfNotBlank(ganttEntity, "upgroupentity", result);
            AuditGanttSrcSynchWkBenchConfigServicePlugin.addEntityIfNotBlank(ganttEntity, "upupgroupentity", result);
        }
        logger.info("getGanttIdToEntitiesMap#result\uff1a" + result);
        return result;
    }

    private static void addEntityIfNotBlank(DynamicObject ganttEntity, String entityKey, Set<String> entities) {
        String entity = ganttEntity.getString(entityKey);
        if (StringUtils.isNotBlank((CharSequence)entity)) {
            entities.add(entity);
        }
    }
}

