/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.IFormPlugin;
import kd.mpscmm.common.util.GanttSourceUtil;

public class ColorDataSelectHelper {
    public static void openColorForm(String key, String entity, IFormView iFormView, IFormPlugin iFormPlugin) {
        int rowIndex = iFormView.getModel().getEntryCurrentRowIndex(entity);
        String fieldName = GanttSourceUtil.getDataModelStringData((IDataModel)iFormView.getModel(), (String)key, (int)rowIndex);
        HashMap<String, String> customParams = new HashMap<String, String>(2);
        customParams.put("color", fieldName);
        CloseCallBack closeCallBack = new CloseCallBack(iFormPlugin, key);
        FormShowParameter formShowParameter = GanttSourceUtil.assembleShowFormParam((String)"msplan_color_select", customParams, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
        formShowParameter.setShowTitle(false);
        formShowParameter.setShowClose(false);
        iFormView.showForm(formShowParameter);
    }

    public static void updateColorFieldGrid(String entryKey, String colorField, String colorValField, IFormView iFormView) {
        IFormView fv = iFormView;
        IDataModel dm = fv.getModel();
        EntryGrid entryGrid = (EntryGrid)fv.getControl(entryKey);
        if (entryGrid == null) {
            return;
        }
        DynamicObjectCollection colls = dm.getEntryEntity(entryKey);
        ArrayList<CellStyle> cells = new ArrayList<CellStyle>(colls.size());
        String defForceColor = "#ffffff";
        String defBackColor = "#ffffff";
        for (int i = 0; i < colls.size(); ++i) {
            DynamicObject rowObj = (DynamicObject)colls.get(i);
            Object colorVal = rowObj.get(colorValField);
            CellStyle cell = ColorDataSelectHelper.getCellStyle(i, colorField);
            if (colorVal instanceof String && !StringUtils.equals((CharSequence)String.valueOf(colorVal), (CharSequence)"")) {
                cell.setBackColor((String)colorVal);
                cell.setForeColor((String)colorVal);
            } else {
                cell.setBackColor(defForceColor);
                cell.setForeColor(defBackColor);
            }
            cells.add(cell);
        }
        if (!cells.isEmpty()) {
            entryGrid.setCellStyle(cells);
        }
    }

    private static CellStyle getCellStyle(int rowIndex, String fieldKey) {
        CellStyle cell = new CellStyle();
        cell.setFieldKey(fieldKey);
        cell.setRow(rowIndex);
        return cell;
    }
}

