/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.business.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportHelper {
    public static void export(List<List<String>> excel, String fileName, IFormView view) {
        String url = ExportHelper.createExcel(excel, fileName);
        view.download(url);
    }

    public static String createExcel(List<List<String>> excel, String fileName) {
        String tempUrl;
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet();
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        for (int i = 0; i < excel.size(); ++i) {
            SXSSFRow row = sheet.createRow(i);
            List<String> valList = excel.get(i);
            for (int j = 0; j < valList.size(); ++j) {
                SXSSFCell cell = row.createCell(j);
                cell.setCellValue(valList.get(j));
                if (i != 0) continue;
                cell.setCellStyle(style);
            }
        }
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            tempUrl = cache.saveAsUrl(fileName + ".xlsx", (InputStream)inStream, timeout);
            outStream.close();
            inStream.close();
            workbook.close();
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        return tempUrl;
    }
}

