/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.business.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msplan.mrp.common.util.DynamicObjDataUtil;

public class PlanProgramHelper {
    private static final String MRP_PRIORITY_TYPE = "mrp_priority_type";

    public static void createDemandEntry(IFormView fv, IDataModel dm, String orgId, int rowIndex) {
        PlanProgramHelper.setSelectRows(fv, orgId, rowIndex);
        dm.deleteEntryData("subentryentity");
        DynamicObjectCollection priorityTypeCol = PlanProgramHelper.getPriorityType(orgId);
        if (priorityTypeCol == null || priorityTypeCol.isEmpty()) {
            return;
        }
        DynamicObject resRegistConfig = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)dm, (String)"demandmodel");
        DynamicObject businessentity = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)resRegistConfig, (String)"businessentity");
        PlanProgramHelper.batchCreateDemandEntry(fv, dm, priorityTypeCol, businessentity);
    }

    public static void setSelectRows(IFormView fv, String orgId, int rowIndex) {
        EntryGrid orgEntryGrid = (EntryGrid)fv.getControl("orgentryentity");
        if (orgEntryGrid == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)orgId, (CharSequence)"0") || StringUtils.isBlank((CharSequence)orgId)) {
            orgEntryGrid.clearEntryState();
        } else {
            orgEntryGrid.selectRows(rowIndex, true);
        }
    }

    public static DynamicObjectCollection getPriorityType(String orgId) {
        QFilter qFilter1 = new QFilter("createorg", "=", (Object)Long.valueOf(orgId));
        QFilter qFilter2 = new QFilter("status", "=", (Object)"C");
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qFilter1, qFilter2, qFilter3};
        String selectField = "id , entryentity.elementname elementname, entryentity.elementtype elementtype, entryentity.elementobject elementobject";
        return QueryServiceHelper.query((String)MRP_PRIORITY_TYPE, (String)selectField, (QFilter[])qFilters);
    }

    public static void batchCreateDemandEntry(IFormView fv, IDataModel dm, DynamicObjectCollection priorityTypeCol, DynamicObject businessentity) {
        AbstractFormDataModel model = (AbstractFormDataModel)dm;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField("entrytypename", new Object[0]);
        vs.addField("entryelementname", new Object[0]);
        vs.addField("entryelementtype", new Object[0]);
        vs.addField("entrydemandentity", new Object[0]);
        for (int i = 0; i < priorityTypeCol.size(); ++i) {
            DynamicObject priorityType = (DynamicObject)priorityTypeCol.get(i);
            vs.addRow(new Object[]{i + 1, priorityType.get("id"), priorityType.get("elementname"), priorityType.get("elementtype"), businessentity == null ? null : businessentity.getPkValue()});
        }
        model.batchCreateNewEntryRow("subentryentity", vs);
        model.endInit();
        fv.updateView("subentryentity");
    }

    public static boolean entityObjectIsExist(Object entityId) {
        QFilter qFilter = new QFilter("id", "=", entityId);
        return QueryServiceHelper.exists((String)"bos_entityobject", (QFilter[])new QFilter[]{qFilter});
    }
}

