/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.business.helper;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msplan.business.helper.model.PriorityModelData;
import org.apache.commons.collections4.map.LinkedMap;

public class PriorityCalculationHelper {
    private static final Log logger = LogFactory.getLog(PriorityCalculationHelper.class);

    public static List<Map<String, Object>> calPlanPriorityModel(Long prioritymodelId, List<Map<String, Object>> parameterList) {
        DynamicObject priorityModel = BusinessDataServiceHelper.loadSingleFromCache((Object)prioritymodelId, (String)"msplan_priority_model");
        DynamicObjectCollection entrys = priorityModel.getDynamicObjectCollection("entryentity");
        ArrayList<Long> idList = new ArrayList<Long>(entrys.size());
        ArrayList<PriorityModelData> modelDataList = new ArrayList<PriorityModelData>(entrys.size());
        for (DynamicObject entry : entrys) {
            if (entry.get("prioritydefine_id") != null && entry.getLong("prioritydefine_id") != 0L) {
                idList.add(entry.getLong("prioritydefine_id"));
            }
            modelDataList.add(PriorityCalculationHelper.genPriorityModelData(entry));
        }
        Collections.sort(modelDataList, (x, y) -> x.getSeq() - y.getSeq());
        Map defineMap = BusinessDataServiceHelper.loadFromCache((Object[])idList.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"msplan_priority_define"));
        ArrayList<Integer> rowList = new ArrayList<Integer>(parameterList.size());
        for (int i = 0; i < parameterList.size(); ++i) {
            rowList.add(i);
        }
        ArrayList<Integer> sortResult = new ArrayList<Integer>(parameterList.size());
        PriorityCalculationHelper.sort(0, sortResult, rowList, modelDataList, parameterList, defineMap);
        ArrayList<Map<String, Object>> sortResultList = new ArrayList<Map<String, Object>>(parameterList.size());
        Iterator iterator = sortResult.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            sortResultList.add(parameterList.get(index));
        }
        return sortResultList;
    }

    public static DataSet sortByDataSet(Long prioritymodelId, DataSet dataSet) {
        DynamicObject priorityModel = BusinessDataServiceHelper.loadSingleFromCache((Object)prioritymodelId, (String)"msplan_priority_model");
        DynamicObjectCollection entrys = priorityModel.getDynamicObjectCollection("entryentity");
        ArrayList<Long> idList = new ArrayList<Long>(entrys.size());
        ArrayList<PriorityModelData> modelDataList = new ArrayList<PriorityModelData>(entrys.size());
        for (DynamicObject entry : entrys) {
            if (entry.get("prioritydefine_id") != null && entry.getLong("prioritydefine_id") != 0L) {
                idList.add(entry.getLong("prioritydefine_id"));
            }
            modelDataList.add(PriorityCalculationHelper.genPriorityModelData(entry));
        }
        Collections.sort(modelDataList, (x, y) -> x.getSeq() - y.getSeq());
        Map defineMap = BusinessDataServiceHelper.loadFromCache((Object[])idList.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"msplan_priority_define"));
        HashMap<String, Map<Long, Integer>> filedToData = new HashMap<String, Map<Long, Integer>>(16);
        HashMap<String, String> newDataFiled = new HashMap<String, String>(16);
        String orderBy = PriorityCalculationHelper.getSortFiledSeq(modelDataList, defineMap, filedToData, newDataFiled);
        DataSet dataSet_new = PriorityCalculationHelper.joinNewData(newDataFiled, filedToData, dataSet);
        DataSet dataSet_finsh = dataSet_new.orderBy(orderBy.split(","));
        return dataSet_finsh;
    }

    private static DataSet joinNewData(Map<String, String> newDataFiled, Map<String, Map<Long, Integer>> filedToData, DataSet dataSet) {
        String[] field = new String[2];
        DataType[] dataType = new DataType[]{new LongType(), new IntegerType()};
        Algo algo = Algo.create((String)"scm");
        DataSet finish = dataSet;
        for (Map.Entry<String, String> mapEntry : newDataFiled.entrySet()) {
            String newFiled;
            String filed = mapEntry.getKey();
            String filedSeq = mapEntry.getValue();
            field[0] = newFiled = filed + 1;
            field[1] = filedSeq;
            List<String> filedList = Arrays.asList(finish.getRowMeta().getFieldNames());
            Map<Long, Integer> idToSeq = filedToData.get(filed);
            ArrayList<Object[]> valueList = new ArrayList<Object[]>(16);
            if (filedList.contains(filed)) {
                for (Map.Entry<Long, Integer> mapEntry_seq : idToSeq.entrySet()) {
                    Object[] objects = new Object[]{mapEntry_seq.getKey(), mapEntry_seq.getValue()};
                    valueList.add(objects);
                }
            }
            RowMeta rowMeta = new RowMeta(field, dataType);
            DataSet dataSet_new = algo.createDataSet(valueList, rowMeta);
            finish = finish.leftJoin(dataSet_new).on(filed, filed + 1).select(finish.getRowMeta().getFieldNames(), dataSet_new.getRowMeta().getFieldNames()).finish();
        }
        return finish;
    }

    private static String getSortFiledSeq(List<PriorityModelData> modelDataList, Map<Object, DynamicObject> defineMap, Map<String, Map<Long, Integer>> filedToData, Map<String, String> newDataFiled) {
        StringBuilder sb = new StringBuilder();
        for (PriorityModelData priorityModelData : modelDataList) {
            String elementtype = priorityModelData.getElementtype();
            String fieldFlag = priorityModelData.getFieldflag();
            String sort = priorityModelData.getSort();
            if ("0".equals(elementtype) || "1".equals(elementtype)) {
                sb.append(fieldFlag).append(" ");
                if ("0".equals(sort)) {
                    sb.append("asc");
                } else {
                    sb.append("desc");
                }
            } else if ("2".equals(elementtype)) {
                long priorityDefineId = priorityModelData.getPrioritydefine();
                DynamicObject priorityDefine = defineMap.get(priorityDefineId);
                DynamicObjectCollection priorityDefineColl = priorityDefine.getDynamicObjectCollection("entryentity");
                HashMap<Long, Integer> idMaps = new HashMap<Long, Integer>(priorityDefineColl.size());
                for (DynamicObject priorityObj : priorityDefineColl) {
                    int priorityLevel = priorityObj.getInt("prioritylevel");
                    if (priorityObj.get("dataid_id") == null) continue;
                    long priorityDefineEntryId = priorityObj.getLong("dataid_id");
                    idMaps.put(priorityDefineEntryId, priorityLevel);
                }
                filedToData.put(fieldFlag, idMaps);
                String sortFiled = fieldFlag + "seq";
                newDataFiled.put(fieldFlag, sortFiled);
                sb.append(sortFiled).append(" ").append("desc");
            }
            sb.append(",");
        }
        if (sb.length() > 1) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public static List<Integer> calPlanPriorityWeight(Long prioritymodelId, List<Map<String, Object>> parameterList) {
        ArrayList<Integer> priorityLevels = new ArrayList<Integer>(parameterList.size());
        DynamicObject priorityModel = BusinessDataServiceHelper.loadSingleFromCache((Object)prioritymodelId, (String)"msplan_priority_model");
        DynamicObjectCollection entrys = priorityModel.getDynamicObjectCollection("entryentity");
        ArrayList<Long> idList = new ArrayList<Long>(entrys.size());
        ArrayList<PriorityModelData> modelDataList = new ArrayList<PriorityModelData>(entrys.size());
        for (DynamicObject entry : entrys) {
            if (entry.get("prioritydefine_id") != null && entry.getLong("prioritydefine_id") != 0L) {
                idList.add(entry.getLong("prioritydefine_id"));
            }
            modelDataList.add(PriorityCalculationHelper.genPriorityModelData(entry));
        }
        Map defineMap = BusinessDataServiceHelper.loadFromCache((Object[])idList.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"msplan_priority_define"));
        for (Map<String, Object> rowData : parameterList) {
            int weight = 0;
            for (PriorityModelData priorityModelData : modelDataList) {
                String elementtype = priorityModelData.getElementtype();
                String fieldFlag = priorityModelData.getFieldflag();
                String sort = priorityModelData.getSort();
                if (!"2".equals(elementtype)) continue;
                long priorityDefineId = priorityModelData.getPrioritydefine();
                DynamicObject priorityDefine = (DynamicObject)defineMap.get(priorityDefineId);
                Long dataId = (Long)DataType.convertValue((DataType)DataType.LongType, (Object)rowData.get(fieldFlag));
                if (priorityDefine == null || dataId == null) continue;
                DynamicObjectCollection priorityDefineColl = priorityDefine.getDynamicObjectCollection("entryentity");
                HashMap<Long, Integer> idMaps = new HashMap<Long, Integer>(priorityDefineColl.size());
                for (DynamicObject priorityObj : priorityDefineColl) {
                    int priorityLevel = priorityObj.getInt("prioritylevel");
                    if (priorityObj.get("dataid_id") == null) continue;
                    long priorityDefineEntryId = priorityObj.getLong("dataid_id");
                    idMaps.put(priorityDefineEntryId, priorityLevel);
                }
                weight += idMaps.getOrDefault(dataId, 0).intValue();
            }
            priorityLevels.add(weight);
        }
        return priorityLevels;
    }

    private static void sort(int level, List<Integer> sortResult, List<Integer> rowList, List<PriorityModelData> modelDataList, List<Map<String, Object>> parameterList, Map<Object, DynamicObject> defineMap) {
        int currentLevel = level;
        while (rowList.size() > 1 && currentLevel < modelDataList.size()) {
            ++currentLevel;
            for (int index = level; index < modelDataList.size() && rowList.size() > 1; ++index) {
                long priorityDefineId;
                DynamicObject priorityDefine;
                List rowLists;
                Map<String, Object> rowData;
                PriorityModelData priorityModelData = modelDataList.get(index);
                String elementtype = priorityModelData.getElementtype();
                String fieldFlag = priorityModelData.getFieldflag();
                String sort = priorityModelData.getSort();
                if ("0".equals(elementtype)) {
                    TreeMap<BigDecimal, List> treeMap = new TreeMap<BigDecimal, List>((x, y) -> {
                        if ("0".equals(sort)) {
                            return x.compareTo((BigDecimal)y);
                        }
                        return y.compareTo((BigDecimal)x);
                    });
                    for (int row = 0; row < rowList.size(); ++row) {
                        rowData = parameterList.get(rowList.get(row));
                        BigDecimal requireQty = BigDecimal.valueOf(0L);
                        try {
                            Object data = rowData.get(fieldFlag);
                            requireQty = data == null ? BigDecimal.ZERO : new BigDecimal(data.toString());
                        }
                        catch (Exception e) {
                            requireQty = BigDecimal.valueOf(0L);
                        }
                        List rowLists2 = treeMap.getOrDefault(requireQty, new ArrayList(16));
                        rowLists2.add(rowList.get(row));
                        treeMap.put(requireQty, rowLists2);
                    }
                    for (Map.Entry qtyEntry : treeMap.entrySet()) {
                        rowLists = (List)qtyEntry.getValue();
                        if (rowLists.size() == 1) {
                            sortResult.add((Integer)rowLists.get(0));
                            rowList.removeAll(rowLists);
                            continue;
                        }
                        if (rowLists.size() > 1 && index < modelDataList.size() - 1) {
                            int nextLevel = level + 1;
                            ArrayList copyLists = new ArrayList(rowLists);
                            PriorityCalculationHelper.sort(nextLevel, sortResult, rowLists, modelDataList, parameterList, defineMap);
                            rowList.removeAll(copyLists);
                            continue;
                        }
                        if (rowLists.size() <= 1) continue;
                        sortResult.addAll(rowLists);
                        rowList.removeAll(rowLists);
                    }
                    continue;
                }
                if ("1".equals(elementtype)) {
                    TreeMap<Date, List> treeMap = new TreeMap<Date, List>((x, y) -> {
                        if ("0".equals(sort)) {
                            return x.compareTo((Date)y);
                        }
                        return y.compareTo((Date)x);
                    });
                    for (int row = 0; row < rowList.size(); ++row) {
                        rowData = parameterList.get(rowList.get(row));
                        Date requireDate = null;
                        if (rowData.get(fieldFlag) != null) {
                            if (rowData.get(fieldFlag) instanceof Long) {
                                Long time = (Long)rowData.get(fieldFlag);
                                requireDate = new Date(time);
                            } else if (rowData.get(fieldFlag) instanceof Date) {
                                requireDate = (Date)rowData.get(fieldFlag);
                            } else if (rowData.get(fieldFlag) instanceof String) {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                try {
                                    requireDate = sdf.parse((String)rowData.get(fieldFlag));
                                }
                                catch (ParseException e) {
                                    logger.error((Throwable)e);
                                }
                            }
                        }
                        if (requireDate == null) continue;
                        List rowLists3 = treeMap.getOrDefault(requireDate, new ArrayList(16));
                        rowLists3.add(rowList.get(row));
                        treeMap.put(requireDate, rowLists3);
                    }
                    for (Map.Entry dateEntry : treeMap.entrySet()) {
                        rowLists = (List)dateEntry.getValue();
                        if (rowLists.size() == 1) {
                            sortResult.add((Integer)rowLists.get(0));
                            rowList.removeAll(rowLists);
                            continue;
                        }
                        if (rowLists.size() > 1 && index < modelDataList.size() - 1) {
                            int nextLevel = level + 1;
                            ArrayList copyLists = new ArrayList(rowLists);
                            PriorityCalculationHelper.sort(nextLevel, sortResult, rowLists, modelDataList, parameterList, defineMap);
                            rowList.removeAll(copyLists);
                            continue;
                        }
                        if (rowLists.size() <= 1) continue;
                        sortResult.addAll(rowLists);
                        rowList.removeAll(rowLists);
                    }
                    continue;
                }
                if (!"2".equals(elementtype) || (priorityDefine = defineMap.get(priorityDefineId = priorityModelData.getPrioritydefine().longValue())) == null) continue;
                DynamicObjectCollection priorityDefineColl = priorityDefine.getDynamicObjectCollection("entryentity");
                TreeMap<Integer, Set> priorityMap = new TreeMap<Integer, Set>((x, y) -> y - x);
                int priorityDefineCollSize = priorityDefineColl.size();
                for (Object priorityObj : priorityDefineColl) {
                    int priorityLevel = priorityObj.getInt("prioritylevel");
                    Set idSet = priorityMap.getOrDefault(priorityLevel, new HashSet(16));
                    long priorityDefineEntryId = 0L;
                    if (priorityObj.get("dataid_id") != null) {
                        priorityDefineEntryId = priorityObj.getLong("dataid_id");
                    }
                    idSet.add(priorityDefineEntryId);
                    priorityMap.put(priorityLevel, idSet);
                }
                LinkedMap priorityDefineToListMap = new LinkedMap(priorityDefineColl.size());
                if (priorityMap != null && priorityMap.size() > 0) {
                    Object priorityObj;
                    priorityObj = priorityMap.entrySet().iterator();
                    while (priorityObj.hasNext()) {
                        Map.Entry entry = (Map.Entry)priorityObj.next();
                        int indexpm = (Integer)entry.getKey();
                        Set idSet = (Set)entry.getValue();
                        Iterator<Integer> rowListIterator = rowList.iterator();
                        while (rowListIterator.hasNext()) {
                            int row = rowListIterator.next();
                            Map<String, Object> rowData2 = parameterList.get(row);
                            long dataId = rowData2.get(fieldFlag) == null ? 0L : (rowData2.get(fieldFlag) instanceof Long ? (Long)rowData2.get(fieldFlag) : 0L);
                            List seqList = (List)priorityDefineToListMap.getOrDefault((Object)indexpm, new ArrayList(16));
                            if (idSet.contains(dataId)) {
                                seqList.add(row);
                                rowListIterator.remove();
                            }
                            priorityDefineToListMap.put((Object)indexpm, (Object)seqList);
                        }
                        if (!rowList.isEmpty()) continue;
                        break;
                    }
                }
                for (Map.Entry priorityDefineToListEntry : priorityDefineToListMap.entrySet()) {
                    List rowLists4 = (List)priorityDefineToListEntry.getValue();
                    if (rowLists4.size() == 1) {
                        sortResult.add((Integer)rowLists4.get(0));
                        rowList.removeAll(rowLists4);
                        continue;
                    }
                    if (rowLists4.size() > 1 && index < modelDataList.size() - 1) {
                        int nextLevel = level + 1;
                        ArrayList copyLists = new ArrayList(rowLists4);
                        PriorityCalculationHelper.sort(nextLevel, sortResult, rowLists4, modelDataList, parameterList, defineMap);
                        rowLists4.removeAll(copyLists);
                        continue;
                    }
                    if (rowLists4.size() <= 1) continue;
                    sortResult.addAll(rowLists4);
                    rowList.removeAll(rowLists4);
                }
            }
        }
        if (!rowList.isEmpty()) {
            sortResult.addAll(rowList);
            rowList.clear();
        }
    }

    private static PriorityModelData genPriorityModelData(DynamicObject entry) {
        PriorityModelData priorityModelData = new PriorityModelData();
        priorityModelData.setSeq(entry.getInt("seq"));
        priorityModelData.setElementName(entry.getString("elementname"));
        priorityModelData.setElementtype(entry.getString("elementtype"));
        if (entry.get("elementobject_id") != null) {
            priorityModelData.setElementobject(entry.getString("elementobject_id"));
        }
        priorityModelData.setSort(entry.getString("sort"));
        if (entry.get("prioritydefine_id") != null) {
            priorityModelData.setPrioritydefine(entry.getLong("prioritydefine_id"));
        }
        priorityModelData.setFieldflag(entry.getString("fieldflag"));
        priorityModelData.setFruncondition(entry.getString("pentryfruncondition_tag"));
        return priorityModelData;
    }
}

