/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.business.inventory;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msplan.business.inventory.InvLevelEntry;
import kd.mpscmm.msplan.business.inventory.InventoryDimension;
import kd.mpscmm.msplan.business.inventory.InventoryUtil;
import kd.mpscmm.msplan.business.inventory.MtGrpStd;

public class InvLevel {
    private Object id;
    private Date planDate;
    private InventoryDimension invDim;
    private Map<List<Object>, DynamicObject> map;
    private MtGrpStd mtGrpStd;
    private String planType;

    public InvLevel(Object id, Date planDate) {
        this(id, planDate, "A/B");
    }

    public InvLevel(Object id, Date planDate, String planType) {
        this.planType = planType;
        this.id = id;
        Calendar instance = Calendar.getInstance();
        instance.setTime(planDate);
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        instance.set(14, 0);
        this.planDate = instance.getTime();
        this.map = new HashMap<List<Object>, DynamicObject>(16);
        this.init();
    }

    private void init() {
        DynamicObject level = BusinessDataServiceHelper.loadSingle((Object)this.id, (String)"msplan_invlevel");
        Object dimId = level.getDynamicObject("dimension").getPkValue();
        this.invDim = InventoryUtil.getDimension(dimId);
        boolean hasMtStd = this.invDim.hasGrp();
        MtGrpStd.Build build = null;
        int orgIdx = -1;
        int stdIdx = -1;
        int grpIdx = -1;
        List<String> entityNames = this.invDim.getEntityNames();
        if (hasMtStd) {
            build = MtGrpStd.getBuild();
            orgIdx = entityNames.indexOf("bos_org");
            stdIdx = entityNames.indexOf("bd_materialgroupstandard");
            grpIdx = entityNames.indexOf("bd_materialgroup");
        }
        int size = entityNames.size();
        DynamicObjectCollection entrys = level.getDynamicObjectCollection("entryentity");
        for (DynamicObject dyn : entrys) {
            Date dateStart = dyn.getDate("datestart");
            Date dateEnd = dyn.getDate("dateend");
            String pt = dyn.getString("plantype");
            if (this.planDate.compareTo(dateStart) < 0 || this.planDate.compareTo(dateEnd) > 0 || !this.planType.contains(pt)) continue;
            ArrayList<Object> key = new ArrayList<Object>(size);
            for (String dim : entityNames) {
                if (dyn.get(dim) == null) continue;
                DynamicObject dynamicObject = dyn.getDynamicObject(dim);
                Object pk = dynamicObject.getPkValue();
                if (pk instanceof Number) {
                    pk = ((Number)pk).longValue();
                }
                key.add(pk);
            }
            if (build != null) {
                build.add(key.get(orgIdx), key.get(stdIdx), key.get(grpIdx));
            }
            this.map.put(key, dyn);
        }
        if (build != null) {
            this.mtGrpStd = build.finish();
        }
    }

    public InvLevelEntry getEntry(Object orgId, Object materialId) {
        return this.getEntry(this.getEntityVals(orgId, materialId));
    }

    public InvLevelEntry getEntry(Object orgId, Object materialId, Map<String, Object> entityValMap) {
        entityValMap.putAll(this.getEntityVals(orgId, materialId));
        return this.getEntry(entityValMap);
    }

    private Map<String, Object> getEntityVals(Object orgId, Object materialId) {
        orgId = DataType.convertValue((DataType)DataType.LongType, (Object)orgId);
        materialId = DataType.convertValue((DataType)DataType.LongType, (Object)materialId);
        if (this.invDim.hasMtAndGrp()) {
            return this.getOriEntityVals(orgId, materialId);
        }
        HashMap<String, Object> entityValMap = new HashMap<String, Object>(8);
        entityValMap.put("bos_org", orgId);
        if (this.mtGrpStd != null) {
            Map<String, Object> orgGrpStd = this.mtGrpStd.getOrgStdGrpInfo(orgId, materialId);
            entityValMap.putAll(orgGrpStd);
        } else {
            entityValMap.put("bd_material", materialId);
        }
        return entityValMap;
    }

    private Map<String, Object> getOriEntityVals(Object orgId, Object materialId) {
        HashMap<String, Object> entityValMap = new HashMap<String, Object>(8);
        entityValMap.put("bos_org", orgId);
        Map<String, Object> orgGrpStd = this.mtGrpStd.getOrgStdOriGrpInfo(orgId, materialId);
        entityValMap.putAll(orgGrpStd);
        entityValMap.put("bd_material", materialId);
        return entityValMap;
    }

    private InvLevelEntry getEntry(Map<String, Object> entityValMap) {
        List<String> entityNames = this.invDim.getEntityNames();
        ArrayList<Object> key = new ArrayList<Object>(entityNames.size());
        for (String entityName : entityNames) {
            Object o = entityValMap.get(entityName);
            Long longVal = o == null ? null : (Long)DataType.convertValue((DataType)DataType.LongType, (Object)o);
            key.add(longVal);
        }
        DynamicObject entry = this.map.get(key);
        return entry == null ? null : new InvLevelEntry(this.id, this.invDim.getIndex(), key, entry);
    }

    public List<InvLevelEntry> getAllBaseEntry() {
        ArrayList<InvLevelEntry> list = new ArrayList<InvLevelEntry>(this.map.size());
        for (Map.Entry<List<Object>, DynamicObject> entry : this.map.entrySet()) {
            list.add(new InvLevelEntry(this.id, this.invDim.getIndex(), entry.getKey(), entry.getValue()));
        }
        return list;
    }

    public InventoryDimension getInvDim() {
        return this.invDim;
    }

    public Set<Object> getAllMaterials() {
        HashSet<Object> result = new HashSet<Object>(16);
        if (this.mtGrpStd != null && !this.invDim.hasMt()) {
            result.addAll(this.mtGrpStd.getAllMaterials());
        } else {
            int idx = this.invDim.getIndex("bd_material");
            for (List<Object> keys : this.map.keySet()) {
                result.add(keys.get(idx));
            }
        }
        return result;
    }

    public Set<Object> getEntryMaterials(InvLevelEntry entry) {
        HashSet<Object> result = new HashSet<Object>(16);
        if (!entry.isExistDimension("bos_org")) {
            return result;
        }
        if (this.mtGrpStd != null && !this.invDim.hasMt()) {
            result.addAll(this.mtGrpStd.getMaterialsByEntry(entry));
        } else if (entry.isExistDimension("bd_material")) {
            result.add(entry.getDimensionValue("bd_material"));
        }
        return result;
    }
}

