/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.business.inventory;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mpscmm.msplan.business.inventory.InvLevelConst;

public class InvLevelEntry {
    private Object id;
    private DynamicObject entry;
    private List<Object> key;
    private Map<String, Integer> index;

    public InvLevelEntry(Object id, Map<String, Integer> index, List<Object> key, DynamicObject entry) {
        this.id = id;
        this.entry = entry;
        this.key = key;
        this.index = index;
    }

    public Object getDimensionValue(String type) {
        Integer integer = this.index.get(type);
        return this.key.get(integer);
    }

    public boolean isExistDimension(String type) {
        Integer integer = this.index.get(type);
        return integer != null;
    }

    public DynamicObject getEntry() {
        return this.entry;
    }

    public BigDecimal getReorder() {
        return this.entry.getBigDecimal("reorder");
    }

    public BigDecimal getEcoBatch() {
        return this.entry.getBigDecimal("ecobatch");
    }

    public BigDecimal getMin() {
        return this.entry.getBigDecimal("min");
    }

    public BigDecimal getMax() {
        return this.entry.getBigDecimal("max");
    }

    public InvLevelConst.PlanType getPlanType() {
        String pt = this.entry.getString("plantype");
        return InvLevelConst.PlanType.get(pt);
    }

    public Object getId() {
        return this.id;
    }

    public Long getEntryId() {
        return this.entry.getLong("id");
    }

    public int getSeq() {
        return this.entry.getInt("seq");
    }
}

