/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.business.inventory;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msplan.business.inventory.InvLevel;
import kd.mpscmm.msplan.business.inventory.InventoryDimension;
import kd.mpscmm.msplan.business.inventory.InventoryDimensionEntry;

public final class InventoryUtil {
    public static List<InventoryDimensionEntry> getInventoryDimension(DynamicObject value) {
        ArrayList<InventoryDimensionEntry> inventoryDimensionList = new ArrayList<InventoryDimensionEntry>(16);
        if (value == null) {
            return inventoryDimensionList;
        }
        Long dimensionId = value.getLong("id");
        QFilter dimensionFilter = new QFilter("id", "=", (Object)dimensionId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"InventoryUtil", (String)"msplan_plan_dimension", (String)"entryentity.dimensionname dimensionname,entryentity.associationobject associationobject", (QFilter[])new QFilter[]{dimensionFilter}, null);){
            for (Row row : dataSet) {
                inventoryDimensionList.add(new InventoryDimensionEntry(row.getString("dimensionname"), row.getString("associationobject")));
            }
        }
        return inventoryDimensionList;
    }

    public static InventoryDimension getDimension(Object dimensionId) {
        return new InventoryDimension(dimensionId);
    }

    public static InventoryDimension getDimension(String orgNum, String number) {
        return new InventoryDimension(orgNum, number);
    }

    public static InventoryDimension getDimension() {
        return new InventoryDimension();
    }

    public static InvLevel getInvLevel(Object invLevelId, Date planDate) {
        return new InvLevel(invLevelId, planDate);
    }

    public static InvLevel getInvLevel(Object invLevelId, Date planDate, String planType) {
        return new InvLevel(invLevelId, planDate, planType);
    }
}

