/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.business.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msplan.business.inventory.InvLevelEntry;

public class MtGrpStd {
    private Map<Object, Map<Object, Grp>> stdMtGrp;
    private Map<Object, Object> orgStdPreData;
    private Map<Object, Set<Object>> orgGrpPredata;

    private MtGrpStd(Map<Object, Map<Object, Grp>> stdMtGrp, Map<Object, Object> orgStdPreData, Map<Object, Set<Object>> orgGrpPredata) {
        this.stdMtGrp = stdMtGrp;
        this.orgStdPreData = orgStdPreData;
        this.orgGrpPredata = orgGrpPredata;
    }

    public static Build getBuild() {
        return new Build();
    }

    public Map<String, Object> getOrgStdGrpInfo(Object org, Object material) {
        return this.getOrgStdGrpInfo(org, material, false);
    }

    public Map<String, Object> getOrgStdOriGrpInfo(Object org, Object material) {
        return this.getOrgStdGrpInfo(org, material, true);
    }

    private Map<String, Object> getOrgStdGrpInfo(Object org, Object material, boolean origin) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        Object grpStd = this.orgStdPreData.get(org);
        Map<Object, Grp> mtGrp = this.stdMtGrp.get(grpStd);
        if (mtGrp == null) {
            return result;
        }
        Grp grp = mtGrp.get(material);
        if (grp == null) {
            return result;
        }
        result.put("bos_org", org);
        result.put("bd_materialgroupstandard", grpStd);
        result.put("bd_materialgroup", origin ? grp.id : grp.orgGrpRef.get(org));
        return result;
    }

    public Set<Object> getAllMaterials() {
        HashSet<Object> result = new HashSet<Object>(100);
        for (Map.Entry<Object, Object> orgStdEntry : this.orgStdPreData.entrySet()) {
            Map<Object, Grp> value;
            Object org = orgStdEntry.getKey();
            Object std = orgStdEntry.getValue();
            Set<Object> group = this.orgGrpPredata.get(org);
            if (group == null || (value = this.stdMtGrp.get(std)) == null) continue;
            for (Map.Entry<Object, Grp> grpEntry : value.entrySet()) {
                Object mid = grpEntry.getKey();
                Grp grp = grpEntry.getValue();
                if (!group.contains(grp.id) && !group.contains(grp.orgGrpRef.get(org))) continue;
                result.add(mid);
            }
        }
        return result;
    }

    public Set<Object> getMaterialsByEntry(InvLevelEntry entry) {
        Object org = entry.getDimensionValue("bos_org");
        Object grpStd = this.orgStdPreData.get(org);
        Object g = entry.isExistDimension("bd_materialgroup") ? entry.getDimensionValue("bd_materialgroup") : null;
        Map<Object, Grp> mtGrp = this.stdMtGrp.get(grpStd);
        if (mtGrp == null) {
            return new HashSet<Object>(0);
        }
        if (g == null) {
            return mtGrp.keySet();
        }
        HashSet<Object> result = new HashSet<Object>(1);
        for (Map.Entry<Object, Grp> grpEntry : mtGrp.entrySet()) {
            Object mid = grpEntry.getKey();
            Grp grp = grpEntry.getValue();
            if (!g.equals(grp.id) && !g.equals(grp.orgGrpRef.get(org))) continue;
            result.add(mid);
        }
        return result;
    }

    public static class Build {
        private Map<Object, Map<Object, Grp>> stdMtGrp = new HashMap<Object, Map<Object, Grp>>(4);
        private Map<Object, Object> orgStdPreData = new HashMap<Object, Object>(4);
        private Map<Object, Set<Object>> orgGrpPredata = new HashMap<Object, Set<Object>>(4);

        private Build() {
        }

        public void add(Object org, Object grpStd, Object grp) {
            this.orgStdPreData.putIfAbsent(org, grpStd);
            this.orgGrpPredata.computeIfAbsent(org, k -> new HashSet()).add(grp);
        }

        public MtGrpStd finish() {
            QFilter[] stdFilter = new QFilter[]{new QFilter("standard", "in", this.orgStdPreData.values())};
            HashMap<Object, Map> stdIdGrp = new HashMap<Object, Map>(4);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"finish", (String)"bd_materialgroup", (String)"id,parent,standard", (QFilter[])stdFilter, null);
            Iterator<Map.Entry<Object, Object>> iterator = null;
            try {
                for (Row d : ds) {
                    Object standard = d.get("standard");
                    Object id = d.get("id");
                    Iterator parent = d.get("parent");
                    stdIdGrp.computeIfAbsent(standard, k -> new HashMap(8)).put(id, new Grp(id, parent));
                }
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (iterator != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            HashMap stdGrp = new HashMap(8);
            for (Map.Entry entry : stdIdGrp.entrySet()) {
                Object std = entry.getKey();
                Map map = (Map)entry.getValue();
                Grp root = new Grp(0, -1);
                map.put(0L, root);
                for (Grp grp : map.values()) {
                    Grp parent = (Grp)map.get(grp.parent);
                    if (parent == null) continue;
                    parent.addChild(grp);
                }
                stdGrp.put(std, root);
            }
            for (Map.Entry<Object, Object> entry : this.orgStdPreData.entrySet()) {
                Object org = entry.getKey();
                Object std = entry.getValue();
                Set<Object> grpPreData = this.orgGrpPredata.get(org);
                Grp root = (Grp)stdGrp.get(std);
                if (grpPreData == null || root == null) continue;
                this.setRef(root, grpPreData, org);
            }
            Throwable throwable = null;
            try (DataSet ds2 = QueryServiceHelper.queryDataSet((String)"finish", (String)"bd_materialgroupdetail", (String)"material,group,standard", (QFilter[])stdFilter, null);){
                for (Row d : ds2) {
                    Object standard = d.get("standard");
                    Object group = d.get("group");
                    Object mt = d.get("material");
                    Map idGrp = (Map)stdIdGrp.get(standard);
                    Grp grp = (Grp)idGrp.get(group);
                    if (grp == null) continue;
                    this.stdMtGrp.computeIfAbsent(standard, k -> new HashMap(2000)).put(mt, grp);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            return new MtGrpStd(this.stdMtGrp, this.orgStdPreData, this.orgGrpPredata);
        }

        private void setRef(Grp root, Set<Object> grpPreData, Object org) {
            Stack<Object> stack = new Stack<Object>();
            this.setRefRec(root, grpPreData, stack, org);
        }

        private void setRefRec(Grp grp, Set<Object> grpPreData, Stack<Object> stack, Object org) {
            boolean contains = grpPreData.contains(grp.id);
            if (contains) {
                stack.push(grp.id);
            }
            for (Grp child : grp.children) {
                this.setRefRec(child, grpPreData, stack, org);
            }
            if (!stack.isEmpty()) {
                grp.orgGrpRef.put(org, stack.peek());
            }
            if (contains) {
                stack.pop();
            }
        }
    }

    private static class Grp {
        private final Object id;
        private Object parent;
        private List<Grp> children;
        private Map<Object, Object> orgGrpRef;

        Grp(Object id, Object parent) {
            this.id = id;
            this.parent = parent;
            this.children = new ArrayList<Grp>(2);
            this.orgGrpRef = new HashMap<Object, Object>(2);
        }

        public void addChild(Grp child) {
            this.children.add(child);
        }
    }
}

