/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class BOTPHelper {
    private BOTPHelper() {
    }

    public static boolean isPush(String entityNumber, Long billId) {
        return BFTrackerServiceHelper.isPush((String)entityNumber, (Long)billId);
    }

    public static boolean isPush(String entityNumber, String entryKey, Long entryId) {
        return BFTrackerServiceHelper.isPush((String)entityNumber, (String)entryKey, (Long)entryId);
    }

    public static List<ConvertRuleElement> excludeConvertRuleByOrdertype(List<ConvertRuleElement> loadRules, String ordertype) {
        if (loadRules == null) {
            return loadRules;
        }
        Iterator<ConvertRuleElement> iterator = loadRules.iterator();
        while (iterator.hasNext()) {
            List filterRows;
            FilterCondition filterCondition;
            ConvertRuleElement convertRuleElement = iterator.next();
            CRCondition runCondition = convertRuleElement.getRunCondition();
            if (runCondition == null || (filterCondition = runCondition.getFilterCondition()) == null || (filterRows = filterCondition.getFilterRow()) == null || filterRows.isEmpty()) continue;
            block1: for (SimpleFilterRow filterRow : filterRows) {
                String fieldName = filterRow.getFieldName();
                if (!"ordertype".equals(fieldName)) continue;
                List values = filterRow.getValue();
                for (FilterValue value : values) {
                    if (value.getValue().equals(ordertype)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
        }
        return loadRules;
    }

    public static List<ConvertRuleElement> getRules(String sourceEntityNumber, String targetEntityNumber) {
        List loadConvertBills = ConvertMetaServiceHelper.loadConvertBills((String)sourceEntityNumber, (ConvertOpType)ConvertOpType.Push);
        for (ConvertBill loadConvertBill : loadConvertBills) {
            if (!loadConvertBill.getEntityNumber().equals(targetEntityNumber)) continue;
            List<ConvertRuleElement> rules = BOTPHelper.loadRules(sourceEntityNumber, targetEntityNumber);
            return rules;
        }
        return null;
    }

    public static Map<ConvertRuleElement, Set<Long>> excludeConvertRule(List<ConvertRuleElement> loadRules, List<Long> ids, String sourceEntityNumber) {
        HashMap<ConvertRuleElement, Set<Long>> loadRuleMap = new HashMap<ConvertRuleElement, Set<Long>>();
        if (loadRules == null) {
            return loadRuleMap;
        }
        StringBuilder selectf = new StringBuilder();
        ArrayList<String> selects = new ArrayList<String>(16);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)sourceEntityNumber);
        for (ConvertRuleElement convertRuleElement : loadRules) {
            List filterRows;
            FilterCondition filterCondition;
            CRCondition runCondition = convertRuleElement.getRunCondition();
            if (runCondition == null || (filterCondition = runCondition.getFilterCondition()) == null || (filterRows = filterCondition.getFilterRow()) == null || filterRows.isEmpty()) continue;
            for (SimpleFilterRow filterRow : filterRows) {
                String fieldName = filterRow.getFieldName();
                String[] fieldNames = fieldName.split("\\.");
                IDataEntityProperty property = null;
                if (fieldNames.length == 1) {
                    property = dataEntityType.findProperty(fieldNames[0]);
                } else if (fieldNames.length >= 2) {
                    property = dataEntityType.findProperty(fieldNames[0]);
                }
                if (property == null || selects.contains(fieldName)) continue;
                selectf.append(fieldName).append(',');
                selects.add(fieldName);
            }
        }
        selectf.append("id");
        DynamicObjectCollection datas = QueryServiceHelper.query((String)sourceEntityNumber, (String)selectf.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        Iterator it = datas.iterator();
        block2: while (it.hasNext()) {
            DynamicObject data = (DynamicObject)it.next();
            for (ConvertRuleElement loadRule : loadRules) {
                boolean isMatch;
                List filterRows;
                CRCondition runCondition = loadRule.getRunCondition();
                if (runCondition == null) {
                    Set idsSet = loadRuleMap.computeIfAbsent(loadRule, k -> new HashSet());
                    idsSet.add(data.getLong("id"));
                    it.remove();
                    ids.remove(data.getLong("id"));
                    continue;
                }
                FilterCondition filterCondition = runCondition.getFilterCondition();
                if (filterCondition == null || (filterRows = filterCondition.getFilterRow()) == null || filterRows.isEmpty() || !(isMatch = BOTPHelper.compareFilterRows(filterRows, data, dataEntityType))) continue;
                Set idsSet = loadRuleMap.computeIfAbsent(loadRule, k -> new HashSet());
                idsSet.add(data.getLong("id"));
                it.remove();
                ids.remove(data.getLong("id"));
                continue block2;
            }
        }
        return loadRuleMap;
    }

    private static boolean compareFilterRows(List<SimpleFilterRow> simpleRows, DynamicObject data, MainEntityType dataEntityType) {
        boolean andLog = true;
        String logicType = "0";
        for (SimpleFilterRow row : simpleRows) {
            StringBuilder field = new StringBuilder();
            field.append(row.getFieldName().toUpperCase());
            String compareType = row.getCompareType();
            String fieldName = field.toString();
            String[] split = fieldName.split("\\.");
            String value = "";
            List filterValues = row.getValue();
            String realValue = "";
            int i = 0;
            DynamicProperty property = BOTPHelper.getFieldProperty(dataEntityType, split, i);
            if (property instanceof BooleanProp) {
                boolean val = data.getBoolean(fieldName);
                realValue = val ? "1" : "0";
            } else if (data.get(fieldName) != null) {
                realValue = data.get(fieldName).toString();
            }
            boolean isInValue = false;
            for (FilterValue filterValue : filterValues) {
                value = filterValue.getValue().toString();
                if (("105".equals(compareType) || "17".equals(compareType) || "67".equals(compareType) || "110".equals(compareType) || "111".equals(compareType)) && value.equals(realValue)) {
                    isInValue = true;
                    break;
                }
                if (("106".equals(compareType) || "34".equals(compareType) || "83".equals(compareType) || "114".equals(compareType) || "115".equals(compareType)) && value.equals(realValue)) {
                    isInValue = false;
                    break;
                }
                if (("106".equals(compareType) || "34".equals(compareType) || "83".equals(compareType) || "114".equals(compareType) || "115".equals(compareType)) && !value.equals(realValue)) {
                    isInValue = true;
                    continue;
                }
                if (("1104".equals(compareType) || "9".equals(compareType)) && !StringUtils.isEmpty((CharSequence)realValue)) {
                    isInValue = true;
                    break;
                }
                if (("1103".equals(compareType) || "37".equals(compareType)) && StringUtils.isEmpty((CharSequence)realValue)) {
                    isInValue = true;
                    break;
                }
                if ("60".equals(compareType) && StringUtils.isNotEmpty((CharSequence)realValue) && realValue.startsWith(value)) {
                    isInValue = true;
                    break;
                }
                if (!"211".equals(compareType) || !StringUtils.isNotEmpty((CharSequence)realValue) || !realValue.endsWith(value)) continue;
                isInValue = true;
                break;
            }
            if (!isInValue && "0".equals(logicType)) {
                andLog = false;
            } else if (isInValue && "1".equals(logicType)) {
                andLog = true;
            }
            logicType = row.getLogic();
        }
        return andLog;
    }

    private static DynamicProperty getFieldProperty(MainEntityType dataEntityType, String[] split, int i) {
        if (i == split.length - 1) {
            return dataEntityType.getProperty(split[i]);
        }
        DynamicProperty property = dataEntityType.getProperty(split[i]);
        MainEntityType baseDataType = null;
        if (!(property instanceof BasedataProp)) {
            return dataEntityType.getProperty(split[i]);
        }
        BasedataProp baseData = (BasedataProp)property;
        baseDataType = EntityMetadataCache.getDataEntityType((String)baseData.getBaseEntityId());
        return BOTPHelper.getFieldProperty(baseDataType, split, ++i);
    }

    public static List<ConvertRuleElement> loadRules(String sourceEntityNumber, String targetEntityNumber) {
        List rules = ConvertRuleCache.loadRules((String)sourceEntityNumber, (String)targetEntityNumber);
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            enableRules.add(rule);
        }
        return enableRules;
    }
}

