/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.business.helper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.common.util.AppCacheUtils;
import kd.mpscmm.mspur.utils.CommonUtils;

public class MaterialHelper {
    public static int[] getMUConvFraction(Long materialId, Long srcUnit, Long desUnit, boolean fromCache) {
        if (CommonUtils.isNull((Object)materialId) || CommonUtils.isNull((Object)srcUnit) || CommonUtils.isNull((Object)desUnit)) {
            return null;
        }
        if (srcUnit.equals(desUnit)) {
            return new int[]{1, 1};
        }
        Map<String, Integer> timelyMuConv = null;
        if (fromCache) {
            String cacheKey = "getMUConv_" + materialId + "_" + srcUnit + "_" + desUnit;
            Object temp = AppCacheUtils.get((String)cacheKey, Map.class);
            if (temp instanceof Map) {
                timelyMuConv = (Map)temp;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit, (Long)desUnit);
                if (muConv != null && muConv.isInitialized()) {
                    timelyMuConv = new HashMap(16);
                    timelyMuConv.put("numerator", muConv.getInt("numerator"));
                    timelyMuConv.put("denominator", muConv.getInt("denominator"));
                    AppCacheUtils.put((String)cacheKey, timelyMuConv);
                }
            }
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit, (Long)desUnit);
            if (muConv != null) {
                timelyMuConv = new HashMap<String, Integer>(16);
                timelyMuConv.put("numerator", muConv.getInt("numerator"));
                timelyMuConv.put("denominator", muConv.getInt("denominator"));
            }
        }
        if (timelyMuConv != null) {
            int numerator = (Integer)timelyMuConv.get("numerator");
            int denominator = (Integer)timelyMuConv.get("denominator");
            return new int[]{numerator, denominator};
        }
        return null;
    }
}

