/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.business.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.common.entity.planorder.BomBaseData;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;

public class PlanOrderBomEntryUtil {
    public static final String MATERIAL_CONFIGPROPERTIES = "configproperties";
    public static final String INTERFACE_MODEL = "model_pom";
    public static final String SUPERBOMEXPANDTYPE = "superbom";
    public static final String BOMTYPE_CHAR = "_bomtype";
    private static final Log logger = LogFactory.getLog(PlanOrderBomEntryUtil.class);

    public static boolean isConfigBomInterface(DynamicObject order) {
        DynamicObject configcode = PlanOrderBomEntryUtil.getOrderConfigCode(order);
        DynamicObject material = PlanOrderBomEntryUtil.getOrderMaterial(order);
        return PlanOrderBomEntryUtil.chkUsedConfigBomInterface(material, configcode);
    }

    public static DynamicObject getOrderConfigCode(DynamicObject order) {
        return order.getDynamicObject("configuredcode");
    }

    public static DynamicObject getOrderMaterial(DynamicObject order) {
        return order.getDynamicObject("material");
    }

    public static Date getOrderBomExpandTime(DynamicObject order) {
        Date date = order.getDate("unfoldbomdate");
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    public static BigDecimal getOrderQty(DynamicObject order) {
        return order.getBigDecimal("orderqty");
    }

    public static boolean chkUsedConfigBomInterface(DynamicObject productMaterial, DynamicObject configCode) {
        return productMaterial != null && configCode != null && PlanOrderBomEntryUtil.materialIsConfig(productMaterial);
    }

    public static boolean materialIsConfig(DynamicObject productMaterial) {
        return "2".equals(productMaterial.get(MATERIAL_CONFIGPROPERTIES));
    }

    public static JSONObject expandConfigBom(Date searchTime, boolean isNeedProRoute, Long configCodeId, BigDecimal num, Long materialId, Long orgId) {
        JSONObject paramObject = PlanOrderBomEntryUtil.getJsonObjectParam(searchTime, isNeedProRoute, configCodeId, num, materialId, orgId);
        JSONObject returnJsonObject = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"proConfigListQueryService", (String)"getConfigBomForWorkOrder", (Object[])new Object[]{paramObject.toString()});
        return returnJsonObject;
    }

    public static String getConfigBomFilterStrByOrder(DynamicObject order, boolean isNeedProRoute) {
        DynamicObject configedCode = PlanOrderBomEntryUtil.getOrderConfigCode(order);
        if (configedCode == null) {
            return "";
        }
        Date expandtime = PlanOrderBomEntryUtil.getOrderBomExpandTime(order);
        BigDecimal qty = PlanOrderBomEntryUtil.getOrderQty(order);
        return PlanOrderBomEntryUtil.getConfigBomFilterStr(expandtime, configedCode.getLong("id"), qty, isNeedProRoute);
    }

    public static String getConfigBomFilterStr(Date expandtime, Long configedCodeId, BigDecimal qty, boolean isNeedProRoute) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return configedCodeId + "-" + qty + "-" + sdf.format(expandtime) + "-" + isNeedProRoute;
    }

    public static String getQueryDataRes(String filterStr) {
        if (!"".equals(filterStr) && !"[]".equals(filterStr)) {
            Long startdate = System.currentTimeMillis();
            logger.info("\u8c03\u7528\u5fae\u670d\u52a1\u83b7\u53d6BOM\u6570\u636e\u5f00\u59cb,\u4f20\u5165\u53c2\u6570\uff1a" + filterStr);
            String bomResult = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"BOMSearchService", (String)"allLevelForwardSearch", (Object[])new Object[]{filterStr});
            Long enddate = System.currentTimeMillis() - startdate;
            logger.info("\u8c03\u7528\u5fae\u670d\u52a1\u83b7\u53d6BOM\u6570\u636e\u7ed3\u675f--------------cost:" + enddate + "ms");
            logger.info("\u8c03\u7528\u5fae\u670d\u52a1\u83b7\u53d6BOM result--------------:" + bomResult);
            return bomResult;
        }
        return "";
    }

    public static void getQueryDataResForMulType(String filterStr, long planOrderId, Map<Long, String> orderBomMap, Map<String, String> bomResultMap) {
        if ("".equals(filterStr) || "[]".equals(filterStr)) {
            return;
        }
        long startDate = System.currentTimeMillis();
        logger.info("\u8c03\u7528\u5fae\u670d\u52a1\u83b7\u53d6BOM\u6570\u636e\u5f00\u59cb,\u4f20\u5165\u53c2\u6570\uff1a" + filterStr);
        String bomResult = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"BOMSearchService", (String)"bomExpandForMulType", (Object[])new Object[]{filterStr});
        long endDate = System.currentTimeMillis() - startDate;
        logger.info("\u8c03\u7528\u5fae\u670d\u52a1\u83b7\u53d6BOM\u6570\u636e\u7ed3\u675f--------------cost:" + endDate + "ms");
        logger.info("\u8c03\u7528\u5fae\u670d\u52a1\u83b7\u53d6BOM result--------------:" + bomResult);
        JSONArray resultArr = JSONObject.parseArray((String)bomResult);
        if (resultArr == null || resultArr.isEmpty()) {
            logger.info("\u8c03\u7528\u5c55BOM\u670d\u52a1(bomExpandForMulType)\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff1a" + bomResult);
            return;
        }
        JSONObject resultObj = resultArr.getJSONObject(0);
        boolean success = resultObj.getBoolean("success");
        if (!success) {
            logger.info("\u8c03\u7528\u5c55BOM\u670d\u52a1(bomExpandForMulType)\u5931\u8d25\uff1a" + resultObj.getString("msg"));
            return;
        }
        String dataKey = resultObj.getString("dataKey");
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
        String cacheData = (String)cache.get(dataKey);
        cache.remove(dataKey);
        orderBomMap.put(planOrderId, dataKey);
        bomResultMap.put(dataKey, cacheData);
    }

    public static List<BomBaseData> getBomChildEntryInfos(DynamicObject bomInfo, DynamicObject planorder, Set<Long> bomEntryIdSet, Map<Long, BigDecimal> standQtyMap, Map<Long, BigDecimal> requireQtyMap) {
        JSONArray filterArray = new JSONArray(16);
        HashMap<Long, String> orderBomMap = new HashMap<Long, String>(16);
        ArrayList<BomBaseData> bomBaseDatas = new ArrayList<BomBaseData>(16);
        HashMap<String, String> bomResultCacheMap = new HashMap<String, String>(1);
        StringBuilder errInfo = new StringBuilder();
        PlanOrderBomEntryUtil.setQueryData(filterArray, bomInfo, planorder);
        PlanOrderBomEntryUtil.getQueryDataResForMulType(filterArray.toString(), planorder.getLong("id"), orderBomMap, bomResultCacheMap);
        if (!bomResultCacheMap.isEmpty()) {
            PlanOrderBomEntryUtil.setResData(bomEntryIdSet, planorder, bomBaseDatas, orderBomMap, bomResultCacheMap, standQtyMap, requireQtyMap);
        }
        return bomBaseDatas;
    }

    private static void setResData(Set<Long> bomEntryIdSet, DynamicObject planorder, List<BomBaseData> bomBaseDatas, Map<Long, String> orderBomMap, Map<String, String> bomResultCacheMap, Map<Long, BigDecimal> standQtyMap, Map<Long, BigDecimal> requireQtyMap) {
        Long orderId = planorder.getLong("id");
        String resStr = orderBomMap.get(orderId);
        if (StringUtils.isEmpty((String)resStr)) {
            return;
        }
        if (PlanOrderBomEntryUtil.isSuperBomExpand(planorder, bomResultCacheMap)) {
            Long proorpurorgId = planorder.getDynamicObject("proorpurorg").getLong("id");
            boolean showJump = true;
            PlanOrderBomEntryUtil.setBomEntrys(resStr, bomEntryIdSet, bomBaseDatas, orderId, bomResultCacheMap, showJump, proorpurorgId);
            return;
        }
        DynamicObject supplyOrg = planorder.getDynamicObject("proorpurorg");
        long supplyOrgId = supplyOrg == null ? 0L : supplyOrg.getLong("id");
        PlanOrderBomEntryUtil.setBbdList(resStr, bomEntryIdSet, bomBaseDatas, orderId, bomResultCacheMap, supplyOrgId, standQtyMap, requireQtyMap);
    }

    private static void setBomEntrys(String resStr, Set<Long> bomEntryIdSet, List<BomBaseData> bomBaseDatas, Long orderId, Map<String, String> bomResultCacheMap, boolean showJump, Long proorpurorgId) {
        String res = bomResultCacheMap.get(resStr);
        if (StringUtils.isEmpty((String)res)) {
            return;
        }
        JSONObject resJsonObject = null;
        try {
            resJsonObject = JSONObject.parseObject((String)res);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            logger.info("setBbdList-JSONObject.parseObject is error,resStr=" + resStr + ",res=" + res);
            return;
        }
        JSONArray resArray = resJsonObject.getJSONArray("treeentryentity");
        if (resArray != null) {
            for (int i = 0; i < resArray.size(); ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                if (resJson.getLong("pid").equals(0L)) continue;
                BomBaseData bbd = PlanOrderBomEntryUtil.getBomBaseDataNew(resJson, proorpurorgId);
                boolean isJump = (Boolean)resJson.get((Object)"entryisjumplevel");
                if (!showJump && isJump) continue;
                bomEntryIdSet.add(resJson.getLong("superbomentryid"));
                bomBaseDatas.add(bbd);
            }
        }
    }

    private static Long getMaterialMftId(JSONObject resJson, Long productOrgId) {
        Long mftId = 0L;
        if (resJson.get((Object)"pmaterial") != null) {
            mftId = Long.parseLong(resJson.get((Object)"pmaterial").toString());
        }
        return mftId;
    }

    private static void setBbdList(String resStr, Set<Long> bomEntryIdSet, List<BomBaseData> bomBaseDatas, Long orderEntryId, Map<String, String> bomResultCacheMap, long supplyOrgId, Map<Long, BigDecimal> standQtyMap, Map<Long, BigDecimal> requireQtyMap) {
        String res = bomResultCacheMap.get(resStr);
        if (StringUtils.isEmpty((String)res)) {
            return;
        }
        logger.info("\u8c03\u7528\u5fae\u670d\u52a1\u83b7\u53d6BOM resStr = " + resStr + ",res--------------:" + res);
        JSONArray resArray = JSONArray.parseArray((String)res);
        if (resArray != null) {
            for (int i = 0; i < resArray.size(); ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                BomBaseData bomBaseData = PlanOrderBomEntryUtil.getBomBaseData(resJson);
                bomEntryIdSet.add(resJson.getLong("entry_Id"));
                bomBaseDatas.add(bomBaseData);
            }
            PlanOrderBomEntryUtil.calcStandQtyAndRequireQty(supplyOrgId, resArray, standQtyMap, requireQtyMap);
        }
    }

    private static void calcStandQtyAndRequireQty(long supplyOrgId, JSONArray resArray, Map<Long, BigDecimal> standQtyMap, Map<Long, BigDecimal> requireQtyMap) {
        ArrayList<Long> entryUnitIdList = new ArrayList<Long>(10);
        ArrayList<Long> entryMaterialIdList = new ArrayList<Long>(10);
        HashMap<String, Object> randomIdEntryIdMap = new HashMap<String, Object>(resArray.size());
        for (int i = 0; i < resArray.size(); ++i) {
            JSONObject resJson = resArray.getJSONObject(i);
            Long entryUnitId = resJson.getLong("entryunit");
            entryUnitIdList.add(entryUnitId);
            Long entryMaterialId = resJson.getLong("entrymaterialId");
            entryMaterialIdList.add(entryMaterialId);
            Long entryId = resJson.getLong("entry_Id");
            String randomId = resJson.getString("randomId");
            String[] splitRandomId = randomId.split("-");
            String curRandomId = splitRandomId[splitRandomId.length - 1];
            randomIdEntryIdMap.put(curRandomId, entryId);
        }
        Map unitMap = BusinessDataServiceHelper.loadFromCache((Object[])entryUnitIdList.toArray(), (String)"bd_measureunits");
        Map<Object, DynamicObject> materialPlanMap = PlanOrderHelper.getMaterialInfos(entryMaterialIdList, supplyOrgId, "mpdm_materialplan", PlanOrderBomEntryUtil.getMaterialPlanSelectFields(), false);
        HashMap<Long, Integer> precisionMap = new HashMap<Long, Integer>(unitMap.size());
        HashMap<Long, Integer> roundModeMap = new HashMap<Long, Integer>(unitMap.size());
        for (DynamicObject unit : unitMap.values()) {
            long unitId = unit.getLong("id");
            int precision = unit.getInt("precision");
            int roundMode = 4;
            String precisionAccount = unit.getString("precisionaccount");
            if ("2".equals(precisionAccount)) {
                roundMode = 1;
            } else if ("3".equals(precisionAccount)) {
                roundMode = 0;
            }
            precisionMap.put(unitId, precision);
            roundModeMap.put(unitId, roundMode);
        }
        for (int i = 0; i < resArray.size(); ++i) {
            String formula;
            BigDecimal standQty;
            BigDecimal entryFixScrap;
            JSONObject resJson = resArray.getJSONObject(i);
            Long entryId = resJson.getLong("entry_Id");
            String randomId = resJson.getString("randomId");
            String[] splitRandomId = randomId.split("-");
            boolean isFirstLevel = splitRandomId.length == 1;
            String parentRandomId = isFirstLevel ? "" : splitRandomId[splitRandomId.length - 2];
            Long entryMaterialId = resJson.getLong("entrymaterialId");
            String entryQtyType = resJson.getString("entryqtytype");
            BigDecimal entryqtynumerator = resJson.getBigDecimal("entryqtynumerator");
            BigDecimal entryqtydenominator = resJson.getBigDecimal("entryqtydenominator");
            BigDecimal entryScrapRate = resJson.getBigDecimal("entryscraprate");
            if (entryScrapRate == null) {
                logger.info("bomEntryId[{}]\u672a\u53d6\u5230\u53d8\u52a8\u635f\u8017\u7387\uff0c\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u4e3a0", (Object)entryId);
                entryScrapRate = BigDecimal.ZERO;
            }
            if ((entryFixScrap = resJson.getBigDecimal("entryfixscrap")) == null) {
                logger.info("bomEntryId[{}]\u672a\u53d6\u5230\u56fa\u5b9a\u635f\u8017\uff0c\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u4e3a0", (Object)entryId);
                entryFixScrap = BigDecimal.ZERO;
            }
            Long entryUnitId = resJson.getLong("entryunit");
            Integer precision = precisionMap.getOrDefault(entryUnitId, 2);
            Integer roundMode = roundModeMap.getOrDefault(entryUnitId, 4);
            if (isFirstLevel) {
                standQty = resJson.getBigDecimal("commonused");
                standQty = standQty.setScale((int)precision, roundMode);
            } else {
                Long parentEntryId = (Long)randomIdEntryIdMap.get(parentRandomId);
                BigDecimal parentRequireQty = requireQtyMap.get(parentEntryId);
                standQty = PlanOrderHelper.calculateStandQty(precision, roundMode, entryQtyType, BigDecimal.ONE, parentRequireQty, entryqtynumerator, entryqtydenominator);
            }
            standQtyMap.put(entryId, standQty);
            String wastageRateFormula = "B";
            DynamicObject entryMaterialPlan = materialPlanMap.get(entryMaterialId);
            if (entryMaterialPlan != null && StringUtils.isNotEmpty((String)(formula = entryMaterialPlan.getString("wastagerateformula")))) {
                wastageRateFormula = formula;
            }
            BigDecimal requireQty = PlanOrderHelper.calculateDemadQty(wastageRateFormula, precision, roundMode, true, standQty, entryScrapRate, entryFixScrap);
            requireQtyMap.put(entryId, requireQty);
        }
    }

    private static String getMaterialPlanSelectFields() {
        return "id,createorg,masterid,wastagerateformula,yield,plangroup,materialattr,operator,plantags,wastagerate,leadtimetype,materialattr,fixedleadtime,changeleadtime,changebatch,preprocessingtime,inspectionleadtime,postprocessingtime,supplynetwork";
    }

    public static BomBaseData getBomBaseData(JSONObject resJson) {
        BigDecimal workEntryQty;
        BomBaseData bbd = new BomBaseData();
        bbd.setBomEntryId(resJson.getLong("entry_Id"));
        bbd.setBomId(resJson.getLong("id"));
        bbd.setQtydenominator(resJson.get((Object)"entryqtydenominator"));
        bbd.setQtynumerator(resJson.get((Object)"entryqtynumerator"));
        bbd.setQtytype(resJson.get((Object)"entryqtytype"));
        if ("true".equals(resJson.get((Object)"issolid"))) {
            bbd.setQtytype((Object)"B");
        }
        bbd.setScraprate(resJson.get((Object)"entryscraprate"));
        bbd.setFixscrap(resJson.get((Object)"entryfixscrap"));
        if (resJson.get((Object)"entryisjumplevel") != null) {
            bbd.setIsJump(resJson.getBoolean("entryisjumplevel").booleanValue());
        }
        if (resJson.get((Object)"materialId") != null) {
            bbd.setPMaterial(resJson.getLong("materialId"));
        }
        if (resJson.get((Object)"entrymaterialId") != null) {
            bbd.setMaterilID(resJson.getLong("entrymaterialId"));
        }
        if (resJson.get((Object)"workentryqty") != null && (workEntryQty = new BigDecimal(resJson.get((Object)"workentryqty").toString())).compareTo(BigDecimal.ZERO) != 0) {
            bbd.setQtynumerator((Object)workEntryQty);
        }
        if (resJson.get((Object)"workcenter") != null) {
            bbd.setWorkCenterId(Long.valueOf(Long.parseLong(resJson.get((Object)"workcenter").toString())));
        }
        if (resJson.get((Object)"workstation") != null) {
            bbd.setWorkStationId(Long.valueOf(Long.parseLong(resJson.get((Object)"workstation").toString())));
        }
        if (resJson.get((Object)"entryConfigCode") != null) {
            bbd.setConfigedCodeId(resJson.getLong("entryConfigCode"));
        }
        return bbd;
    }

    public static BomBaseData getBomBaseDataNew(JSONObject resJson, Long productOrgId) {
        BigDecimal workEntryQty;
        BigDecimal entryqty;
        BomBaseData bbd = new BomBaseData();
        bbd.setBomEntryId(resJson.getLong("superbomentryid"));
        bbd.setQtydenominator(resJson.get((Object)"entryqtydenominator"));
        bbd.setQtynumerator(resJson.get((Object)"entryqtynumerator"));
        bbd.setBomId(resJson.getLong("superbomid"));
        bbd.setQtytype(resJson.get((Object)"entryqtytype"));
        if (resJson.get((Object)"issolid") != null && "true".equals(resJson.get((Object)"issolid").toString())) {
            bbd.setQtytype((Object)"B");
        }
        bbd.setScraprate(resJson.get((Object)"entryscraprate"));
        bbd.setFixscrap(resJson.get((Object)"entryfixscrap"));
        if (resJson.get((Object)"entryisjumplevel") != null) {
            bbd.setIsJump(((Boolean)resJson.get((Object)"entryisjumplevel")).booleanValue());
        }
        bbd.setPMaterial(PlanOrderBomEntryUtil.getMaterialMftId(resJson, productOrgId));
        bbd.setMaterilID(resJson.getLong("entrymaterial_id"));
        bbd.setConfigedCodeId(Long.valueOf(Long.parseLong(resJson.get((Object)"configcode").toString())));
        if (resJson.get((Object)"workcenter") != null) {
            bbd.setWorkCenterId(Long.valueOf(Long.parseLong(resJson.get((Object)"workcenter").toString())));
        }
        if (resJson.get((Object)"entryqty") != null && (entryqty = new BigDecimal(resJson.get((Object)"entryqty").toString())).compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal entryqtydenominator = (BigDecimal)resJson.get((Object)"entryqtydenominator");
            bbd.setQtynumerator((Object)entryqty.multiply(entryqtydenominator));
        }
        if (resJson.get((Object)"workentryqty") != null && (workEntryQty = new BigDecimal(resJson.get((Object)"workentryqty").toString())).compareTo(BigDecimal.ZERO) != 0) {
            bbd.setQtynumerator((Object)workEntryQty);
        }
        if (resJson.get((Object)"workstation") != null) {
            bbd.setWorkStationId(Long.valueOf(Long.parseLong(resJson.get((Object)"workstation").toString())));
        }
        return bbd;
    }

    public static boolean isSuperBomExpand(DynamicObject order, Map<String, String> bomResultCacheMap) {
        String resStr = PlanOrderBomEntryUtil.getConfigBomFilterStrByOrderEntry(order, false);
        if (resStr == null || "".equals(resStr)) {
            return false;
        }
        String bomType = bomResultCacheMap.get(resStr + BOMTYPE_CHAR);
        return bomType != null && SUPERBOMEXPANDTYPE.equalsIgnoreCase(bomType);
    }

    private static void setQueryData(JSONArray filterArray, DynamicObject bom, DynamicObject planOrder) {
        DynamicObject supplyOrg;
        DynamicObject configuredCode;
        String configProperties;
        DynamicObject material = planOrder.getDynamicObject("material");
        Date unfoldBomDate = planOrder.getDate("unfoldbomdate");
        BigDecimal orderQty = planOrder.getBigDecimal("orderqty");
        BigDecimal num = BigDecimal.ONE;
        if (orderQty.compareTo(BigDecimal.ZERO) != 0) {
            num = orderQty;
        }
        long bomId = bom == null ? 0L : bom.getLong("id");
        long materialId = material == null ? 0L : material.getLong("id");
        Long configCodeId = null;
        String string = configProperties = material == null ? "" : material.getString(MATERIAL_CONFIGPROPERTIES);
        if ("2".equals(configProperties) && (configuredCode = planOrder.getDynamicObject("configuredcode")) != null) {
            configCodeId = configuredCode.getLong("id");
        }
        Long auxPropertyId = null;
        DynamicObject auxProperty = planOrder.getDynamicObject("auxproperty");
        if (auxProperty != null) {
            auxPropertyId = auxProperty.getLong("id");
        }
        long supplyOrgId = (supplyOrg = planOrder.getDynamicObject("proorpurorg")) == null ? 0L : supplyOrg.getLong("id");
        JSONObject param = PlanOrderBomEntryUtil.getMulBomJsonObjectParam(bomId, unfoldBomDate, configCodeId, num, materialId, auxPropertyId, supplyOrgId);
        filterArray.add((Object)param);
    }

    public static JSONObject getBomFilterJsonType(Long bomId, BigDecimal qty, Date expendbomtime, String type) {
        JSONObject filterJson = PlanOrderBomEntryUtil.getBomFilterJsonNew(bomId, qty, expendbomtime);
        filterJson.put("type", (Object)type);
        return filterJson;
    }

    private static JSONObject getMulBomJsonObjectParam(Long bomId, Date searchTime, Long configCodeId, BigDecimal num, Long materialId, Long auxPropertyId, Long supplyOrgId) {
        JSONObject paramObject = new JSONObject();
        paramObject.put("org", (Object)supplyOrgId);
        if (bomId != null && bomId != 0L) {
            paramObject.put("bomId", (Object)bomId);
        }
        paramObject.put("materialid", (Object)materialId);
        paramObject.put("searchDate", (Object)searchTime);
        if (configCodeId != null) {
            paramObject.put("configcode", (Object)configCodeId);
        }
        if (auxPropertyId != null) {
            paramObject.put("auxproperty", (Object)auxPropertyId);
        }
        paramObject.put("num", (Object)num);
        paramObject.put("showtype", (Object)"E");
        paramObject.put("model", (Object)"model_mrp");
        return paramObject;
    }

    public static JSONObject getBomFilterJsonNew(Long bomId, BigDecimal qty, Date expendbomtime) {
        JSONObject filterJson = new JSONObject();
        filterJson.put("id", (Object)bomId);
        filterJson.put("num", (Object)qty);
        filterJson.put("time", (Object)expendbomtime);
        filterJson.put("routeId", (Object)0L);
        return filterJson;
    }

    public static String getBomFilterStrType(Long bomId, BigDecimal qty, Date expandtime, String type) {
        return PlanOrderBomEntryUtil.getBomFilterStrNew(bomId, qty, expandtime) + "-" + type + "-" + 0L;
    }

    public static String getBomFilterStr(Long bomId, BigDecimal qty, Date expandtime) {
        return PlanOrderBomEntryUtil.getBomFilterStrNew(bomId, qty, expandtime) + "-D-" + 0L;
    }

    public static String getBomFilterStrNew(Long bomId, BigDecimal qty, Date expandtime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return bomId + "-" + qty + "-" + sdf.format(expandtime);
    }

    public static String getConfigBomFilterStrByOrderEntry(DynamicObject order, boolean isNeedProRoute) {
        DynamicObject configedCode = PlanOrderBomEntryUtil.getOrderConfigCode(order);
        if (configedCode == null) {
            return "";
        }
        Date expandtime = PlanOrderBomEntryUtil.getOrderBomExpandTime(order);
        BigDecimal qty = PlanOrderBomEntryUtil.getOrderQty(order);
        return PlanOrderBomEntryUtil.getConfigBomFilterStr(expandtime, configedCode.getLong("id"), qty, isNeedProRoute);
    }

    public static void initBomExpandResult(DynamicObject order, Map<String, String> bomResultCacheMap) {
        DynamicObject configedCode = PlanOrderBomEntryUtil.getOrderConfigCode(order);
        BigDecimal num = PlanOrderBomEntryUtil.getOrderQty(order);
        DynamicObject proorpurorg = order.getDynamicObject("proorpurorg");
        DynamicObject material = order.getDynamicObject("material");
        PlanOrderBomEntryUtil.getExpandConfigBom(PlanOrderBomEntryUtil.getOrderBomExpandTime(order), false, configedCode.getLong("id"), num, bomResultCacheMap, material.getLong("id"), proorpurorg.getLong("id"));
    }

    public static JSONObject getExpandConfigBom(Date searchTime, boolean isNeedProRoute, Long configCodeId, BigDecimal qty, Map<String, String> bomResultCacheMap, Long materialId, Long orgId) {
        long startdate = System.currentTimeMillis();
        String resStr = PlanOrderBomEntryUtil.getConfigBomFilterStr(searchTime, configCodeId, qty, isNeedProRoute);
        if (bomResultCacheMap == null) {
            bomResultCacheMap = new HashMap<String, String>(16);
        }
        bomResultCacheMap.put(resStr + BOMTYPE_CHAR, SUPERBOMEXPANDTYPE);
        String cacheValue = bomResultCacheMap.get(resStr);
        if (!StringUtils.isEmpty((String)cacheValue)) {
            long enddate = System.currentTimeMillis() - startdate;
            logger.info("mmc-getExpandConfigBom.....cost:" + enddate + "ms,from bomResultCacheMap");
            return JSONObject.parseObject((String)cacheValue);
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mpscmm-msplan-business");
        cacheValue = (String)cache.get(resStr);
        if (!StringUtils.isEmpty((String)cacheValue)) {
            bomResultCacheMap.put(resStr, cacheValue);
            long enddate = System.currentTimeMillis() - startdate;
            logger.info("mmc-getExpandConfigBom.....cost:" + enddate + "ms,from DistributeSessionlessCache");
            return JSONObject.parseObject((String)cacheValue);
        }
        JSONObject returnObject = PlanOrderBomEntryUtil.expandConfigBom(searchTime, isNeedProRoute, configCodeId, qty, materialId, orgId);
        if (!"success".equalsIgnoreCase(returnObject.getString("status"))) {
            String errorInfo = returnObject.getString("msg");
            logger.info("-------------configBomExpad error:" + errorInfo + ",configCodeId=" + configCodeId);
            return null;
        }
        long enddate = System.currentTimeMillis() - startdate;
        logger.info("mmc-getExpandConfigBom.....cost:" + enddate + "ms,from mservice");
        JSONObject data = returnObject.getJSONObject("data").getJSONObject(String.valueOf(configCodeId));
        if ("failed".equalsIgnoreCase(data.getString("status"))) {
            String errorInfo = data.getString("msg");
            logger.info("-------------configBomExpad errorInfo:" + errorInfo + ",configCodeId=" + configCodeId);
            logger.info("-------------configBomExpad stackTrace:" + data.getString("StackTrace"));
            return null;
        }
        bomResultCacheMap.put(resStr, data.toJSONString());
        cache.put(resStr, (Object)data.toJSONString(), 600);
        return data;
    }

    public static JSONObject getJsonObjectParam(Date searchTime, boolean isNeedProRoute, Long configCodeId, BigDecimal num, Long materialId, Long orgId) {
        JSONObject configedCodeList = new JSONObject();
        configedCodeList.put(configCodeId.toString(), (Object)"");
        JSONObject paramObject = new JSONObject();
        paramObject.put("org", (Object)orgId);
        paramObject.put("searchTime", (Object)searchTime);
        paramObject.put("isNeedProRoute", (Object)isNeedProRoute);
        paramObject.put("configCodeList", (Object)configedCodeList);
        paramObject.put("model", (Object)INTERFACE_MODEL);
        paramObject.put("matId", (Object)materialId);
        paramObject.put("bomVer", null);
        paramObject.put("num", (Object)num);
        paramObject.put("purchaseExpand", (Object)false);
        return paramObject;
    }
}

