/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.business.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanScopeHelper;

public class PlanOrderBomHelper {
    private static final String BOM_KEY = "pdm_mftbom";
    private static final String MPDM_MATERIAL_PLAN = "mpdm_materialplan";

    public static DynamicObject getBOMAndBOMExpansion(DynamicObject planOrder) {
        DynamicObject material = planOrder.getDynamicObject("material");
        if (material == null) {
            return planOrder;
        }
        DynamicObject supplyOrg = planOrder.getDynamicObject("proorpurorg");
        DynamicObject bom = null;
        DynamicObject auxpty = planOrder.getDynamicObject("auxproperty");
        Date unfoldBomDate = planOrder.getDate("unfoldbomdate");
        if (unfoldBomDate == null) {
            unfoldBomDate = new Date();
        }
        QFilter qfilter = new QFilter("1", "=", (Object)"1");
        DynamicObject configuredcode = planOrder.getDynamicObject("configuredcode");
        if (configuredcode != null) {
            QFilter configuredcodeqfilter = new QFilter("configuredcode", "=", configuredcode.getPkValue());
            qfilter.and(configuredcodeqfilter);
        }
        if (auxpty != null) {
            boolean isaCarryBom = PlanOrderHelper.dealAuxptyEntry(material, auxpty);
            boolean isAffectPlan = PlanOrderHelper.dealAuxptyEntry(material, null);
            if (!isaCarryBom) {
                QFilter auxptyqfilter = new QFilter("auxproperty", "=", auxpty.getPkValue());
                auxptyqfilter.and(qfilter);
                bom = PlanOrderBomHelper.getBom(supplyOrg, material, unfoldBomDate, auxptyqfilter);
                if (bom == null) {
                    List<String> auxptyEntryMust = PlanOrderHelper.getAuxptyEntryMust(material);
                    auxptyqfilter = null;
                    if (auxpty != null && isAffectPlan) {
                        String json = auxpty.getString("value");
                        Map values = (Map)JSON.parseObject((String)json, Map.class);
                        for (Map.Entry value : values.entrySet()) {
                            Object key = value.getKey();
                            if (!auxptyEntryMust.contains(key)) continue;
                            StringBuilder str = new StringBuilder();
                            str.append("%\"").append(key).append("\":");
                            Object val = value.getValue();
                            if (val instanceof String) {
                                str.append("\"").append(val).append("\"%");
                            } else if (val instanceof Integer || val instanceof Long) {
                                str.append(val).append("%");
                            }
                            QFilter auxpropertyqfilter = new QFilter("auxproperty.value", "like", (Object)str.toString());
                            if (auxptyqfilter == null) {
                                auxptyqfilter = auxpropertyqfilter;
                                continue;
                            }
                            auxptyqfilter.and(auxpropertyqfilter);
                        }
                    }
                    auxptyqfilter = auxptyqfilter == null ? qfilter : auxptyqfilter.and(qfilter);
                    bom = PlanOrderBomHelper.getBom(supplyOrg, material, unfoldBomDate, auxptyqfilter);
                }
            }
        } else {
            bom = PlanOrderBomHelper.getBom(supplyOrg, material, unfoldBomDate, qfilter);
        }
        if (bom == null) {
            return planOrder;
        }
        Date startDate = planOrder.getDate("startdate");
        if (startDate == null) {
            startDate = new Date();
        }
        bom = BusinessDataServiceHelper.loadSingle((Object)bom.getLong("id"), (String)BOM_KEY, (String)PlanOrderHelper.selectBOMPropertites());
        planOrder.set("bom", (Object)bom);
        HashMap<String, Date> requireDateMap = new HashMap<String, Date>();
        requireDateMap.put(bom.getPkValue().toString(), startDate);
        BigDecimal orderQty = planOrder.getBigDecimal("orderqty");
        HashMap<Long, BigDecimal> standQtyMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> requireQtyMap = new HashMap<Long, BigDecimal>(16);
        List<DynamicObject> bomEntrys = PlanOrderHelper.getBomChildEntryInfo(bom, planOrder, orderQty, unfoldBomDate, supplyOrg == null ? 0L : supplyOrg.getLong("id"), requireDateMap, standQtyMap, requireQtyMap);
        DynamicObjectCollection copentrys = bom.getDynamicObjectCollection("copentry");
        PlanOrderBomHelper.createCopEntry(copentrys, orderQty, unfoldBomDate, planOrder);
        PlanOrderBomHelper.createNewEntry(bom, bomEntrys, orderQty, requireDateMap, planOrder);
        return planOrder;
    }

    private static void createNewEntry(DynamicObject bom, List<DynamicObject> bomEntrys, BigDecimal orderQty, Map<String, Date> requireDateMap, DynamicObject planOrder) {
        DynamicObject supplyOrg = planOrder.getDynamicObject("proorpurorg");
        ArrayList<Long> materialMftInfoIds = new ArrayList<Long>(bomEntrys.size());
        ArrayList<Long> materialIds = new ArrayList<Long>(bomEntrys.size());
        HashMap<String, DynamicObject> bomEntryMaps = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> entrymaterialMap = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> entrymaterialInfoMap = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> interAssistTypeMap = new HashMap<String, DynamicObject>();
        DynamicObject manuVersiontInfo = planOrder.getDynamicObject("manuversion");
        for (DynamicObject bomEntry : bomEntrys) {
            Long materialId = bomEntry.getLong("entry.entrymaterialid");
            if (materialId == null || materialId == 0L) continue;
            materialIds.add(materialId);
            Long materialInfoId = bomEntry.getLong("entry.entrymaterial");
            if (materialInfoId == null || materialInfoId == 0L) continue;
            materialMftInfoIds.add(materialInfoId);
        }
        Map materialMap = BusinessDataServiceHelper.loadFromCache((Object[])materialIds.toArray(new Long[0]), (String)"bd_material");
        Map materialmftMap = BusinessDataServiceHelper.loadFromCache((Object[])materialMftInfoIds.toArray(new Long[0]), (String)"bd_materialmftinfo");
        Map<Object, DynamicObject> entryMaterialPlanMap = PlanOrderHelper.getMaterialInfos(materialIds, supplyOrg == null ? 0L : supplyOrg.getLong("id"), MPDM_MATERIAL_PLAN, PlanOrderBomHelper.getMaterialPlanSelectFields(), false);
        Map<Object, DynamicObject> entryMaterialMft = PlanOrderHelper.getMaterialMftInfos(materialIds, supplyOrg == null ? 0L : supplyOrg.getLong("id"), "bd_materialmftinfo", PlanOrderBomHelper.getMaterialMftSelectFields());
        long[] genLongIds = DB.genLongIds((String)"t_mrp_planorderentry", (int)bomEntrys.size());
        for (int i = 0; i < bomEntrys.size(); ++i) {
            DynamicObject entrymaterial;
            Long planorderentryId = genLongIds[i];
            DynamicObject bomEntry = bomEntrys.get(i);
            Long materialId = bomEntry.getLong("entry.entrymaterialid");
            if (materialId == null || materialId == 0L || (entrymaterial = (DynamicObject)materialMap.get(materialId)) == null) continue;
            DynamicObject materialmft = entryMaterialMft.get(materialId);
            DynamicObject entrymaterialPlan = entryMaterialPlanMap.get(materialId);
            entrymaterialInfoMap.put(planorderentryId.toString(), materialmft);
            bomEntryMaps.put(planorderentryId.toString(), bomEntry);
            entrymaterialMap.put(planorderentryId.toString(), entrymaterial);
            DynamicObject interAssistType = null;
            if (entrymaterialPlan != null) {
                interAssistType = entrymaterialPlan.getDynamicObject("inter_assist_type");
            }
            interAssistTypeMap.put(planorderentryId.toString(), interAssistType);
        }
        Map<String, Map<String, Long>> batchDefSupplierInfo = PlanScopeHelper.getBatchDefSupplierInfoConsiderInterAssist(bomEntryMaps, entrymaterialMap, entrymaterialInfoMap, interAssistTypeMap, supplyOrg, manuVersiontInfo);
        DynamicObjectCollection entrys = planOrder.getDynamicObjectCollection("entryentity");
        DynamicObjectType entryType = entrys.getDynamicObjectType();
        for (Map.Entry bomEntryEntry : bomEntryMaps.entrySet()) {
            String key = (String)bomEntryEntry.getKey();
            DynamicObject bomEntry = (DynamicObject)bomEntryEntry.getValue();
            Map<String, Long> supplyInfoMap = batchDefSupplierInfo.get(key);
            PlanOrderBomHelper.setMaterialEntry(bom, bomEntry, orderQty, requireDateMap, materialmftMap, entryMaterialPlanMap, entryMaterialMft, supplyInfoMap, materialMap, entryType, planOrder, entrys);
        }
    }

    private static void setMaterialEntry(DynamicObject bom, DynamicObject bomEntry, BigDecimal orderQty, Map<String, Date> requireDateMap, Map<Object, DynamicObject> materialmftMap, Map<Object, DynamicObject> entryMaterialPlans, Map<Object, DynamicObject> entryMaterialMfts, Map<String, Long> supplyInfoMap, Map<Object, DynamicObject> materialMap, DynamicObjectType entryType, DynamicObject planOrder, DynamicObjectCollection entrys) {
        String entryisreplace;
        Long materialId = bomEntry.getLong("entry.entrymaterialid");
        if (materialId == null || materialId == 0L) {
            return;
        }
        DynamicObject entryMaterialPlan = entryMaterialPlans.get(materialId);
        DynamicObject entryMaterialMft = entryMaterialMfts.get(materialId);
        Long entryConfiguredcodeId = bomEntry.getLong("entry.entryconfiguredcode");
        Long entryAuxpropertyId = bomEntry.getLong("entry.entryauxproperty");
        Long entryId = bomEntry.getLong("entry.id");
        String wastagerateformula = "";
        if (entryMaterialPlan != null) {
            wastagerateformula = entryMaterialPlan.getString("wastagerateformula");
        }
        if (StringUtils.isBlank((CharSequence)wastagerateformula)) {
            wastagerateformula = "B";
        }
        Integer leadtime = bomEntry.getInt("entry.entryleadtime");
        Long entryunitId = bomEntry.getLong("entry.entryunit");
        Long entryversionId = bomEntry.getLong("entry.entryversion");
        String entryqtytype = bomEntry.getString("entry.entryqtytype");
        BigDecimal entryqtynumerator = bomEntry.getBigDecimal("entry.entryqtynumerator");
        BigDecimal entryqtydenominator = bomEntry.getBigDecimal("entry.entryqtydenominator");
        int precision = 2;
        if (bomEntry.get("entry.entryunit.precision") != null) {
            precision = bomEntry.getInt("entry.entryunit.precision");
        }
        BigDecimal useratio = new BigDecimal("100").divide(BigDecimal.valueOf(100L), 4, 4);
        BigDecimal entryscraprate = bomEntry.getBigDecimal("entry.entryscraprate");
        BigDecimal entryfixscrap = bomEntry.getBigDecimal("entry.entryfixscrap");
        BigDecimal entrystandqty = PlanOrderHelper.calculateStandQty(precision, entryqtytype, useratio, orderQty, entryqtynumerator, entryqtydenominator);
        Long entryreplaceplanId = bomEntry.getLong("entry.entryreplaceplan");
        String entryreplacestra = "";
        String entryreplacemethod = "";
        BigDecimal entryrequireqty = PlanOrderHelper.calculateDemadQty(wastagerateformula, precision, true, entrystandqty, entryscraprate, entryfixscrap);
        BigDecimal entrylossqty = entryrequireqty.subtract(entrystandqty);
        Date date = requireDateMap.get(entryId.toString());
        if (date == null) {
            date = new Date();
        }
        String entrysupplytype = bomEntry.getString("entry.entrysupplytype");
        DynamicObject mtfOrg = planOrder.getDynamicObject("proorpurorg");
        Long entrysupplyorgId = bomEntry.getLong("entry.entrysupplyorg");
        if ((entrysupplyorgId == null || entrysupplyorgId == 0L) && mtfOrg != null && mtfOrg.getBoolean("fisinventory")) {
            entrysupplyorgId = mtfOrg.getLong("id");
        }
        if ("true".equals(entryisreplace = bomEntry.getString("entry.entryisreplace"))) {
            entryrequireqty = BigDecimal.ZERO;
            entrystandqty = BigDecimal.ZERO;
        }
        boolean entryisstockallot = false;
        if (entryMaterialMft != null) {
            entryisstockallot = entryMaterialMft.getBoolean("isstockallot");
        }
        Long entrysupplyorgunitid = supplyInfoMap.get("entrysupplyorg");
        Long entrywarehouseId = supplyInfoMap.get("entrywarehouse");
        Long entrylocationId = supplyInfoMap.get("entrylocation");
        int reppriority = bomEntry.getInt("entry.reppriority");
        String entryisreplaceplanmm = bomEntry.getString("entry.entryisreplaceplanmm");
        String entryMode = "B";
        String entrytype = "A";
        boolean entryisjumplevel = bomEntry.getBoolean("entry.entryisjumplevel");
        DynamicObject entryparentmaterial = bom == null ? null : bom.getDynamicObject("materialid");
        DynamicObject entry = new DynamicObject(entryType);
        entry.set("entrymode", (Object)entryMode);
        entry.set("entrytype", (Object)entrytype);
        entry.set("entrymaterial_id", (Object)materialId);
        entry.set("entryversion_id", (Object)entryversionId);
        entry.set("entryunit_id", (Object)entryunitId);
        entry.set("entryqtytype", (Object)entryqtytype);
        entry.set("entryqtynumerator", (Object)entryqtynumerator);
        entry.set("entryqtydenominator", (Object)entryqtydenominator);
        entry.set("entrystandqty", (Object)entrystandqty);
        entry.set("entryrequireqty", (Object)entryrequireqty);
        entry.set("entryrequiredate", (Object)date);
        entry.set("entryfixscrap", (Object)entryfixscrap);
        entry.set("entryscraprate", (Object)entryscraprate);
        entry.set("entrylossqty", (Object)entrylossqty);
        entry.set("entrysupplytype", (Object)entrysupplytype);
        entry.set("entrysupplyorg_id", (Object)entrysupplyorgId);
        entry.set("entrybomid", bom == null ? Integer.valueOf(0) : bom.getPkValue());
        entry.set("entrybomentryid", (Object)bomEntry.getLong("entry.id"));
        entry.set("entrymaterialplanid", (Object)entryMaterialPlan);
        entry.set("entryreplaceplan_id", (Object)entryreplaceplanId);
        entry.set("entryisreplace", (Object)entryisreplace);
        entry.set("entryreplacestra", (Object)entryreplacestra);
        entry.set("entryreplacemethod", (Object)entryreplacemethod);
        entry.set("entryreplacematerial", (Object)entryisreplaceplanmm);
        entry.set("entryreplacepriority", (Object)reppriority);
        entry.set("wastagerateformula", (Object)wastagerateformula);
        entry.set("entryleadtime", (Object)leadtime);
        entry.set("entryconfiguredcode_id", (Object)entryConfiguredcodeId);
        entry.set("entryauxproperty_id", (Object)entryAuxpropertyId);
        entry.set("entrysupplyorgunitid_id", (Object)entrysupplyorgunitid);
        entry.set("entrywarehouse_id", (Object)entrywarehouseId);
        entry.set("entrylocation_id", (Object)entrylocationId);
        entry.set("entryisstockallot", (Object)entryisstockallot);
        entry.set("entryisjumplevel", (Object)entryisjumplevel);
        entry.set("entryparentmaterial", (Object)entryparentmaterial);
        entrys.add((Object)entry);
    }

    private static void createCopEntry(DynamicObjectCollection bomCopentrys, BigDecimal orderQty, Date unfoldBomDate, DynamicObject planOrder) {
        DynamicObjectCollection copentrys = planOrder.getDynamicObjectCollection("copentry");
        for (DynamicObject bomCopentry : bomCopentrys) {
            DynamicObjectType copentryType = copentrys.getDynamicObjectType();
            PlanOrderBomHelper.setCopEntry(copentryType, bomCopentry, orderQty, unfoldBomDate, copentrys);
        }
    }

    private static void setCopEntry(DynamicObjectType copentryType, DynamicObject bomCopentry, BigDecimal orderQty, Date unfoldBomDate, DynamicObjectCollection copentrys) {
        String copentrytype = bomCopentry.getString("copentrytype");
        DynamicObject copentrymaterial = bomCopentry.getDynamicObject("copentrymaterial");
        DynamicObject copentryversion = bomCopentry.getDynamicObject("copentryversion");
        DynamicObject copentryunit = bomCopentry.getDynamicObject("copentryunit");
        BigDecimal copentryqty = bomCopentry.getBigDecimal("copentryqty");
        BigDecimal copentryallqty = copentryqty.multiply(orderQty);
        DynamicObject copentryoperation = bomCopentry.getDynamicObject("copentryoperation");
        Date copentryvaliddate = bomCopentry.getDate("copentryvaliddate");
        Date copentryinvaliddate = bomCopentry.getDate("copentryinvaliddate");
        if (copentryvaliddate == null || copentryinvaliddate == null) {
            return;
        }
        if (copentryvaliddate.compareTo(unfoldBomDate) > 0 || copentryinvaliddate.compareTo(unfoldBomDate) < 0) {
            return;
        }
        DynamicObject copentryauxproperty = bomCopentry.getDynamicObject("copentryauxproperty");
        String copentryremark = bomCopentry.getLocaleString("copentryremark").getLocaleValue();
        DynamicObject copentry = new DynamicObject(copentryType);
        copentry.set("copentrytype", (Object)copentrytype);
        copentry.set("copentrymaterial", (Object)copentrymaterial);
        copentry.set("copentryversion", (Object)copentryversion);
        copentry.set("copentryunit", (Object)copentryunit);
        copentry.set("copentryqty", (Object)copentryqty);
        copentry.set("copentryallqty", (Object)copentryallqty);
        copentry.set("copentryoperation", (Object)copentryoperation);
        copentry.set("copentryauxproperty", (Object)copentryauxproperty);
        copentry.set("copentryremark", (Object)copentryremark);
        copentrys.add((Object)copentry);
    }

    private static DynamicObject getBom(DynamicObject supplyOrg, DynamicObject material, Date unfoldBomDate, QFilter qfilter) {
        QFilter masteridQF;
        if (supplyOrg == null) {
            return null;
        }
        QFilter statusQF = new QFilter("status", "=", (Object)Character.valueOf('C'));
        QFilter enableQF = new QFilter("enable", "=", (Object)"1");
        QFilter materialQfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)Long.valueOf(supplyOrg.getPkValue().toString()));
        DynamicObjectCollection materialInfos = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"id", (QFilter[])new QFilter[]{materialQfilter, masteridQF = new QFilter("masterid", "=", (Object)material.getLong("id")), statusQF, enableQF});
        if (materialInfos.isEmpty()) {
            return null;
        }
        HashSet materialInfoIds = new HashSet(materialInfos.size());
        materialInfos.forEach(s -> materialInfoIds.add(s.getLong("id")));
        QFilter basedataQfilter = BaseDataServiceHelper.getBaseDataFilter((String)BOM_KEY, (Long)Long.valueOf(supplyOrg.getPkValue().toString()));
        QFilter materialQF = new QFilter("material", "in", materialInfoIds);
        DynamicObjectCollection col = QueryServiceHelper.query((String)BOM_KEY, (String)"id,version,ecn", (QFilter[])new QFilter[]{basedataQfilter, materialQF, statusQF, enableQF});
        if (col.isEmpty()) {
            return null;
        }
        HashSet verSet = new HashSet(col.size());
        col.forEach(s -> verSet.add(s.getLong("version")));
        DynamicObjectCollection verCol = QueryServiceHelper.query((String)"bd_bomversion", (String)"id,effectdate,invaliddate", (QFilter[])new QFilter[]{new QFilter("id", "in", verSet)});
        Date date = null;
        Long versionId = 0L;
        for (DynamicObject obj : verCol) {
            if (unfoldBomDate.before(obj.getDate("effectdate")) || unfoldBomDate.after(obj.getDate("invaliddate")) || date != null && !date.before(obj.getDate("effectdate"))) continue;
            date = obj.getDate("effectdate");
            versionId = obj.getLong("id");
        }
        if (versionId == 0L) {
            for (DynamicObject obj : col) {
                if (obj.getLong("version") != 0L) continue;
                return obj;
            }
        } else {
            for (DynamicObject obj : col) {
                if (obj.getLong("version") != versionId.longValue()) continue;
                return obj;
            }
        }
        return null;
    }

    private static String getMaterialMftSelectFields() {
        StringBuilder selectFields = new StringBuilder("id,createorg,masterid,inwarorg,inwarehouse,inwarelocation,supplyorgunitid,warehouse,location,isstockallot,invinfosrc");
        return selectFields.toString();
    }

    private static String getMaterialPlanSelectFields() {
        StringBuilder selectFields = new StringBuilder("id,createorg,masterid,wastagerateformula,yield,plangroup,materialattr,operator,plantags,wastagerate,leadtimetype,materialattr,fixedleadtime,changeleadtime,changebatch,preprocessingtime,inspectionleadtime,postprocessingtime,inter_assist_type");
        return selectFields.toString();
    }
}

