/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldMapPolicy;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mpscmm.common.cache.PLanOrderCache;
import kd.mpscmm.common.consts.DropPlanOrderConst;
import kd.mpscmm.common.consts.PlanOrderConst;
import kd.mpscmm.common.entity.planorder.BomBaseData;
import kd.mpscmm.common.entity.planorder.PushOrderResult;
import kd.mpscmm.common.entity.planorder.WorkDayResult;
import kd.mpscmm.common.enums.MaterialAttrEnum;
import kd.mpscmm.msplan.business.inventory.InvLevel;
import kd.mpscmm.msplan.business.inventory.InvLevelEntry;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderBomEntryUtil;

public class PlanOrderHelper {
    private static final String BOM_KEY = "pdm_mftbom";
    private static final String MRP_DROPPLANORDERLOG = "mrp_dropplanorderlog";
    private static final ThreadLocal<SimpleDateFormat> DATETIME = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private static final String AUXPTYENTRY = "auxptyentry";
    private static final String ISUSEAUXPTY = "isuseauxpty";
    private static final String ISAFFECTPLAN = "isaffectplan";
    private static final String AUXPTY = "auxpty";
    private static final String BD_AUXPROPERTY = "bd_auxproperty";
    private static final String _SPLIT_ = "_";
    private static final Log log = LogFactory.getLog(PlanOrderHelper.class);

    public static BigDecimal calculateStandQty(int precision, String qtyType, BigDecimal useratio, BigDecimal orderQty, BigDecimal qtynumerator, BigDecimal qtydenominator) {
        return PlanOrderHelper.calculateStandQty(precision, 4, qtyType, useratio, orderQty, qtynumerator, qtydenominator);
    }

    public static BigDecimal calculateStandQty(int precision, int roundingMode, String qtyType, BigDecimal useratio, BigDecimal orderQty, BigDecimal qtynumerator, BigDecimal qtydenominator) {
        BigDecimal standQty = BigDecimal.ZERO;
        if (StringUtils.equals((CharSequence)qtyType, (CharSequence)"A") || StringUtils.equals((CharSequence)qtyType, (CharSequence)"C")) {
            standQty = orderQty.multiply(useratio).multiply(qtynumerator).divide(qtydenominator, precision, roundingMode);
        } else if (StringUtils.equals((CharSequence)qtyType, (CharSequence)"B")) {
            standQty = useratio.multiply(qtynumerator).divide(qtydenominator, precision, roundingMode);
        }
        return standQty;
    }

    public static BigDecimal calculateDemadQty(String wastagerateformula, int precision, boolean isconsiderloss, BigDecimal standqty, BigDecimal scraprate, BigDecimal fixscrap) {
        return PlanOrderHelper.calculateDemadQty(wastagerateformula, precision, 4, isconsiderloss, standqty, scraprate, fixscrap);
    }

    public static BigDecimal calculateDemadQty(String wastagerateformula, int precision, int roundMode, boolean isconsiderloss, BigDecimal standqty, BigDecimal scraprate, BigDecimal fixscrap) {
        BigDecimal demandQty = standqty;
        if (isconsiderloss) {
            if (StringUtils.equals((CharSequence)"A", (CharSequence)wastagerateformula)) {
                demandQty = standqty.divide(BigDecimal.ONE.subtract(scraprate), precision, roundMode).add(fixscrap);
            } else if (StringUtils.equals((CharSequence)"B", (CharSequence)wastagerateformula)) {
                demandQty = standqty.multiply(BigDecimal.ONE.add(scraprate)).add(fixscrap);
            }
        }
        demandQty = demandQty.setScale(precision, roundMode);
        return demandQty;
    }

    public static Tuple<Long, List<DynamicObject>> getBomAndChildEntryInfo(DynamicObject planOrder, Long orgId, Map<String, Date> requireDateMap, Date requireDate, Map<Long, BigDecimal> standQtyMap, Map<Long, BigDecimal> requireQtyMap) {
        HashSet<Long> bomEntryIdSet = new HashSet<Long>(16);
        List<BomBaseData> bomBaseDataList = PlanOrderBomEntryUtil.getBomChildEntryInfos(null, planOrder, bomEntryIdSet, standQtyMap, requireQtyMap);
        DynamicObject material = planOrder.getDynamicObject("material");
        long materialId = material.getLong("id");
        Long bomId = 0L;
        for (BomBaseData bomBaseData : bomBaseDataList) {
            Long pMaterialId = bomBaseData.getPMaterialid();
            if (pMaterialId != materialId || bomBaseData.getBomId() == null) continue;
            bomId = bomBaseData.getBomId();
            break;
        }
        requireDateMap.put(bomId.toString(), requireDate);
        List<DynamicObject> bomEntryList = PlanOrderHelper.buildBomEntryInfo(orgId, bomId, bomBaseDataList, bomEntryIdSet, requireDateMap);
        return new Tuple((Object)bomId, bomEntryList);
    }

    public static List<DynamicObject> getBomChildEntryInfo(DynamicObject bomInfo, DynamicObject planorder, BigDecimal qty, Date expendbomtime, Long orgId, Map<String, Date> requireDateMap, Map<Long, BigDecimal> standQtyMap, Map<Long, BigDecimal> requireQtyMap) {
        if (bomInfo == null) {
            return null;
        }
        Long bomid = bomInfo.getLong("id");
        HashSet<Long> bomEntryIdSet = new HashSet<Long>(16);
        List<BomBaseData> bomBaseDataList = PlanOrderBomEntryUtil.getBomChildEntryInfos(bomInfo, planorder, bomEntryIdSet, standQtyMap, requireQtyMap);
        return PlanOrderHelper.buildBomEntryInfo(orgId, bomid, bomBaseDataList, bomEntryIdSet, requireDateMap);
    }

    private static List<DynamicObject> buildBomEntryInfo(Long orgId, Long bomId, List<BomBaseData> bomBaseDataList, Set<Long> bomEntryIdSet, Map<String, Date> requireDateMap) {
        ArrayList<DynamicObject> returnColl = new ArrayList<DynamicObject>(bomBaseDataList.size());
        DynamicObjectCollection bomEntryList = QueryServiceHelper.query((String)BOM_KEY, (String)PlanOrderHelper.selectBOMEntryPropertites(), (QFilter[])new QFilter[]{new QFilter("entry.id", "in", bomEntryIdSet)});
        HashMap<Long, DynamicObject> bomEntryMap = new HashMap<Long, DynamicObject>(bomEntryList.size());
        for (DynamicObject bomEntry : bomEntryList) {
            bomEntryMap.put(bomEntry.getLong("entry.id"), bomEntry);
        }
        CloneUtils cloneUtils = new CloneUtils(false, false);
        for (BomBaseData bomBaseData : bomBaseDataList) {
            Long entryId = bomBaseData.getBomEntryId();
            Date reqDate = requireDateMap.get(bomId.toString());
            DynamicObject bomentry = (DynamicObject)bomEntryMap.get(entryId);
            if (bomentry.get("entry.entrymaterialid") == null || bomentry.getLong("entry.entrymaterialid") == 0L) {
                bomentry = (DynamicObject)cloneUtils.clone((IDataEntityBase)bomentry);
                bomentry.set("entry.entrymaterialid", (Object)bomBaseData.getMaterilID());
            }
            String materialattr = bomentry.get("entry.entrymaterialattr") == null ? null : bomentry.get("entry.entrymaterialattr").toString().trim();
            Integer leadtime = bomentry.getInt("entry.entryleadtime");
            reqDate = PlanOrderHelper.getReqDate(reqDate, leadtime, orgId, materialattr);
            bomentry.set("entry.entryconfiguredcode", (Object)bomBaseData.getConfigedCodeId());
            bomentry.set("entry.entryqtydenominator", bomBaseData.getQtydenominator());
            bomentry.set("entry.entryqtynumerator", bomBaseData.getQtynumerator());
            requireDateMap.put(entryId.toString(), reqDate);
            returnColl.add(bomentry);
        }
        return returnColl;
    }

    public static List<DynamicObject> getBomChildEntryInfo(DynamicObject bomInfo, BigDecimal qty, Date expendbomtime, Long orgId, Map<String, Date> requireDateMap) {
        if (bomInfo == null) {
            return null;
        }
        HashMap<String, BigDecimal> qtyMapCache = new HashMap<String, BigDecimal>();
        DynamicObjectCollection bomEntrys = bomInfo.getDynamicObjectCollection("entry");
        ArrayList<DynamicObject> retrunColl = new ArrayList<DynamicObject>(bomEntrys.size());
        HashMap<Object, BigDecimal> wastagerateMap = new HashMap<Object, BigDecimal>(bomEntrys.size());
        PlanOrderHelper.changeLadToFix(bomEntrys, qty, expendbomtime, qtyMapCache, wastagerateMap);
        ArrayList<DynamicObject> loopBomEntryCollection = new ArrayList<DynamicObject>();
        loopBomEntryCollection.addAll((Collection)bomEntrys.clone());
        BigDecimal qtyentrybatchstartqty = BigDecimal.ZERO;
        BigDecimal qtyentrybatchendqty = BigDecimal.ZERO;
        DynamicObject childinfo = null;
        while (!loopBomEntryCollection.isEmpty()) {
            DynamicObject createorg;
            DynamicObject loopBomEntryInfo = (DynamicObject)loopBomEntryCollection.get(0);
            BigDecimal parentqty = (BigDecimal)qtyMapCache.get(loopBomEntryInfo.getPkValue().toString());
            String pentryqtytype = loopBomEntryInfo.get("entryqtytype") == null ? null : loopBomEntryInfo.get("entryqtytype").toString();
            DynamicObject parent = (DynamicObject)loopBomEntryInfo.getParent();
            String bomid = parent != null ? parent.getPkValue().toString() : "";
            Date reqDate = requireDateMap.get(bomid);
            String materialattr = loopBomEntryInfo.get("entrymaterialattr") == null ? null : loopBomEntryInfo.get("entrymaterialattr").toString().trim();
            Integer leadtime = loopBomEntryInfo.getInt("entryleadtime");
            reqDate = PlanOrderHelper.getReqDate(reqDate, leadtime, orgId, materialattr);
            requireDateMap.put(loopBomEntryInfo.getPkValue().toString(), reqDate);
            BigDecimal entryqtynumerator = loopBomEntryInfo.getBigDecimal("entryqtynumerator");
            BigDecimal entryqtydenominator = loopBomEntryInfo.getBigDecimal("entryqtydenominator");
            BigDecimal entryfixscrap = loopBomEntryInfo.getBigDecimal("entryfixscrap");
            BigDecimal entryscraprate = loopBomEntryInfo.getBigDecimal("entryscraprate");
            DynamicObject materialInfo = loopBomEntryInfo.getDynamicObject("entrymaterial");
            DynamicObject version = (DynamicObject)loopBomEntryInfo.get("entryversion");
            boolean isjumplevel = loopBomEntryInfo.getBoolean("entryisjumplevel");
            if (isjumplevel && (childinfo = PlanOrderHelper.getBomByOrgAndVersion((createorg = ((DynamicObject)loopBomEntryInfo.getParent()).getDynamicObject("createorg")).getPkValue(), version == null ? null : version.getPkValue(), materialInfo.getPkValue())) != null && childinfo.getDynamicObjectCollection("entry") != null && !childinfo.getDynamicObjectCollection("entry").isEmpty()) {
                requireDateMap.put(childinfo.getPkValue().toString(), reqDate);
                DynamicObjectCollection childBomEntrys = childinfo.getDynamicObjectCollection("entry");
                for (DynamicObject childBomentryInfo : childBomEntrys) {
                    DynamicObjectCollection qtyentrys;
                    String entryqtytype;
                    Date entryvaliddate = childBomentryInfo.getDate("entryvaliddate");
                    Date entryinvaliddate = childBomentryInfo.getDate("entryinvaliddate");
                    if (expendbomtime.compareTo(entryvaliddate) < 0 || expendbomtime.compareTo(entryinvaliddate) > 0) continue;
                    DynamicObject unit = childBomentryInfo.getDynamicObject("entryunit");
                    int precision = unit == null ? 2 : (unit.get("precision") == null ? 2 : childBomentryInfo.getDynamicObject("entryunit").getInt("precision"));
                    BigDecimal entryqty = childBomentryInfo.getBigDecimal("entryqtynumerator").divide(childBomentryInfo.getBigDecimal("entryqtydenominator"), precision, 4);
                    String string = entryqtytype = childBomentryInfo.get("entryqtytype") == null ? null : childBomentryInfo.get("entryqtytype").toString();
                    if (StringUtils.equals((CharSequence)entryqtytype, (CharSequence)"C") && (qtyentrys = childBomentryInfo.getDynamicObjectCollection("qtyentry")) != null && !qtyentrys.isEmpty()) {
                        for (DynamicObject qtyentry : qtyentrys) {
                            qtyentrybatchstartqty = qtyentry.getBigDecimal("qtyentrybatchstartqty");
                            qtyentrybatchendqty = qtyentry.getBigDecimal("qtyentrybatchendqty");
                            if (parentqty.compareTo(qtyentrybatchstartqty) < 0 || parentqty.compareTo(qtyentrybatchendqty) >= 0) continue;
                            childBomentryInfo.set("entryqtynumerator", (Object)qtyentry.getBigDecimal("qtyentryqtynumerator"));
                            childBomentryInfo.set("entryqtydenominator", (Object)qtyentry.getBigDecimal("qtyentryqtydenominator"));
                            childBomentryInfo.set("entryfixscrap", (Object)qtyentry.getBigDecimal("qtyentryfixscrap"));
                            break;
                        }
                    }
                    if (!StringUtils.equals((CharSequence)entryqtytype, (CharSequence)"B")) {
                        childBomentryInfo.set("entryqtynumerator", (Object)childBomentryInfo.getBigDecimal("entryqtynumerator").multiply(entryqtynumerator));
                        childBomentryInfo.set("entryqtydenominator", (Object)childBomentryInfo.getBigDecimal("entryqtydenominator").multiply(entryqtydenominator));
                        childBomentryInfo.set("entryfixscrap", (Object)childBomentryInfo.getBigDecimal("entryfixscrap").multiply(entryfixscrap));
                        childBomentryInfo.set("entryscraprate", (Object)childBomentryInfo.getBigDecimal("entryscraprate").multiply(entryscraprate));
                        entryqty = parentqty.multiply(childBomentryInfo.getBigDecimal("entryqtynumerator").divide(childBomentryInfo.getBigDecimal("entryqtydenominator"), precision, 4));
                    }
                    qtyMapCache.put(childBomentryInfo.getPkValue().toString(), entryqty);
                    loopBomEntryCollection.add(1, childBomentryInfo);
                }
            }
            retrunColl.add(loopBomEntryInfo);
            loopBomEntryCollection.remove(loopBomEntryInfo);
        }
        return retrunColl;
    }

    public static Date getReqDate(Date reqDate, Integer leadtime, Long orgId, String materialattr) {
        if (leadtime == null || leadtime == 0) {
            return reqDate;
        }
        Date newDate = null;
        newDate = !MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr) ? PlanOrderHelper.getToWorkDate(leadtime, reqDate, orgId, materialattr) : PlanOrderHelper.getDate(reqDate, leadtime);
        reqDate = newDate == null ? PlanOrderHelper.getDate(reqDate, leadtime) : newDate;
        return reqDate;
    }

    private static void changeLadToFix(DynamicObjectCollection bomEntrys, BigDecimal qty, Date expendbomtime, Map<String, BigDecimal> qtyMapCache, Map<Object, BigDecimal> wastagerateMap) {
        if (bomEntrys == null || bomEntrys.isEmpty()) {
            return;
        }
        DynamicObjectCollection qtyentrys = null;
        BigDecimal entryqtynumerator = BigDecimal.ZERO;
        BigDecimal entryqtydenominator = BigDecimal.ZERO;
        BigDecimal qtyentrybatchstartqty = BigDecimal.ZERO;
        BigDecimal qtyentrybatchendqty = BigDecimal.ZERO;
        ArrayList<DynamicObject> removecoll = new ArrayList<DynamicObject>();
        for (DynamicObject bomentry : bomEntrys) {
            String entryqtytype;
            Date entryvaliddate = bomentry.getDate("entryvaliddate");
            Date entryinvaliddate = bomentry.getDate("entryinvaliddate");
            if (expendbomtime == null || entryvaliddate == null || expendbomtime.compareTo(entryvaliddate) < 0 || expendbomtime.compareTo(entryinvaliddate) > 0) {
                removecoll.add(bomentry);
                continue;
            }
            DynamicObject unit = bomentry.getDynamicObject("entryunit");
            int precision = unit == null ? 2 : (unit.get("precision") == null ? 2 : bomentry.getDynamicObject("entryunit").getInt("precision"));
            entryqtynumerator = bomentry.getBigDecimal("entryqtynumerator");
            entryqtydenominator = bomentry.getBigDecimal("entryqtydenominator");
            BigDecimal entryqty = entryqtynumerator.divide(entryqtydenominator, precision, 4).multiply(qty);
            String string = entryqtytype = bomentry.get("entryqtytype") == null ? null : bomentry.get("entryqtytype").toString();
            if (StringUtils.equals((CharSequence)entryqtytype, (CharSequence)"C")) {
                qtyentrys = bomentry.getDynamicObjectCollection("qtyentry");
                for (DynamicObject qtyentry : qtyentrys) {
                    qtyentrybatchstartqty = qtyentry.getBigDecimal("qtyentrybatchstartqty");
                    qtyentrybatchendqty = qtyentry.getBigDecimal("qtyentrybatchendqty");
                    if (qty.compareTo(qtyentrybatchstartqty) < 0 || qty.compareTo(qtyentrybatchendqty) > 0) continue;
                    bomentry.set("entryqtynumerator", (Object)qtyentry.getBigDecimal("qtyentryqtynumerator"));
                    bomentry.set("entryqtydenominator", (Object)qtyentry.getBigDecimal("qtyentryqtydenominator"));
                    bomentry.set("entryfixscrap", (Object)qtyentry.getBigDecimal("qtyentryfixscrap"));
                    entryqty = qty.multiply(qtyentry.getBigDecimal("qtyentryqtynumerator").divide(qtyentry.getBigDecimal("qtyentryqtydenominator"), precision, 4));
                    break;
                }
            }
            qtyMapCache.put(bomentry.getPkValue().toString(), entryqty);
        }
        bomEntrys.removeAll(removecoll);
    }

    public static void recalCulationQty(DynamicObject entry, DynamicObject newplanOrder, DynamicObject oldentry, int i, BigDecimal newOrderQty, BigDecimal oldOrderQty) {
        String wastagerateformula = entry.getString("wastagerateformula");
        int precision = 2;
        if (entry.getDynamicObject("entryunit") != null) {
            precision = entry.getDynamicObject("entryunit").get("precision") == null ? 2 : entry.getDynamicObject("entryunit").getInt("precision");
        }
        String entryqtytype = entry.getString("entryqtytype");
        BigDecimal useratio = new BigDecimal("100").divide(BigDecimal.valueOf(100L), 4, 4);
        BigDecimal entryscraprate = entry.getBigDecimal("entryscraprate");
        BigDecimal entryfixscrap = entry.getBigDecimal("entryfixscrap");
        BigDecimal entryqtynumerator = entry.getBigDecimal("entryqtynumerator");
        BigDecimal entryqtydenominator = entry.getBigDecimal("entryqtydenominator");
        BigDecimal entrystandqty = PlanOrderHelper.calculateStandQty(precision, entryqtytype, useratio, newOrderQty, entryqtynumerator, entryqtydenominator);
        DynamicObject entryreplaceplan = entry.getDynamicObject("entryreplaceplan");
        if (entryreplaceplan != null && oldentry != null) {
            BigDecimal oldentrystandqty = oldentry.getBigDecimal("entrystandqty");
            entrystandqty = oldentrystandqty.multiply(newOrderQty).divide(oldOrderQty, precision, 4);
        }
        String entryrepmaterials = entry.getString("entryrepmaterials");
        BigDecimal entryrequireqty = PlanOrderHelper.calculateDemadQty(wastagerateformula, precision, true, entrystandqty, entryscraprate, entryfixscrap);
        BigDecimal entryrepqty = entry.getBigDecimal("entryrepqty");
        if (StringUtils.isNotBlank((CharSequence)entryrepmaterials) && BigDecimal.ZERO.compareTo(entryrepqty) < 0) {
            entryrequireqty = BigDecimal.ZERO;
        }
        entry.set("entrystandqty", (Object)entrystandqty);
        entry.set("entryrequireqty", (Object)entryrequireqty);
        BigDecimal entrylossqty = entryrequireqty.subtract(entrystandqty);
        entry.set("entrylossqty", (Object)entrylossqty);
    }

    private static DynamicObject getBomByOrgAndVersion(Object orgPk, Object versionPK, Object materialpk) {
        if (orgPk == null || !(orgPk instanceof Long)) {
            return null;
        }
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)BOM_KEY, (Long)((Long)orgPk));
        QFilter qFilterBOMVersion = new QFilter("version", "is not null", versionPK);
        if (versionPK != null) {
            qFilterBOMVersion = new QFilter("version", "=", versionPK);
        }
        QFilter qFilterMater = new QFilter("material", "=", materialpk);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingle((String)BOM_KEY, (String)PlanOrderHelper.selectBOMPropertites(), (QFilter[])new QFilter[]{qFilterBOMVersion, qFilterMater, qFilterStatus, qFilterOrg, qFilterEnable});
    }

    public static DynamicObject getMaterialInfo(Long matrialId, Long orgId, String entityKey, String selectFields, IPageCache page) {
        return PlanOrderHelper.getMaterialInfo(matrialId, orgId, entityKey, selectFields, page, null);
    }

    public static Map<Object, DynamicObject> getMaterialMftInfos(List<Long> materialIds, Long orgId, String entityKey, String selectFields) {
        if (materialIds == null || materialIds.size() == 0 || orgId == 0L || StringUtils.isBlank((CharSequence)entityKey)) {
            return null;
        }
        HashMap<Object, DynamicObject> materialPlanMaps = new HashMap<Object, DynamicObject>(materialIds.size());
        long starttime = System.currentTimeMillis();
        QFilter qFilterMater = new QFilter("masterid", "in", materialIds);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId);
        DynamicObject[] data = BusinessDataServiceHelper.load((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{qFilterMater, qFilterStatus, qFilterOrg, qFilterEnable});
        HashMap<Object, DynamicObject> datas = new HashMap<Object, DynamicObject>(data.length);
        HashMap<Object, Map> materialdatas = new HashMap<Object, Map>(data.length);
        for (DynamicObject dobj : data) {
            datas.put(dobj.getPkValue(), dobj);
            DynamicObject material = dobj.getDynamicObject("masterid");
            materialdatas.computeIfAbsent(material.getPkValue(), k -> new HashMap()).put(dobj.getPkValue(), dobj);
        }
        Map<String, DynamicObject> createOrgMaterialInfoMap = PlanOrderHelper.getDataByCreateOrgData(datas);
        for (Long matrialId : materialIds) {
            DynamicObject materialPlan = createOrgMaterialInfoMap.get(orgId + _SPLIT_ + matrialId);
            if (materialPlan == null) continue;
            materialPlanMaps.put(matrialId, materialPlan);
        }
        materialIds.removeAll(materialPlanMaps.keySet());
        if (materialIds.size() == 0) {
            return materialPlanMaps;
        }
        for (Long matrialId : materialIds) {
            Map map = (Map)materialdatas.get(matrialId);
            DynamicObject plan = PlanOrderHelper.getDataByIdMin(map);
            materialPlanMaps.put(matrialId, plan);
        }
        long endtime = System.currentTimeMillis();
        log.info("planorder-insert-getMaterialInfo,\u83b7\u53d6\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff0c\u8017\u65f6" + (endtime - starttime) + "ms");
        return materialPlanMaps;
    }

    public static Map<Object, DynamicObject> getMaterialInfos(List<Long> materialIds, Long orgId, String entityKey, String selectFields, boolean isCheckCollaborativepart) {
        if (materialIds == null || materialIds.size() == 0 || orgId == 0L || StringUtils.isBlank((CharSequence)entityKey)) {
            return null;
        }
        HashMap<Object, DynamicObject> materialPlanMaps = new HashMap<Object, DynamicObject>(materialIds.size());
        long starttime = System.currentTimeMillis();
        QFilter qFilterMater = new QFilter("masterid", "in", materialIds);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId);
        QFilter qFilterAttr = null;
        qFilterAttr = new QFilter("materialattr", "!=", (Object)MaterialAttrEnum.PHANTOMPART.getValue());
        if (isCheckCollaborativepart) {
            qFilterAttr.and("materialattr", "!=", (Object)MaterialAttrEnum.COLLABORATIVEPART.getValue());
        }
        Map datas = BusinessDataServiceHelper.loadFromCache((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{qFilterMater, qFilterStatus, qFilterOrg, qFilterEnable, qFilterAttr});
        HashMap<Object, Map> materialdatas = new HashMap<Object, Map>(datas.size());
        for (DynamicObject dobj : datas.values()) {
            DynamicObject material = dobj.getDynamicObject("masterid");
            materialdatas.computeIfAbsent(material.getPkValue(), k -> new HashMap()).put(dobj.getPkValue(), dobj);
        }
        Map<String, DynamicObject> createOrgMaterialInfoMap = PlanOrderHelper.getDataByCreateOrgData(datas);
        ArrayList<Long> surplusId = new ArrayList<Long>();
        for (Long materialId : materialIds) {
            DynamicObject materialPlan = createOrgMaterialInfoMap.get(orgId + _SPLIT_ + materialId);
            if (materialPlan == null) {
                surplusId.add(materialId);
                continue;
            }
            materialPlanMaps.put(materialId, materialPlan);
        }
        if (surplusId.size() == 0) {
            return materialPlanMaps;
        }
        PlanOrderHelper.getInvLevels(surplusId, orgId, "msplan_invlevel", materialPlanMaps, isCheckCollaborativepart);
        surplusId.removeAll(materialPlanMaps.keySet());
        if (surplusId.size() == 0) {
            return materialPlanMaps;
        }
        for (Long matrialId : materialIds) {
            Map map = (Map)materialdatas.get(matrialId);
            DynamicObject plan = PlanOrderHelper.getDataByIdMin(map);
            materialPlanMaps.put(matrialId, plan);
        }
        long endtime = System.currentTimeMillis();
        log.info("planorder-insert-getMaterialInfo,\u83b7\u53d6\u7269\u6599\u8ba1\u5212\u4fe1\u606f\uff0c\u8017\u65f6" + (endtime - starttime) + "ms");
        return materialPlanMaps;
    }

    private static void getInvLevels(List<Long> materialIds, Long orgId, String entityKey, Map<Object, DynamicObject> materialPlanMaps, boolean isCheckCollaborativepart) {
        if (materialIds == null || materialIds.size() == 0 || orgId == 0L) {
            return;
        }
        Date date = new Date();
        QFilter qFilterMater = new QFilter("type", "=", (Object)"A");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId);
        Object qFilterAttr = null;
        Map data = BusinessDataServiceHelper.loadFromCache((String)entityKey, (String)"id,createorg", (QFilter[])new QFilter[]{qFilterMater, qFilterStatus, qFilterOrg, qFilterEnable, qFilterAttr});
        DynamicObject invLevelData = null;
        DynamicObject plan = null;
        Map<Long, DynamicObject> createOrgMaterialInfoMap = PlanOrderHelper.getDataByCreateOrg(data);
        invLevelData = createOrgMaterialInfoMap.get(orgId);
        if (invLevelData == null) {
            invLevelData = PlanOrderHelper.getDataByIdMin(data);
        }
        if (invLevelData != null) {
            InvLevel invLevel = new InvLevel(invLevelData.getPkValue(), date);
            for (Long materialId : materialIds) {
                plan = PlanOrderHelper.analysisInvLevel(invLevel, orgId, materialId, null, isCheckCollaborativepart);
                materialPlanMaps.put(materialId, plan);
            }
        }
    }

    public static DynamicObject getMaterialInfo(Long matrialId, Long orgId, String entityKey, String selectFields, IPageCache page, String materialattr, boolean isCheckCollaborativepart) {
        String materialPlanStr;
        if (matrialId == 0L || orgId == 0L || StringUtils.isBlank((CharSequence)entityKey)) {
            return null;
        }
        long starttime = System.currentTimeMillis();
        if (page != null && (materialPlanStr = page.get(entityKey + matrialId + orgId)) != null && !materialPlanStr.isEmpty()) {
            DynamicObject materialPlan = null;
            try {
                Object[] o = DynamicObjectSerializeUtil.deserialize((String)materialPlanStr, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityKey));
                materialPlan = (DynamicObject)o[0];
                long endtime = System.currentTimeMillis();
                log.info("planorder-insert-getMaterialInfo,\u83b7\u53d6\u7269\u6599\u8ba1\u5212\u4fe1\u606f\uff0c\u8017\u65f6" + (endtime - starttime) + "ms");
                return materialPlan;
            }
            catch (Exception e) {
                log.error("planorder-insert-getMaterialInfo,\u83b7\u53d6\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u62a5\u9519", (Throwable)e);
            }
        }
        QFilter qFilterMater = new QFilter("masterid", "=", (Object)matrialId);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId);
        QFilter qFilterAttr = null;
        if (StringUtils.isNotBlank((CharSequence)materialattr)) {
            qFilterAttr = new QFilter("materialattr", "=", (Object)materialattr);
        } else if (isCheckCollaborativepart) {
            qFilterAttr = new QFilter("materialattr", "!=", (Object)MaterialAttrEnum.COLLABORATIVEPART.getValue());
        }
        Map datas = BusinessDataServiceHelper.loadFromCache((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{qFilterMater, qFilterStatus, qFilterOrg, qFilterEnable, qFilterAttr});
        DynamicObject plan = null;
        Map<Long, DynamicObject> createOrgMaterialInfoMap = PlanOrderHelper.getDataByCreateOrg(datas);
        plan = createOrgMaterialInfoMap.get(orgId);
        if (plan == null) {
            plan = PlanOrderHelper.getInvLevel(matrialId, orgId, "msplan_invlevel", materialattr, isCheckCollaborativepart);
        }
        if (plan == null) {
            plan = PlanOrderHelper.getDataByIdMin(datas);
        }
        if (page != null && plan != null) {
            page.put(entityKey + matrialId + orgId, DynamicObjectSerializeUtil.serialize((Object[])new Object[]{plan}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityKey)));
        }
        long endtime = System.currentTimeMillis();
        log.info("planorder-insert-getMaterialInfo,\u83b7\u53d6\u7269\u6599\u8ba1\u5212\u4fe1\u606f\uff0c\u8017\u65f6" + (endtime - starttime) + "ms");
        return plan;
    }

    public static DynamicObject getMaterialPlanInfo(Long matrialId, Long orgId, String entityKey, String selectFields, QFilter qFilter) {
        if (matrialId == 0L || orgId == 0L || StringUtils.isBlank((CharSequence)entityKey)) {
            return null;
        }
        long starttime = System.currentTimeMillis();
        QFilter qFilterMater = new QFilter("masterid", "=", (Object)matrialId);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId);
        Object qFilterAttr = null;
        if (qFilter != null) {
            qFilterMater.and(qFilter);
        }
        DynamicObject[] data = BusinessDataServiceHelper.load((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{qFilterMater, qFilterStatus, qFilterOrg, qFilterEnable, qFilterAttr});
        DynamicObject plan = null;
        HashMap<Object, DynamicObject> datas = new HashMap<Object, DynamicObject>(data.length);
        for (DynamicObject dobj : data) {
            datas.put(dobj.getPkValue(), dobj);
        }
        Map<Long, DynamicObject> createOrgMaterialInfoMap = PlanOrderHelper.getDataByCreateOrg(datas);
        plan = createOrgMaterialInfoMap.get(orgId);
        if (plan == null) {
            plan = PlanOrderHelper.getDataByIdMin(datas);
        }
        long endtime = System.currentTimeMillis();
        log.info("planorder-insert-getMaterialInfo,\u83b7\u53d6\u7269\u6599\u8ba1\u5212\u4fe1\u606f\uff0c\u8017\u65f6" + (endtime - starttime) + "ms");
        return plan;
    }

    public static Map<Long, DynamicObject> getDataByCreateOrg(Map<Object, DynamicObject> datas) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(datas.size());
        for (DynamicObject data : datas.values()) {
            DynamicObject createorg = data.getDynamicObject("createorg");
            Long createorgId = createorg == null ? 0L : createorg.getLong("id");
            map.put(createorgId, data);
        }
        return map;
    }

    public static Map<String, DynamicObject> getDataByCreateOrgData(Map<Object, DynamicObject> datas) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(datas.size());
        for (DynamicObject data : datas.values()) {
            DynamicObject createorg = data.getDynamicObject("createorg");
            DynamicObject material = data.getDynamicObject("masterid");
            map.put(createorg.getPkValue() + _SPLIT_ + material.getPkValue(), data);
        }
        return map;
    }

    public static DynamicObject getDataByIdMin(Map<Object, DynamicObject> data) {
        DynamicObject plan = null;
        if (data != null && data.size() > 0) {
            TreeSet<Object> ts = new TreeSet<Object>(data.keySet());
            ts.comparator();
            Object id = ts.first();
            plan = data.get(id);
        }
        return plan;
    }

    public static DynamicObject getMaterialInfo(Long matrialId, Long orgId, String entityKey, String selectFields, IPageCache page, String materialattr) {
        return PlanOrderHelper.getMaterialInfo(matrialId, orgId, entityKey, selectFields, page, materialattr, true);
    }

    public static String selectBOMPropertites() {
        StringBuilder string = new StringBuilder("materialid,replaceno,type,status,enable,iscoproduct,version,createorg,material,material.masterid,ecn,material.materialattr,id,number, copentry.copentrytype,copentry.copentrymaterial,copentry.copentryversion,copentry.copentryunit,copentry.copentryqty,copentry.copentryoperation,copentry.copentryvaliddate,copentry.copentryinvaliddate,copentry.copentryauxproperty,copentry.copentryremark");
        return string.toString();
    }

    public static String selectBOMEntryPropertites() {
        StringBuilder string = new StringBuilder("id,materialid, entry.id,entry.seq,entry.entrymaterial,entry.entrymaterialattr,entry.entryversion,entry.entryunit,entry.entryunit.id,entry.entryunit.precision,entry.entryunit.precisionaccount,entry.entryqtytype,entry.entryqtynumerator,entry.entryqtydenominator,entry.entryfixscrap,entry.entryscraprate,entry.entryremark,entry.entryleadtime,entry.entrytimeunit,entry.entrysupplytype,entry.entrysupplymode,entry.entryisbackflush,entry.entryoperationnumber,entry.entryiskey,entry.entryisjumplevel,entry.entryownertype,entry.entryecn.invaliddate,entry.entryecn.validdate,entry.entryvaliddate,entry.entryinvaliddate,entry.entryecn,entry.entryecn.id,entry.entryecn.number,entry.entryreplaceplan, entry.entryreplaceplan.replacemethod, entry.entryreplaceplan.replacestra, entry.entryisreplace,entry.reppriority,entry.entryisreplaceplanmm,entry.entryconfiguredcode,entry.entryauxproperty,entry.entrymaterialid,entry.entrysupplyorg,entry.entrywarehouse,entry.entrylocation");
        return string.toString();
    }

    @Deprecated
    public static DynamicObject getCalendar(QFilter dateFilter, Long orgId, String isDef) {
        QFilter[] qfilters = PlanOrderHelper.getCalendarFilter(dateFilter, orgId);
        return qfilters == null ? null : BusinessDataServiceHelper.loadSingle((String)"mpdm_calendar", (String)"id,number, dateentry.workdate", (QFilter[])qfilters);
    }

    private static QFilter[] getCalendarFilter(QFilter dateFilter, Long orgId) {
        QFilter[] qfilters;
        Set<Long> calendarIds = PlanOrderHelper.getCalendarIds(orgId);
        if (calendarIds == null || calendarIds.isEmpty()) {
            return null;
        }
        if (dateFilter == null) {
            qfilters = new QFilter[1];
        } else {
            qfilters = new QFilter[2];
            qfilters[1] = dateFilter;
        }
        Long id = new ArrayList<Long>(calendarIds).get(0);
        qfilters[0] = new QFilter("id", "=", (Object)id).and("dateentry.datetype", "=", (Object)"1");
        return qfilters;
    }

    public static boolean dealAuxptyEntry(DynamicObject material, DynamicObject auxproperty) {
        boolean isUseauxpty = material.getBoolean(ISUSEAUXPTY);
        DynamicObjectCollection auxptyEntrys = material.getDynamicObjectCollection(AUXPTYENTRY);
        if (!isUseauxpty || auxptyEntrys == null || auxptyEntrys.size() == 0) {
            return false;
        }
        for (DynamicObject auxptyEntry : auxptyEntrys) {
            String flexfield;
            Boolean isAffectPlan = auxptyEntry.getBoolean(ISAFFECTPLAN);
            if (isAffectPlan.booleanValue() && auxproperty == null) {
                return true;
            }
            if (!isAffectPlan.booleanValue() || auxproperty == null) continue;
            DynamicObject auxpty = auxptyEntry.getDynamicObject(AUXPTY);
            String value = auxproperty.getString("value");
            if (value.contains(flexfield = PlanOrderHelper.getAuxptyDataFlexfield(auxpty))) continue;
            return true;
        }
        return false;
    }

    public static List<String> getAuxptyEntryMust(DynamicObject material) {
        ArrayList<String> array = new ArrayList<String>();
        boolean isUseauxpty = material.getBoolean(ISUSEAUXPTY);
        DynamicObjectCollection auxptyEntrys = material.getDynamicObjectCollection(AUXPTYENTRY);
        if (!isUseauxpty || auxptyEntrys == null || auxptyEntrys.size() == 0) {
            return array;
        }
        for (DynamicObject auxptyEntry : auxptyEntrys) {
            Boolean isAffectPlan = auxptyEntry.getBoolean(ISAFFECTPLAN);
            DynamicObject auxpty = auxptyEntry.getDynamicObject(AUXPTY);
            String flexfield = PlanOrderHelper.getAuxptyDataFlexfield(auxpty);
            if (!isAffectPlan.booleanValue()) continue;
            array.add(flexfield);
        }
        return array;
    }

    public static String getAuxptyDataFlexfield(DynamicObject auxpty) {
        DynamicObject auxptyData = BusinessDataServiceHelper.loadSingleFromCache((Object)auxpty.getPkValue(), (String)BD_AUXPROPERTY);
        String flexfield = auxptyData.getString("flexfield");
        return flexfield;
    }

    @Deprecated
    public static DynamicObjectCollection getDefCalendar(QFilter dateFilter, Long orgId) {
        QFilter[] qfilters = PlanOrderHelper.getCalendarFilter(dateFilter, orgId);
        if (qfilters == null) {
            return null;
        }
        DynamicObjectCollection colByOrg = QueryServiceHelper.query((String)"mpdm_calendar", (String)"id,number, dateentry.workdate workdate", (QFilter[])qfilters, (String)"dateentry.workdate");
        return colByOrg.isEmpty() ? null : colByOrg;
    }

    public static Set<Long> getCalendarIds(Long orgId) {
        return (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"ICalendarService", (String)"getCalendarIdSet", (Object[])new Object[]{orgId, "A", "B"});
    }

    public static Date getRecentWorkDate(Date date, Long orgId) {
        if (date == null) {
            return null;
        }
        return (Date)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"ICalendarService", (String)"getFirstWorkDate", (Object[])new Object[]{orgId, "A", "B", null, date, true});
    }

    public static Date getToWorkDate(int toDays, Date startDate, Long orgId) {
        return PlanOrderHelper.getToWorkDate(toDays, startDate, orgId, MaterialAttrEnum.FABRICATEDPART.getValue());
    }

    public static Date getToWorkDate(int toDays, Date startDate, Long orgId, String materialattr) {
        return PlanOrderHelper.getToWorkDateToDate(toDays, startDate, orgId, materialattr);
    }

    public static WorkDayResult getWorkDate(Long orgId) {
        WorkDayResult workDayResult = new WorkDayResult();
        List<Date> entrys = PlanOrderHelper.getCalendarEntryDates(orgId, true);
        if (entrys == null || entrys.isEmpty()) {
            return workDayResult;
        }
        Date startDate = null;
        Date endDate = null;
        HashMap<String, Integer> dateIndexMap = new HashMap<String, Integer>(entrys.size());
        HashMap<Integer, String> indexDateMap = new HashMap<Integer, String>(entrys.size());
        Integer index = 0;
        for (Date date : entrys) {
            date = PlanOrderHelper.getCompDate(date);
            if (index == 0) {
                startDate = date;
            }
            String formatDateTime = PlanOrderHelper.formatDateTime(date);
            dateIndexMap.put(formatDateTime, index);
            indexDateMap.put(index, formatDateTime);
            endDate = date;
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        workDayResult.setDateIndexMap(dateIndexMap);
        workDayResult.setIndexdateMap(indexDateMap);
        workDayResult.setStartDate(startDate);
        workDayResult.setEndDate(endDate);
        return workDayResult;
    }

    public static List<Date> getCalendarEntryDates(Long orgId, boolean onlyWorkDay) {
        JSONObject jsonObject = (JSONObject)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"ICalendarService", (String)"getCalendarData", (Object[])new Object[]{orgId, "A", "B", null, null, null});
        if (jsonObject == null || !jsonObject.getBoolean("issuccessful").booleanValue()) {
            return null;
        }
        JSONObject defCal = jsonObject.getJSONArray("data").getJSONObject(0);
        Map entryMap = defCal.getJSONObject("workdateentry").getInnerMap();
        ArrayList<Date> entrys = new ArrayList<Date>(entryMap.size());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (Map.Entry entry : entryMap.entrySet()) {
            if (onlyWorkDay && !"1".equals(entry.getValue())) continue;
            Date date = PlanOrderHelper.normalize(sdf, (String)entry.getKey());
            entrys.add(date);
        }
        entrys.sort(Date::compareTo);
        return entrys;
    }

    public static String formatDateTime(Date date) {
        return DATETIME.get().format(date);
    }

    public static Date normalize(SimpleDateFormat SDF_YYYY_MM_DD, String dateStr) {
        Date date;
        try {
            date = SDF_YYYY_MM_DD.parse(dateStr);
        }
        catch (ParseException e) {
            return new Date();
        }
        return date;
    }

    public static Date getCompDate(Date date) {
        if (date == null) {
            return date;
        }
        Calendar fromDate = Calendar.getInstance();
        fromDate.setTime(date);
        fromDate.clear(12);
        fromDate.clear(13);
        fromDate.clear(14);
        fromDate.set(11, 0);
        return fromDate.getTime();
    }

    public static Date getToWorkDateToDate(int toDays, Date startDate, Long orgId, String materialattr) {
        if (toDays == 0) {
            return startDate;
        }
        if (MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            return PlanOrderHelper.getDate(startDate, toDays);
        }
        return (Date)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"ICalendarService", (String)"getRecentlyWorkDate", (Object[])new Object[]{orgId, "A", "B", null, startDate, toDays});
    }

    public static Date getToWorkDateToLastDate(int toDays, Date startDate, Long orgId, String materialattr) {
        return PlanOrderHelper.getToWorkDateToDate(toDays, startDate, orgId, materialattr);
    }

    public static Date getLastDateToDate(Long orgId) {
        List<Date> entrys = PlanOrderHelper.getCalendarEntryDates(orgId, false);
        return entrys == null || entrys.isEmpty() ? null : entrys.get(entrys.size() - 1);
    }

    public static int getSubtractWorkData(Date newDate, Date oldDate, Long orgId) {
        if (newDate == null || oldDate == null) {
            return 0;
        }
        List<Date> entrys = PlanOrderHelper.getCalendarEntryDates(orgId, true);
        int newIdx = -1;
        int oldIdx = -1;
        if (entrys != null) {
            for (int i = 0; i < entrys.size() - 1; ++i) {
                Date date = entrys.get(i);
                Date next = entrys.get(i + 1);
                if (date.compareTo(newDate) <= 0 && next.compareTo(newDate) > 0) {
                    newIdx = i;
                }
                if (date.compareTo(oldDate) <= 0 && next.compareTo(oldDate) > 0) {
                    oldIdx = i;
                }
                if (newIdx >= 0 && oldIdx >= 0) break;
            }
        }
        return newIdx - oldIdx;
    }

    public static Date getDate(Date date, int day) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, day);
        date = calendar.getTime();
        return date;
    }

    public static String getMenuParams(IFormView view, String params) {
        if (view != null && view.getFormShowParameter() != null && view.getFormShowParameter().getCustomParams() != null && view.getFormShowParameter().getCustomParams().get(params) != null) {
            return (String)view.getFormShowParameter().getCustomParams().get(params);
        }
        return "";
    }

    @Deprecated
    public static PushOrderResult dropPlanOrder(List<Long> planOrderIds, String entityNumber, String selectfield, Map<Long, BigDecimal> planOrderIdQtyMap, Map<Long, Map<String, Object>> dropLogMap) {
        return null;
    }

    public static PushOrderResult dropPlanOrder(List<Long> planOrderIds, String entityNumber, String selectfield, Map<Long, BigDecimal> planOrderIdQtyMap, Map<Long, Map<String, Object>> dropLogMap, String targetEntity) {
        PushOrderResult orderResult = new PushOrderResult();
        HashMap<Long, String> errors = new HashMap<Long, String>(planOrderIds.size());
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)entityNumber, (String)selectfield, (QFilter[])new QFilter[]{new QFilter("id", "in", planOrderIds)});
        planOrderIds = new ArrayList<Long>(orders.length);
        HashMap<Long, DynamicObject> orderMap = new HashMap<Long, DynamicObject>(orders.length);
        HashMap<Object, HashSet<Object>> orgMaterialsMap = new HashMap<Object, HashSet<Object>>(16);
        for (DynamicObject order : orders) {
            DynamicObject material = order.getDynamicObject("material");
            DynamicObject dept = order.getDynamicObject("proorpurorg");
            if (!"pom_mftorder".equals(targetEntity) && !"om_mftorder".equals(targetEntity)) continue;
            HashSet<Object> materialsSet = (HashSet<Object>)orgMaterialsMap.get(dept.getPkValue());
            if (materialsSet == null || materialsSet.size() == 0) {
                materialsSet = new HashSet<Object>(16);
            }
            materialsSet.add(material.getPkValue());
            orgMaterialsMap.put(dept.getPkValue(), materialsSet);
        }
        for (DynamicObject order : orders) {
            String error = PlanOrderHelper.checkPlanorderData(order, planOrderIdQtyMap);
            if (StringUtils.isNotBlank((CharSequence)error)) {
                Long orderId = Long.valueOf(order.getPkValue().toString());
                errors.put(orderId, error);
                continue;
            }
            Long planOrderId = Long.valueOf(order.getPkValue().toString());
            planOrderIds.add(planOrderId);
            orderMap.put(planOrderId, order);
        }
        Map<Long, String> updateErrors = PlanOrderHelper.updatePlanOrderStatus(planOrderIds, orderMap, planOrderIdQtyMap, dropLogMap, entityNumber, targetEntity);
        errors.putAll(updateErrors);
        orderResult.setErrorMap(errors);
        orderResult.setPlanOrderIds(planOrderIds);
        return orderResult;
    }

    public static Map<String, Long> getMaterialmftInfos(Map<Object, Set<Object>> orgMaterialsMap) {
        HashMap<String, Long> materialmftInfosMap = new HashMap<String, Long>(16);
        try {
            for (Map.Entry<Object, Set<Object>> orgMaterials : orgMaterialsMap.entrySet()) {
                Object orgId = orgMaterials.getKey();
                Long createorgId = Long.valueOf(orgId.toString());
                Set<Object> materialIds = orgMaterials.getValue();
                QFilter qFilterMater = new QFilter("masterid", "in", materialIds);
                QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
                QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
                QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)createorgId);
                QFilter[] filters = new QFilter[]{qFilterMater, qFilterStatus, qFilterEnable, basedataFilter};
                DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanOrderHelper.class.getName(), (String)"bd_materialmftinfo", (String)"id,masterid,createorg", (QFilter[])filters, null);
                Throwable throwable = null;
                try {
                    while (dataset.hasNext()) {
                        Row row = dataset.next();
                        Long id = row.getLong(0);
                        Long masterid = row.getLong(1);
                        Long createorgid = row.getLong(2);
                        String key = masterid + "&&" + orgId;
                        if (createorgId.equals(createorgid)) {
                            materialmftInfosMap.put(key, id);
                            continue;
                        }
                        if (materialmftInfosMap.get(key) != null) continue;
                        materialmftInfosMap.put(key, id);
                    }
                    dataset.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataset == null) continue;
                    if (throwable != null) {
                        try {
                            dataset.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dataset.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return materialmftInfosMap;
    }

    public static DynamicObject getInvLevel(Long materialId, Long orgId, String entityKey, String materialattr, boolean isCheckCollaborativepart) {
        if (materialId == 0L || orgId == 0L) {
            return null;
        }
        Date date = new Date();
        QFilter qFilterMater = new QFilter("type", "=", (Object)"A");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId);
        Object qFilterAttr = null;
        Map data = BusinessDataServiceHelper.loadFromCache((String)entityKey, (String)"id,createorg", (QFilter[])new QFilter[]{qFilterMater, qFilterStatus, qFilterOrg, qFilterEnable, qFilterAttr});
        DynamicObject invLevelData = null;
        DynamicObject plan = null;
        Map<Long, DynamicObject> createOrgMaterialInfoMap = PlanOrderHelper.getDataByCreateOrg(data);
        invLevelData = createOrgMaterialInfoMap.get(orgId);
        if (invLevelData == null) {
            invLevelData = PlanOrderHelper.getDataByIdMin(data);
        }
        if (invLevelData != null) {
            InvLevel invLevel = new InvLevel(invLevelData.getPkValue(), date);
            plan = PlanOrderHelper.analysisInvLevel(invLevel, orgId, materialId, materialattr, isCheckCollaborativepart);
        }
        return plan;
    }

    private static DynamicObject analysisInvLevel(InvLevel invLevel, Long orgId, Long materialId, String materialattr, boolean isCheckCollaborativepart) {
        DynamicObject plan = null;
        if (invLevel == null) {
            return plan;
        }
        InvLevelEntry entry = invLevel.getEntry(orgId, materialId);
        if (entry == null) {
            return plan;
        }
        DynamicObject invLevelEntry = entry.getEntry();
        if (invLevelEntry == null) {
            return plan;
        }
        String materialAttr = invLevelEntry.getString("materialattr");
        if (StringUtils.isBlank((CharSequence)materialattr) && (MaterialAttrEnum.PHANTOMPART.getValue().equals(materialAttr) || isCheckCollaborativepart && MaterialAttrEnum.COLLABORATIVEPART.getValue().equals(materialAttr))) {
            return plan;
        }
        if (StringUtils.isNotBlank((CharSequence)materialattr) && !materialAttr.equals(materialattr)) {
            return plan;
        }
        plan = BusinessDataServiceHelper.newDynamicObject((String)"mpdm_materialplan");
        plan.set("masterid", (Object)materialId);
        plan.set("materialattr", invLevelEntry.get("materialattr"));
        plan.set("yield", invLevelEntry.get("yield"));
        plan.set("operator", invLevelEntry.get("operator"));
        plan.set("plantags", invLevelEntry.get("plantag"));
        plan.set("leadtimetype", (Object)"A");
        plan.set("fixedleadtime", invLevelEntry.get("leadtime"));
        plan.set("wastagerateformula", (Object)invLevelEntry.getString("wastagerateformula"));
        plan.set("inspectionleadtime", invLevelEntry.get("inspectionleadtime"));
        plan.set("preprocessingtime", invLevelEntry.get("preprocessingtime"));
        plan.set("postprocessingtime", invLevelEntry.get("postprocessingtime"));
        return plan;
    }

    public static Map<Long, String> updatePlanOrderStatus(List<Long> planOrderIds, Map<Long, DynamicObject> orderMap, Map<Long, BigDecimal> planOrderIdQtyMap, Map<Long, Map<String, Object>> dropLogMap, String entityNumber, String targetEntity) {
        HashMap<Long, String> errors = new HashMap<Long, String>(16);
        if (planOrderIds == null || planOrderIds.size() == 0) {
            return errors;
        }
        ArrayList<Object[]> datas = new ArrayList<Object[]>(planOrderIds.size());
        try (TXHandle h0 = TX.requiresNew();){
            try {
                String updatesql = "update t_mrp_planorder set fdropstatus = ?,fqty =?,fdropqty =(fdropqty+?) where fid = ? and fdropstatus in('A','C',' ','','E') and forderqty>=(fdropqty+?);";
                for (Long orderId : planOrderIds) {
                    HashMap<String, Object> dropLog = new HashMap<String, Object>(2);
                    DynamicObject order = orderMap.get(orderId);
                    Object id = order.getPkValue();
                    BigDecimal qty = BigDecimal.ZERO;
                    BigDecimal dropQty = order.getBigDecimal("dropqty");
                    BigDecimal orderQty = order.getBigDecimal("orderqty");
                    String dropStatus = PlanOrderConst.DropStatusEnum.D.name();
                    if (planOrderIdQtyMap.get(orderId) != null) {
                        qty = planOrderIdQtyMap.get(orderId);
                        if (orderQty.compareTo(qty.add(dropQty)) > 0) {
                            dropStatus = PlanOrderConst.DropStatusEnum.C.name();
                        }
                    } else {
                        qty = orderQty.subtract(order.getBigDecimal("dropqty"));
                        planOrderIdQtyMap.put(orderId, qty);
                    }
                    dropLog.put("dropqty", qty);
                    dropLog.put("billno", order.getString("billno"));
                    dropLog.put("planorderid", orderId);
                    dropLog.put("soureorder", entityNumber);
                    dropLog.put("targetorder", targetEntity);
                    PlanOrderHelper.updateDropLogInfo(dropLog, order);
                    dropLogMap.put(orderId, dropLog);
                    Object[] params = new Object[]{dropStatus, qty, qty, id, qty};
                    datas.add(params);
                }
                if (datas.size() > 0) {
                    int[] result = DB.executeBatch((DBRoute)new DBRoute("scm"), (String)updatesql, datas);
                    for (int n = result.length - 1; n >= 0; --n) {
                        int isfail = result[n];
                        Long id = planOrderIds.get(n);
                        if (isfail == 0) {
                            DynamicObject order = orderMap.get(id);
                            String error = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u201c%s\u201d\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u6295\u653e\uff0c\u65e0\u6cd5\u518d\u6b21\u6295\u653e\u3002", (String)"PlanOrderHelper_0", (String)"mpscmm-msplan-business", (Object[])new Object[0]), order.getString("billno"));
                            planOrderIds.remove(n);
                            dropLogMap.remove(id);
                            errors.put(id, error);
                            continue;
                        }
                        PLanOrderCache.updateCrtlStrgyCache((String)id.toString(), (String)"true");
                    }
                }
                PlanOrderHelper.recordDropPlanorderLog(dropLogMap, DropPlanOrderConst.DropStatusEnum.B.name(), " ");
            }
            catch (Throwable throwable) {
                log.error("\u66f4\u65b0\u8ba1\u5212\u8ba2\u5355\u72b6\u6001\u5931\u8d25", throwable);
                h0.markRollback();
                Iterator<Long> iterator = planOrderIds.iterator();
                while (iterator.hasNext()) {
                    Long orderId = iterator.next();
                    DynamicObject order = orderMap.get(orderId);
                    String error = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u201c%s\u201d\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PlanOrderHelper_1", (String)"mpscmm-msplan-business", (Object[])new Object[0]), order.getString("billno"));
                    iterator.remove();
                    dropLogMap.remove(orderId);
                    errors.put(orderId, error);
                }
            }
        }
        return errors;
    }

    public static void recordDropFailLog(List<Long> orderIdsList, Map<Long, String> errorMap, Map<Long, DynamicObject> orderMap, String entityNumber, Map<Long, BigDecimal> planOrderIdQtyMap) {
        HashMap<Long, Map<String, Object>> dropLogMap = new HashMap<Long, Map<String, Object>>(16);
        for (Long orderId : orderIdsList) {
            HashMap<String, Object> dropLog = new HashMap<String, Object>(16);
            DynamicObject order = orderMap.get(orderId);
            if (order == null) {
                log.info("\u8bb0\u5f55\u5931\u8d25\u65e5\u5fd7\u65f6\u51fa\u73b0\u5f02\u5e38\u6570\u636e\uff0c\u6839\u636eid[{}]\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8ba1\u5212\u8ba2\u5355\u3002", (Object)orderId);
                continue;
            }
            String errorMsg = errorMap.get(orderId);
            if (StringUtils.isBlank((CharSequence)errorMsg)) {
                log.info("\u8ba1\u5212\u8ba2\u5355[{}]\u6ca1\u6709\u5bf9\u5e94\u7684\u9519\u8bef\u4fe1\u606f\uff0c\u4e0d\u8bb0\u5f55\u6295\u653e\u5931\u8d25\u65e5\u5fd7\u3002", (Object)orderId);
                continue;
            }
            BigDecimal dropQty = order.getBigDecimal("dropqty");
            BigDecimal orderQty = order.getBigDecimal("orderqty");
            BigDecimal qty = planOrderIdQtyMap != null && planOrderIdQtyMap.get(orderId) != null ? planOrderIdQtyMap.get(orderId) : orderQty.subtract(dropQty);
            dropLog.put("dropqty", qty);
            dropLog.put("billno", order.getString("billno"));
            dropLog.put("planorderid", orderId);
            dropLog.put("soureorder", entityNumber);
            dropLog.put("schedule", errorMsg);
            PlanOrderHelper.updateDropLogInfo(dropLog, order);
            dropLogMap.put(orderId, dropLog);
        }
        PlanOrderHelper.recordDropPlanorderLog(dropLogMap, DropPlanOrderConst.DropStatusEnum.E.name(), DropPlanOrderConst.DropFailTypeEnum.B.name());
    }

    public static void recordDropPlanorderLog(Map<Long, Map<String, Object>> dropLogMap, String dropstatus, String failtype) {
        ArrayList<DynamicObject> dropPlanorderLogs = new ArrayList<DynamicObject>(dropLogMap.size());
        long operator = RequestContext.get().getCurrUserId();
        Date operationdate = new Date();
        for (Map.Entry<Long, Map<String, Object>> dropLog : dropLogMap.entrySet()) {
            Object soureorder;
            Object targetbillno;
            Object targetorder;
            Map<String, Object> planorder = dropLog.getValue();
            BigDecimal qty = (BigDecimal)planorder.get("dropqty");
            String billno = (String)planorder.get("billno");
            Object tagnetorderId = planorder.get("targetorderid");
            DynamicObject dropPlanorderLog = BusinessDataServiceHelper.newDynamicObject((String)MRP_DROPPLANORDERLOG);
            dropPlanorderLog.set("operator", (Object)operator);
            dropPlanorderLog.set("operationdate", (Object)operationdate);
            dropPlanorderLog.set("billno", (Object)billno);
            dropPlanorderLog.set("dropqty", (Object)qty);
            dropPlanorderLog.set("planorderid", (Object)dropLog.getKey());
            dropPlanorderLog.set("failtype", (Object)failtype);
            dropPlanorderLog.set("tracknumber", planorder.get("tracknumber"));
            dropPlanorderLog.set("ordertype", planorder.get("ordertype"));
            Object schedule = planorder.get("schedule");
            if (StringUtils.isNotBlank((Object)schedule)) {
                dropPlanorderLog.set("schedule", schedule);
            }
            dropPlanorderLog.set("planorderid", (Object)dropLog.getKey());
            if (StringUtils.isNotBlank((Object)tagnetorderId)) {
                dropPlanorderLog.set("targetorderid", tagnetorderId);
            }
            if (StringUtils.isNotBlank((Object)(targetorder = planorder.get("targetorder")))) {
                dropPlanorderLog.set("targetorder", targetorder);
            }
            if (StringUtils.isNotBlank((Object)(targetbillno = planorder.get("targetbillno")))) {
                dropPlanorderLog.set("targetbillno", targetbillno);
            }
            if (StringUtils.isNotBlank((Object)(soureorder = planorder.get("soureorder")))) {
                dropPlanorderLog.set("soureorder", soureorder);
            }
            dropPlanorderLog.set("billtype", planorder.get("billtype"));
            dropPlanorderLog.set("proorpurorg", planorder.get("proorpurorg"));
            dropPlanorderLog.set("billstatus", planorder.get("billstatus"));
            dropPlanorderLog.set("org", planorder.get("org"));
            dropPlanorderLog.set("planscope", planorder.get("planscope"));
            dropPlanorderLog.set("material", planorder.get("material"));
            dropPlanorderLog.set("unit", planorder.get("unit"));
            dropPlanorderLog.set("configuredcode", planorder.get("configuredcode"));
            dropPlanorderLog.set("orderqty", planorder.get("orderqty"));
            dropPlanorderLog.set("supplier", planorder.get("supplier"));
            dropPlanorderLog.set("planoperatenum", planorder.get("planoperatenum"));
            dropPlanorderLog.set("dropstatus", (Object)dropstatus);
            dropPlanorderLogs.add(dropPlanorderLog);
        }
        SaveServiceHelper.save((DynamicObject[])dropPlanorderLogs.toArray(new DynamicObject[0]));
    }

    @Deprecated
    public static PushOrderResult push(String sourceEntity, String targetEntity, List<Long> sourceBillPks, DynamicObject[] orders, Map<Long, BigDecimal> planOrderIdQtyMap, Map<Long, Map<String, Object>> dropLogMap, String ruleId) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static PushOrderResult push(String sourceEntity, String targetEntity, List<Long> sourceBillPks, DynamicObject[] orders, Map<Long, BigDecimal> planOrderIdQtyMap, Map<Long, Map<String, Object>> dropLogMap, String ruleId, MainEntityType dataEntityType) {
        PushOrderResult pushOrderResult = new PushOrderResult();
        HashMap<Long, String> errorMap = new HashMap<Long, String>(sourceBillPks.size());
        try {
            if (StringUtils.isBlank((CharSequence)ruleId)) {
                StringBuilder error = new StringBuilder();
                error.append(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u5339\u914d\u7684\u8f6c\u6362\u89c4\u5219\uff0c\u6216\u8005\u539f\u59cb\u8f6c\u6362\u89c4\u5219\u88ab\u7981\u7528\u3002", (String)"PlanOrderHelper_2", (String)"mpscmm-msplan-business", (Object[])new Object[0]));
                PlanOrderHelper.failInfoUpdate(error.toString(), orders, pushOrderResult, errorMap, planOrderIdQtyMap, dropLogMap);
                return pushOrderResult;
            }
            ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(sourceBillPks.size());
            for (Long pk : sourceBillPks) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)pk);
                selectedRows.add(row);
            }
            PushArgs args = new PushArgs();
            args.setSourceEntityNumber(sourceEntity);
            args.setTargetEntityNumber(targetEntity);
            args.setRuleId(ruleId);
            args.setSelectedRows(selectedRows);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
            if (result.getBillReports().size() > 0) {
                for (SourceBillReport billReport : result.getBillReports()) {
                    if (billReport.isFullSuccess()) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u65f6\u4e0b\u63a8\u5355\u636e\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d", (String)"PlanOrderHelper_3", (String)"mpscmm-msplan-business", (Object[])new Object[0]));
                    stringBuilder.append(result.getMessage()).append('\u3002').append("\r\n");
                    stringBuilder.append(billReport.getRowInfo());
                    stringBuilder.append(':');
                    stringBuilder.append(billReport.buildSummary()).append('\u3002').append("\r\n");
                    Object billId = billReport.getBillId();
                    Long orderId = Long.valueOf(billId.toString());
                    errorMap.put(orderId, stringBuilder.toString());
                    log.error(stringBuilder.toString(), (Object)stringBuilder);
                }
                PlanOrderHelper.failInfoUpdate(pushOrderResult, errorMap, planOrderIdQtyMap, dropLogMap, dataEntityType);
            } else if (result.getBillReports().size() == 0) {
                String message = result.getMessage();
                String[] messages = message.split("&&");
                if (messages.length == 2) {
                    messages[0] = messages[0].replace("[", "");
                    messages[0] = messages[0].replace("]", "");
                    String[] stringArray = messages[0].split(",");
                    String errormessage = messages[1];
                    if (stringArray != null && stringArray.length > 0) {
                        StringBuilder error = new StringBuilder();
                        error.append(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u65f6\u4e0b\u63a8\u5355\u636e\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d", (String)"PlanOrderHelper_3", (String)"mpscmm-msplan-business", (Object[])new Object[0]));
                        error.append(String.format(ResManager.loadKDString((String)"%s\u3002", (String)"PlanOrderHelper_12", (String)"mpscmm-msplan-business", (Object[])new Object[0]), errormessage));
                        for (String id : stringArray) {
                            errorMap.put(Long.valueOf(id.trim()), error.toString());
                        }
                        log.error(error.toString(), (Object)error);
                    }
                    PlanOrderHelper.failInfoUpdate(pushOrderResult, errorMap, planOrderIdQtyMap, dropLogMap, dataEntityType);
                } else {
                    if (message.length() > 450) {
                        message = message.substring(0, 450);
                    }
                    PlanOrderHelper.rollbackPlanOrder(orders, errorMap, planOrderIdQtyMap);
                    for (DynamicObject dynamicObject : orders) {
                        Long orderId = dynamicObject.getLong("id");
                        errorMap.put(orderId, message);
                    }
                    pushOrderResult.setErrorMap(errorMap);
                }
            }
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
                }
            };
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
            List list = result.loadTargetDataObjects(refDataProvider, mainType);
            if (list == null || list.size() <= 0) {
                void var18_39;
                ArrayList<Long> remainingDataIds = new ArrayList<Long>(sourceBillPks.size());
                for (Long l : sourceBillPks) {
                    if (errorMap.containsKey(l)) continue;
                    remainingDataIds.add(l);
                }
                if (remainingDataIds.isEmpty()) {
                    pushOrderResult.setTargetOrders(new ArrayList());
                    return pushOrderResult;
                }
                PushOrderResult push = PlanOrderHelper.push(sourceEntity, targetEntity, remainingDataIds, orders, planOrderIdQtyMap, dropLogMap, ruleId, dataEntityType);
                List list2 = pushOrderResult.getTargetOrders();
                if (list2 == null) {
                    ArrayList arrayList = new ArrayList(10);
                }
                var18_39.addAll(push.getTargetOrders());
                pushOrderResult.setTargetOrders((List)var18_39);
                return pushOrderResult;
            }
            pushOrderResult.setTargetOrders(list);
            return pushOrderResult;
        }
        catch (Exception e) {
            String errorStr = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u4e0b\u63a8\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u6295\u653e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a", (String)"PlanOrderHelper_4", (String)"mpscmm-msplan-business", (Object[])new Object[0]);
            StringBuilder error = new StringBuilder();
            error.append(errorStr);
            error.append(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PlanOrderHelper_5", (String)"mpscmm-msplan-business", (Object[])new Object[0]), e.getMessage()));
            PlanOrderHelper.failInfoUpdate(error.toString(), orders, pushOrderResult, errorMap, planOrderIdQtyMap, dropLogMap);
            return pushOrderResult;
        }
    }

    private static void rollbackPlanOrder(DynamicObject[] orders, Map<Long, String> errorMap, Map<Long, BigDecimal> planOrderIdQtyMap) {
        for (DynamicObject planorder : orders) {
            Long orderId = planorder.getLong("id");
            String error = errorMap.get(orderId);
            if (StringUtils.isNotBlank((CharSequence)error)) continue;
            BigDecimal lastDropQty = planorder.getBigDecimal("dropqty").subtract(planOrderIdQtyMap.get(orderId));
            planorder.set("schedule", (Object)" ");
            if (lastDropQty.compareTo(BigDecimal.ZERO) > 0) {
                planorder.set("dropstatus", (Object)PlanOrderConst.DropStatusEnum.C.name());
            } else {
                planorder.set("dropstatus", (Object)PlanOrderConst.DropStatusEnum.A.name());
            }
            planorder.set("dropqty", (Object)lastDropQty);
        }
        SaveServiceHelper.update((DynamicObject[])orders);
    }

    private static void failInfoUpdate(Map<Long, String> errorMap, Map<Long, BigDecimal> planOrderIdQtyMap, Map<Long, Map<String, Object>> dropLogMap, MainEntityType dataEntityType) {
        DynamicObject[] planorders;
        HashMap<Long, Map<String, Object>> dropFailLogMap = new HashMap<Long, Map<String, Object>>(errorMap.size());
        for (DynamicObject planorder : planorders = BusinessDataServiceHelper.load((Object[])errorMap.keySet().toArray(new Object[0]), (DynamicObjectType)dataEntityType)) {
            Long orderId = planorder.getLong("id");
            String error = errorMap.get(orderId);
            if (error == null) continue;
            if (error.split("%s").length == 2) {
                error = String.format(error, planorder.getString("billno"));
            }
            if (error.length() > 450) {
                error = error.substring(0, 450);
            }
            planorder.set("schedule", (Object)error);
            errorMap.put(orderId, error);
            planorder.set("dropstatus", (Object)PlanOrderConst.DropStatusEnum.E.name());
            planorder.set("dropqty", (Object)planorder.getBigDecimal("dropqty").subtract(planOrderIdQtyMap.get(orderId)));
            Map<String, Object> dropLog = dropLogMap.get(orderId);
            dropLog.put("schedule", error);
            dropLog.put("failtype", "B");
            PlanOrderHelper.updateDropLogInfo(dropLog, planorder);
            dropLogMap.put(orderId, dropLog);
            dropFailLogMap.put(orderId, dropLog);
        }
        SaveServiceHelper.update((DynamicObject[])planorders);
        PlanOrderHelper.recordDropPlanorderLog(dropFailLogMap, DropPlanOrderConst.DropStatusEnum.E.name(), DropPlanOrderConst.DropFailTypeEnum.B.name());
    }

    private static void failInfoUpdate(PushOrderResult pushOrderResult, Map<Long, String> errorMap, Map<Long, BigDecimal> planOrderIdQtyMap, Map<Long, Map<String, Object>> dropLogMap, MainEntityType dataEntityType) {
        PlanOrderHelper.failInfoUpdate(errorMap, planOrderIdQtyMap, dropLogMap, dataEntityType);
        pushOrderResult.setErrorMap(errorMap);
    }

    public static void failInfoUpdate(String error, DynamicObject[] orders, PushOrderResult pushOrderResult, Map<Long, String> errorMap, Map<Long, BigDecimal> planOrderIdQtyMap, Map<Long, Map<String, Object>> dropLogMap) {
        HashMap<Long, Map<String, Object>> dropFailLogMap = new HashMap<Long, Map<String, Object>>(errorMap.size());
        for (DynamicObject planorder : orders) {
            String errorStr = error;
            if (error == null) continue;
            if (error.split("%s").length == 2) {
                errorStr = String.format(error, planorder.getString("billno"));
            }
            Long orderId = planorder.getLong("id");
            if (errorStr.length() > 450) {
                errorStr = errorStr.substring(0, 450);
            }
            errorMap.put(orderId, errorStr);
            planorder.set("dropstatus", (Object)PlanOrderConst.DropStatusEnum.E.name());
            planorder.set("schedule", (Object)errorStr);
            planorder.set("dropqty", (Object)planorder.getBigDecimal("dropqty").subtract(planOrderIdQtyMap.get(orderId)));
            Map<String, Object> dropLog = dropLogMap.get(orderId);
            dropLog.put("schedule", errorStr);
            dropLog.put("failtype", "B");
            PlanOrderHelper.updateDropLogInfo(dropLog, planorder);
            dropLogMap.put(orderId, dropLog);
            dropFailLogMap.put(orderId, dropLog);
        }
        SaveServiceHelper.update((DynamicObject[])orders);
        PlanOrderHelper.recordDropPlanorderLog(dropFailLogMap, DropPlanOrderConst.DropStatusEnum.E.name(), DropPlanOrderConst.DropFailTypeEnum.B.name());
        pushOrderResult.setErrorMap(errorMap);
        pushOrderResult.setTargetOrders(new ArrayList());
    }

    public static void updateDropLogInfo(Map<String, Object> dropLog, DynamicObject planorder) {
        dropLog.put("billtype", planorder.get("billtype"));
        dropLog.put("proorpurorg", planorder.get("proorpurorg"));
        dropLog.put("billstatus", planorder.get("billstatus"));
        dropLog.put("org", planorder.get("org"));
        dropLog.put("planscope", planorder.get("planscope"));
        dropLog.put("material", planorder.get("material"));
        dropLog.put("unit", planorder.get("unit"));
        dropLog.put("configuredcode", planorder.get("configuredcode"));
        dropLog.put("orderqty", planorder.get("orderqty"));
        dropLog.put("supplier", planorder.get("supplier"));
        dropLog.put("planoperatenum", planorder.get("planoperatenum"));
        dropLog.put("tracknumber", planorder.get("tracknumber"));
        dropLog.put("ordertype", planorder.get("ordertype"));
    }

    public static String checkPlanorderData(DynamicObject order, Map<Long, BigDecimal> planOrderIdQtyMap) {
        Long orderId;
        String error = "";
        boolean planOrderDropStatus = PLanOrderCache.getPlanOrderDropStatus((String)order.getString("id"));
        if (planOrderDropStatus) {
            error = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u201c%s\u201d\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u6295\u653e\uff0c\u65e0\u6cd5\u518d\u6b21\u6295\u653e\u3002", (String)"PlanOrderHelper_0", (String)"mpscmm-msplan-business", (Object[])new Object[0]), order.getString("billno"));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)BillStatus.C.name(), (CharSequence)order.getString("billstatus"))) {
            error = String.format(ResManager.loadKDString((String)"\u6240\u9009\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\uff0c\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\u3002", (String)"PlanOrderHelper_6", (String)"mpscmm-msplan-business", (Object[])new Object[0]), order.getString("billno"));
        }
        if (order.getString("billstatus").equals("D") || order.getString("dropstatus").equals(PlanOrderConst.DropStatusEnum.D.name())) {
            error = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u201c%s\u201d\u5df2\u6295\u653e\uff0c\u4e0d\u53ef\u91cd\u590d\u6295\u653e\u3002", (String)"PlanOrderHelper_7", (String)"mpscmm-msplan-business", (Object[])new Object[0]), order.getString("billno"));
        }
        if (planOrderIdQtyMap.get(orderId = Long.valueOf(order.getLong("id"))) != null) {
            BigDecimal dropqty = order.getBigDecimal("dropqty");
            BigDecimal orderqty = order.getBigDecimal("orderqty");
            BigDecimal qty = planOrderIdQtyMap.get(orderId);
            if (qty.add(dropqty).compareTo(orderqty) > 0) {
                error = String.format(ResManager.loadKDString((String)"\u6240\u9009\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\uff0c\u672c\u6b21\u6295\u653e\u6570\u91cf\u52a0\u5df2\u6295\u653e\u6570\u91cf\u8d85\u8fc7\u4e86\u8ba2\u5355\u6570\u91cf\u3002", (String)"PlanOrderHelper_8", (String)"mpscmm-msplan-business", (Object[])new Object[0]), order.getString("billno"));
            }
        }
        return error;
    }

    public static Map<Object, DynamicObject> getDropConfigures(Long orgId) {
        if (orgId == 0L) {
            return null;
        }
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)"msplan_dropconfigure", (Long)orgId);
        Map data = BusinessDataServiceHelper.loadFromCache((String)"msplan_dropconfigure", (QFilter[])new QFilter[]{qFilterStatus, qFilterOrg, qFilterEnable});
        return data;
    }

    public static DynamicObject getDropConfigure(Long orgId, IPageCache page) {
        String dropconfigureStr;
        if (orgId == 0L) {
            return null;
        }
        DynamicObject dropConfigure = null;
        long starttime = System.currentTimeMillis();
        if (page != null && (dropconfigureStr = page.get("msplan_dropconfigure" + orgId.toString())) != null && !dropconfigureStr.isEmpty()) {
            try {
                Object[] o = DynamicObjectSerializeUtil.deserialize((String)dropconfigureStr, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"msplan_dropconfigure"));
                dropConfigure = (DynamicObject)o[0];
                long endtime = System.currentTimeMillis();
                log.info("planorder-insert-getDropConfigure,\u83b7\u53d6\u6295\u653e\u914d\u7f6e\u4fe1\u606f\uff0c\u8017\u65f6" + (endtime - starttime) + "ms");
                return dropConfigure;
            }
            catch (Exception e) {
                log.error("planorder-insert-getDropConfigure,\u83b7\u53d6\u6295\u653e\u914d\u7f6e\u4fe1\u606f\u62a5\u9519", (Throwable)e);
            }
        }
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)"msplan_dropconfigure", (Long)orgId);
        Map data = BusinessDataServiceHelper.loadFromCache((String)"msplan_dropconfigure", (QFilter[])new QFilter[]{qFilterStatus, qFilterOrg, qFilterEnable});
        Map<Long, DynamicObject> createOrgMaterialInfoMap = PlanOrderHelper.getDataByCreateOrg(data);
        dropConfigure = createOrgMaterialInfoMap.get(orgId);
        if (dropConfigure == null) {
            dropConfigure = PlanOrderHelper.getDataByIdMin(data);
        }
        if (page != null && dropConfigure != null) {
            page.put("msplan_dropconfigure" + orgId.toString(), DynamicObjectSerializeUtil.serialize((Object[])new Object[]{dropConfigure}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"msplan_dropconfigure")));
        }
        long endtime = System.currentTimeMillis();
        log.info("planorder-insert-getDropConfigure,\u83b7\u53d6\u6295\u653e\u914d\u7f6e\u4fe1\u606f\uff0c\u8017\u65f6" + (endtime - starttime) + "ms");
        return dropConfigure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PushOrderResult saveTargetOrder(DynamicObject[] orders, String targetEntity, DynamicObject[] dynamicObjects, Map<Object, DynamicObject> targetOrderMap, Map<Long, BigDecimal> planOrderIdQtyMap, Map<Long, Map<String, Object>> dropLogMap, Date nowdate, String sourceLoadField, MainEntityType dataEntityType, String customOperation) {
        PushOrderResult orderResult = new PushOrderResult();
        HashMap<Long, String> errorMap = new HashMap<Long, String>(orders.length);
        Map<Long, DynamicObject> orderMap = Arrays.stream(orders).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        long starttime = System.currentTimeMillis();
        OperateOption option = OperateOption.create();
        OperationResult result = null;
        long endtime = System.currentTimeMillis();
        HashSet<Object> successIds = new HashSet<Object>(200);
        try {
            starttime = System.currentTimeMillis();
            option.setVariableValue("planInvokeOrderSave", "planInvokeOrderSave");
            option.setVariableValue("needlog", "true");
            result = OperationServiceHelper.executeOperate((String)customOperation, (String)targetEntity, (DynamicObject[])dynamicObjects, (OperateOption)option);
            endtime = System.currentTimeMillis();
            log.info("\u8ba1\u5212\u8ba2\u5355\u4e0b\u63a8\u5355\u636e\u4fdd\u5b58" + targetEntity + "\u8017\u65f6" + (endtime - starttime) + "ms");
            HashMap<Long, Map<String, Object>> dropSuccessLogMap = new HashMap<Long, Map<String, Object>>(200);
            PushOrderResult targetOrders = BusinessDataServiceHelper.load((String)targetEntity, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", targetOrderMap.keySet())});
            ArrayList<Long> successPkIds = new ArrayList<Long>(((DynamicObject[])targetOrders).length);
            for (DynamicObject targetorder : targetOrders) {
                Long successPkId = targetorder.getLong("id");
                DynamicObject targetOrder = targetOrderMap.get(successPkId);
                if (targetOrder == null) continue;
                successPkIds.add(successPkId);
                List<Long> sourceBillIds = PlanOrderHelper.getSourceBillId(targetOrder, targetEntity, sourceLoadField);
                successIds.addAll(sourceBillIds);
                for (Long planId : sourceBillIds) {
                    Map<String, Object> map = dropLogMap.get(planId);
                    map.put("targetorderid", successPkId);
                    map.put("targetorder", targetEntity);
                    map.put("targetbillno", targetorder.getString("billno"));
                    PlanOrderHelper.updateDropLogInfo(map, orderMap.get(planId));
                    log.info("\u8ba1\u5212\u8ba2\u5355\u4e0b\u63a8\u5355\u636e\u4fdd\u5b58\u4e0b\u6e38\u5355\u7f16\u7801\u4e3a" + targetorder.getString("billno"));
                    dropSuccessLogMap.put(planId, map);
                }
            }
            orderResult.setDropLogMap(dropSuccessLogMap);
            orderResult.setSuccessPkIds(successPkIds);
            if (!result.isSuccess()) {
                List allErrors;
                HashMap<Long, String> errorMessageMaps = new HashMap<Long, String>(result.getAllErrorOrValidateInfo().size());
                StringBuilder error = new StringBuilder();
                error.append(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"PlanOrderHelper_9", (String)"mpscmm-msplan-business", (Object[])new Object[0]));
                error.append(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\uff1a%s\u3002", (String)"PlanOrderHelper_10", (String)"mpscmm-msplan-business", (Object[])new Object[0]));
                if (StringUtils.isNotBlank((CharSequence)result.getMessage())) {
                    error.append(result.getMessage());
                }
                if ((allErrors = result.getAllErrorOrValidateInfo()) == null || allErrors.size() == 0) {
                    String errorStr = result.getMessage();
                    PlanOrderHelper.rollbackPlanOrder(errorStr, orders, successIds, errorMap, planOrderIdQtyMap);
                    orderResult.setErrorMap(errorMap);
                } else {
                    for (IOperateInfo info : allErrors) {
                        DynamicObject targetOrder;
                        Object pkValue = info.getPkValue();
                        if (successPkIds.contains(pkValue) || (targetOrder = targetOrderMap.get(pkValue)) == null) continue;
                        List<Long> sourceBillIds = PlanOrderHelper.getSourceBillId(targetOrder, targetEntity, sourceLoadField);
                        for (Long sourceBillId : sourceBillIds) {
                            StringBuilder infoerror = new StringBuilder();
                            String errorMessage = (String)errorMessageMaps.get(sourceBillId);
                            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                                errorMessageMaps.put(sourceBillId, infoerror.append(errorMessage).append(info.getMessage()).append("\n\r").toString());
                                continue;
                            }
                            errorMessageMaps.put(sourceBillId, infoerror.append((CharSequence)error).append(info.getMessage()).append("\n\r").toString());
                        }
                    }
                    PlanOrderHelper.failInfoUpdate(orderResult, errorMessageMaps, planOrderIdQtyMap, dropLogMap, dataEntityType);
                }
            }
            PushOrderResult pushOrderResult = orderResult;
            return pushOrderResult;
        }
        catch (Exception e) {
            log.error("\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage(), (Throwable)e);
            String errorStr = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u4fdd\u5b58\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u6295\u653e\u7cfb\u7edf\u7e41\u5fd9\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a", (String)"PlanOrderHelper_11", (String)"mpscmm-msplan-business", (Object[])new Object[0]);
            StringBuilder error = new StringBuilder();
            error.append(errorStr);
            error.append(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PlanOrderHelper_5", (String)"mpscmm-msplan-business", (Object[])new Object[0]), e.getMessage()));
            PlanOrderHelper.failInfoUpdate(error.toString(), orders, orderResult, errorMap, planOrderIdQtyMap, dropLogMap);
            PushOrderResult pushOrderResult = orderResult;
            return pushOrderResult;
        }
        finally {
            log.info("\u8ba1\u5212\u8ba2\u5355\u4e0b\u63a8\u5355\u636e\u4fdd\u5b58" + targetEntity + "-finally");
        }
    }

    @Deprecated
    public static List<Long> getsourceBillId(DynamicObject bill, String targetEntity) {
        return null;
    }

    public static List<Long> getSourceBillId(DynamicObject bill, String targetEntity, String sourceLoadField) {
        List<Long> sourceBills = null;
        String[] sourceLoadFields = sourceLoadField.split("\\.");
        int i = 0;
        sourceBills = PlanOrderHelper.getSourceBills(bill, sourceLoadFields, i, sourceBills);
        return sourceBills;
    }

    public static List<Long> getAllSourceBillIds(DynamicObject targetBill) {
        BillEntityType targetBillType = (BillEntityType)targetBill.getDataEntityType();
        Map allEntities = targetBillType.getAllEntities();
        ArrayList<Long> sourceBillIds = new ArrayList<Long>(16);
        for (Map.Entry allEntity : allEntities.entrySet()) {
            String key = (String)allEntity.getKey();
            EntityType entityType = (EntityType)allEntity.getValue();
            if (!(entityType instanceof LinkEntryType)) continue;
            LinkEntryType linkEntryType = (LinkEntryType)entityType;
            IDataEntityType parent = linkEntryType.getParent();
            if (parent instanceof EntryType) {
                DynamicObjectCollection targetBillEntrys = targetBill.getDynamicObjectCollection(parent.getName());
                for (DynamicObject targetBillEntry : targetBillEntrys) {
                    DynamicObjectCollection linkDatas = targetBillEntry.getDynamicObjectCollection(key);
                    linkDatas.stream().forEach(a -> sourceBillIds.add(a.getLong(key + "_sbillid")));
                }
                continue;
            }
            if (!(parent instanceof BillEntityType)) continue;
            DynamicObjectCollection linkDatas = targetBill.getDynamicObjectCollection(key);
            linkDatas.stream().forEach(a -> sourceBillIds.add(a.getLong(key + "_sbillid")));
        }
        return sourceBillIds;
    }

    public static void dealDropRequireqty(DynamicObject planorder, BigDecimal dropQty) {
        DynamicObjectCollection entrys = planorder.getDynamicObjectCollection("entryentity");
        BigDecimal orderQty = planorder.getBigDecimal("orderqty");
        for (DynamicObject entry : entrys) {
            BigDecimal entryRequireqQty = entry.getBigDecimal("entryrequireqty");
            DynamicObject entryUnit = entry.getDynamicObject("entryunit");
            int precision = 2;
            if (entryUnit != null) {
                precision = entryUnit.get("precision") == null ? 2 : entryUnit.getInt("precision");
            }
            BigDecimal entryDropRequireQty = BigDecimal.ZERO;
            if (orderQty.compareTo(BigDecimal.ZERO) != 0) {
                entryDropRequireQty = dropQty.multiply(entryRequireqQty).divide(orderQty, precision, 4);
            }
            entry.set("entrydroprequireqty", (Object)entryDropRequireQty);
        }
    }

    private static List<Long> getSourceBills(DynamicObject bill, String[] sourceLoadFields, int i, List<Long> sourceBills) {
        Long sourceBill = 0L;
        if (sourceBills == null) {
            sourceBills = new ArrayList<Long>(16);
        }
        if (sourceLoadFields[i] != null) {
            if (bill.get(sourceLoadFields[i]) instanceof Long || bill.get(sourceLoadFields[i]) instanceof String) {
                sourceBill = bill.getLong(sourceLoadFields[i]);
                sourceBills.add(sourceBill);
                log.info("\u8ba1\u5212\u8ba2\u5355\u6295\u653e\uff0c\u4ece\u4e0b\u6e38\u5355\u627e\u6e90\u5355id\uff0c\u6e90\u5355id\u5b57\u6bb5[{}]\uff0c\u5b57\u6bb5\u503c[{}]", (Object)sourceLoadFields[i], bill.get(sourceLoadFields[i]));
            } else if (bill.get(sourceLoadFields[i]) instanceof DynamicObjectCollection) {
                DynamicObjectCollection entityentrys = bill.getDynamicObjectCollection(sourceLoadFields[i]);
                ++i;
                for (DynamicObject entry : entityentrys) {
                    if (entry == null) continue;
                    PlanOrderHelper.getSourceBills(entry, sourceLoadFields, i, sourceBills);
                }
            }
        }
        return sourceBills;
    }

    public static String getSourceLoadField(ConvertRuleElement loadRule, String entry) {
        return PlanOrderHelper.getSourceLoadField(loadRule, entry, "id");
    }

    public static String getSourceLoadField(ConvertRuleElement loadRule, String entry, String idKey) {
        StringBuilder extendfieldName = new StringBuilder();
        String sourceLoad = "";
        if (StringUtils.isNotBlank((CharSequence)entry)) {
            StringBuilder str = new StringBuilder(entry);
            idKey = str.append('.').append(idKey).toString();
        }
        if (loadRule != null) {
            String targetEntity = loadRule.getTargetEntityNumber();
            FieldMapPolicy fieldMapPolicy = loadRule.getFieldMapPolicy();
            List fieldMaps = fieldMapPolicy.getFieldMaps();
            for (FieldMapItem fieldMap : fieldMaps) {
                String expression;
                CRFormula formula = fieldMap.getFormula();
                if (formula == null || !idKey.equals(expression = formula.getExpression())) continue;
                sourceLoad = fieldMap.getTargetFieldKey();
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)targetEntity);
            Map fields = dataEntityType.getAllFields();
            IDataEntityProperty property = (IDataEntityProperty)fields.get(sourceLoad);
            if (property != null && property.getParent() != null && property.getParent() instanceof EntryType) {
                IDataEntityType parent = property.getParent();
                if (parent.getParent() != null && parent.getParent() instanceof SubEntryType) {
                    extendfieldName.append(parent.getParent().getName()).append('.').append(parent.getName()).append('.').append(sourceLoad);
                } else {
                    extendfieldName.append(parent.getName()).append('.').append(sourceLoad);
                }
            } else {
                extendfieldName.append(sourceLoad);
            }
        }
        return extendfieldName.toString();
    }

    public static String getSourceLoadField(ConvertRuleElement loadRule) {
        return PlanOrderHelper.getSourceLoadField(loadRule, null);
    }

    public static void rollbackPlanOrder(String errorStr, DynamicObject[] orders, Set<Object> successIds, Map<Long, String> errorMap, Map<Long, BigDecimal> planOrderIdQtyMap) {
        ArrayList<DynamicObject> planOrders = new ArrayList<DynamicObject>(orders.length);
        for (DynamicObject planorder : orders) {
            Long orderId = planorder.getLong("id");
            if (successIds.contains(orderId)) continue;
            errorMap.put(orderId, errorStr);
            BigDecimal lastDropQty = planorder.getBigDecimal("dropqty").subtract(planOrderIdQtyMap.get(orderId));
            if (lastDropQty.compareTo(BigDecimal.ZERO) > 0) {
                planorder.set("dropstatus", (Object)PlanOrderConst.DropStatusEnum.C.name());
            } else {
                planorder.set("dropstatus", (Object)PlanOrderConst.DropStatusEnum.A.name());
            }
            planorder.set("schedule", (Object)" ");
            planorder.set("dropqty", (Object)lastDropQty);
            planOrders.add(planorder);
        }
        SaveServiceHelper.update((DynamicObject[])planOrders.toArray(new DynamicObject[0]));
    }

    @Deprecated
    public static String getTargetEntityByorderType(String orderType) {
        return null;
    }

    public static DynamicObject getMaterialMftInfo(Long matrialId, Long orgId, String entityKey, String selectFields, IPageCache page) {
        String materialPlanStr;
        if (matrialId == 0L || orgId == 0L || StringUtils.isBlank((CharSequence)entityKey)) {
            return null;
        }
        long starttime = System.currentTimeMillis();
        if (page != null && (materialPlanStr = page.get(entityKey + matrialId + orgId)) != null && !materialPlanStr.isEmpty()) {
            DynamicObject materialPlan = null;
            try {
                Object[] o = DynamicObjectSerializeUtil.deserialize((String)materialPlanStr, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityKey));
                materialPlan = (DynamicObject)o[0];
                long endtime = System.currentTimeMillis();
                log.info("planorder-insert-getMaterialInfo,\u83b7\u53d6\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff0c\u8017\u65f6" + (endtime - starttime) + "ms");
                return materialPlan;
            }
            catch (Exception e) {
                log.error("planorder-insert-getMaterialInfo,\u83b7\u53d6\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u62a5\u9519", (Throwable)e);
            }
        }
        QFilter qFilterMater = new QFilter("masterid", "=", (Object)matrialId);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId);
        Object qFilterAttr = null;
        DynamicObject[] data = BusinessDataServiceHelper.load((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{qFilterMater, qFilterStatus, qFilterOrg, qFilterEnable, qFilterAttr});
        DynamicObject mftinfo = null;
        HashMap<Object, DynamicObject> datas = new HashMap<Object, DynamicObject>(data.length);
        for (DynamicObject dobj : data) {
            datas.put(dobj.getPkValue(), dobj);
        }
        Map<Long, DynamicObject> createOrgMaterialInfoMap = PlanOrderHelper.getDataByCreateOrg(datas);
        mftinfo = createOrgMaterialInfoMap.get(orgId);
        if (mftinfo == null) {
            mftinfo = PlanOrderHelper.getDataByIdMin(datas);
        }
        if (page != null && mftinfo != null) {
            page.put(entityKey + matrialId + orgId, DynamicObjectSerializeUtil.serialize((Object[])new Object[]{mftinfo}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityKey)));
        }
        long endtime = System.currentTimeMillis();
        log.info("planorder-insert-getMaterialInfo,\u83b7\u53d6\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff0c\u8017\u65f6" + (endtime - starttime) + "ms");
        return mftinfo;
    }

    public static int getBatchSaveQty(String targetEntity, DynamicObject dropConfigure) {
        int batchSaveQty = 0;
        if (dropConfigure == null) {
            return batchSaveQty;
        }
        DynamicObjectCollection entrys = dropConfigure.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            String targetbill = entry.getDynamicObject("targetbill").getString("number");
            if (!targetEntity.equals(targetbill)) continue;
            batchSaveQty = entry.getInt("batchsaveqty");
        }
        return batchSaveQty;
    }

    public static String getTargetEntityByorderType(String orderType, DynamicObject dropConfigure) {
        String targetEntity = null;
        if (dropConfigure == null) {
            return null;
        }
        DynamicObjectCollection entrys = dropConfigure.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            String dataorderType = entry.getString("ordertype");
            boolean isDefault = entry.getBoolean("isdefault");
            if (!isDefault || !dataorderType.equals(orderType)) continue;
            targetEntity = entry.getDynamicObject("targetbill").getString("number");
        }
        return targetEntity;
    }

    public static void recalCulationCopentrysQty(DynamicObjectCollection copentrys, BigDecimal orderQty) {
        for (int i = 0; i < copentrys.size(); ++i) {
            DynamicObject copentry = (DynamicObject)copentrys.get(i);
            BigDecimal copentryqty = copentry.getBigDecimal("copentryqty");
            BigDecimal copentryallqty = copentryqty.multiply(orderQty);
            copentry.set("copentryallqty", (Object)copentryallqty);
        }
    }

    public static String getMaterialPlanSelectFields() {
        StringBuilder selectFields = new StringBuilder("id,createorg,masterid,wastagerateformula,yield,plangroup,materialattr,operator,plantags,wastagerate,leadtimetype,materialattr,fixedleadtime,changeleadtime,changebatch,preprocessingtime,inspectionleadtime,postprocessingtime");
        return selectFields.toString();
    }

    public static String getPlanOrderSelectFields() {
        StringBuilder selectFields = new StringBuilder("id,billno,billtype,isautoaudit,isautodrop,orderdate,ordertype,org,seq,entryentity,billstatus,bom,unfoldbomdate,proorpurorg,orderqty,yield,tracknumber,endproqty,startdate,enddate,availabledate,material,unit,materialplanid,materiallock,materialspread,configuredcode,auxproperty,entryentity.entrymaterial,entryentity.entryversion,entryentity.entrymode,entryentity.seq,copentry.seq,entryentity.entryrequiredate,entryentity.entryunit,copentry.copentryunit,entryentity.entryreplaceplan,entryentity.entryrequireqty,entryentity.entrystandqty,entryentity.entryscraprate,entryentity.entryconfiguredcode,copentry,copentry.id,modifytime,entryentity.entrymaterialplanid,entryentity.entryleadtime,entryentity.entryauxproperty,inwarehouse,supplyrule,planscope");
        return selectFields.toString();
    }
}

