/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.business.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mpscmm.common.consts.PlanScopeInitConst;
import kd.mpscmm.common.enums.PlanScopeInitStatusEnum;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;

public class PlanScopeHelper {
    private static final Log log = LogFactory.getLog(PlanScopeHelper.class);
    public static final String MSPLAN_MATPLANSCOP = "msplan_matplanscop";
    public static final String MSPLAN_PLANSCOPE_WHS = "msplan_planscope_whs";
    public static final String MRP_STOCKSUPPLY_POLICY = "mrp_stocksupply_policy";
    public static final String IM_WAREHOUSESETUP = "im_warehousesetup";
    public static final String PDM_MANUVERSION = "pdm_manuversion";

    public static boolean isEnablePlanScope() {
        QFilter[] filters;
        String selectFields = String.join((CharSequence)",", "enableplanscope", "initstatus");
        DynamicObject planScopeInit = QueryServiceHelper.queryOne((String)"msplan_planscopeinit", (String)selectFields, (QFilter[])(filters = new QFilter[]{new QFilter("id", "=", (Object)PlanScopeInitConst.PRE_INS_ID)}));
        if (planScopeInit == null) {
            return false;
        }
        boolean enablePlanScope = planScopeInit.getBoolean("enableplanscope");
        String initStatus = planScopeInit.getString("initstatus");
        return enablePlanScope && PlanScopeInitStatusEnum.INIT.getValue().equals(initStatus);
    }

    public static Long getPlanScope(Long orgId) {
        Long planScopeId = 0L;
        QFilter qFilterStatus = new QFilter("planscope.status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("planscope.enable", "=", (Object)"1");
        QFilter qFilterEffect = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterPlanscopeType = new QFilter("planscope.type", "=", (Object)"A");
        QFilter qFilterorg = new QFilter("planscope.createorg", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterorg, qFilterEffect, qFilterPlanscopeType};
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,createorg,planscope", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long planscopeid = row.getLong(2);
                if (createorgid.equals(orgId)) {
                    Long l = planScopeId = planscopeid;
                    return l;
                }
                planScopeId = planscopeid;
            }
            dataset.close();
        }
        return planScopeId;
    }

    public static List<Long> getPlanScopes(Long orgId) {
        ArrayList<Long> planScopeIds = new ArrayList<Long>();
        QFilter qFilterStatus = new QFilter("planscope.status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("planscope.enable", "=", (Object)"1");
        QFilter qFilterEffect = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterPlanscopeType = new QFilter("planscope.type", "=", (Object)"A");
        QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MSPLAN_PLANSCOPE_WHS, (Long)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, basedataFilter, qFilterEffect, qFilterPlanscopeType};
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,createorg,planscope", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long planscopeid = row.getLong(2);
                planScopeIds.add(planscopeid);
            }
            dataset.close();
        }
        return planScopeIds;
    }

    public static List<Long> getPlanScopes(List<Long> orgIds) {
        ArrayList<Long> planScopeIds = new ArrayList<Long>();
        QFilter qFilterStatus = new QFilter("planscope.status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("planscope.enable", "=", (Object)"1");
        QFilter qFilterEffect = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterPlanscopeType = new QFilter("planscope.type", "=", (Object)"A");
        QFilter qFilterorg = new QFilter("planscope.createorg", "in", orgIds);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterorg, qFilterEffect, qFilterPlanscopeType};
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,planscope", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long planscopeid = row.getLong(1);
                planScopeIds.add(planscopeid);
            }
            dataset.close();
        }
        return planScopeIds;
    }

    public static List<Long> getPlanScopes(List<Long> orgIds, QFilter qFilter) {
        ArrayList<Long> planScopeIds = new ArrayList<Long>();
        QFilter qFilterStatus = new QFilter("planscope.status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("planscope.enable", "=", (Object)"1");
        QFilter qFilterEffect = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterorg = new QFilter("planscope.createorg", "in", orgIds);
        if (qFilter != null) {
            qFilterorg.and(qFilter);
        }
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterorg, qFilterEffect};
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,planscope", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long planscopeid = row.getLong(1);
                planScopeIds.add(planscopeid);
            }
            dataset.close();
        }
        return planScopeIds;
    }

    public static List<Long> getPlanScopes(List<Long> orgIds, Long materialId) {
        ArrayList<Long> planScopeIds = new ArrayList<Long>(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterStartUseing = new QFilter("entrymatplanscop.start_useing", "=", (Object)"1");
        QFilter qFilterMaterial = new QFilter("material", "=", (Object)materialId);
        QFilter qFilterorg = new QFilter("entrymatplanscop.planscope.createorg", "in", orgIds);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterMaterial, qFilterorg, qFilterStartUseing};
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_MATPLANSCOP, (String)"id,entrymatplanscop.planscope", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long planScopeId = row.getLong(1);
                planScopeIds.add(planScopeId);
            }
            dataset.close();
        }
        return planScopeIds;
    }

    public static List<Long> getPlanScopes(Long materialId, Long orgId, Long purorgId) {
        ArrayList<Long> planScopeIds = new ArrayList<Long>(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterStartUseing = new QFilter("entrymatplanscop.start_useing", "=", (Object)"1");
        QFilter qFilterMaterial = new QFilter("material", "=", (Object)materialId);
        QFilter qFilterorg = new QFilter("createorg", "=", (Object)orgId);
        QFilter qFilterpurorg = new QFilter("createorg", "=", (Object)purorgId);
        qFilterorg.or(qFilterpurorg);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterMaterial, qFilterorg, qFilterStartUseing};
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_MATPLANSCOP, (String)"id,entrymatplanscop.planscope", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long planScopeId = row.getLong(1);
                planScopeIds.add(planScopeId);
            }
            dataset.close();
        }
        return planScopeIds;
    }

    public static List<Long> getPlanScopes(Long orgId, Long materialId) {
        return PlanScopeHelper.getPlanScopes(orgId, materialId, (QFilter)null);
    }

    public static List<Long> getPlanScopes(Long orgId, Long materialId, QFilter qFilterInterAssist) {
        List<Long> planScopeIds = new ArrayList(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterMaterial = new QFilter("material", "=", (Object)materialId);
        if (qFilterInterAssist != null) {
            qFilterMaterial.and(qFilterInterAssist);
        }
        QFilter qFilterStartUseing = new QFilter("entrymatplanscop.start_useing", "=", (Object)"1");
        QFilter orgFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterMaterial, orgFilter, qFilterStartUseing};
        HashMap<Long, List> createorgplanScopeMap = new HashMap<Long, List>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_MATPLANSCOP, (String)"id,createorg,entrymatplanscop.planscope", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long planScopeId = row.getLong(2);
                List planScopeList = createorgplanScopeMap.computeIfAbsent(createorgid, k -> new ArrayList(16));
                planScopeList.add(planScopeId);
            }
            dataset.close();
        }
        planScopeIds = (List)createorgplanScopeMap.get(orgId);
        if ((planScopeIds == null || planScopeIds.isEmpty()) && createorgplanScopeMap.size() > 0) {
            Iterator it = createorgplanScopeMap.entrySet().iterator();
            planScopeIds = (List)it.next().getValue();
        }
        return planScopeIds;
    }

    public static Map<String, Long> getInwareInfo(Long planScopeId, Long orgId, Long materialId) {
        Map<String, Long> inwareInfo = new HashMap(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterMaterial = new QFilter("material", "=", (Object)materialId);
        QFilter qFilterStartUseing = new QFilter("entrymatplanscop.start_useing", "=", (Object)"1");
        QFilter qFilterPlanscope = new QFilter("entrymatplanscop.planscope", "=", (Object)planScopeId);
        QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MSPLAN_MATPLANSCOP, (Long)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterMaterial, basedataFilter, qFilterPlanscope, qFilterStartUseing};
        HashMap<Long, Map> createorgInwareInfo = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_MATPLANSCOP, (String)"id,createorg,entrymatplanscop.in_storage_org,entrymatplanscop.in_storage_warehouse,entrymatplanscop.in_storage_shipping", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long in_storage_org = row.getLong(2);
                Long in_storage_warehouse = row.getLong(3);
                Long in_storage_shipping = row.getLong(4);
                Map inwareInfoMap = createorgInwareInfo.computeIfAbsent(createorgid, k -> new HashMap(16));
                inwareInfoMap.put("inwarorg", in_storage_org);
                inwareInfoMap.put("inwarehouse", in_storage_warehouse);
                inwareInfoMap.put("inwarelocation", in_storage_shipping);
            }
            dataset.close();
        }
        inwareInfo = (Map)createorgInwareInfo.get(orgId);
        if ((inwareInfo == null || inwareInfo.isEmpty()) && createorgInwareInfo.size() > 0) {
            Iterator it = createorgInwareInfo.entrySet().iterator();
            inwareInfo = (Map)it.next().getValue();
        }
        return inwareInfo;
    }

    public static Map<String, Long> getSupplierInfo(Long orgId, Long materialId) {
        HashMap<String, Long> supplierInfo = new HashMap(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterMaterial = new QFilter("material", "=", (Object)materialId);
        QFilter qFilterStartUseing = new QFilter("entrymatplanscop.start_useing", "=", (Object)"1");
        QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MSPLAN_MATPLANSCOP, (Long)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterMaterial, basedataFilter, qFilterStartUseing};
        HashMap<Long, Map> createorgsupplierInfo = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_MATPLANSCOP, (String)"id,createorg,entrymatplanscop.planscope,entrymatplanscop.supplier_org,entrymatplanscop.supplier_warehouse,entrymatplanscop.supplier_shipping", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long planscopeId = row.getLong(2);
                Long supplier_org = row.getLong(3);
                Long supplier_warehouse = row.getLong(4);
                Long supplier_shipping = row.getLong(5);
                Map planscopeAupplierInfoMap = createorgsupplierInfo.computeIfAbsent(createorgid, k -> new HashMap(16));
                Map supplierInfoMap = planscopeAupplierInfoMap.computeIfAbsent(planscopeId, k -> new HashMap(16));
                supplierInfoMap.put("entrysupplyorgunitid", supplier_org);
                supplierInfoMap.put("entrywarehouse", supplier_warehouse);
                supplierInfoMap.put("entrylocation", supplier_shipping);
            }
            dataset.close();
        }
        Map planscopeAupplierInfoMap = (Map)createorgsupplierInfo.get(orgId);
        if ((planscopeAupplierInfoMap == null || planscopeAupplierInfoMap.isEmpty()) && createorgsupplierInfo.size() > 0) {
            Iterator it = createorgsupplierInfo.entrySet().iterator();
            planscopeAupplierInfoMap = (Map)it.next().getValue();
        }
        if (planscopeAupplierInfoMap == null || planscopeAupplierInfoMap.isEmpty()) {
            return null;
        }
        supplierInfo = PlanScopeHelper.getSupplierInfoMap(planscopeAupplierInfoMap, orgId);
        return supplierInfo;
    }

    private static Map<String, Long> getSupplierInfoMap(Map<Long, Map<String, Long>> planscopeAupplierInfoMap, Long orgId) {
        Map warehouses;
        Map<String, Long> supplierInfo = new HashMap<String, Long>();
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEffectuate = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterWarehouse = new QFilter("planscope", "in", planscopeAupplierInfoMap.keySet());
        QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MSPLAN_PLANSCOPE_WHS, (Long)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, basedataFilter, qFilterWarehouse, qFilterEffectuate};
        HashMap<Long, Map> createorgPlanscopeWarehouse = new HashMap<Long, Map>();
        DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,createorg,warehouse,planscope", (QFilter[])filters, null);
        Object object = null;
        try {
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long warehouse = row.getLong(2);
                Long planscope = row.getLong(3);
                Map planscopeWarehouseList = createorgPlanscopeWarehouse.computeIfAbsent(createorgid, k -> new HashMap(16));
                List warehouseList = planscopeWarehouseList.computeIfAbsent(planscope, k -> new ArrayList(16));
                warehouseList.add(warehouse);
            }
            dataset.close();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataset != null) {
                if (object != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataset.close();
                }
            }
        }
        Map map = warehouses = createorgPlanscopeWarehouse.get(orgId) == null ? new HashMap() : (Map)createorgPlanscopeWarehouse.get(orgId);
        if (warehouses.isEmpty() && createorgPlanscopeWarehouse.size() > 0) {
            Iterator it = createorgPlanscopeWarehouse.entrySet().iterator();
            warehouses = (Map)it.next().getValue();
        }
        for (Map.Entry entry : planscopeAupplierInfoMap.entrySet()) {
            Long warehouse;
            Long planscopeId = (Long)entry.getKey();
            Map supplierMap = (Map)entry.getValue();
            List warehouseList = (List)warehouses.get(planscopeId);
            if (warehouseList == null || warehouseList.isEmpty() || supplierMap == null || (Long)supplierMap.get("entrywarehouse") == 0L || !warehouseList.contains(warehouse = (Long)supplierMap.get("entrywarehouse"))) continue;
            supplierInfo = supplierMap;
            break;
        }
        return supplierInfo;
    }

    public static Map<String, Map<String, Long>> getSupplierInfo(Long planScopeId, Long orgId, Long warehouseId, Set<Long> materialIds) {
        HashMap<String, Map<String, Long>> supplierInfo = new HashMap<String, Map<String, Long>>(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterMaterial = new QFilter("material", "in", materialIds);
        QFilter qFilterPlanscope = new QFilter("entrymatplanscop.planscope", "=", (Object)planScopeId);
        QFilter qFilterStartUseing = new QFilter("entrymatplanscop.start_useing", "=", (Object)"1");
        QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MSPLAN_MATPLANSCOP, (Long)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterMaterial, basedataFilter, qFilterPlanscope, qFilterStartUseing};
        HashMap<String, Map> createorgsupplierInfo = new HashMap<String, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_MATPLANSCOP, (String)"id,createorg,entrymatplanscop.supplier_org,entrymatplanscop.supplier_warehouse,entrymatplanscop.supplier_shipping,material", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long supplier_org = row.getLong(2);
                Long supplier_warehouse = row.getLong(3);
                Long supplier_shipping = row.getLong(4);
                Long materialId = row.getLong(5);
                Map computeIfAbsent = createorgsupplierInfo.computeIfAbsent(materialId + "" + orgId + "" + warehouseId, k -> new HashMap(16));
                Map supplierInfoMap = computeIfAbsent.computeIfAbsent(createorgid, k -> new HashMap(16));
                supplierInfoMap.put("entrysupplyorgunitid", supplier_org);
                supplierInfoMap.put("entrywarehouse", supplier_warehouse);
                supplierInfoMap.put("entrylocation", supplier_shipping);
            }
            dataset.close();
        }
        for (Map.Entry createorgsupplier : createorgsupplierInfo.entrySet()) {
            String key = (String)createorgsupplier.getKey();
            Map value = (Map)createorgsupplier.getValue();
            Map supplierInfoMap = (Map)value.get(orgId);
            if ((supplierInfoMap == null || supplierInfoMap.isEmpty()) && value.size() > 0) {
                Iterator it = value.entrySet().iterator();
                supplierInfoMap = (Map)it.next().getValue();
            }
            supplierInfo.put(key, supplierInfoMap);
        }
        return supplierInfo;
    }

    public static Map<String, Long> getSupplierInfo(Long supplierWarehouse, Long orgId, Long materialId) {
        Map<String, Long> supplierInfo = new HashMap<String, Long>(16);
        Map<String, Long> inwareInfoByInwarehouse = PlanScopeHelper.getInwareInfoByInwarehouse(supplierWarehouse, orgId);
        if (inwareInfoByInwarehouse == null || inwareInfoByInwarehouse.isEmpty() || inwareInfoByInwarehouse.get("planscope") == 0L) {
            return supplierInfo;
        }
        Long planScopeId = inwareInfoByInwarehouse.get("planscope");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterMaterial = new QFilter("material", "=", (Object)materialId);
        QFilter qFilterStartUseing = new QFilter("entrymatplanscop.start_useing", "=", (Object)"1");
        QFilter qFilterPlanscope = new QFilter("entrymatplanscop.planscope", "=", (Object)planScopeId);
        QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MSPLAN_MATPLANSCOP, (Long)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterMaterial, basedataFilter, qFilterPlanscope, qFilterStartUseing};
        HashMap<Long, Map> createorgsupplierInfo = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_MATPLANSCOP, (String)"id,createorg,entrymatplanscop.supplier_org,entrymatplanscop.supplier_warehouse,entrymatplanscop.supplier_shipping", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long supplier_org = row.getLong(2);
                Long supplier_warehouse = row.getLong(3);
                Long supplier_shipping = row.getLong(4);
                Map supplierInfoMap = createorgsupplierInfo.computeIfAbsent(createorgid, k -> new HashMap(16));
                supplierInfoMap.put("entrysupplyorgunitid", supplier_org);
                supplierInfoMap.put("entrywarehouse", supplier_warehouse);
                supplierInfoMap.put("entrylocation", supplier_shipping);
            }
            dataset.close();
        }
        supplierInfo = (Map)createorgsupplierInfo.get(orgId);
        if ((supplierInfo == null || supplierInfo.isEmpty()) && createorgsupplierInfo.size() > 0) {
            Iterator it = createorgsupplierInfo.entrySet().iterator();
            supplierInfo = (Map)it.next().getValue();
        }
        return supplierInfo;
    }

    public static Long getDataId(Object object) {
        Long dataid = 0L;
        if (object instanceof DynamicObject) {
            DynamicObject data = (DynamicObject)object;
            dataid = data.getLong("id");
        } else if (object instanceof Long) {
            dataid = (Long)object;
        }
        return dataid;
    }

    public static Long getInwareOrg(Long orgId, Long warehouseId) {
        Long inwareOrg = 0L;
        List<Long> storageorgs = PlanScopeHelper.getStocksupplyPolicy(orgId);
        QFilter isinit = new QFilter("initstatus", "=", (Object)"B");
        QFilter storageflt = new QFilter("org", "in", storageorgs);
        QFilter warehouseQf = new QFilter("warehouse", "in", (Object)warehouseId);
        QFilter[] qFilters = new QFilter[]{isinit, storageflt, warehouseQf};
        DynamicObjectCollection coll = QueryServiceHelper.query((String)IM_WAREHOUSESETUP, (String)"id,org", (QFilter[])qFilters);
        for (DynamicObject obj : coll) {
            inwareOrg = obj.getLong("org");
        }
        return inwareOrg;
    }

    public static List<Long> getInwareHouses(Long orgId) {
        ArrayList<Long> inwareHouses = new ArrayList<Long>(16);
        boolean enablePlanScope = PlanScopeHelper.isEnablePlanScope();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (enablePlanScope) {
            List<Long> storageorgs = PlanScopeHelper.getStocksupplyPolicy(orgId);
            filterList.add(new QFilter("org", "in", storageorgs));
        } else {
            filterList.add(new QFilter("org", "=", (Object)orgId));
        }
        filterList.add(new QFilter("initstatus", "=", (Object)"B"));
        filterList.add(new QFilter("startstatus", "=", (Object)"B"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)IM_WAREHOUSESETUP, (String)"warehouse.id", (QFilter[])filterList.toArray(new QFilter[0]));
        for (DynamicObject obj : coll) {
            inwareHouses.add(obj.getLong("warehouse.id"));
        }
        return inwareHouses;
    }

    private static List<Long> getStocksupplyPolicy(Long orgId) {
        List<Long> storageorgs = new ArrayList(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)MRP_STOCKSUPPLY_POLICY, (Long)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterOrg};
        HashMap<Long, List> createorginwareHouse = new HashMap<Long, List>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MRP_STOCKSUPPLY_POLICY, (String)"id,createorg,entryentity.storageorg", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long storageorg = row.getLong(2);
                List storageorgList = createorginwareHouse.computeIfAbsent(createorgid, k -> new ArrayList(16));
                storageorgList.add(storageorg);
            }
            dataset.close();
        }
        storageorgs = (List)createorginwareHouse.get(orgId);
        if ((storageorgs == null || storageorgs.isEmpty()) && createorginwareHouse.size() > 0) {
            Iterator it = createorginwareHouse.entrySet().iterator();
            storageorgs = (List)it.next().getValue();
        }
        return storageorgs;
    }

    public static Map<String, Long> getInwareInfoByInwarehouse(Long warehouseId, Long orgId) {
        Map<String, Long> inwareInfo = new HashMap(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEffectuate = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterWarehouse = new QFilter("warehouse", "=", (Object)warehouseId);
        QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MSPLAN_PLANSCOPE_WHS, (Long)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, basedataFilter, qFilterWarehouse, qFilterEffectuate};
        HashMap<Long, Map> createorgInwareInfo = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,createorg,planscope,invorg", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long planscope = row.getLong(2);
                Long in_storage_org = row.getLong(3);
                Map inwareInfoMap = createorgInwareInfo.computeIfAbsent(createorgid, k -> new HashMap(16));
                inwareInfoMap.put("inwarorg", in_storage_org);
                inwareInfoMap.put("planscope", planscope);
            }
            dataset.close();
        }
        inwareInfo = (Map)createorgInwareInfo.get(orgId);
        if ((inwareInfo == null || inwareInfo.isEmpty()) && createorgInwareInfo.size() > 0) {
            Iterator it = createorgInwareInfo.entrySet().iterator();
            inwareInfo = (Map)it.next().getValue();
        }
        return inwareInfo;
    }

    public static Map<Long, Long> getPlanscopeBywarehouses(Set<Long> warehouseIds, Long orgId) {
        HashMap<Long, Long> inwareInfo = new HashMap<Long, Long>(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEffectuate = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterWarehouse = new QFilter("warehouse", "in", warehouseIds);
        QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MSPLAN_PLANSCOPE_WHS, (Long)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, basedataFilter, qFilterWarehouse, qFilterEffectuate};
        HashMap<Long, Map> createorgInwareInfo = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,createorg,planscope,warehouse", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long planscope = row.getLong(2);
                Long warehouse = row.getLong(3);
                Map inwareInfoMap = createorgInwareInfo.computeIfAbsent(warehouse, k -> new HashMap(16));
                inwareInfoMap.put(createorgid, planscope);
            }
            dataset.close();
        }
        for (Map.Entry createorgsupplier : createorgInwareInfo.entrySet()) {
            Long key = (Long)createorgsupplier.getKey();
            Map value = (Map)createorgsupplier.getValue();
            Long planscopeId = (Long)value.get(orgId);
            if ((planscopeId == null || planscopeId == 0L) && value.size() > 0) {
                Iterator it = value.entrySet().iterator();
                planscopeId = (Long)it.next().getValue();
            }
            inwareInfo.put(key, planscopeId);
        }
        return inwareInfo;
    }

    public static Map<String, Long> getInwareInfoByInwarehouse(Long warehouseId, Long orgId, Boolean isIninvWhs) {
        Map<String, Long> inwareInfo = new HashMap(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEffectuate = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterWarehouse = new QFilter("warehouse", "=", (Object)warehouseId);
        QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MSPLAN_PLANSCOPE_WHS, (Long)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, basedataFilter, qFilterWarehouse, qFilterEffectuate};
        HashMap<Long, Map> createorgInwareInfo = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,createorg,planscope,invorg", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long planscope = row.getLong(2);
                Long in_storage_org = row.getLong(3);
                Map inwareInfoMap = createorgInwareInfo.computeIfAbsent(createorgid, k -> new HashMap(16));
                inwareInfoMap.put("inwarorg", in_storage_org);
                inwareInfoMap.put("planscope", planscope);
            }
            dataset.close();
        }
        inwareInfo = (Map)createorgInwareInfo.get(orgId);
        if ((inwareInfo == null || inwareInfo.isEmpty()) && createorgInwareInfo.size() > 0) {
            Iterator it = createorgInwareInfo.entrySet().iterator();
            inwareInfo = (Map)it.next().getValue();
        }
        return inwareInfo;
    }

    public static Map<String, Long> getInwareInfoByPlanscope(Long planscopeId, Long orgId, Boolean isIninvWhs) {
        Map<String, Long> inwareInfo = new HashMap(16);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEffectuate = new QFilter("effectuate_type", "=", (Object)"A");
        QFilter qFilterIsIninvWhs = new QFilter("is_ininv_whs", "=", (Object)isIninvWhs);
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterWarehouse = new QFilter("planscope", "=", (Object)planscopeId);
        QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MSPLAN_PLANSCOPE_WHS, (Long)orgId);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, basedataFilter, qFilterWarehouse, qFilterEffectuate, qFilterIsIninvWhs};
        HashMap<Long, Map> createorgInwareInfo = new HashMap<Long, Map>();
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeHelper.class.getName(), (String)MSPLAN_PLANSCOPE_WHS, (String)"id,createorg,warehouse,invorg", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long createorgid = row.getLong(1);
                Long warehouse = row.getLong(2);
                Long in_storage_org = row.getLong(3);
                Map inwareInfoMap = createorgInwareInfo.computeIfAbsent(createorgid, k -> new HashMap(16));
                inwareInfoMap.put("inwarorg", in_storage_org);
                inwareInfoMap.put("inwarehouse", warehouse);
            }
            dataset.close();
        }
        inwareInfo = (Map)createorgInwareInfo.get(orgId);
        if ((inwareInfo == null || inwareInfo.isEmpty()) && createorgInwareInfo.size() > 0) {
            Iterator it = createorgInwareInfo.entrySet().iterator();
            inwareInfo = (Map)it.next().getValue();
        }
        return inwareInfo;
    }

    public static DynamicObject getManuVersiontInfo(Long materialId, Long orgId, String entityKey, String selectFields, Long configuredcodeId, IPageCache page) {
        DynamicObject materialMftInfo;
        String manuVersionStr;
        if (materialId == 0L || orgId == 0L || StringUtils.isBlank((CharSequence)entityKey)) {
            return null;
        }
        if (page != null && (manuVersionStr = page.get(entityKey + materialId + orgId)) != null && !manuVersionStr.isEmpty()) {
            DynamicObject manuVersion = null;
            try {
                Object[] o = DynamicObjectSerializeUtil.deserialize((String)manuVersionStr, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityKey));
                manuVersion = (DynamicObject)o[0];
                return manuVersion;
            }
            catch (Exception o) {
                // empty catch block
            }
        }
        if ((materialMftInfo = PlanOrderHelper.getMaterialMftInfo(materialId, orgId, "bd_materialmftinfo", "id,createorg", null)) == null) {
            return null;
        }
        Date now = new Date();
        QFilter qFilterMater = new QFilter("material", "=", materialMftInfo.getPkValue());
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterBegindate = new QFilter("begindate", "<=", (Object)now);
        QFilter qFilterEnddate = new QFilter("enddate", ">=", (Object)now);
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId);
        DynamicObject[] data = BusinessDataServiceHelper.load((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{qFilterMater, qFilterStatus, qFilterOrg, qFilterEnable, qFilterBegindate, qFilterEnddate});
        DynamicObject manuversioninfo = null;
        HashMap<Object, DynamicObject> datas = new HashMap<Object, DynamicObject>(data.length);
        for (DynamicObject dobj : data) {
            datas.put(dobj.getPkValue(), dobj);
        }
        Map<Long, Map<Object, DynamicObject>> createOrgMaterialInfoMap = PlanScopeHelper.getDataByCreateOrg(datas);
        Map<Object, DynamicObject> map = createOrgMaterialInfoMap.get(orgId);
        if (map != null) {
            manuversioninfo = PlanOrderHelper.getDataByIdMin(map);
        }
        if (manuversioninfo == null) {
            manuversioninfo = PlanOrderHelper.getDataByIdMin(datas);
        }
        if (page != null && manuversioninfo != null) {
            page.put(entityKey + materialId + orgId, DynamicObjectSerializeUtil.serialize((Object[])new Object[]{manuversioninfo}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityKey)));
        }
        return manuversioninfo;
    }

    public static Map<Long, Map<Object, DynamicObject>> getDataByCreateOrg(Map<Object, DynamicObject> datas) {
        HashMap<Long, Map<Object, DynamicObject>> createOrgDataMap = new HashMap<Long, Map<Object, DynamicObject>>(datas.size());
        for (Map.Entry<Object, DynamicObject> entry : datas.entrySet()) {
            DynamicObject data = entry.getValue();
            Object key = entry.getKey();
            DynamicObject createorg = data.getDynamicObject("createorg");
            Long createorgId = createorg == null ? 0L : createorg.getLong("id");
            Map computeIfAbsent = createOrgDataMap.computeIfAbsent(createorgId, k -> new HashMap(datas.size()));
            computeIfAbsent.put(key, data);
        }
        return createOrgDataMap;
    }

    public static Map<String, Map<String, Long>> getBatchDefSupplierInfoConsiderInterAssist(Map<String, DynamicObject> bomEntryMaps, Map<String, DynamicObject> entrymaterialMap, Map<String, DynamicObject> entrymaterialInfoMap, Map<String, DynamicObject> interAssistTypeMap, DynamicObject supplyorg, DynamicObject manuVersiontInfo) {
        HashMap<String, Map<String, Long>> supplyInfo = new HashMap<String, Map<String, Long>>(bomEntryMaps.size());
        Set<String> noInterAssistTypeKey = interAssistTypeMap.keySet();
        HashMap<String, Long> entrysupplyorgIdMap = new HashMap<String, Long>(noInterAssistTypeKey.size());
        PlanScopeHelper.initializeSupplyInfo(supplyInfo, noInterAssistTypeKey);
        log.info("\u521d\u59cb\u5316\u6570\u636e\uff1a" + supplyInfo);
        HashMap<String, Long> keyWarehouses = new HashMap<String, Long>(16);
        HashMap<Long, Map> orgWarehouseMaterial = new HashMap<Long, Map>(16);
        HashMap<String, Map<String, Long>> supplyInfoMft = new HashMap<String, Map<String, Long>>(16);
        Long orgId = supplyorg == null ? 0L : supplyorg.getLong("id");
        for (String key : noInterAssistTypeKey) {
            DynamicObject materialInfo = entrymaterialInfoMap.get(key);
            if (materialInfo == null) continue;
            entrysupplyorgIdMap.put(key, orgId);
            DynamicObject material = entrymaterialMap.get(key);
            Long materialId = material.getLong("id");
            String invinfosrc = materialInfo.getString("invinfosrc");
            Map materialWarehouse = orgWarehouseMaterial.computeIfAbsent(orgId, k -> new HashMap(16));
            if ("A".equals(invinfosrc)) {
                DynamicObject bomEntry = bomEntryMaps.get(key);
                PlanScopeHelper.updateSupplyInfoBomEntry(supplyInfo, key, bomEntry);
                log.info("bom\u7684\u6570\u636e\uff1a" + supplyInfo);
                continue;
            }
            if ("B".equals(invinfosrc)) {
                PlanScopeHelper.updateSupplyInfoMaterialMft(supplyInfo, key, materialInfo, materialWarehouse, materialId, keyWarehouses);
                log.info("\u751f\u4ea7\u4fe1\u606f\u7684\u6570\u636e\uff1a" + supplyInfo);
                continue;
            }
            if ("C".equals(invinfosrc)) {
                if (manuVersiontInfo == null) continue;
                PlanScopeHelper.updateSupplyInfoManuVersion(supplyInfo, key, manuVersiontInfo, materialWarehouse, materialId, keyWarehouses);
                log.info("\u751f\u4ea7\u7248\u672c\u7684\u6570\u636e\uff1a" + supplyInfo);
                continue;
            }
            if (!"D".equals(invinfosrc)) continue;
            if (manuVersiontInfo == null) {
                PlanScopeHelper.updateSupplyInfoMaterialMft(supplyInfo, key, materialInfo, materialWarehouse, materialId, keyWarehouses);
                continue;
            }
            DynamicObject warehouse = manuVersiontInfo.getDynamicObject("supwarehouseid");
            Long entrywarehouseId = warehouse == null ? 0L : warehouse.getLong("id");
            if (entrywarehouseId == 0L) {
                PlanScopeHelper.updateSupplyInfoMaterialMft(supplyInfo, key, materialInfo, materialWarehouse, materialId, keyWarehouses);
                continue;
            }
            Set materials = materialWarehouse.computeIfAbsent(entrywarehouseId, k -> new HashSet());
            materials.add(materialId);
            keyWarehouses.put(key, entrywarehouseId);
            PlanScopeHelper.updateSupplyInfoMaterialMft(supplyInfoMft, key, materialInfo, materialWarehouse, materialId, null);
        }
        HashMap<String, Map<String, Long>> supplierInfos = new HashMap<String, Map<String, Long>>();
        for (Map.Entry orgWarehouseMaterialEntry : orgWarehouseMaterial.entrySet()) {
            Long supplyorgId = (Long)orgWarehouseMaterialEntry.getKey();
            Map warehouseMaterial = (Map)orgWarehouseMaterialEntry.getValue();
            Set<Long> warehouseIds = warehouseMaterial.keySet();
            Map<Long, Long> warehousesPlanscopes = PlanScopeHelper.getPlanscopeBywarehouses(warehouseIds, supplyorgId);
            for (Map.Entry<Long, Long> warehousesPlanscopeEntry : warehousesPlanscopes.entrySet()) {
                Long planscopeId = warehousesPlanscopeEntry.getValue();
                if (planscopeId == null) continue;
                Long warehouseId = warehousesPlanscopeEntry.getKey();
                Set materialIds = (Set)warehouseMaterial.get(warehouseId);
                Map<String, Map<String, Long>> supplierInfo = PlanScopeHelper.getSupplierInfo(planscopeId, supplyorgId, warehouseId, materialIds);
                supplierInfos.putAll(supplierInfo);
            }
        }
        log.info("\u6839\u636e\u6761\u4ef6\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f\u6570\u636e\uff1a" + supplyInfo);
        for (Map.Entry keyWarehouse : keyWarehouses.entrySet()) {
            String key = (String)keyWarehouse.getKey();
            Long warehouseId = (Long)keyWarehouse.getValue();
            DynamicObject material = entrymaterialMap.get(key);
            Long materialId = material.getLong("id");
            Long supplyOrgId = (Long)entrysupplyorgIdMap.get(key);
            String supplierInfoKey = materialId + "" + supplyOrgId + "" + warehouseId;
            Map supplierInfo = (Map)supplierInfos.get(supplierInfoKey);
            if (supplierInfo == null || supplierInfo.isEmpty() || (Long)supplierInfo.get("entrywarehouse") == 0L) {
                Map map = (Map)supplyInfoMft.get(key);
                if (map == null || map.isEmpty() || (Long)map.get("entrywarehouse") == 0L) continue;
                supplyInfo.put(key, map);
                Long entrywarehouse = (Long)map.get("entrywarehouse");
                String supplierKey = materialId + "" + supplyOrgId + "" + entrywarehouse;
                Map supplier = (Map)supplierInfos.get(supplierKey);
                if (supplier == null || supplier.isEmpty() || (Long)supplier.get("entrywarehouse") == 0L) continue;
                PlanScopeHelper.updateSupplyInfoPlanScope(supplyInfo, key, supplier);
                continue;
            }
            PlanScopeHelper.updateSupplyInfoPlanScope(supplyInfo, key, supplierInfo);
        }
        log.info("\u8ba1\u5212\u8303\u56f4\u6570\u636e\uff1a" + supplyInfo);
        return supplyInfo;
    }

    private static void updateSupplyInfoPlanScope(Map<String, Map<String, Long>> supplyInfo, String key, Map<String, Long> supplierInfo) {
        Long entrysupplyorgunit = supplierInfo.get("entrysupplyorgunitid");
        Long entrywarehouse = supplierInfo.get("entrywarehouse");
        Long entrylocation = supplierInfo.get("entrylocation");
        Map supplyInfoMap = supplyInfo.computeIfAbsent(key, k -> new HashMap());
        supplyInfoMap.put("entrysupplyorg", entrysupplyorgunit);
        supplyInfoMap.put("entrywarehouse", entrywarehouse);
        supplyInfoMap.put("entrylocation", entrylocation);
    }

    private static void updateSupplyInfoManuVersion(Map<String, Map<String, Long>> supplyInfo, String key, DynamicObject manuVersiontInfo, Map<Long, Set<Long>> materialWarehouse, Long materialId, Map<String, Long> keyWarehouses) {
        DynamicObject supplyorgunitid = manuVersiontInfo.getDynamicObject("supstockorgid");
        Long entrysupplyorgunitid = supplyorgunitid == null ? 0L : supplyorgunitid.getLong("id");
        DynamicObject warehouse = manuVersiontInfo.getDynamicObject("supwarehouseid");
        Long entrywarehouseId = warehouse == null ? 0L : warehouse.getLong("id");
        DynamicObject location = manuVersiontInfo.getDynamicObject("suplocationid");
        Long entrylocationId = location == null ? 0L : location.getLong("id");
        Map supplyInfoMap = supplyInfo.computeIfAbsent(key, k -> new HashMap());
        supplyInfoMap.put("entrysupplyorg", entrysupplyorgunitid);
        supplyInfoMap.put("entrywarehouse", entrywarehouseId);
        supplyInfoMap.put("entrylocation", entrylocationId);
        if (entrywarehouseId == 0L) {
            return;
        }
        Set materials = materialWarehouse.computeIfAbsent(entrywarehouseId, k -> new HashSet());
        materials.add(materialId);
        keyWarehouses.put(key, entrywarehouseId);
    }

    private static void updateSupplyInfoBomEntry(Map<String, Map<String, Long>> supplyInfo, String key, DynamicObject bomEntry) {
        Long entrysupplyorgunitid = 0L;
        Long entrywarehouseId = 0L;
        Long entrylocationId = 0L;
        if (bomEntry != null) {
            entrysupplyorgunitid = bomEntry.getLong("entry.entrysupplyorg");
            entrywarehouseId = bomEntry.getLong("entry.entrywarehouse");
            entrylocationId = bomEntry.getLong("entry.entrylocation");
        }
        Map supplyInfoMap = supplyInfo.computeIfAbsent(key, k -> new HashMap());
        supplyInfoMap.put("entrysupplyorg", entrysupplyorgunitid);
        supplyInfoMap.put("entrywarehouse", entrywarehouseId);
        supplyInfoMap.put("entrylocation", entrylocationId);
    }

    private static void updateSupplyInfoMaterialMft(Map<String, Map<String, Long>> supplyInfo, String key, DynamicObject entryMaterialMft, Map<Long, Set<Long>> materialWarehouse, Long materialId, Map<String, Long> keyWarehouses) {
        Map supplyInfoMap = supplyInfo.computeIfAbsent(key, k -> new HashMap());
        DynamicObject supplyorgunitid = entryMaterialMft.getDynamicObject("supplyorgunitid");
        DynamicObject warehouse = entryMaterialMft.getDynamicObject("warehouse");
        DynamicObject location = entryMaterialMft.getDynamicObject("location");
        Long warehouseId = warehouse == null ? 0L : warehouse.getLong("id");
        supplyInfoMap.put("entrysupplyorg", supplyorgunitid == null ? 0L : supplyorgunitid.getLong("id"));
        supplyInfoMap.put("entrywarehouse", warehouseId);
        supplyInfoMap.put("entrylocation", location == null ? 0L : location.getLong("id"));
        if (warehouseId == 0L) {
            return;
        }
        Set materials = materialWarehouse.computeIfAbsent(warehouseId, k -> new HashSet());
        materials.add(materialId);
        if (keyWarehouses == null) {
            return;
        }
        keyWarehouses.put(key, warehouseId);
    }

    private static void initializeSupplyInfo(Map<String, Map<String, Long>> supplyInfo, Set<String> keys) {
        for (String key : keys) {
            HashMap<String, Long> supplyInfoMap = new HashMap<String, Long>(3);
            supplyInfoMap.put("entrysupplyorg", 0L);
            supplyInfoMap.put("entrywarehouse", 0L);
            supplyInfoMap.put("entrylocation", 0L);
            supplyInfo.put(key, supplyInfoMap);
        }
    }
}

