/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.business.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;

public class ResourceFieldHelper {
    public static String getFuncsXML(String[] supportMethod) {
        HashSet<String> functionSet = new HashSet<String>(Arrays.asList(supportMethod));
        FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
        Iterator functionTypeIterator = functionTypes.getFunctionTypes().iterator();
        while (functionTypeIterator.hasNext()) {
            FunctionType function = (FunctionType)functionTypeIterator.next();
            String functionId = function.getId();
            if (functionSet.contains(functionId)) continue;
            functionTypeIterator.remove();
        }
        ResourceFieldHelper.addRelationOrgCustomMethod(functionTypes, functionSet);
        ResourceFieldHelper.addRelationProductOrgCustomMethod(functionTypes, functionSet);
        ResourceFieldHelper.addDateDiffCustomMethod(functionTypes, functionSet);
        String funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
        return funcsXML;
    }

    public static void addCustomMethods(FunctionTypes functionTypes, Set<String> functionSet) {
        ResourceFieldHelper.addRelationOrgCustomMethod(functionTypes, functionSet);
        ResourceFieldHelper.addDateDiffCustomMethod(functionTypes, functionSet);
    }

    public static void addRelationOrgCustomMethod(FunctionTypes functionTypes, Set<String> functionSet) {
        if (functionSet.contains("GetRelationOrg")) {
            FunctionType customType = new FunctionType();
            customType.setDef("GetRelationOrg(ownerid, entryrecorgid, entryreqorgid)");
            customType.setId("GetRelationOrg");
            customType.setGroupId("Common");
            customType.setSeq(1);
            StringBuilder desc = new StringBuilder();
            desc.append(ResManager.loadKDString((String)"1.\u51fd\u6570\u63cf\u8ff0\uff1a\u83b7\u53d6\u53d7\u6e90\u7ec4\u7ec7\u59d4\u6258\u7684\u76ee\u6807\u7ec4\u7ec7\uff1b", (String)"ResourceFieldHelper_1", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"2.\u51fd\u6570\u683c\u5f0f\uff1aGetRelationOrg(ownerid, entryrecorgid, entryreqorgid)\uff1b", (String)"ResourceFieldHelper_20", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"3.\u51fd\u6570\u53c2\u6570\uff1aownerid, \u8d27\u4e3b; entryrecorgid, \u6536\u8d27\u7ec4\u7ec7; entryreqorgid\uff0c \u9700\u6c42\u7ec4\u7ec7\uff1b", (String)"ResourceFieldHelper_3", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"4.\u4e3e\u4f8b\uff1aGetRelationOrg(0,  billentry.entryrecorg ,  billentry.entryreqorg ), 0\u4ee3\u8868\u53c2\u6570\u503c\u4e3a\u7a7a\uff0c\u5176\u4ed6\u5219\u662f\u5b57\u6bb5\u6807\u8bc6\uff1b", (String)"ResourceFieldHelper_4", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            customType.setDesc(new LocaleString(desc.toString()));
            customType.setReturnType("long");
            customType.setName(new LocaleString(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u59d4\u6258\u7684\u6536\u8d27\u7ec4\u7ec7", (String)"ResourceFieldHelper_0", (String)"mpscmm-msplan-business", (Object[])new Object[0])));
            functionTypes.getFunctionTypes().add(customType);
        }
    }

    public static void addDateDiffCustomMethod(FunctionTypes functionTypes, Set<String> functionSet) {
        if (functionSet.contains("DATEDIFF")) {
            FunctionType customType = new FunctionType();
            customType.setDef("DATEDIFF(sourcedate, destdate)");
            customType.setId("DATEDIFF");
            customType.setGroupId("DateTime");
            customType.setSeq(10);
            StringBuilder desc = new StringBuilder();
            desc.append(ResManager.loadKDString((String)"1.\u51fd\u6570\u63cf\u8ff0\uff1a\u83b7\u53d6\u4e24\u4e2a\u65e5\u671f\u76f8\u51cf\u540e\u7684\u503c\uff08\u8fd4\u56de\u503c\u4ee5\u79d2\u4e3a\u5355\u4f4d\uff09\uff1b", (String)"ResourceFieldHelper_5", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"2.\u51fd\u6570\u683c\u5f0f\uff1aDATEDIFF(sourcedate, destdate)\uff1b", (String)"ResourceFieldHelper_6", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"3.\u51fd\u6570\u53c2\u6570\uff1asourcedate, \u6e90\u65e5\u671f\uff1bdestdate, \u76ee\u6807\u65e5\u671f\uff1b", (String)"ResourceFieldHelper_7", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"4.\u4e3e\u4f8b\uff1aDATEDIFF(sourcedate, destdate) > 5*60*60*24, \u4ee3\u8868\u6e90\u65e5\u671f - \u76ee\u6807\u65e5\u671f\u662f\u5426\u5927\u4e8e5\u5929\uff1b", (String)"ResourceFieldHelper_8", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            customType.setDesc(new LocaleString(desc.toString()));
            customType.setReturnType("long");
            customType.setName(new LocaleString(ResManager.loadKDString((String)"\u65e5\u671f\u6bd4\u8f83", (String)"ResourceFieldHelper_9", (String)"mpscmm-msplan-business", (Object[])new Object[0])));
            functionTypes.getFunctionTypes().add(customType);
        }
    }

    public static TreeNode buildCalTreeNodes(BillTreeBuildParameter parameter) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List<TreeNode> fldNodes = BillFieldEntityHelper.buildFldCalTreeNodes(parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static void addRelationProductOrgCustomMethod(FunctionTypes functionTypes, Set<String> functionSet) {
        StringBuilder desc;
        FunctionType customType;
        if (functionSet.contains("GetInwareOrgByOrg")) {
            customType = new FunctionType();
            customType.setDef("GetInwareOrgByOrg(orgId)");
            customType.setId("GetInwareOrgByOrg");
            customType.setGroupId("Common");
            customType.setSeq(2);
            desc = new StringBuilder();
            desc.append(ResManager.loadKDString((String)"1.\u51fd\u6570\u63cf\u8ff0\uff1a\u6839\u636e\u751f\u4ea7\u7ec4\u7ec7\u627e\u5230\u5bf9\u5e94\u7684\u5e93\u5b58\u7ec4\u7ec7", (String)"ResourceFieldHelper_10", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"2.\u51fd\u6570\u683c\u5f0f\uff1aGetInwareOrgByOrg(orgId)\uff1b", (String)"ResourceFieldHelper_11", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"3.\u51fd\u6570\u53c2\u6570\uff1aorgId \u751f\u4ea7\u7ec4\u7ec7\uff1b", (String)"ResourceFieldHelper_12", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"4.GetInwareOrgByOrg(orgId) \u8fd4\u56de\u5339\u914d\u7684\u5e93\u5b58\u7ec4\u7ec7\uff1b", (String)"ResourceFieldHelper_13", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            customType.setDesc(new LocaleString(desc.toString()));
            customType.setReturnType("long");
            customType.setName(new LocaleString(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u59d4\u6258\u7684\u5e93\u5b58\u7ec4\u7ec7", (String)"ResourceFieldHelper_14", (String)"mpscmm-msplan-business", (Object[])new Object[0])));
            functionTypes.getFunctionTypes().add(customType);
        }
        if (functionSet.contains("GetPurChaseOrgByOrg")) {
            customType = new FunctionType();
            customType.setDef("GetPurChaseOrgByOrg(orgId)");
            customType.setId("GetPurChaseOrgByOrg");
            customType.setGroupId("Common");
            customType.setSeq(3);
            desc = new StringBuilder();
            desc.append(ResManager.loadKDString((String)"1.\u51fd\u6570\u63cf\u8ff0\uff1a\u6839\u636e\u751f\u4ea7\u7ec4\u7ec7\u627e\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u7ec4\u7ec7", (String)"ResourceFieldHelper_15", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"2.\u51fd\u6570\u683c\u5f0f\uff1aGetPurChaseOrgByOrg(orgId)\uff1b", (String)"ResourceFieldHelper_16", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"3.\u51fd\u6570\u53c2\u6570\uff1aorgId \u751f\u4ea7\u7ec4\u7ec7\uff1b", (String)"ResourceFieldHelper_12", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            desc.append(ResManager.loadKDString((String)"4.GetPurChaseOrgByOrg(orgId) \u8fd4\u56de\u5339\u914d\u7684\u91c7\u8d2d\u7ec4\u7ec7\uff1b", (String)"ResourceFieldHelper_18", (String)"mpscmm-msplan-business", (Object[])new Object[0])).append('\n');
            customType.setDesc(new LocaleString(desc.toString()));
            customType.setReturnType("long");
            customType.setName(new LocaleString(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u59d4\u6258\u7684\u91c7\u8d2d\u7ec4\u7ec7", (String)"ResourceFieldHelper_19", (String)"mpscmm-msplan-business", (Object[])new Object[0])));
            functionTypes.getFunctionTypes().add(customType);
        }
    }
}

