/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.datasync.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBackWraper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.schedule.form.TaskProgressFormEdit;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.mpscmm.mspur.utils.CommonUtils;

public class BackgroundTaskSubscriber
implements Runnable {
    private Log log = LogFactory.getLog(BackgroundTaskSubscriber.class);
    private JobFormInfo jobFormInfo;
    private String taskId;
    private RequestContext rc;
    private TaskInfo lastTaskInfo;
    private Date lastTime;

    public JobFormInfo getJobFormInfo() {
        return this.jobFormInfo;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int getCircleInteval() {
        String circleInteval = System.getProperty("backgroundtask.querytask.inteval");
        if (StringUtils.isBlank((Object)circleInteval)) {
            return 2;
        }
        int inteval = Integer.parseInt(circleInteval.toString());
        if (inteval > 10 || inteval < 1) {
            return 2;
        }
        return inteval;
    }

    public BackgroundTaskSubscriber(RequestContext rc, JobFormInfo jobFormInfo, String taskId) {
        this.rc = rc;
        this.jobFormInfo = jobFormInfo;
        this.taskId = taskId;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        try {
            this.execute();
        }
        catch (Throwable exp) {
            this.log.error(exp);
            TaskInfo taskInfo = new TaskInfo();
            taskInfo.setId(this.getTaskId());
            taskInfo.setStatus("FAILED");
            taskInfo.setDesc(String.format(ResManager.loadKDString((String)"\u51fa\u9519\uff1a%s", (String)"BackgroundTaskSubscriber_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), StringUtils.isBlank((CharSequence)exp.getMessage()) ? exp.getClass().getSimpleName() : exp.getMessage()));
            TaskClientProxy.feedbackProgress((JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo, null);
        }
    }

    public void execute() {
        long timeout_MS = 1000 * this.getJobFormInfo().getTimeout();
        long circleInteval_MS = (long)this.getCircleInteval() * 1000L;
        long beginat_MS = System.currentTimeMillis();
        while (true) {
            this.sleep(circleInteval_MS, beginat_MS);
            beginat_MS = System.currentTimeMillis();
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.getTaskId());
            if (taskInfo == null) {
                taskInfo = new TaskInfo();
                taskInfo.setId(this.getTaskId());
                taskInfo.setStatus("FAILED");
                taskInfo.setDesc(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u83b7\u53d6\u5931\u8d25\u3002", (String)"BackgroundTaskSubscriber_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
            if (taskInfo.isTaskEnd()) {
                List<Map<String, Object>> formActions = this.closeCallBack(taskInfo);
                TaskClientProxy.feedbackProgress((JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo, formActions);
                break;
            }
            if (this.compareTaskInfo(taskInfo)) {
                TaskClientProxy.feedbackProgress((JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo, null);
                continue;
            }
            long offset_MS = System.currentTimeMillis() - this.lastTime.getTime();
            if (offset_MS > timeout_MS) {
                taskInfo = new TaskInfo();
                taskInfo.setId(this.getTaskId());
                taskInfo.setStatus("FAILED");
                taskInfo.setDesc(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u957f\u65f6\u95f4\u6ca1\u6709\u8fdb\u5c55", (String)"BackgroundTaskSubscriber_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                TaskClientProxy.feedbackProgress((JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo, null);
                break;
            }
            taskInfo.setProgress(CommonUtils.getProcessByVersionId((Long)((Long)this.jobFormInfo.getParams().get("versionid"))));
            TaskClientProxy.feedbackProgress((JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo, null);
        }
    }

    private List<Map<String, Object>> closeCallBack(TaskInfo taskInfo) {
        IFormView progressView;
        if (!TaskClientProxy.isExistTask((String)this.getTaskId())) {
            return null;
        }
        String progressPageId = TaskClientProxy.getProgressPageId((String)this.getTaskId());
        if (StringUtils.isNotBlank((CharSequence)progressPageId) && (progressView = SessionManager.getCurrent().getViewNoPlugin(progressPageId)) != null) {
            return null;
        }
        if (this.getJobFormInfo().getCloseCallBack() == null) {
            return null;
        }
        Map returnData = TaskProgressFormEdit.packageReturnResult((TaskInfo)taskInfo);
        if (returnData == null) {
            return null;
        }
        FormShowParameter parentViewParameter = SessionManager.getCurrent().getFormShowParameter(this.getJobFormInfo().getParentPageId());
        if (parentViewParameter == null) {
            return null;
        }
        CloseCallBackWraper closeCallBackWraper = new CloseCallBackWraper(this.getJobFormInfo().getParentPageId(), this.getJobFormInfo().getCloseCallBack(), null, false);
        closeCallBackWraper.setReturnData((Object)returnData);
        List acts = (List)DispatchServiceHelper.invokeBOSService((String)parentViewParameter.getServiceAppId(), (String)"FormService", (String)"closeCallBack", (Object[])new Object[]{closeCallBackWraper});
        if (acts == null) {
            return null;
        }
        HashMap<String, Object> arg = new HashMap<String, Object>();
        arg.put("pageId", this.getJobFormInfo().getParentPageId());
        arg.put("actions", acts);
        ArrayList<HashMap<String, Object>> paras = new ArrayList<HashMap<String, Object>>();
        paras.add(arg);
        HashMap<String, Object> sendParentViewAction = new HashMap<String, Object>();
        sendParentViewAction.put("a", "sendDynamicFormAction");
        sendParentViewAction.put("p", paras);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        list.add(sendParentViewAction);
        return list;
    }

    private boolean compareTaskInfo(TaskInfo taskInfo) {
        boolean equals;
        if (null == taskInfo && null == this.lastTaskInfo) {
            return false;
        }
        if (null == this.lastTaskInfo) {
            this.lastTaskInfo = taskInfo;
            this.lastTime = new Date();
            return true;
        }
        if (null == taskInfo) {
            this.lastTaskInfo = null;
            this.lastTime = new Date();
            return true;
        }
        boolean bl = equals = StringUtils.equals((CharSequence)taskInfo.getStatus(), (CharSequence)this.lastTaskInfo.getStatus()) && StringUtils.equals((CharSequence)taskInfo.getDesc(), (CharSequence)this.lastTaskInfo.getDesc()) && StringUtils.equals((CharSequence)taskInfo.getData(), (CharSequence)this.lastTaskInfo.getData()) && taskInfo.getProgress() == this.lastTaskInfo.getProgress();
        if (!equals) {
            this.lastTaskInfo = taskInfo;
            this.lastTime = new Date();
        }
        return !equals;
    }

    private void sleep(long circleInteval_MS, long beginat_MS) {
        long sleeptime = circleInteval_MS - (System.currentTimeMillis() - beginat_MS);
        if (sleeptime > 0L) {
            try {
                Thread.sleep(sleeptime);
            }
            catch (InterruptedException e) {
                this.log.error((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

