/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.datasync.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;

public class DataSyncProgressFormPlugin
extends AbstractFormPlugin
implements ClickListener,
ProgresssListener {
    public void initialize() {
        super.initialize();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar pb = (ProgressBar)this.getControl("progressbarap");
        pb.run(true);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnclose"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar pb = (ProgressBar)this.getControl("progressbarap");
        pb.addProgressListener((ProgresssListener)this);
        Button btnStop = (Button)this.getControl("btnstop");
        btnStop.addClickListener((ClickListener)this);
        Button btnHide = (Button)this.getControl("btnbackgroundrun");
        btnHide.addClickListener((ClickListener)this);
        Button btnClose = (Button)this.getControl("btnclose");
        btnClose.addClickListener((ClickListener)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (!(src instanceof Button)) return;
        Button btn = (Button)src;
        if ("btnstop".equals(btn.getKey())) {
            FormShowParameter params = this.getView().getFormShowParameter();
            Long versionId = (Long)params.getCustomParam("versionid");
            Map statistics = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"stopDataVersion", (Object[])new Object[]{versionId});
            if (!Boolean.TRUE.equals(statistics.get("ok"))) throw new KDBizException("STOP_DATA_SYNC_FAILED, ec: " + statistics.get("ec") + ", em: " + statistics.get("em"));
            this.getView().close();
            return;
        } else {
            if (!"btnclose".equals(btn.getKey()) && !"btnbackgroundrun".equals(btn.getKey())) return;
            this.getView().close();
        }
    }

    public void onProgress(ProgressEvent evt) {
        FormShowParameter params = this.getView().getFormShowParameter();
        Long versionId = (Long)params.getCustomParam("versionid");
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"queryDataSyncActionStatus", (Object[])new Object[]{versionId});
        int ip = 0;
        if (!Boolean.TRUE.equals(result.get("ok"))) {
            throw new KDBizException("UNKNOWN SYNC STATUS, ec: " + result.get("ec") + ", em: " + result.get("em"));
        }
        Map statistics = (Map)result.get("desc");
        String status = (String)statistics.get("status");
        ip = this.updateProgress(ip, statistics, status);
        this.getView().updateView("progressdesc");
        evt.setProgress(ip);
    }

    private int updateProgress(int ip, Map<Object, Object> statistics, String status) {
        String msg = "";
        if ("A".equals(status)) {
            ip = (Integer)statistics.get("progress");
            msg = (String)statistics.get("current");
        } else if ("S".equals(status)) {
            ip = 100;
            msg = ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u6210\u529f\u3002", (String)"DataSyncProgressFormPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        } else if ("F".equals(status)) {
            ip = 100;
            msg = ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5931\u8d25\u3002", (String)"DataSyncProgressFormPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        } else if ("C".equals(status)) {
            ip = 100;
            msg = ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u53d6\u6d88\u3002", (String)"DataSyncProgressFormPlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        } else if ("N".equals(status)) {
            ip = 100;
            msg = ResManager.loadKDString((String)"\u672a\u8fdb\u884c\u8fc7\u6570\u636e\u540c\u6b65\u3002", (String)"DataSyncProgressFormPlugin_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        } else {
            throw new KDBizException("UNKNOWN SYNC STATUS, status: " + status);
        }
        this.getModel().getDataEntity().set("progressdesc", (Object)msg);
        if (ip == 100) {
            if ("A".equals(status)) {
                ip /= 2;
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnstop", "btnbackgroundrun"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnclose"});
            }
        }
        return ip;
    }
}

