/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.datasync.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mrp.business.helper.MrpEntityTypeUtil;

public class DataSyncSettingsFormPlugin
extends AbstractBasePlugIn
implements AfterF7SelectListener {
    private static final String OPER_SHOWENTITYFIELDSELECTOR = "showentityfieldselector";
    private static final String OPER_ENTRYUP = "entryup";
    private static final String OPER_ENTRYDOWN = "entrydown";
    private static final String CTRL_ENTITYTYPE = "entitytype";
    private static final String CTRL_SRCTYPE = "srctype";
    private static final String CTRL_DATASOURCE = "datasrc";
    private static final String CTRL_ENTITYMAPPING = "entitymapping";
    private static final String CTRL_FILTERGRID = "filtergrid";
    private static final String BOS_FIELD_NUMBER = "number";
    private static final String CTRL_ENTRYENTITY = "entryentity";
    private static final String ENTRY_FIELD_FIELDNAME = "fieldname";
    private static final String ENTRY_FIELD_FIELD = "field";
    private static final String ENTRY_FIELD_ISREF = "isref";
    private static final String REF_BILLFIELDTRANSFER = "billfieldtransfer";
    private static final String REF_SRCBILL = "srcbill";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dataSource = (BasedataEdit)this.getControl(CTRL_DATASOURCE);
        dataSource.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit entityMapping = (BasedataEdit)this.getControl(CTRL_ENTITYMAPPING);
        entityMapping.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit entityType = (BasedataEdit)this.getControl(CTRL_ENTITYTYPE);
        entityType.addAfterF7SelectListener((AfterF7SelectListener)this);
        TextEdit materialFieldSelector = (TextEdit)this.getControl("materialfield");
        materialFieldSelector.addButtonClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        BasedataEdit entitySelector = (BasedataEdit)this.getControl(CTRL_ENTITYTYPE);
        DynamicObject selection = (DynamicObject)entitySelector.getModel().getValue(CTRL_ENTITYTYPE);
        FormShowParameter params = new FormShowParameter();
        params.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showmaterialfieldselector"));
        params.setCustomParam("__et__", selection == null ? null : selection.getString(BOS_FIELD_NUMBER));
        params.getOpenStyle().setShowType(ShowType.Modal);
        params.setFormId("msplan_ds_sfs");
        this.getView().showForm(params);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty prop = e.getProperty();
        ChangeData[] changes = e.getChangeSet();
        if (changes != null && changes.length > 0 && CTRL_SRCTYPE.equals(prop.getName())) {
            ChangeData change = changes[0];
            String newVal = String.valueOf(change.getNewValue());
            this.updateSelectors(newVal);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject model = this.getModel().getDataEntity();
        String srcType = model.getString(CTRL_SRCTYPE);
        this.updateSelectors(srcType);
        DynamicObject et = model.getDynamicObject(CTRL_ENTITYTYPE);
        if (et == null) {
            return;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)et.getString(BOS_FIELD_NUMBER));
        MrpEntityTypeUtil helper = new MrpEntityTypeUtil();
        List colxs = helper.getFilterColumns((IDataEntityType)mainEntityType);
        Map fields = mainEntityType.getAllFields();
        List<Map<String, Object>> cols = this.removeNoAliascol(colxs, fields);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CTRL_FILTERGRID);
        filterGrid.setEntityNumber(mainEntityType.getName());
        filterGrid.setFilterColumns(cols);
        String filterContent = model.getString("filtervalue_tag");
        if (StringUtils.isEmpty((String)filterContent)) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterContent, FilterCondition.class);
        filterGrid.SetValue(filterCondition);
        this.getView().updateView(CTRL_FILTERGRID);
    }

    private void updateSelectors(String srcType) {
        IFormView view = this.getView();
        boolean[] flags = new boolean[2];
        if ("A".equals(srcType)) {
            view.setVisible(Boolean.FALSE, new String[]{CTRL_ENTITYMAPPING});
            view.setVisible(Boolean.TRUE, new String[]{CTRL_DATASOURCE});
            view.setEnable(Boolean.FALSE, new String[]{CTRL_ENTITYTYPE});
            flags[0] = true;
            flags[1] = false;
        } else if ("B".equals(srcType)) {
            view.setVisible(Boolean.FALSE, new String[]{CTRL_DATASOURCE});
            view.setVisible(Boolean.TRUE, new String[]{CTRL_ENTITYMAPPING});
            view.setEnable(Boolean.FALSE, new String[]{CTRL_ENTITYTYPE});
            flags[0] = false;
            flags[1] = true;
        } else if ("C".equals(srcType)) {
            view.setEnable(Boolean.TRUE, new String[]{CTRL_ENTITYTYPE});
            view.setVisible(Boolean.FALSE, new String[]{CTRL_ENTITYMAPPING, CTRL_DATASOURCE});
            flags[0] = false;
            flags[1] = false;
        }
        IDataModel model = this.getModel();
        if (!model.isInitialized()) {
            return;
        }
        BasedataEdit bd = (BasedataEdit)view.getControl(CTRL_DATASOURCE);
        bd.setMustInput(flags[0]);
        bd = (BasedataEdit)view.getControl(CTRL_ENTITYMAPPING);
        bd.setMustInput(flags[1]);
        model.beginInit();
        model.setValue(CTRL_DATASOURCE, null);
        model.setValue(CTRL_ENTITYMAPPING, null);
        model.setValue(CTRL_ENTITYTYPE, null);
        model.deleteEntryData(CTRL_ENTRYENTITY);
        model.endInit();
        view.updateView(CTRL_DATASOURCE);
        view.updateView(CTRL_ENTITYMAPPING);
        view.updateView(CTRL_ENTITYTYPE);
        view.updateView(CTRL_ENTRYENTITY);
        FilterGrid filterGrid = (FilterGrid)view.getControl(CTRL_FILTERGRID);
        filterGrid.SetValue((FilterCondition)null);
        view.updateView(CTRL_FILTERGRID);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object ak;
        super.closedCallBack(evt);
        Object result = evt.getReturnData();
        Map map = (Map)result;
        if (map == null) {
            return;
        }
        if ("showmaterialfieldselector".equals(evt.getActionId())) {
            Object ak2 = map.remove("__actionKey__");
            if (ak2 instanceof String && ((String)ak2).equals("btnok")) {
                List selections = (List)map.remove("__actionVal__");
                Map sel = (Map)selections.get(0);
                String fieldTag = String.valueOf(sel.get("id"));
                this.getModel().setValue("materialfield", (Object)fieldTag);
                this.getView().updateView("materialfield");
            }
        } else if (OPER_SHOWENTITYFIELDSELECTOR.equals(evt.getActionId()) && (ak = map.remove("__actionKey__")) instanceof String && ((String)ak).equals("btnok")) {
            List selections = (List)map.remove("__actionVal__");
            IDataModel model = this.getModel();
            DynamicObject data = model.getDataEntity();
            String srcType = data.getString(CTRL_SRCTYPE);
            if ("A".equals(srcType)) {
                data.getDynamicObject(CTRL_DATASOURCE);
            } else if ("B".equals(srcType)) {
                data.getDynamicObject(CTRL_ENTITYMAPPING);
            }
            model.beginInit();
            DynamicObjectCollection oldEntrys = model.getEntryEntity(CTRL_ENTRYENTITY);
            HashSet<String> oldEntrySet = new HashSet<String>();
            ArrayList<DynamicObject> oldEntryList = new ArrayList<DynamicObject>();
            for (DynamicObject entry : oldEntrys) {
                if (!entry.getBoolean(ENTRY_FIELD_ISREF)) continue;
                oldEntrySet.add(entry.getString(ENTRY_FIELD_FIELD));
                oldEntryList.add(entry);
            }
            model.deleteEntryData(CTRL_ENTRYENTITY);
            int size = oldEntryList.size();
            if (size > 0) {
                model.batchCreateNewEntryRow(CTRL_ENTRYENTITY, oldEntryList.size());
                int i = 0;
                for (DynamicObject old : oldEntryList) {
                    model.setValue(ENTRY_FIELD_FIELDNAME, old.get(ENTRY_FIELD_FIELDNAME), i);
                    model.setValue(ENTRY_FIELD_FIELD, old.get(ENTRY_FIELD_FIELD), i);
                    model.setValue(ENTRY_FIELD_ISREF, (Object)Boolean.TRUE, i);
                    ++i;
                }
            }
            for (Object item : selections) {
                Map sel = (Map)item;
                String fieldTag = String.valueOf(sel.get("id"));
                if (oldEntrySet.contains(fieldTag)) continue;
                int i = model.createNewEntryRow(CTRL_ENTRYENTITY);
                model.setValue(ENTRY_FIELD_FIELDNAME, sel.get("text"), i);
                model.setValue(ENTRY_FIELD_FIELD, (Object)fieldTag, i);
                model.setValue(ENTRY_FIELD_ISREF, (Object)Boolean.FALSE, i);
            }
            model.endInit();
            this.getView().updateView(CTRL_ENTRYENTITY);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        Object src = evt.getSource();
        if (src instanceof Donothing) {
            Donothing oper = (Donothing)src;
            String operKey = oper.getOperateKey();
            if (OPER_SHOWENTITYFIELDSELECTOR.equals(operKey)) {
                BasedataEdit entitySelector = (BasedataEdit)this.getControl(CTRL_ENTITYTYPE);
                DynamicObject selection = (DynamicObject)entitySelector.getModel().getValue(CTRL_ENTITYTYPE);
                FormShowParameter params = new FormShowParameter();
                params.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPER_SHOWENTITYFIELDSELECTOR));
                params.setCustomParam("__et__", selection == null ? null : selection.getString(BOS_FIELD_NUMBER));
                HashSet<String> fields = new HashSet<String>();
                DynamicObjectCollection entrys = this.getModel().getEntryEntity(CTRL_ENTRYENTITY);
                for (DynamicObject entry : entrys) {
                    fields.add(entry.getString(ENTRY_FIELD_FIELD));
                }
                params.setCustomParam("__selections__", fields);
                params.getOpenStyle().setShowType(ShowType.Modal);
                params.setFormId("msplan_ds_mfs");
                this.getView().showForm(params);
            }
        } else if (src instanceof Save || src instanceof Submit) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CTRL_FILTERGRID);
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            List rows = filterCondition.getFilterRow();
            if (rows == null || rows.size() < 1) {
                evt.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DataSyncSettingsFormPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            String filterContent = SerializationUtils.toJsonString((Object)filterCondition);
            this.getModel().setValue("filtervalue", (Object)"");
            this.getModel().setValue("filtervalue_tag", (Object)filterContent);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterF7Select(AfterF7SelectEvent evt) {
        Object src = evt.getSource();
        if (src instanceof BasedataEdit) {
            IDataModel model = this.getModel();
            model.beginInit();
            DynamicObject data = model.getDataEntity();
            try {
                DynamicObject et;
                String filterContent;
                DynamicObject em;
                BasedataEdit bd = (BasedataEdit)src;
                String key = bd.getKey();
                if (CTRL_DATASOURCE.equals(key)) {
                    em = data.getDynamicObject(CTRL_DATASOURCE);
                    filterContent = null;
                    if (em != null) {
                        filterContent = BusinessDataServiceHelper.loadSingleFromCache((String)em.getDataEntityType().getName(), (String)"id, filter_tag, entryentity.*", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)em.getLong("id"))}).getString("filter_tag");
                        em = em.getDynamicObject(REF_BILLFIELDTRANSFER);
                        em = BusinessDataServiceHelper.loadSingleFromCache((String)em.getDataEntityType().getName(), (String)"id, sourcefieldflag, sourcefieldname, calculateexc_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)em.getLong("id"))});
                    }
                } else if (CTRL_ENTITYMAPPING.equals(key)) {
                    em = data.getDynamicObject(CTRL_ENTITYMAPPING);
                    if (em != null) {
                        em = BusinessDataServiceHelper.loadSingleFromCache((String)em.getDataEntityType().getName(), (String)"id, filter_tag, sourcefieldflag, sourcefieldname, calculateexc_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)em.getLong("id"))});
                        filterContent = em.getString("filter_tag");
                    } else {
                        em = null;
                        filterContent = null;
                    }
                } else if (CTRL_ENTITYTYPE.equals(key)) {
                    et = data.getDynamicObject(CTRL_ENTITYTYPE);
                    if (et != null) {
                        this.updateFilterCtrl(et.getString(BOS_FIELD_NUMBER));
                        return;
                    }
                    filterContent = null;
                    em = null;
                } else {
                    return;
                }
                if (em == null) {
                    model.setValue(CTRL_ENTITYTYPE, null);
                    model.deleteEntryData(CTRL_ENTRYENTITY);
                    FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CTRL_FILTERGRID);
                    filterGrid.SetValue((FilterCondition)null);
                    return;
                }
                et = BusinessDataServiceHelper.loadSingleFromCache((String)em.getDataEntityType().getName(), (String)"id, name, number, srcbill.id, srcbill.name, srcbill.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)em.getLong("id"))}).getDynamicObject(REF_SRCBILL);
                model.setValue(CTRL_ENTITYTYPE, (Object)et);
                String entityType = et.getString(BOS_FIELD_NUMBER);
                this.updateFilterCtrl(entityType);
                if (!StringUtils.isEmpty((String)filterContent)) {
                    FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterContent, FilterCondition.class);
                    FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CTRL_FILTERGRID);
                    filterGrid.SetValue(filterCondition);
                }
                DynamicObjectCollection fields = em.getDynamicObjectCollection(CTRL_ENTRYENTITY);
                model.deleteEntryData(CTRL_ENTRYENTITY);
                for (DynamicObject field : fields) {
                    String fieldName = field.getString("sourcefieldflag");
                    String fieldTag = field.getString("sourcefieldname");
                    if (StringUtils.isEmpty((String)fieldTag)) continue;
                    int i = model.createNewEntryRow(CTRL_ENTRYENTITY);
                    model.setValue(ENTRY_FIELD_FIELDNAME, (Object)fieldTag, i);
                    model.setValue(ENTRY_FIELD_FIELD, (Object)fieldName, i);
                    model.setValue(ENTRY_FIELD_ISREF, (Object)Boolean.TRUE, i);
                }
            }
            finally {
                model.endInit();
                this.getView().updateView(CTRL_FILTERGRID);
                this.getView().updateView(CTRL_ENTRYENTITY);
                this.getView().updateView(CTRL_ENTITYTYPE);
            }
        }
    }

    private void updateFilterCtrl(String et) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CTRL_FILTERGRID);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)et);
        MrpEntityTypeUtil helper = new MrpEntityTypeUtil();
        List colxs = helper.getFilterColumns((IDataEntityType)mainEntityType);
        Map fields = mainEntityType.getAllFields();
        List<Map<String, Object>> cols = this.removeNoAliascol(colxs, fields);
        filterGrid.SetValue(new FilterCondition());
        filterGrid.setEntityNumber(mainEntityType.getName());
        filterGrid.setFilterColumns(cols);
    }

    private List<Map<String, Object>> removeNoAliascol(List<Map<String, Object>> cols, Map<String, IDataEntityProperty> fields) {
        Iterator<Map.Entry<String, IDataEntityProperty>> fits = fields.entrySet().iterator();
        ArrayList<Integer> lstindex = new ArrayList<Integer>();
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        while (fits.hasNext()) {
            Map.Entry<String, IDataEntityProperty> entry = fits.next();
            IDataEntityProperty entity = entry.getValue();
            String key = entry.getKey();
            String alias = entity.getAlias();
            int i = 0;
            if (entity instanceof ItemClassProp) {
                alias = "";
            }
            if (!"".equals(alias)) continue;
            i = 0;
            for (Map<String, Object> map : cols) {
                String skey = (String)map.get("fieldName");
                if (skey.equals(key) || skey.indexOf(key + ".") == 0) {
                    lstindex.add(i);
                }
                ++i;
            }
        }
        int i = 0;
        for (Map<String, Object> map : cols) {
            if (!lstindex.contains(i)) {
                res.add(map);
            }
            ++i;
        }
        return res;
    }
}

