/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.datasync.formplugin;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.UnAudit;
import kd.bos.entity.operate.UnSubmit;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.mvc.base.BaseView;
import kd.bos.report.ReportShowParameter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import org.apache.log4j.Logger;

public class DataVersionFormPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
CellClickListener,
ProgresssListener {
    private static Logger logger = Logger.getLogger(DataVersionFormPlugin.class);
    private static final String OPER_CLEARSYNCDATAS = "clearsyncdatas";
    private static final String OPER_ACTIVATE = "activatestatus";
    private static final String OPER_DATAVIEWER = "dataviewer";
    private static final String OPER_SHOWDATASYNCSELECTOR = "showdatasyncselector";
    private static final String CTRL_DATASYNCSELECTOR = "datasyncselector";
    private static final String CTRL_SYNCSETTINGS = "entryentity";
    private static final String ENTRY_SYNCSETTING = "settings";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dsSelector = (BasedataEdit)this.getControl(CTRL_DATASYNCSELECTOR);
        dsSelector.addAfterF7SelectListener((AfterF7SelectListener)this);
        SubEntryGrid subs = (SubEntryGrid)this.getControl("subentryentity");
        subs.addCellClickListener((CellClickListener)this);
        EntryGrid grid = (EntryGrid)this.getControl("hisentity");
        grid.addCellClickListener((CellClickListener)this);
        ProgressBar pb = (ProgressBar)this.getControl("progressbarap");
        pb.addProgressListener((ProgresssListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        Object src = evt.getSource();
        if (src instanceof Donothing) {
            Donothing oper = (Donothing)src;
            String operKey = oper.getOperateKey();
            if (OPER_SHOWDATASYNCSELECTOR.equals(operKey)) {
                IDataModel model = this.getModel();
                model.beginInit();
                try {
                    DynamicObject data = model.getDataEntity();
                    DynamicObjectCollection selections = data.getDynamicObjectCollection(CTRL_DATASYNCSELECTOR);
                    selections.clear();
                    int size = model.getEntryRowCount(CTRL_SYNCSETTINGS);
                    for (int i = 0; i < size; ++i) {
                        DynamicObject row = selections.addNew();
                        row.set("fbasedataid", model.getValue(ENTRY_SYNCSETTING, i));
                    }
                }
                finally {
                    model.endInit();
                    this.getView().updateView(CTRL_DATASYNCSELECTOR);
                }
            } else if (OPER_CLEARSYNCDATAS.equals(operKey) || OPER_ACTIVATE.equals(operKey)) {
                String billstatus = (String)this.getModel().getValue("billstatus");
                if ("C".equals(billstatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"DataVersionFormPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (DataVersionFormPlugin.exist((Long)this.getModel().getValue("id"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u7248\u672c\u540c\u6b65\u4e2d\uff0c\u8bf7\u7b49\u5f85\u672c\u6b21\u540c\u6b65\u5b8c\u6210\u518d\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", (String)"DataVersionFormPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }
        } else if (src instanceof UnAudit || src instanceof Audit || src instanceof Save || src instanceof Submit || src instanceof UnSubmit) {
            DynamicObject data = this.getModel().getDataEntity();
            long userId = UserServiceHelper.getCurrentUserId();
            this.getModel().setValue("modifier", (Object)userId);
            data.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
            if (src instanceof Save || src instanceof Submit) {
                DynamicObjectCollection selections = data.getDynamicObjectCollection(CTRL_DATASYNCSELECTOR);
                DynamicObjectCollection newSelections = this.getModel().getEntryEntity(CTRL_SYNCSETTINGS);
                HashSet<Long> ids = new HashSet<Long>();
                for (DynamicObject obj : newSelections) {
                    ids.add(obj.getDynamicObject(ENTRY_SYNCSETTING).getLong("id"));
                }
                selections.removeIf(e -> !ids.contains(e.getDynamicObject("fbasedataid").get("id")));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.sync2EntryGrid();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid hisGrid = (EntryGrid)this.getControl("hisentity");
        hisGrid.selectRows(0);
        this.startSelfProgressChecker();
        this.hideDataViewerCtrl(0);
    }

    private void startSelfProgressChecker() {
        Map statistics;
        String status;
        this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
        DynamicObject entity = this.getModel().getDataEntity();
        Long versionId = entity.getLong("id");
        if (versionId == 0L) {
            return;
        }
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"queryDataSyncActionStatus", (Object[])new Object[]{versionId});
        if (Boolean.TRUE.equals((Boolean)result.get("ok")) && "A".equals(status = (String)(statistics = (Map)result.get("desc")).get("status"))) {
            ProgressBar pb = (ProgressBar)this.getControl("progressbarap");
            pb.start();
        }
    }

    public void afterCopyData(EventObject e) {
        DynamicObjectCollection hisentity;
        super.afterCopyData(e);
        DynamicObjectCollection subentryentity = this.getModel().getEntryEntity("subentryentity");
        if (subentryentity != null) {
            this.getModel().deleteEntryData("subentryentity");
        }
        if ((hisentity = this.getModel().getEntryEntity("hisentity")) != null) {
            this.getModel().deleteEntryData("hisentity");
        }
    }

    private boolean checkExistEnableRow(DynamicObjectCollection hisEntrys) {
        boolean isEnableRow = false;
        for (int i = 0; i < hisEntrys.size(); ++i) {
            DynamicObject his = (DynamicObject)hisEntrys.get(i);
            String status = his.getString("activestatus");
            String syncstatus = his.getString("syncstatus");
            if (!"S".equals(status) || !"A".equals(syncstatus)) continue;
            isEnableRow = true;
        }
        return isEnableRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operKey = evt.getOperateKey();
        if (OPER_CLEARSYNCDATAS.equals(operKey)) {
            IDataModel model = this.getModel();
            EntryGrid grid = (EntryGrid)this.getControl("hisentity");
            int[] selections = grid.getSelectRows();
            if (selections == null || selections.length == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u5386\u53f2\u540c\u6b65\u8bb0\u5f55\u3002", (String)"DataVersionFormPlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            int row = selections[0];
            DynamicObjectCollection hisEntrys = model.getEntryEntity("hisentity");
            if (hisEntrys.size() <= row) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u540c\u6b65\u8bb0\u5f55\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DataVersionFormPlugin_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject his = (DynamicObject)hisEntrys.get(row);
            final Object hisPk = his.get("id");
            his.set("activestatus", (Object)"D");
            for (int i = 0; i < hisEntrys.size(); ++i) {
                his = (DynamicObject)hisEntrys.get(i);
                String status = his.getString("activestatus");
                String syncstatus = his.getString("syncstatus");
                if ("A".equals(status)) break;
                if (!"B".equals(status) || !"S".equals(syncstatus) || this.checkExistEnableRow(hisEntrys)) continue;
                his.set("activestatus", (Object)"A");
                break;
            }
            DynamicObject entity = model.getDataEntity();
            BusinessDataWriter.update((IDataEntityType)model.getDataEntityType(), (Object[])new Object[]{entity});
            BaseDataServiceHelper.clearCache((DynamicObject)entity);
            ((BaseView)this.getView()).updateView("hisentity");
            grid.selectRows(row);
            this.hideDataViewerCtrl(row);
            this.getModel().setDataChanged(false);
            ThreadPools.executeOnceIncludeRequestContext((String)"mmc-datasync-data-clear-%s-%S", (Runnable)new Runnable(){

                @Override
                public void run() {
                    DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"clearDatas", (Object[])new Object[]{hisPk});
                }
            });
        } else if (OPER_DATAVIEWER.equals(operKey)) {
            ReportQueryParam queryParam = new ReportQueryParam();
            DynamicObjectCollection subs = this.getModel().getEntryEntity("subentryentity");
            String rowStr = this.getPageCache().get("subEntityRow");
            int subEntityRow = StringUtils.isBlank((CharSequence)rowStr) ? 0 : Integer.parseInt(rowStr);
            DynamicObject sub = (DynamicObject)subs.get(subEntityRow);
            DynamicObject selectedVersion = this.getModel().getDataEntity();
            DynamicObject selectedSettings = sub.getDynamicObject("hissettings");
            FilterInfo filter = queryParam.getFilter();
            filter.addFilterItem("dataversion", selectedVersion.getPkValue());
            filter.addFilterItem("syncsettings", selectedSettings.getPkValue());
            ReportShowParameter params = new ReportShowParameter();
            params.setFormId("msplan_ds_rpt");
            params.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPER_DATAVIEWER));
            params.setQueryParam(queryParam);
            params.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String pageId = sub.getString("id");
            logger.warn((Object)("mmc-datasync-detail-veiw, " + pageId));
            params.setPageId(selectedVersion.getString("id") + "-" + pageId);
            params.setHasRight(true);
            this.getView().showForm((FormShowParameter)params);
        } else if (OPER_SHOWDATASYNCSELECTOR.equals(operKey)) {
            BasedataEdit dsSelector = (BasedataEdit)this.getControl(CTRL_DATASYNCSELECTOR);
            dsSelector.click();
        } else if ("deleteentry".equals(operKey)) {
            IDataModel model = this.getModel();
            model.beginInit();
            try {
                DynamicObject data = model.getDataEntity();
                DynamicObjectCollection selections = data.getDynamicObjectCollection(CTRL_DATASYNCSELECTOR);
                DynamicObjectCollection newSelections = model.getEntryEntity(CTRL_SYNCSETTINGS);
                HashSet<Long> ids = new HashSet<Long>();
                for (DynamicObject obj : newSelections) {
                    ids.add(obj.getDynamicObject(ENTRY_SYNCSETTING).getLong("id"));
                }
                selections.removeIf(e -> !ids.contains(e.getDynamicObject("fbasedataid").get("id")));
            }
            finally {
                model.endInit();
                this.getView().updateView(CTRL_DATASYNCSELECTOR);
            }
        } else if ("executedatasync".equals(operKey)) {
            String billstatusfield = (String)this.getModel().getValue("billstatusfield");
            if (!"1".equalsIgnoreCase(billstatusfield)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001\u4e0d\u4e3a\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u3002", (String)"DataVersionFormPlugin_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            Long pk = this.getModel().getDataEntity().getLong("id");
            Map<String, Object> ret = this.dispatch(pk);
            if (!Boolean.TRUE.equals((Boolean)ret.get("ok"))) {
                this.getView().showMessage(ret.get("ec") + ":" + ret.get("em"));
            }
        } else if ("save".equals(operKey) || "submit".equals(operKey) || "unsubmit".equals(operKey) || "audit".equals(operKey) || "unaudit".equals(operKey)) {
            this.sync2EntryGrid();
            this.getView().updateView("modifier");
            this.getView().updateView("modifytime");
        } else if ("stopdatasync".equals(operKey)) {
            Long versionId = this.getModel().getDataEntity().getLong("id");
            EntryGrid grid = (EntryGrid)this.getControl("hisentity");
            if (grid.getSelectRows().length == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5386\u53f2\u540c\u6b65\u8bb0\u5f55\u3002", (String)"DataVersionFormPlugin_5", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            int sels = grid.getSelectRows()[0];
            Long hisEntryID = (Long)this.getModel().getValue("hisentity.id", sels);
            Map statistics = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"stopDataVersion", (Object[])new Object[]{versionId, hisEntryID});
            if (!Boolean.TRUE.equals((Boolean)statistics.get("ok"))) {
                throw new KDBizException("STOP_DATA_SYNC_FAILED, ec: " + statistics.get("ec") + ", em: " + statistics.get("em"));
            }
            this.getView().invokeOperation("refresh");
        } else if (OPER_ACTIVATE.equals(operKey)) {
            IDataModel model = this.getModel();
            EntryGrid grid = (EntryGrid)this.getControl("hisentity");
            int[] selections = grid.getSelectRows();
            if (selections == null || selections.length == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6fc0\u6d3b\u7684\u5386\u53f2\u540c\u6b65\u8bb0\u5f55\u3002", (String)"DataVersionFormPlugin_6", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            int row = selections[0];
            DynamicObjectCollection hisEntrys = model.getEntryEntity("hisentity");
            if (hisEntrys.size() <= row) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u540c\u6b65\u8bb0\u5f55\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DataVersionFormPlugin_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject his = (DynamicObject)hisEntrys.get(row);
            String syncStatus = his.getString("syncstatus");
            if (!"S".equals(syncStatus)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u6fc0\u6d3b\u6210\u529f\u540c\u6b65\u7684\u5386\u53f2\u6570\u636e\u3002", (String)"DataVersionFormPlugin_7", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            String currentStatus = his.getString("activestatus");
            if ("B".equals(currentStatus)) {
                his.set("activestatus", (Object)"A");
                for (int i = 0; i < hisEntrys.size(); ++i) {
                    DynamicObject _his = (DynamicObject)hisEntrys.get(i);
                    String status = _his.getString("activestatus");
                    if (_his == his || !"A".equals(status)) continue;
                    _his.set("activestatus", (Object)"B");
                }
                DynamicObject entity = model.getDataEntity();
                BusinessDataWriter.update((IDataEntityType)model.getDataEntityType(), (Object[])new Object[]{entity});
                BaseDataServiceHelper.clearCache((DynamicObject)entity);
                ((BaseView)this.getView()).updateView("hisentity");
                grid.selectRows(row);
                this.getModel().setDataChanged(false);
            } else if ("D".equals(currentStatus)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u5df2\u88ab\u6e05\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6fc0\u6d3b\u3002", (String)"DataVersionFormPlugin_8", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("refresh".equals(operKey)) {
            this.hideDataViewerCtrl(0);
            this.getView().updateView("subentryentity");
        }
    }

    public boolean tryLock(Long versionId) {
        boolean ret;
        String lockKey = versionId + "_lock";
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("MMC-DATASYNC");
        boolean bl = ret = cache.get(lockKey) == null;
        if (ret) {
            cache.put(lockKey, (Object)"1");
        }
        return ret;
    }

    public static boolean exist(Long versionId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("MMC-DATASYNC");
        String val = (String)cache.get(String.valueOf(versionId), "executor");
        return "1".equals(val);
    }

    private Map<String, Object> dispatch(Long pk) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("PK", pk);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (!this.tryLock(pk)) {
            ret.put("ok", Boolean.FALSE);
            ret.put("ec", "10000");
            ret.put("em", ResManager.loadKDString((String)"\u7248\u672c\u88ab\u9501\u5b9a\uff0c\u8bf7\u91ca\u653e\u7248\u672c\u9501\u540e\u8fdb\u884c\u6570\u636e\u540c\u6b65\u3002", (String)"DataVersionFormPlugin_9", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return ret;
        }
        DynamicObject dataVer = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"msplan_ds_version");
        DynamicObjectCollection hisEntrys = dataVer.getDynamicObjectCollection("hisentity");
        if (!hisEntrys.isEmpty()) {
            hisEntrys.sort((Comparator)new DataVersionFormSyncHisEntrySorter());
            if ("A".equals(((DynamicObject)hisEntrys.get(0)).getString("syncstatus")) && DataVersionFormPlugin.exist(pk)) {
                ret.put("ok", Boolean.FALSE);
                ret.put("ec", "10001");
                ret.put("em", ResManager.loadKDString((String)"\u6570\u636e\u7248\u672c\u540c\u6b65\u4e2d\uff0c\u8bf7\u7b49\u5f85\u672c\u6b21\u540c\u6b65\u5b8c\u6210\u518d\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", (String)"DataVersionFormPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return ret;
            }
        }
        String className = "kd.mpscmm.msplan.mservice.service.datasync.task.DataSyncCalcTask";
        JobInfo jobInfo = this.createJobInfo("mrp", JobType.REALTIME, ResManager.loadKDString((String)"\u6570\u636e\u7248\u672c\u540c\u6b65", (String)"DataVersionFormPlugin_10", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), className, params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dispatch_key");
        String clickClassName = "kd.mpscmm.msplan.mservice.service.datasync.task.DataSyncCalcClickTask";
        JobFormInfo jobFormInfo = this.createJobFormInfo(jobInfo, ResManager.loadKDString((String)"\u6570\u636e\u7248\u672c\u540c\u6b65", (String)"DataVersionFormPlugin_10", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), closeCallBack, true, true, clickClassName);
        DataVersionFormPlugin.dispatch(jobFormInfo, this.getView(), pk);
        ret.put("ok", Boolean.TRUE);
        return ret;
    }

    public static void dispatch(JobFormInfo jobFormInfo, IFormView view, Long versionid) {
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        jobFormInfo.setParentPageId(view.getPageId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msplan_taskprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isBlank((CharSequence)jobFormInfo.getCaption())) {
            showParameter.setCaption(jobFormInfo.getCaption());
        } else if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getName())) {
            showParameter.setCaption(jobFormInfo.getJobInfo().getName());
        }
        showParameter.getCustomParams().put("ServiceAppId", view.getFormShowParameter().getServiceAppId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
        showParameter.getCustomParams().put("versionid", versionid);
        showParameter.setCloseCallBack(jobFormInfo.getCloseCallBack());
        view.showForm(showParameter);
    }

    private JobInfo createJobInfo(String appId, JobType jobType, String jobName, String taskClassname, Map<String, Object> params) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setJobType(jobType);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setName(jobName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(taskClassname);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setParams(params);
        return jobInfo;
    }

    private JobFormInfo createJobFormInfo(JobInfo jobInfo, String caption, CloseCallBack closeCallBack, boolean isCanBackground, boolean isCanStop, String clickClassName) {
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(caption);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(isCanBackground);
        jobFormInfo.setCanStop(isCanStop);
        jobFormInfo.setClickClassName(clickClassName);
        return jobFormInfo;
    }

    public void afterF7Select(AfterF7SelectEvent paramAfterF7SelectEvent) {
        this.sync2EntryGrid();
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync2EntryGrid() {
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity();
        DynamicObjectCollection selections = data.getDynamicObjectCollection(CTRL_DATASYNCSELECTOR);
        int size = selections.size();
        if (size == 0) {
            return;
        }
        model.beginInit();
        try {
            model.deleteEntryData(CTRL_SYNCSETTINGS);
            model.batchCreateNewEntryRow(CTRL_SYNCSETTINGS, size);
            int i = 0;
            for (DynamicObject selection : selections) {
                model.setValue(ENTRY_SYNCSETTING, (Object)selection.getDynamicObject("fbasedataid"), i);
                ++i;
            }
        }
        finally {
            model.endInit();
            DynamicObjectCollection entrys = data.getDynamicObjectCollection(CTRL_SYNCSETTINGS);
            for (DynamicObject entry : entrys) {
                entry.getDataEntityState().setBizChanged(false);
            }
            this.getView().updateView(CTRL_SYNCSETTINGS);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("showdatasyncprogressor".equals(evt.getActionId())) {
            this.getView().invokeOperation("refresh");
        } else if ("dispatch_key".equals(evt.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void cellClick(CellClickEvent evt) {
        Object src = evt.getSource();
        if (src == this.getControl("hisentity")) {
            EntryGrid grid = (EntryGrid)src;
            int[] selections = grid.getSelectRows();
            if (selections == null || selections.length == 0) {
                return;
            }
            int row = selections[0];
            this.hideDataViewerCtrl(row);
        } else if (src == this.getControl("subentryentity") && OPER_DATAVIEWER.equals(evt.getFieldKey())) {
            this.getPageCache().put("subEntityRow", String.valueOf(evt.getRow()));
        }
    }

    private void hideDataViewerCtrl(int hisEntryRow) {
        IDataModel model = this.getModel();
        DynamicObjectCollection hisEntrys = model.getEntryEntity("hisentity");
        if (hisEntrys.isEmpty()) {
            return;
        }
        DynamicObject his = (DynamicObject)hisEntrys.get(hisEntryRow);
        String syncStatus = his.getString("activestatus");
        SubEntryGrid subEntity = (SubEntryGrid)this.getControl("subentryentity");
        if ("D".equals(syncStatus) || "B".equals(syncStatus) || StringUtils.isBlank((CharSequence)syncStatus)) {
            ArrayList<String> keys = new ArrayList<String>();
            keys.add(OPER_DATAVIEWER);
            int rc = model.getEntryRowCount("subentryentity");
            for (int i = 0; i < rc; ++i) {
                subEntity.hideOperateItems(OPER_DATAVIEWER, i, keys);
            }
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void onProgress(ProgressEvent evt) {
        DynamicObject entity = this.getModel().getDataEntity();
        Long versionId = entity.getLong("id");
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"queryDataSyncActionStatus", (Object[])new Object[]{versionId});
        int ip = 0;
        String cacheKey = "running.task.current.progress";
        if (Boolean.TRUE.equals((Boolean)result.get("ok"))) {
            Map statistics = (Map)result.get("desc");
            String status = (String)statistics.get("status");
            if ("A".equals(status)) {
                String p = this.getPageCache().get(cacheKey);
                if (!StringUtils.isEmpty((CharSequence)p)) {
                    ip = Integer.parseInt(p);
                }
                if (++ip == 100) {
                    ip = 0;
                }
            } else {
                ip = 100;
            }
        } else {
            ip = 100;
        }
        this.getPageCache().put(cacheKey, String.valueOf(ip));
        evt.setProgress(ip);
        if (ip == 100) {
            this.getView().invokeOperation("refresh");
            ProgressBar pb = (ProgressBar)this.getControl("progressbarap");
            pb.stop();
        }
    }

    static class DataVersionFormSyncHisEntrySorter
    implements Comparator<DynamicObject> {
        DataVersionFormSyncHisEntrySorter() {
        }

        @Override
        public int compare(DynamicObject o1, DynamicObject o2) {
            long s2;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            long s1 = o1.getDate("startdatetime").getTime();
            return s1 < (s2 = o2.getDate("startdatetime").getTime()) ? 1 : (s1 == s2 ? 0 : -1);
        }
    }
}

