/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.datasync.formplugin;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPools;

public class DataVersionHisClearSettingsFormPlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject entity = this.getModel().getDataEntity();
        entity.set("startdate", (Object)new Timestamp(System.currentTimeMillis() - 691200000L));
        entity.set("enddate", (Object)new Timestamp(System.currentTimeMillis() - 259200000L));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((Button)this.getControl("btnconfirm")).addClickListener((ClickListener)this);
        ((Button)this.getControl("btncancel")).addClickListener((ClickListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src == this.getControl("btnconfirm")) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject entity = this.getModel().getDataEntity();
            final Boolean isSelOnly = entity.getBoolean("btnselonly");
            QFilter statusFilter = new QFilter("hisentity.activestatus", "=", (Object)"B");
            filters.add(statusFilter);
            final Date startdate = (Date)entity.get("startdate");
            QFilter startFilter = new QFilter("hisentity.startdatetime", ">=", (Object)startdate);
            filters.add(startFilter);
            final Date enddate = (Date)entity.get("enddate");
            QFilter endFilter = new QFilter("hisentity.startdatetime", "<=", (Object)enddate);
            filters.add(endFilter);
            ORM orm = ORM.create();
            DataSet ds = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "msplan_ds_version", "id, hisentity.id", filters.toArray(new QFilter[0]));
            final ArrayList<Long> ids = new ArrayList<Long>();
            ArrayList<Object[]> updates = new ArrayList<Object[]>();
            try {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Long hisEntryId = row.getLong("hisentity.id");
                    ids.add(hisEntryId);
                    updates.add(new Object[]{hisEntryId});
                }
            }
            finally {
                ds.close();
            }
            if (!updates.isEmpty()) {
                DB.executeBatch((DBRoute)new DBRoute("scm"), (String)"UPDATE t_msplan_dv_hisentry set factivestatus = 'D' where fentryid = ?", updates);
            }
            ThreadPools.executeOnceIncludeRequestContext((String)"mmc-datasync-batch-data-clear", (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (isSelOnly.booleanValue()) {
                        DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"batchClearDatas", (Object[])new Object[]{ids.toArray(new Long[0]), null, null});
                    } else {
                        DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"batchClearDatas", (Object[])new Object[]{null, startdate.getTime(), enddate.getTime()});
                    }
                }
            });
        }
        this.getView().close();
    }
}

