/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.datasync.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.datasync.util.EntityTreeBuilder;

public class EntityFieldSelectorFormPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    public static final String ENTITY_TYPE = "__et__";
    public static final String FIELD_SELECTIONS = "__selections__";
    public static final String ENTITY_ID = "entityselector";
    public static final String ACTION_KEY = "__actionKey__";
    public static final String ACTION_VAL = "__actionVal__";
    public static final String CTRL_BTN_CANCEL = "btncancel";
    public static final String CTRL_BTN_CONFIRM = "btnok";
    public static final String TREE_NODE_ID = "id";
    public static final String TREE_NODE_TEXT = "text";
    private static final String CTRL_TREE_VIEW = "tv_fields";
    private static final String CTRL_TREESEARCH = "treesearch";
    private static final String LATEST_SEARCH_TXT = "latestSearchTxt";
    private static final String LATEST_SEARCH_NODE_IDX = "latestSearchNodeIdx";
    private static final String TREE_NODE_CACHE = "treeNodes";
    private String et;

    public void initialize() {
        super.initialize();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter params = this.getView().getFormShowParameter();
        this.et = (String)params.getCustomParam(ENTITY_TYPE);
        if (StringUtils.isEmpty((String)this.et)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"EntityFieldSelectorFormPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            this.getView().close();
        } else {
            TreeView tv = (TreeView)this.getView().getControl(CTRL_TREE_VIEW);
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)this.et);
            TreeNode root = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
            EntityTreeBuilder.buildTree(mainType, root, 3);
            JSONArray arr = (JSONArray)params.getCustomParam(FIELD_SELECTIONS);
            HashSet<String> selections = new HashSet<String>(arr.size());
            for (int i = 0; i < arr.size(); ++i) {
                selections.add(arr.getString(i));
            }
            tv.addNode(root);
            CheckNodeVisitor visitor = new CheckNodeVisitor(selections);
            this.find(root, visitor);
            tv.checkNodes(visitor.nodes);
            this.getPageCache().put(TREE_NODE_CACHE, JSON.toJSONString((Object)root));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_BTN_CANCEL, CTRL_BTN_CONFIRM});
        Search search = (Search)this.getControl(CTRL_TREESEARCH);
        search.addEnterListener((SearchEnterListener)this);
        this.registFastKeys();
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(ACTION_KEY, key);
        switch (key) {
            case "btncancel": {
                break;
            }
            case "btnok": {
                TreeView tv = (TreeView)this.getView().getControl(CTRL_TREE_VIEW);
                List selections = tv.getTreeState().getCheckedNodes();
                ret.put(ACTION_VAL, selections);
                this.getView().returnDataToParent(ret);
            }
        }
        this.getView().close();
    }

    private void doSearch(String searchTxt) {
        TreeView tv = (TreeView)this.getView().getControl(CTRL_TREE_VIEW);
        IPageCache pageCahe = this.getPageCache();
        String oldSearchTxt = pageCahe.get(LATEST_SEARCH_TXT);
        TreeNode root = (TreeNode)JSON.parseObject((String)pageCahe.get(TREE_NODE_CACHE), TreeNode.class);
        String idxStr = pageCahe.get(LATEST_SEARCH_NODE_IDX);
        if (StringUtils.isEmpty((String)searchTxt)) {
            pageCahe.remove(LATEST_SEARCH_TXT);
            pageCahe.remove(LATEST_SEARCH_NODE_IDX);
            if (!StringUtils.isEmpty((String)oldSearchTxt)) {
                this.updateNodes(root, tv, oldSearchTxt, "#000000");
            }
            return;
        }
        int idx = 0;
        if (!StringUtils.isEmpty((String)idxStr)) {
            idx = Integer.parseInt(idxStr);
        }
        if (!searchTxt.equals(oldSearchTxt)) {
            idx = 0;
            if (!StringUtils.isEmpty((String)oldSearchTxt)) {
                this.updateNodes(root, tv, oldSearchTxt, "#000000");
            }
        }
        SearchNodeVisitor visitor = new SearchNodeVisitor(searchTxt, "#00ff00");
        this.find(root, visitor);
        List nodes = visitor.nodes;
        tv.updateNodes(nodes);
        if (nodes != null && idx == nodes.size()) {
            idx = 0;
        }
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        TreeNode selection = (TreeNode)nodes.get(idx++);
        selection.setColor("#ff0000");
        tv.showNode(selection.getId());
        tv.focusNode(selection);
        pageCahe.put(LATEST_SEARCH_TXT, searchTxt);
        pageCahe.put(LATEST_SEARCH_NODE_IDX, String.valueOf(idx));
    }

    private void updateNodes(TreeNode root, TreeView tv, String searchTxt, String color) {
        SearchNodeVisitor visitor = new SearchNodeVisitor(searchTxt, "#000000");
        this.find(root, visitor);
        tv.updateNodes(visitor.nodes);
    }

    private void find(TreeNode root, INodeVisitor visitor) {
        this.dfs(root, visitor);
    }

    private void dfs(TreeNode root, INodeVisitor visitor) {
        if (!visitor.visit(root)) {
            return;
        }
        if (!root.isLeaf() && root.getChildren() != null && root.getChildren().size() > 0) {
            for (TreeNode node : root.getChildren()) {
                this.dfs(node, visitor);
            }
        }
    }

    private void registFastKeys() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item = new JSONObject();
        item.put("k", (Object)CTRL_TREESEARCH);
        item.put("type", (Object)"keyDown");
        item.put("shortCuts", (Object)"enter");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void customEvent(CustomEventArgs e) {
        String key;
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts") && "[13]".equals(key = e.getEventArgs())) {
            String oldSearchTxt = this.getPageCache().get(LATEST_SEARCH_TXT);
            if (StringUtils.isEmpty((String)oldSearchTxt)) {
                return;
            }
            this.doSearch(oldSearchTxt);
        }
    }

    public void search(SearchEnterEvent evt) {
        this.doSearch(evt.getText());
    }

    private static class CheckNodeVisitor
    implements INodeVisitor {
        private Set<String> ids;
        private List<TreeNode> nodes = new ArrayList<TreeNode>();

        public CheckNodeVisitor(Set<String> ids) {
            this.ids = ids;
        }

        @Override
        public boolean visit(TreeNode node) {
            String id = node.getId();
            if (this.ids.remove(id)) {
                this.nodes.add(node);
            }
            return !this.ids.isEmpty();
        }
    }

    private static class SearchNodeVisitor
    implements INodeVisitor {
        private String searchTxt;
        private String color;
        private List<TreeNode> nodes = new ArrayList<TreeNode>();

        public SearchNodeVisitor(String searchTxt, String color) {
            this.searchTxt = searchTxt;
            this.color = color;
        }

        @Override
        public boolean visit(TreeNode root) {
            if (root.getId().contains(this.searchTxt) || root.getText().contains(this.searchTxt)) {
                this.nodes.add(root);
                root.setColor(this.color);
            }
            return true;
        }
    }

    private static interface INodeVisitor {
        public boolean visit(TreeNode var1);
    }
}

