/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.datasync.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.mpscmm.common.enums.GanttLabelTypeEnum;
import kd.mpscmm.gantt.model.FiledLabel;

public class MutilFieldSelectorConfirmPlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("signfields");
            if (dynamicObjects.isEmpty()) {
                this.getView().returnDataToParent((Object)"");
            } else {
                ArrayList<FiledLabel> labels = new ArrayList<FiledLabel>(dynamicObjects.size());
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String labeltype = dynamicObject.getString("labeltype");
                    String labelformat = dynamicObject.getString("labelformat");
                    if (StringUtils.isEmpty((CharSequence)labelformat)) {
                        labelformat = " ";
                    } else if (StringUtils.equals((CharSequence)labelformat, (CharSequence)"1")) {
                        labelformat = "yyyy-MM-dd";
                    } else if (StringUtils.equals((CharSequence)labelformat, (CharSequence)"2")) {
                        labelformat = "yyyy-MM-dd HH:mm:ss";
                    }
                    FiledLabel filedLabel = new FiledLabel(dynamicObject.getString("fkey"), dynamicObject.getString("fname"), StringUtils.isEmpty((CharSequence)labeltype) ? " " : labeltype, StringUtils.isEmpty((CharSequence)labelformat) ? " " : labelformat);
                    labels.add(filedLabel);
                }
                this.getView().returnDataToParent(labels);
            }
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("signfields");
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            if (!StringUtils.isBlank((CharSequence)dynamicObject.getString("labeltype")) && !StringUtils.equals((CharSequence)GanttLabelTypeEnum.PERCENTAGE.getValue(), (CharSequence)dynamicObject.getString("labeltype"))) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"labelformat"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeDatas = e.getChangeSet();
        if ("labeltype".equals(key)) {
            String labeltype = (String)changeDatas[0].getNewValue();
            if (StringUtils.equals((CharSequence)GanttLabelTypeEnum.PERCENTAGE.getValue(), (CharSequence)labeltype)) {
                this.getModel().setValue("labelformat", (Object)"%", changeDatas[0].getRowIndex());
                this.getView().setEnable(Boolean.FALSE, changeDatas[0].getRowIndex(), new String[]{"labelformat"});
            } else if (StringUtils.equals((CharSequence)GanttLabelTypeEnum.DATE.getValue(), (CharSequence)labeltype)) {
                this.getModel().setValue("labelformat", null, changeDatas[0].getRowIndex());
                this.getView().setEnable(Boolean.TRUE, changeDatas[0].getRowIndex(), new String[]{"labelformat"});
            }
        }
    }
}

