/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.datasync.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.annotation.PluginEvent;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;

public class MutilFieldSelectorFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    public static final String FormId_SelectField = "botp_selectfield";
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String CustParamKey_IsMulti = "ismulti";
    public static final String CustParamKey_SelectedNodeIds = "nodeids";
    public static final String Key_btnOK = "btnok";
    public static final String Key_btnCancel = "btncancel";
    public static final String Key_TreeView = "tv_fields";
    public static final String Key_SearchField = "searchfield";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search search = (Search)this.getView().getControl(Key_SearchField);
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        } else {
            this.addTreeRootNode();
        }
    }

    @PluginEvent(enableOverride=true)
    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeId = this.getNodeIds();
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                this.getView().returnDataToParent((Object)currNodeId);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
            this.getView().close();
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            return;
        }
        this.getView().returnDataToParent((Object)currNodeId);
        this.getView().close();
    }

    private void removeParentNodeId(Object parentNodeId, List<String> currChecks, TreeNode rootNode) {
        if (Objects.nonNull(parentNodeId) && StringUtils.isNotEmpty((CharSequence)parentNodeId.toString())) {
            if (currChecks.contains(parentNodeId)) {
                currChecks.remove(parentNodeId);
            }
            this.removeParentNodeId(rootNode.getTreeNode(parentNodeId.toString()).getParentid(), currChecks, rootNode);
        }
    }

    private List<String> getControlNode(TreeNodeCheckEvent evt) {
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        boolean ischeck = evt.getChecked();
        ArrayList<String> nodeIDs = new ArrayList<String>(16);
        String nodesJson = this.getPageCache().get("nodesJson");
        String strJson = StringUtils.isNotEmpty((CharSequence)nodesJson) ? nodesJson : (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        ArrayList<String> currChecks = new ArrayList<String>(tree.getTreeState().getCheckedNodeIds());
        this.removeParentNodeId(evt.getParentNodeId(), currChecks, rootNode);
        for (int i = 0; i < currChecks.size(); ++i) {
            String nodeId = (String)currChecks.get(i);
            if (currChecks.contains(rootNode.getTreeNode(nodeId).getParentid())) {
                currChecks.remove(rootNode.getTreeNode(nodeId).getParentid());
            }
            if (CollectionUtils.isEmpty((Collection)rootNode.getTreeNode(nodeId).getChildren())) continue;
            currChecks.remove(nodeId);
        }
        String nodeIds = this.getNodeIds();
        String selectField = nodeIds == null ? "" : nodeIds;
        String[] arrays = selectField != null ? StringUtils.split((String)selectField, (String)",") : new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>(16);
        arrayList.addAll(Arrays.asList(arrays));
        if (ischeck) {
            for (String checkObj : currChecks) {
                if (arrayList.contains(checkObj)) continue;
                nodeIDs.add(checkObj);
            }
        } else {
            ArrayList<String> currUnChecks = new ArrayList<String>(16);
            if (!CollectionUtils.isEmpty((Collection)rootNode.getChildren())) {
                this.setNodes(rootNode.getChildren(), currUnChecks);
            }
            if (!currChecks.isEmpty()) {
                currUnChecks.removeAll(currChecks);
            }
            for (String checkObj : arrays) {
                if (!currUnChecks.contains(checkObj)) continue;
                nodeIDs.add(checkObj);
            }
        }
        return nodeIDs;
    }

    private void setNodes(List<TreeNode> treeNodeList, List<String> currChecks) {
        for (TreeNode treeNode : treeNodeList) {
            if (CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
                currChecks.add(treeNode.getId());
                continue;
            }
            this.setNodes(treeNode.getChildren(), currChecks);
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        String metaDataKey = (String)this.getView().getFormShowParameter().getCustomParam("formNumber");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)metaDataKey);
        String nodeIds = this.getNodeIds();
        String selectField = nodeIds == null ? "" : nodeIds;
        String[] arrays = selectField != null ? StringUtils.split((String)selectField, (String)",") : new String[]{};
        boolean isCheck = evt.getChecked();
        List<String> changeNodes = this.getControlNode(evt);
        if (isCheck) {
            for (String addNode : changeNodes) {
                int row = this.getModel().createNewEntryRow("signfields");
                this.getModel().setValue("fkey", (Object)addNode, row);
                this.getModel().setValue("fname", (Object)BillFieldEntityHelper.buildPropFullCaption((EntityType)entityType, (String)addNode), row);
            }
        } else {
            for (String delNode : changeNodes) {
                DynamicObjectCollection colls = this.getModel().getEntryEntity("signfields");
                for (int row = colls.size() - 1; row >= 0; --row) {
                    String key = ((DynamicObject)colls.get(row)).getString("fkey");
                    if (!key.equals(delNode)) continue;
                    this.getModel().deleteEntryRow("signfields", row);
                }
            }
        }
    }

    private void fillTreeNodes(String strJson) {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(rootNode);
        if (this.isMultiSelected()) {
            this.multiSelect(tree, rootNode, "fillEntry");
        }
    }

    private String getNodeIds() {
        StringBuilder nodeids = new StringBuilder();
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("signfields");
        for (DynamicObject dynamicObject : dynamicObjects) {
            nodeids.append(dynamicObject.getString("fkey")).append(",");
        }
        if (nodeids.length() > 0) {
            return nodeids.substring(0, nodeids.length() - 1);
        }
        return null;
    }

    private void multiSelect(TreeView tree, TreeNode rootNode, String flag) {
        tree.setMulti(true);
        String cacheNodeIds = "";
        if (StringUtils.equals((CharSequence)flag, (CharSequence)"fillEntry")) {
            cacheNodeIds = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_SelectedNodeIds);
        } else {
            StringBuilder nodeids = new StringBuilder();
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("signfields");
            for (DynamicObject dynamicObject : dynamicObjects) {
                nodeids.append(dynamicObject.getString("fkey")).append(",");
            }
            cacheNodeIds = this.getNodeIds();
        }
        String metaDataKey = (String)this.getView().getFormShowParameter().getCustomParam("formNumber");
        String labelTypes = (String)this.getView().getFormShowParameter().getCustomParam("labelTypes");
        String labelFormats = (String)this.getView().getFormShowParameter().getCustomParam("labelFormats");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)metaDataKey);
        if (StringUtils.isNotBlank((CharSequence)cacheNodeIds)) {
            String[] arr = StringUtils.split((String)cacheNodeIds, (String)",");
            String[] labelTypesArr = StringUtils.isEmpty((CharSequence)labelTypes) ? null : labelTypes.split(",");
            String[] labelFormatsArr = StringUtils.isEmpty((CharSequence)labelFormats) ? null : labelFormats.split(",");
            ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>(16);
            int index = 0;
            for (String nodeId : arr) {
                TreeNode node = rootNode.getTreeNode(nodeId, 5);
                if (node != null) {
                    selectedNodes.add(node);
                    if (StringUtils.equals((CharSequence)flag, (CharSequence)"fillEntry")) {
                        int row = this.getModel().createNewEntryRow("signfields");
                        this.getModel().setValue("fkey", (Object)node.getId(), row);
                        this.getModel().setValue("fname", (Object)BillFieldEntityHelper.buildPropFullCaption((EntityType)entityType, (String)node.getId()), row);
                        if (StringUtils.isNotEmpty((CharSequence)labelTypes) && labelTypesArr != null && labelTypesArr.length == arr.length) {
                            this.getModel().setValue("labeltype", (Object)labelTypesArr[index], row);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)labelFormats) && labelFormatsArr != null && labelFormatsArr.length == arr.length) {
                            this.getModel().setValue("labelformat", (Object)labelFormatsArr[index], row);
                        }
                    }
                }
                ++index;
            }
            if (selectedNodes.size() > 0) {
                tree.checkNodes(selectedNodes);
            }
        }
        this.getView().updateView("signfields");
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"SelectFieldList_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(root);
    }

    private boolean isMultiSelected() {
        String isMulti = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_IsMulti);
        if (StringUtils.isBlank((CharSequence)isMulti)) {
            return false;
        }
        return isMulti.equalsIgnoreCase("true") || isMulti.equalsIgnoreCase("1");
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)Key_SearchField, (CharSequence)search.getKey())) {
            String searchText = evt.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
            if (StringUtils.isNotBlank((CharSequence)searchText) && rootNode.getChildren().size() > 0) {
                rootNode.setChildren(this.getContains(rootNode.getChildren(), searchText));
            }
            String nodesJson = SerializationUtils.toJsonString((Object)rootNode);
            this.getPageCache().put("nodesJson", nodesJson);
            tree.updateNode(rootNode);
            if (this.isMultiSelected()) {
                this.multiSelect(tree, rootNode, "doSearch");
            }
        }
    }

    private List<TreeNode> getContains(List<TreeNode> childrens, String searchText) {
        Iterator<TreeNode> iterator = childrens.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = iterator.next();
            if (treeNode == null || treeNode.getText().contains(searchText)) continue;
            if (treeNode.getChildren() != null && treeNode.getChildren().size() > 0) {
                treeNode.setChildren(this.getContains(treeNode.getChildren(), searchText));
            }
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren()) || treeNode.getText().contains(searchText)) continue;
            iterator.remove();
        }
        return childrens;
    }
}

