/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.datasync.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msplan.datasync.formplugin.BackgroundTaskSubscriber;

public class TaskProgressFormEdit
extends AbstractFormPlugin
implements ProgresssListener {
    public static final String FORMID_TASKPROGRESS = "msplan_taskprogress";
    public static final String CUSTPARAM_CLIENTJOBINFO = "sch_clientjobinfo";
    public static final String CUSTPARAM_TASKID = "sch_taskid";
    private boolean canClose = false;
    private JobFormInfo jobFormInfo = null;

    private JobFormInfo getJobFormInfo() {
        if (this.jobFormInfo == null) {
            String str = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_CLIENTJOBINFO);
            if (StringUtils.isBlank((CharSequence)str)) {
                return null;
            }
            this.jobFormInfo = (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
        }
        FormShowParameter params = this.getView().getFormShowParameter();
        Long versionId = (Long)params.getCustomParam("versionid");
        this.jobFormInfo.getParams().put("versionid", versionId);
        this.jobFormInfo.setTimeout(1200000);
        return this.jobFormInfo;
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CUSTPARAM_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_TASKID);
        }
        return this.getPageCache().get(CUSTPARAM_TASKID);
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put(CUSTPARAM_TASKID, taskId);
    }

    private boolean isStart() {
        String start = this.getPageCache().get("isstart");
        if (StringUtils.isBlank((CharSequence)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put("isstart", String.valueOf(start));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get("isfinished");
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put("isfinished", String.valueOf(finished));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btnstop", "btnmin", "btnclose"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.startBar();
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnstop", "btnmin"});
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            this.setProgressDesc(ResManager.loadKDString((String)"\u51c6\u5907\u542f\u52a8\u4efb\u52a1", (String)"TaskProgressFormEdit_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        } else {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
            bar.setPercent(progress);
            this.setProgressDesc(taskInfo.getDesc());
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            if (jobFormInfo != null) {
                this.setButtonVisible(jobFormInfo);
            }
        }
    }

    public void click(EventObject e) {
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnstop")) {
            this.stop();
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnmin")) {
            this.tranBackground();
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnclose")) {
            this.getView().close();
        }
    }

    public void onProgress(ProgressEvent evt) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnclose"});
            this.dispatchTask();
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        FormShowParameter params = this.getView().getFormShowParameter();
        Long versionId = (Long)params.getCustomParam("versionid");
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"queryDataSyncActionStatus", (Object[])new Object[]{versionId});
        int ip = 0;
        if (!Boolean.TRUE.equals(result.get("ok"))) {
            throw new KDBizException("UNKNOWN SYNC STATUS, ec: " + result.get("ec") + ", em: " + result.get("em"));
        }
        Map statistics = (Map)result.get("desc");
        ip = this.updateProgress(statistics);
        evt.setProgress(ip);
    }

    private int updateProgress(Map<String, Object> statistics) {
        String msg;
        String status = (String)statistics.get("status");
        int ip = 0;
        if ("A".equals(status)) {
            ip = (Integer)statistics.get("progress");
            msg = (String)statistics.get("current");
        } else if ("S".equals(status)) {
            ip = 100;
            msg = ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u6210\u529f\u3002", (String)"TaskProgressFormEdit_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        } else if ("F".equals(status)) {
            ip = 100;
            msg = ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5931\u8d25\u3002", (String)"TaskProgressFormEdit_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        } else if ("C".equals(status)) {
            ip = 100;
            msg = ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u53d6\u6d88\u3002", (String)"TaskProgressFormEdit_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        } else if ("N".equals(status)) {
            ip = 100;
            msg = ResManager.loadKDString((String)"\u672a\u8fdb\u884c\u8fc7\u6570\u636e\u540c\u6b65\u3002", (String)"TaskProgressFormEdit_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        } else {
            throw new KDBizException("UNKNOWN SYNC STATUS, status: " + status);
        }
        if (ip == 100) {
            if ("A".equals(status)) {
                ip /= 2;
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnstop", "btnmin"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnclose"});
            }
            this.setFinished(true);
        }
        this.getModel().getDataEntity().set("progressdesc", (Object)msg);
        this.getView().updateView("progressdesc");
        return ip;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!this.isStart()) {
            e.setCancel(true);
            return;
        }
        if (this.canClose || this.isFinished()) {
            return;
        }
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo == null) {
            return;
        }
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        if (jobFormInfo.isCanStop()) {
            this.stop();
            e.setCancel(true);
        } else if (jobFormInfo.isCanBackground()) {
            this.tranBackground();
            e.setCancel(true);
        } else {
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() != MessageBoxResult.Yes) {
            this.startBar();
        } else if (StringUtils.equals((CharSequence)evt.getCallBackId(), (CharSequence)"continue_background")) {
            this.doTranBackground();
        } else {
            this.doStop();
        }
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)this.getView().getPageId());
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getAppId())) {
            jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.setTaskId(taskId);
        this.setButtonVisible(jobFormInfo);
    }

    private void stop() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_stop", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u6267\u884c", (String)"TaskProgressFormEdit_5", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ec8\u6b62\u6267\u884c", (String)"TaskProgressFormEdit_6", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u5c1a\u672a\u5b8c\u6210\uff0c\u786e\u8ba4\u7ec8\u6b62\u6267\u884c\uff1f\uff08\u5bf9\u5e94\u6309\u94ae\uff1a\u53d6\u6d88\u3001\u786e\u8ba4\uff09", (String)"TaskProgressFormEdit_7", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    private void doStop() {
        this.startBar();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        ScheduleServiceHelper.stopTask((String)taskId);
        this.setFinished(true);
        FormShowParameter params = this.getView().getFormShowParameter();
        Long versionId = (Long)params.getCustomParam("versionid");
        Map statistics = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"stopDataVersion", (Object[])new Object[]{versionId});
        if (!Boolean.TRUE.equals(statistics.get("ok"))) {
            throw new KDBizException("STOP_DATA_SYNC_FAILED, ec: " + statistics.get("ec") + ", em: " + statistics.get("em"));
        }
        this.getView().close();
    }

    private void tranBackground() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_background", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaskProgressFormEdit_8", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u540e\u53f0\u6267\u884c", (String)"TaskProgressFormEdit_9", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u5c1a\u672a\u5b8c\u6210\uff0c\u786e\u8ba4\u8f6c\u5165\u540e\u53f0\u6267\u884c\uff1f\uff08\u5bf9\u5e94\u6309\u94ae\uff1a\u53d6\u6d88\u3001\u786e\u8ba4\uff09", (String)"TaskProgressFormEdit_10", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        this.stopBar();
    }

    private void doTranBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), this.getJobFormInfo(), taskId);
            ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        }
    }

    private void setProgressDesc(String desc) {
        this.getModel().getDataEntity().set("progressdesc", (Object)desc);
        this.getView().updateView("progressdesc");
    }

    private void setButtonVisible(JobFormInfo jobFormInfo) {
        if (jobFormInfo.isCanStop()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnstop"});
        }
        if (jobFormInfo.isCanBackground()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnmin"});
        }
    }
}

