/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.permission.model.AdminType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;

public class AdjustSuggestReleaseEdit
extends AbstractBasePlugIn {
    private static final String ADJUST_SUG_FIELD_NAME = "adjustsugfieldname";
    private static final String ADJUST_SUG_FIELD_SIGN = "adjustsugfieldsign";
    private static final String CHANGE_BILL_FIELD_NAME = "changebillfieldname";
    private static final String CHANGE_BILL_FIELD_SIGN = "changebillfieldsign";
    private static final String REL_CONFIG_BASE_DATA = "relconfigbasedata";
    private static final String BILL_TYPE = "billtype";
    private static final String CHANGE_BILL = "changebill";
    private static final String NUMBER = "number";
    private static final String MRP_ADJUST_SUGGEST = "mrp_adjustsuggest";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String SUB_ENTRY_ENTITY = "subentryentity";
    private static final String MSPLAN_BILL_FIELD_SELECT = "msplan_billfieldselect";
    private static final String TREE_NODES = "treenodes";
    private static final String APPLICATION_NAME = "mpscmm-msplan-formplugin";
    private static final int AUTO_FILL_ROWS = 3;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit textEdit = (TextEdit)this.getControl(ADJUST_SUG_FIELD_NAME);
        if (textEdit != null) {
            textEdit.addClickListener((ClickListener)this);
        }
        if ((textEdit = (TextEdit)this.getControl(CHANGE_BILL_FIELD_NAME)) != null) {
            textEdit.addClickListener((ClickListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)BILL_TYPE)) {
            this.billTypeChanged();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)CHANGE_BILL)) {
            this.changeBillChanged();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)ADJUST_SUG_FIELD_NAME)) {
            this.adjustSugFieldNameChanged(e);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)CHANGE_BILL_FIELD_NAME)) {
            this.changeBillFieldNameChanged(e);
        }
    }

    public void afterBindData(EventObject e) {
        RequestContext requestContext = RequestContext.get();
        long userId = requestContext.getCurrUserId();
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)userId, (AdminType)AdminType.Administrator);
        if (!isAdmin) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_delete", "bar_save", "bar_disable", "bar_more"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap"});
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (ADJUST_SUG_FIELD_NAME.equals(source.getKey())) {
            this.subEntryEntityHandler(evt, BILL_TYPE);
        } else if (CHANGE_BILL_FIELD_NAME.equals(source.getKey())) {
            this.subEntryEntityHandler(evt, CHANGE_BILL);
        }
    }

    private void subEntryEntityHandler(BeforeClickEvent evt, String billRelate) {
        EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int selectRow = 0;
        if (entry.getSelectRows().length != 0) {
            selectRow = entry.getSelectRows()[0];
        }
        if (this.getModel().getValue(billRelate, selectRow) == null) {
            if (BILL_TYPE.equals(billRelate)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u8c03\u6574\u5355\u636e\u5173\u7cfb\u201d\u7b2c%s\u884c\u201c\u4f9b\u5e94\u5355\u636e\u5b9e\u4f53\u201d\u3002", (String)"AdjustSuggestReleaseEdit_0", (String)APPLICATION_NAME, (Object[])new Object[0]), selectRow + 1));
            } else if (CHANGE_BILL.equals(billRelate)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u8c03\u6574\u5355\u636e\u5173\u7cfb\u201d\u7b2c%s\u884c\u201c\u53d8\u66f4\u5355\u5b9e\u4f53\u201d\u3002", (String)"AdjustSuggestReleaseEdit_1", (String)APPLICATION_NAME, (Object[])new Object[0]), selectRow + 1));
            }
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if (ADJUST_SUG_FIELD_NAME.equals(fieldKey)) {
            this.openBillFieldList(REL_CONFIG_BASE_DATA);
        } else if (CHANGE_BILL_FIELD_NAME.equals(fieldKey)) {
            this.openBillFieldList(CHANGE_BILL);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (REL_CONFIG_BASE_DATA.equals(actionId) && returnData != null && !StringUtils.isBlank((Object)returnData)) {
            this.setEntryEntityField((String)returnData, REL_CONFIG_BASE_DATA, ADJUST_SUG_FIELD_NAME, ADJUST_SUG_FIELD_SIGN);
        } else if (CHANGE_BILL.equals(actionId) && returnData != null && !StringUtils.isBlank((Object)returnData)) {
            this.setEntryEntityField((String)returnData, CHANGE_BILL, CHANGE_BILL_FIELD_NAME, CHANGE_BILL_FIELD_SIGN);
        }
    }

    private void setEntryEntityField(String fieldId, String baseDataSign, String fieldNameParam, String fieldSignParam) {
        int row = this.getModel().getEntryCurrentRowIndex(SUB_ENTRY_ENTITY);
        MainEntityType srcbillMainType = this.getMainEntityType(baseDataSign);
        DynamicObjectCollection coll = this.getModel().getEntryEntity(SUB_ENTRY_ENTITY);
        Iterator its = coll.iterator();
        int index = 0;
        boolean flag = true;
        while (its.hasNext()) {
            DynamicObject it = (DynamicObject)its.next();
            String fieldName = it.getString(fieldSignParam);
            if (index != row && fieldName.equals(fieldId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u914d\u7f6e\u4e86\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u914d\u7f6e\u3002", (String)"AdjustSuggestReleaseEdit_2", (String)APPLICATION_NAME, (Object[])new Object[0]));
                flag = false;
                break;
            }
            ++index;
        }
        if (flag) {
            String fieldCaption = BillFieldEntityHelper.buildPropFullCaption((EntityType)srcbillMainType, (String)fieldId);
            this.getModel().setValue(fieldNameParam, (Object)fieldCaption, row);
            this.getModel().setValue(fieldSignParam, (Object)fieldId, row);
        }
    }

    private void billTypeChanged() {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(REL_CONFIG_BASE_DATA);
        if (dynamicObject != null && MRP_ADJUST_SUGGEST.equals(dynamicObject.getString(NUMBER))) {
            this.setAdjustSuggestFields();
        } else {
            IDataModel dataModel = this.getModel();
            int rowCount = dataModel.getEntryRowCount(SUB_ENTRY_ENTITY);
            if (rowCount > 0) {
                for (int i = 0; i < rowCount; ++i) {
                    dataModel.setValue(ADJUST_SUG_FIELD_NAME, (Object)"", i);
                    dataModel.setValue(ADJUST_SUG_FIELD_SIGN, (Object)"", i);
                }
            }
        }
    }

    private void changeBillChanged() {
        IDataModel dataModel = this.getModel();
        int rowCount = dataModel.getEntryRowCount(SUB_ENTRY_ENTITY);
        for (int i = 0; i < rowCount; ++i) {
            dataModel.setValue(CHANGE_BILL_FIELD_NAME, (Object)"", i);
            dataModel.setValue(CHANGE_BILL_FIELD_SIGN, (Object)"", i);
        }
    }

    private void adjustSugFieldNameChanged(PropertyChangedArgs e) {
        if ("".equals(e.getChangeSet()[0].getNewValue())) {
            int index = this.getModel().getEntryCurrentRowIndex(SUB_ENTRY_ENTITY);
            this.getModel().setValue(ADJUST_SUG_FIELD_SIGN, (Object)"", index);
        }
    }

    private void changeBillFieldNameChanged(PropertyChangedArgs e) {
        if ("".equals(e.getChangeSet()[0].getNewValue())) {
            int index = this.getModel().getEntryCurrentRowIndex(SUB_ENTRY_ENTITY);
            this.getModel().setValue(CHANGE_BILL_FIELD_SIGN, (Object)"", index);
        }
    }

    private void setAdjustSuggestFields() {
        IDataModel dataModel = this.getModel();
        int rowCount = dataModel.getEntryRowCount(SUB_ENTRY_ENTITY);
        for (int i = 0; i < rowCount; ++i) {
            dataModel.setValue(ADJUST_SUG_FIELD_NAME, (Object)"", i);
            dataModel.setValue(ADJUST_SUG_FIELD_SIGN, (Object)"", i);
        }
        if (rowCount < 3) {
            dataModel.batchCreateNewEntryRow(SUB_ENTRY_ENTITY, 3 - rowCount);
        }
        dataModel.setValue(ADJUST_SUG_FIELD_NAME, (Object)ResManager.loadKDString((String)"\u5355\u636e\u5934.\u6570\u91cf", (String)"AdjustSuggestReleaseEdit_3", (String)APPLICATION_NAME, (Object[])new Object[0]), 0);
        dataModel.setValue(ADJUST_SUG_FIELD_SIGN, (Object)"qty", 0);
        dataModel.setValue(ADJUST_SUG_FIELD_NAME, (Object)ResManager.loadKDString((String)"\u5355\u636e\u5934.\u8c03\u6574\u53ef\u7528\u65e5\u671f", (String)"AdjustSuggestReleaseEdit_4", (String)APPLICATION_NAME, (Object[])new Object[0]), 1);
        dataModel.setValue(ADJUST_SUG_FIELD_SIGN, (Object)"adjustdate", 1);
        dataModel.setValue(ADJUST_SUG_FIELD_NAME, (Object)ResManager.loadKDString((String)"\u5355\u636e\u5934.\u8c03\u6574\u539f\u56e0", (String)"AdjustSuggestReleaseEdit_5", (String)APPLICATION_NAME, (Object[])new Object[0]), 2);
        dataModel.setValue(ADJUST_SUG_FIELD_SIGN, (Object)"adjustcause", 2);
    }

    private MainEntityType getMainEntityType(String entityname) {
        DynamicObject accEntity = (DynamicObject)this.getModel().getValue(entityname);
        if (accEntity != null) {
            Object billentityPkValue = accEntity.getPkValue();
            return MetadataServiceHelper.getDataEntityType((String)billentityPkValue.toString());
        }
        return null;
    }

    private void openBillFieldList(String baseDataTag) {
        int row = this.getModel().getEntryCurrentRowIndex(SUB_ENTRY_ENTITY);
        MainEntityType billMainType = this.getMainEntityType(baseDataTag);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(billMainType);
        parameter.setIncludePKField(true);
        parameter.setOnlyPhysicsField(false);
        if (row >= 0) {
            if (StringUtils.equals((CharSequence)CHANGE_BILL, (CharSequence)baseDataTag)) {
                String adjustsugfieldsign = (String)this.getModel().getValue(ADJUST_SUG_FIELD_SIGN, row);
                if (StringUtils.isBlank((CharSequence)adjustsugfieldsign)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u8c03\u6574\u5b57\u6bb5\u914d\u7f6e\u201d\u7b2c%s\u884c\u201c\u8c03\u6574\u5efa\u8bae\u5b57\u6bb5\u540d\u79f0\u201d\u3002", (String)"AdjustSuggestReleaseEdit_6", (String)APPLICATION_NAME, (Object[])new Object[0]), row + 1));
                    return;
                }
                MainEntityType destbillMainType = this.getMainEntityType(REL_CONFIG_BASE_DATA);
                if (destbillMainType != null) {
                    if (adjustsugfieldsign.contains(".")) {
                        adjustsugfieldsign = Arrays.stream(adjustsugfieldsign.split("[.]")).reduce((first, second) -> second).orElse("");
                    }
                    IDataEntityProperty property = destbillMainType.findProperty(adjustsugfieldsign);
                    parameter.setMatchedProperty(property);
                }
            }
            TreeNode destBillNode = this.buildBillTreeNodes(parameter);
            String nodesJson = SerializationUtils.toJsonString((Object)destBillNode);
            this.showBillFieldForm(nodesJson, baseDataTag);
        }
    }

    private void showBillFieldForm(String nodesJson, String actionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(MSPLAN_BILL_FIELD_SELECT);
        showParameter.getCustomParams().put(TREE_NODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private TreeNode buildBillTreeNodes(BillTreeBuildParameter parameter) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List fldNodes = BillFieldEntityHelper.buildFldTreeNodes((BillTreeBuildParameter)parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }
}

