/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class BillFieldSelectPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    public static final String Key_btnOK = "ok";
    public static final String Key_btnCancel = "cancel";
    public static final String Tree = "tree";
    public static final String EntryEntity = "entryentity";
    public static final String TREE_ID = "treeid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        Search search = (Search)this.getControl("search");
        search.addEnterListener((SearchEnterListener)this);
        TreeView tree = (TreeView)this.getControl(Tree);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterBindData(EventObject e) {
        boolean isFlexDim;
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        }
        if (isFlexDim = this.isFlexDim()) {
            TreeView treeView = (TreeView)this.getControl(Tree);
            treeView.setMulti(true);
        }
    }

    private boolean isFlexDim() {
        return this.getView().getFormShowParameter().getCustomParam("cus_felxdim") != null;
    }

    public void fillTreeNodes(String strJson) {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(Tree);
        tree.addNode(rootNode);
    }

    private Map<String, String> fillTreeNodeMap() {
        String strJson = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        HashMap<String, String> treeNodeMap = new HashMap<String, String>(16);
        if (StringUtils.isNotBlank((CharSequence)strJson)) {
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
            this.generateTreeMap(treeNodeMap, rootNode);
        }
        return treeNodeMap;
    }

    private void generateTreeMap(Map<String, String> treeNodeMap, TreeNode rootNode) {
        treeNodeMap.put(rootNode.getId(), rootNode.getText());
        if (rootNode.getChildren() != null) {
            for (TreeNode currentNode : rootNode.getChildren()) {
                this.generateTreeMap(treeNodeMap, currentNode);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String currNodeId = (String)evt.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        this.getPageCache().put("nodeids", currNodeId);
    }

    private List<String> getSelectNodes() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(EntryEntity);
        ArrayList<String> selectNodes = new ArrayList<String>(dynamicObjects.size());
        HashSet<String> nodes = new HashSet<String>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            String treeId = dynamicObject.getString(TREE_ID);
            if (!nodes.add(treeId)) continue;
            selectNodes.add(treeId);
        }
        return selectNodes;
    }

    private boolean closeFlexDimView() {
        if (this.isFlexDim()) {
            StringBuilder expression = new StringBuilder("CONCAT(");
            StringBuilder description = new StringBuilder("CONCAT(");
            CRFormula crFormula = new CRFormula();
            List<String> selectNodes = this.getSelectNodes();
            if (selectNodes.isEmpty()) {
                this.getView().close();
                return true;
            }
            Map<String, String> treeNodeMap = this.fillTreeNodeMap();
            int nodesSize = selectNodes.size();
            for (int i = 0; i < nodesSize; ++i) {
                String node = selectNodes.get(i);
                if (i != nodesSize - 1) {
                    expression.append(node).append(',').append("'-',");
                    description.append(treeNodeMap.get(node)).append(",'-'").append(',');
                    continue;
                }
                expression.append(node);
                description.append(treeNodeMap.get(node));
            }
            expression.append(')');
            description.append(')');
            crFormula.setExpression(expression.toString());
            crFormula.setExprTran(description.toString());
            crFormula.setDescription(new LocaleString(description.toString()));
            crFormula.setLocaleExprTran(new LocaleString(description.toString()));
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)crFormula));
            this.getView().close();
            return true;
        }
        return false;
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        if (this.closeFlexDimView()) {
            return;
        }
        String currNodeId = (String)evt.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        if (!StringUtils.isBlank((CharSequence)currNodeId)) {
            this.getView().returnDataToParent((Object)currNodeId);
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            if (this.closeFlexDimView()) {
                return;
            }
            String currNodeId = this.getPageCache().get("nodeids");
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                this.getView().returnDataToParent((Object)currNodeId);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
            this.getView().close();
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        String json = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            List treeNodes;
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            IPageCache pageCache = this.getPageCache();
            String pageId = this.getView().getPageId();
            String searchNodesCacheKey = pageId + "_searchNodes";
            String matchNodesCacheKey = pageId + "_matchNodes";
            String oldSearchTextCacheKey = pageId + "_oldSearchText";
            String searchIndexCacheKey = pageId + "_searchIndex";
            String oldSearchText = pageCache.get(oldSearchTextCacheKey);
            pageCache.put(oldSearchTextCacheKey, searchText);
            String matchNodesCache = pageCache.get(matchNodesCacheKey);
            if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
                treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
                pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            } else {
                String searchNodesCache = pageCache.get(searchNodesCacheKey);
                treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
            }
            if (treeNodes.isEmpty()) {
                treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
                pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
                this.getView().showMessage(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u5339\u914d\u5230\u641c\u7d22\u9879\u3002", (String)"BillFieldSelectPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            } else {
                TreeView treeView = (TreeView)this.getView().getControl(Tree);
                if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                    int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                    if (indexCache < treeNodes.size()) {
                        treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                        treeView.showNode(((TreeNode)treeNodes.get(indexCache)).getParentid());
                        treeView.focusNode((TreeNode)treeNodes.get(indexCache));
                        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                    } else {
                        pageCache.put(searchIndexCacheKey, String.valueOf(0));
                    }
                } else {
                    treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                    treeView.showNode(((TreeNode)treeNodes.get(0)).getParentid());
                    treeView.showNode(((TreeNode)treeNodes.get(0)).getId());
                    treeView.focusNode((TreeNode)treeNodes.get(0));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
                pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            }
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        if (this.isFlexDim()) {
            String currNodeId = (String)treeNodeCheckEvent.getNodeId();
            if (!treeNodeCheckEvent.getChecked().booleanValue()) {
                DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(EntryEntity);
                for (int index = 0; index < dynamicObjects.size(); ++index) {
                    DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(index);
                    if (!currNodeId.equals(dynamicObject.getString(TREE_ID))) continue;
                    this.getModel().deleteEntryRow(EntryEntity, index);
                }
            } else {
                int rowIndex = this.getModel().createNewEntryRow(EntryEntity);
                this.getModel().setValue(TREE_ID, (Object)currNodeId, rowIndex);
            }
        }
    }
}

